/*
 * Decompiled with CFR 0.152.
 */
package at.gnu.gridz;

import at.gnu.gridz.ActionInProgress;
import at.gnu.gridz.ChargeTile;
import at.gnu.gridz.Empty;
import at.gnu.gridz.EnterExit;
import at.gnu.gridz.Exit;
import at.gnu.gridz.ExitEntered;
import at.gnu.gridz.ExitOpened;
import at.gnu.gridz.GameEnded;
import at.gnu.gridz.GameReset;
import at.gnu.gridz.GridzAction;
import at.gnu.gridz.GridzEvent;
import at.gnu.gridz.GridzHandler;
import at.gnu.gridz.GridzItem;
import at.gnu.gridz.GridzTile;
import at.gnu.gridz.ItemCollected;
import at.gnu.gridz.ItemConsumed;
import at.gnu.gridz.Key;
import at.gnu.gridz.MoveWall;
import at.gnu.gridz.NoAction;
import at.gnu.gridz.Pill;
import at.gnu.gridz.Portal;
import at.gnu.gridz.Teleport;
import at.gnu.gridz.TeleportEnded;
import at.gnu.gridz.TeleportStarted;
import at.gnu.gridz.TileEntered;
import at.gnu.gridz.TileLit;
import at.gnu.gridz.TileLitDeceased;
import at.gnu.gridz.Wall;
import at.gnu.gridz.WallMoved;
import at.gnu.gridz.WallMoving;
import at.gnu.gridz.levels.GridzLevel;
import at.gnu.gridz.levels.PacmanLevel;
import at.gnu.gridz.levels.PortalsLevel;
import at.gnu.gridz.levels.SpaceLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.logger.Console;
import korlibs.time.DateTime;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\u0018\u0000 ]2\u00020\u0001:\u0002]^B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020%H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010A\u001a\u00020%H\u0002J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020C0#2\u0006\u0010E\u001a\u00020/H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010H\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001eH\u0002J\u001a\u0010I\u001a\u0004\u0018\u00010\u00112\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001eH\u0002J\b\u0010J\u001a\u00020\u0018H\u0016J\b\u0010K\u001a\u00020*H\u0016J\b\u0010L\u001a\u00020\u0018H\u0016J\b\u0010M\u001a\u00020GH\u0016J\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020C0#2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004H\u0016J\u001a\u0010O\u001a\u0004\u0018\u0001032\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001eH\u0002J(\u0010P\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0006\u0012\u0004\u0018\u0001030Q2\u0006\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u0004H\u0002J,\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040Q2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020%H\u0002J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020C0#2\u0006\u0010A\u001a\u00020%H\u0002J\u0018\u0010V\u001a\u00020\u001d*\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001e0WH\u0002J\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020C0Y*\u0004\u0018\u000103H\u0002J\u001e\u0010Z\u001a\u0004\u0018\u000103*\u0002032\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020\u001eH\u0002J\u0014\u0010[\u001a\b\u0012\u0004\u0012\u00020C0#*\u0004\u0018\u000103H\u0002J\u001c\u0010\\\u001a\b\u0012\u0004\u0012\u00020C0#*\u0004\u0018\u0001032\u0006\u0010A\u001a\u00020%H\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R>\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00122\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R>\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00122\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R6\u00100\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001e0.2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001e0.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R>\u00104\u001a\u0012\u0012\u0004\u0012\u0002030\u0010j\b\u0012\u0004\u0012\u000203`\u00122\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u0002030\u0010j\b\u0012\u0004\u0012\u000203`\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0015R\u000e\u00106\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001e\u0010:\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0007R\u001e\u0010<\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0007\u00a8\u0006_"}, d2={"Lat/gnu/gridz/GridzGame;", "Lat/gnu/gridz/GridzHandler;", "()V", "<set-?>", "", "acceleration", "getAcceleration", "()F", "action", "Lat/gnu/gridz/GridzAction;", "Lat/gnu/gridz/ChargeTile;", "chargeTile", "getChargeTile", "()Lat/gnu/gridz/ChargeTile;", "direction", "getDirection", "Ljava/util/ArrayList;", "Lat/gnu/gridz/GridzItem;", "Lkotlin/collections/ArrayList;", "inventory", "getInventory", "()Ljava/util/ArrayList;", "items", "getItems", "Lat/gnu/gridz/levels/GridzLevel;", "level", "getLevel", "()Lat/gnu/gridz/levels/GridzLevel;", "levelCompleted", "", "", "levelNumber", "getLevelNumber", "()I", "levels", "", "pauseTime", "", "preferX", "speed", "start", "startPause", "Lat/gnu/gridz/GridzGame$State;", "state", "getState", "()Lat/gnu/gridz/GridzGame$State;", "", "", "tasks", "getTasks", "()Ljava/util/Map;", "Lat/gnu/gridz/GridzTile;", "tiles", "getTiles", "timeSinceLastMoved", "timer", "getTimer", "()J", "x", "getX", "y", "getY", "checkTimeout", "inputX", "inputY", "dt", "handleAction", "Lat/gnu/gridz/GridzEvent;", "handleTasks", "name", "init", "", "isBlocked", "item", "next", "pause", "previous", "reset", "tick", "tile", "updatePosition", "Lkotlin/Pair;", "dx", "dy", "updateSpeed", "updateTiles", "areCompleted", "", "handleItems", "", "isMovable", "onEntered", "updateCharging", "Companion", "State", "gridz"})
@SourceDebugExtension(value={"SMAP\nGridzGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridzGame.kt\nat/gnu/gridz/GridzGame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,396:1\n1855#2,2:397\n288#2,2:399\n1855#2,2:402\n288#2,2:404\n288#2,2:406\n1#3:401\n167#4,3:408\n*S KotlinDebug\n*F\n+ 1 GridzGame.kt\nat/gnu/gridz/GridzGame\n*L\n135#1:397,2\n170#1:399,2\n229#1:402,2\n369#1:404,2\n372#1:406,2\n389#1:408,3\n*E\n"})
public final class GridzGame
implements GridzHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GridzLevel> levels;
    private float direction;
    private float acceleration;
    @NotNull
    private ArrayList<GridzItem> items;
    @NotNull
    private ArrayList<GridzItem> inventory;
    @NotNull
    private GridzLevel level;
    private int levelNumber;
    @NotNull
    private State state;
    @NotNull
    private Map<String, Integer> tasks;
    @NotNull
    private ArrayList<GridzTile> tiles;
    private long timer;
    private float x;
    private float y;
    @NotNull
    private ChargeTile chargeTile;
    private boolean preferX;
    private boolean levelCompleted;
    private float speed;
    private long start;
    private long startPause;
    private long pauseTime;
    private long timeSinceLastMoved;
    @NotNull
    private GridzAction action;
    @NotNull
    public static final String NAME = "gridZ";
    public static final long TIMEOUT_NOT_MOVING = 60000L;

    public GridzGame() {
        GridzLevel[] gridzLevelArray = new GridzLevel[]{new GridzLevel(), new PacmanLevel(), new SpaceLevel(), new PortalsLevel()};
        this.levels = CollectionsKt.listOf(gridzLevelArray);
        this.items = new ArrayList();
        this.inventory = new ArrayList();
        this.level = CollectionsKt.first(this.levels);
        this.state = State.UNKNOWN;
        this.tasks = new LinkedHashMap();
        this.tiles = new ArrayList();
        this.chargeTile = new ChargeTile(0, 0, 0L, false, 15, null);
        this.preferX = true;
        this.action = NoAction.INSTANCE;
        this.init(0);
    }

    public final float getDirection() {
        return this.direction;
    }

    public final float getAcceleration() {
        return this.acceleration;
    }

    @NotNull
    public final ArrayList<GridzItem> getItems() {
        return this.items;
    }

    @NotNull
    public final ArrayList<GridzItem> getInventory() {
        return this.inventory;
    }

    @NotNull
    public final GridzLevel getLevel() {
        return this.level;
    }

    public final int getLevelNumber() {
        return this.levelNumber;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @NotNull
    public final Map<String, Integer> getTasks() {
        return this.tasks;
    }

    @NotNull
    public final ArrayList<GridzTile> getTiles() {
        return this.tiles;
    }

    public final long getTimer() {
        return this.timer;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    @NotNull
    public final ChargeTile getChargeTile() {
        return this.chargeTile;
    }

    @Override
    public void reset() {
        this.init(this.levelNumber);
    }

    @Override
    @NotNull
    public GridzLevel next() {
        int next = (this.levelNumber + 1) % this.levels.size();
        this.init(next);
        return this.levels.get(next);
    }

    @Override
    @NotNull
    public GridzLevel previous() {
        int previous = (this.levelNumber + this.levels.size() - 1) % this.levels.size();
        this.init(previous);
        return this.levels.get(previous);
    }

    @Override
    @NotNull
    public State pause() {
        if (this.state == State.RUNNING) {
            this.state = State.PAUSED;
            this.startPause = DateTime.Companion.nowUnixMillisLong();
        } else if (this.state == State.PAUSED) {
            this.state = State.RUNNING;
            this.pauseTime += DateTime.Companion.nowUnixMillisLong() - this.startPause;
        }
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<GridzEvent> tick(float inputX, float inputY) {
        if (this.state == State.LOADED) {
            if (inputX == 0.0f && inputY == 0.0f) return CollectionsKt.emptyList();
            this.state = State.RUNNING;
            this.start = DateTime.Companion.nowUnixMillisLong();
        } else if (this.state != State.RUNNING) {
            return CollectionsKt.emptyList();
        }
        long lastTimer = this.timer;
        this.timer = DateTime.Companion.nowUnixMillisLong() - this.start - this.pauseTime;
        long dt = this.timer - lastTimer;
        if (this.checkTimeout(inputX, inputY, dt)) {
            return CollectionsKt.listOf(GameReset.INSTANCE);
        }
        GridzEvent event = this.handleAction(dt);
        if (event instanceof WallMoved) {
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.handleItems(((WallMoved)event).getToTile()), (Iterable)this.onEntered(((WallMoved)event).getToTile())), event);
        }
        if (event instanceof TeleportEnded) {
            return CollectionsKt.plus((Collection)this.handleTasks("Teleport"), TeleportEnded.INSTANCE);
        }
        if (event instanceof GameEnded) {
            this.state = State.ENDED;
            return CollectionsKt.listOf(GameEnded.INSTANCE);
        }
        if (event instanceof ActionInProgress) {
            return CollectionsKt.listOf(ActionInProgress.INSTANCE);
        }
        Pair<Float, Float> pair = this.updateSpeed(inputX, inputY, dt);
        float dx = ((Number)pair.component1()).floatValue();
        float dy = ((Number)pair.component2()).floatValue();
        Pair<GridzTile, GridzTile> pair2 = this.updatePosition(dx, dy);
        GridzTile nextTile = pair2.component1();
        GridzTile tile = pair2.component2();
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.handleItems(tile), (Iterable)this.onEntered(tile)), (Iterable)this.updateTiles(dt)), (Iterable)this.updateCharging(nextTile, dt));
    }

    private final GridzEvent handleAction(long dt) {
        GridzEvent gridzEvent;
        if (Intrinsics.areEqual(this.action, NoAction.INSTANCE)) {
            return null;
        }
        Triple<GridzEvent, Float, Float> triple = this.action.perform(dt);
        GridzEvent event = triple.component1();
        float x = ((Number)triple.component2()).floatValue();
        float y = ((Number)triple.component3()).floatValue();
        this.x = x;
        this.y = y;
        if (event != null) {
            this.action = NoAction.INSTANCE;
            gridzEvent = event;
        } else {
            gridzEvent = this.action instanceof EnterExit || this.action instanceof Teleport || this.action instanceof MoveWall ? (GridzEvent)ActionInProgress.INSTANCE : null;
        }
        return gridzEvent;
    }

    private final List<GridzEvent> handleTasks(String name2) {
        if (!this.levelCompleted) {
            if (this.tasks.containsKey(name2)) {
                Integer n = this.tasks.get(name2);
                Intrinsics.checkNotNull(n);
                this.tasks.put(name2, RangesKt.coerceAtLeast(((Number)n).intValue() - 1, 0));
            }
            if (this.areCompleted(this.tasks)) {
                this.levelCompleted = true;
                Iterable $this$forEach$iv = this.tiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GridzTile it = (GridzTile)element$iv;
                    boolean bl = false;
                    if (!(it instanceof Exit)) continue;
                    ((Exit)it).setOpen(true);
                }
                return CollectionsKt.listOf(ExitOpened.INSTANCE);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final List<GridzEvent> handleItems(GridzTile $this$handleItems) {
        List events = new ArrayList();
        if ($this$handleItems == null) {
            return events;
        }
        GridzItem gridzItem = this.item($this$handleItems.getX(), $this$handleItems.getY());
        if (gridzItem == null) {
            return events;
        }
        GridzItem item2 = gridzItem;
        ((Collection)this.items).remove(item2);
        CollectionsKt.addAll((Collection)events, (Iterable)this.handleTasks(item2.getName()));
        if (item2.getCollectable() && this.inventory.size() < this.level.getMaxInventory()) {
            ((Collection)this.inventory).add(item2);
            ((Collection)events).add(new ItemCollected(item2));
        } else {
            ((Collection)events).add(new ItemConsumed(item2));
        }
        return events;
    }

    private final List<GridzEvent> onEntered(GridzTile $this$onEntered) {
        List<TileEntered> list2;
        if ($this$onEntered == null) {
            return CollectionsKt.emptyList();
        }
        List events = new ArrayList();
        Object object = $this$onEntered;
        if (object instanceof Exit) {
            this.action = new EnterExit(this.x, this.y, (float)$this$onEntered.getX() + 0.5f, (float)$this$onEntered.getY() + 0.5f, GameEnded.INSTANCE);
            ((Collection)events).add(new ExitEntered($this$onEntered));
        } else if (object instanceof Empty) {
            if (this.level.getTailLitTime() > 0L) {
                if (((Empty)$this$onEntered).getLit() <= 0L) {
                    CollectionsKt.addAll((Collection)events, (Iterable)this.handleTasks("Empty"));
                }
                ((Empty)$this$onEntered).setLit(this.level.getTailLitTime());
                ((Collection)events).add(new TileLit($this$onEntered));
            }
        } else if (object instanceof Portal) {
            Object v0;
            block14: {
                Iterable $this$firstOrNull$iv = this.tiles;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GridzTile it = (GridzTile)element$iv;
                    boolean bl = false;
                    if (!(it != $this$onEntered && it instanceof Portal && ((Portal)it).getId() == ((Portal)$this$onEntered).getId())) continue;
                    v0 = element$iv;
                    break block14;
                }
                v0 = null;
            }
            GridzTile gridzTile = v0;
            if (gridzTile != null) {
                GridzTile it = gridzTile;
                boolean bl = false;
                this.action = new Teleport(this.x, this.y, $this$onEntered.getX(), $this$onEntered.getY(), it.getX(), it.getY(), TeleportEnded.INSTANCE);
                ((Collection)events).add(new TeleportStarted($this$onEntered, it));
            }
        } else if (object instanceof Wall) {
            GameReset gameReset;
            Collection collection = events;
            GameReset it = gameReset = GameReset.INSTANCE;
            boolean bl = false;
            Object[] objectArray = new Object[]{"Stuck in wall!"};
            Console.INSTANCE.error(objectArray);
            collection.add(gameReset);
        }
        object = events;
        if (object.isEmpty()) {
            boolean bl = false;
            list2 = CollectionsKt.listOf(TileEntered.INSTANCE);
        } else {
            list2 = object;
        }
        return list2;
    }

    private final boolean checkTimeout(float inputX, float inputY, long dt) {
        if (!(inputX == 0.0f) && !(inputY == 0.0f)) {
            this.timeSinceLastMoved = 0L;
        } else {
            this.timeSinceLastMoved += dt;
            if (this.timeSinceLastMoved > 60000L) {
                return true;
            }
        }
        return false;
    }

    private final void init(int levelNumber) {
        this.state = State.INIT;
        this.levelNumber = levelNumber;
        this.level = this.levels.get(levelNumber);
        this.pauseTime = 0L;
        this.timeSinceLastMoved = 0L;
        this.x = (float)this.level.getStartX() + 0.5f;
        this.y = (float)this.level.getStartY() + 0.5f;
        this.acceleration = 0.0f;
        this.direction = 0.0f;
        this.timer = 0L;
        this.tiles = new ArrayList();
        this.items = new ArrayList();
        this.inventory = new ArrayList();
        this.tasks = MapsKt.toMutableMap(this.level.getTasks());
        this.levelCompleted = false;
        this.chargeTile = new ChargeTile(0, 0, 0L, false, 15, null);
        int n = this.level.getRows();
        for (int y = 0; y < n; ++y) {
            int n2 = this.level.getCols();
            for (int x = 0; x < n2; ++x) {
                Object object = CollectionsKt.getOrNull(this.level.getLayout(), y);
                char c = object != null && (object = StringsKt.getOrNull((CharSequence)object, x)) != null ? (char)((Character)object).charValue() : (char)' ';
                if (Character.isDigit(c)) {
                    ((Collection)this.tiles).add(new Portal(x, y, CharsKt.digitToInt(c)));
                } else if (c == '*') {
                    ((Collection)this.tiles).add(new Wall(x, y));
                } else if (c == 'x') {
                    ((Collection)this.tiles).add(new Exit(x, y));
                } else {
                    ((Collection)this.tiles).add(new Empty(x, y));
                }
                char c2 = c;
                if (c2 == 'k') {
                    ((Collection)this.items).add(new Key(x, y));
                    continue;
                }
                if (c2 != 46) continue;
                ((Collection)this.items).add(new Pill(x, y));
            }
        }
        this.state = State.LOADED;
    }

    private final List<GridzEvent> updateTiles(long dt) {
        List events = new ArrayList();
        Iterable $this$forEach$iv = this.tiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GridzTile it = (GridzTile)element$iv;
            boolean bl = false;
            if (!(it instanceof Empty) || ((Empty)it).getLit() <= 0L) continue;
            ((Empty)it).setLit(RangesKt.coerceAtLeast(((Empty)it).getLit() - dt * 10L, 0L));
            if (((Empty)it).getLit() > 0L) continue;
            ((Collection)events).add(new TileLitDeceased(it));
        }
        return events;
    }

    private final Pair<Float, Float> updateSpeed(float inputX, float inputY, long dt) {
        this.acceleration = RangesKt.coerceAtMost((float)Math.sqrt(inputX * inputX + inputY * inputY), 1.0f);
        if (Math.abs(inputX) + Math.abs(inputY) > 0.004f) {
            this.direction = (float)Math.atan2(inputX, inputY);
        }
        float factor = (float)dt / 500.0f;
        this.speed = !(this.acceleration == 0.0f) ? RangesKt.coerceIn(this.speed + factor * this.acceleration, 0.0f, factor * 5.0f) : RangesKt.coerceAtLeast(this.speed - factor, 0.0f);
        float dx = RangesKt.coerceIn(this.speed * (float)Math.sin(this.direction), -0.5f, 0.5f);
        float dy = RangesKt.coerceIn(this.speed * (float)Math.cos(this.direction), -0.5f, 0.5f);
        return TuplesKt.to(Float.valueOf(Math.abs(dx) < 0.004f ? 0.0f : dx), Float.valueOf(Math.abs(dy) < 0.004f ? 0.0f : dy));
    }

    private final Pair<GridzTile, GridzTile> updatePosition(float dx, float dy) {
        int thisX = (int)this.x;
        int thisY = (int)this.y;
        float snapX = (float)thisX + 0.5f;
        float snapY = (float)thisY + 0.5f;
        float nextXFloat = this.x + dx + 0.5f * Math.signum(dx);
        int nextX = nextXFloat >= 0.0f ? (int)nextXFloat : this.level.getCols() - 1;
        float nextYFloat = this.y - dy - 0.5f * Math.signum(dy);
        int nextY = nextYFloat >= 0.0f ? (int)nextYFloat : this.level.getRows() - 1;
        float offsetX = this.x - (float)((int)this.x);
        float offsetY = this.y - (float)((int)this.y);
        float speedX = RangesKt.coerceIn(this.speed * Math.signum(dx), -0.5f, 0.5f);
        float speedY = RangesKt.coerceIn(this.speed * Math.signum(dy), -0.5f, 0.5f);
        if (nextX == thisX && nextY != thisY) {
            if (!this.isBlocked(thisX, nextY) && offsetX < 0.5f && this.isBlocked(thisX - 1, nextY)) {
                this.x = Math.abs(0.5f - offsetX) < 0.1f ? snapX : (this.x += RangesKt.coerceAtLeast(speedX, 0.04f));
                this.y = snapY;
            } else if (!this.isBlocked(thisX, nextY) && offsetX > 0.5f && this.isBlocked(thisX + 1, nextY)) {
                this.x = Math.abs(0.5f - offsetX) < 0.1f ? snapX : (this.x += RangesKt.coerceAtMost(speedX, -0.04f));
                this.y = snapY;
            } else if (this.isBlocked(thisX, nextY)) {
                this.preferX = false;
                this.x += speedX;
            } else {
                this.x += dx;
                this.y -= dy;
            }
        } else if (nextX != thisX && nextY == thisY) {
            if (!this.isBlocked(nextX, thisY) && offsetY > 0.5f && this.isBlocked(nextX, thisY + 1)) {
                this.x = snapX;
                this.y = Math.abs(0.5f - offsetY) < 0.1f ? snapY : (this.y -= RangesKt.coerceAtLeast(speedY, 0.04f));
            } else if (!this.isBlocked(nextX, thisY) && offsetY < 0.5f && this.isBlocked(nextX, thisY - 1)) {
                this.x = snapX;
                this.y = Math.abs(0.5f - offsetY) < 0.1f ? snapY : (this.y -= RangesKt.coerceAtMost(speedY, -0.04f));
            } else if (this.isBlocked(nextX, thisY)) {
                this.preferX = true;
                this.y -= speedY;
            } else {
                this.x += dx;
                this.y -= dy;
            }
        } else if (nextX != thisX && nextY != thisY) {
            boolean bl = Math.abs(dx) > 2.0f * Math.abs(dy) ? true : (this.preferX = Math.abs(dy) > 2.0f * Math.abs(dx) ? false : this.preferX);
            if (this.isBlocked(nextX, nextY) || !this.isBlocked(nextX, thisY) || !this.isBlocked(thisX, nextY)) {
                if (this.isBlocked(nextX, nextY) && !this.isBlocked(nextX, thisY) && this.preferX) {
                    this.x += speedX;
                    this.y = snapY;
                } else if (this.isBlocked(nextX, nextY) && !this.isBlocked(thisX, nextY) && this.preferX) {
                    this.x = snapX;
                    this.y -= speedY;
                } else if (this.isBlocked(nextX, nextY) && !this.isBlocked(thisX, nextY) && !this.preferX) {
                    this.x = snapX;
                    this.y -= speedY;
                } else if (this.isBlocked(nextX, nextY) && !this.isBlocked(nextX, thisY) && !this.preferX) {
                    this.x += speedX;
                    this.y = snapY;
                } else if (!this.isBlocked(nextX, nextY) && this.isBlocked(thisX, nextY)) {
                    this.x += speedX;
                    this.y = snapY;
                } else if (!this.isBlocked(nextX, nextY) && this.isBlocked(nextX, thisY)) {
                    this.x = snapX;
                    this.y -= speedY;
                } else if (!this.isBlocked(nextX, nextY)) {
                    this.x += dx;
                    this.y -= dy;
                }
            }
        } else {
            this.x += dx;
            this.y -= dy;
        }
        if (this.x > (float)this.level.getCols()) {
            this.x -= (float)this.level.getCols();
        }
        if (this.x < 0.0f) {
            this.x += (float)this.level.getCols();
        }
        if (this.y > (float)this.level.getRows()) {
            this.y -= (float)this.level.getRows();
        }
        if (this.y < 0.0f) {
            this.y += (float)this.level.getRows();
        }
        int endX = (int)this.x;
        int endY = (int)this.y;
        GridzTile nextTile = this.tile(nextX, nextY);
        return endX != thisX || endY != thisY ? TuplesKt.to(nextTile, this.tile(endX, endY)) : TuplesKt.to(nextTile, null);
    }

    private final List<GridzEvent> updateCharging(GridzTile $this$updateCharging, long dt) {
        List events = new ArrayList();
        if ($this$updateCharging == null) {
            return events;
        }
        if (!this.isBlocked($this$updateCharging.getX(), $this$updateCharging.getY())) {
            this.chargeTile.setCharge(-1L);
        } else if ($this$updateCharging.getX() == this.chargeTile.getX() && $this$updateCharging.getY() == this.chargeTile.getY()) {
            if (!this.chargeTile.getCharged()) {
                ChargeTile chargeTile = this.chargeTile;
                chargeTile.setCharge(chargeTile.getCharge() + dt);
                if (this.chargeTile.getCharge() > 255L) {
                    int dy;
                    int dx = (int)Math.signum((double)($this$updateCharging.getX() - (int)this.x));
                    GridzTile toTile = this.isMovable($this$updateCharging, dx, dy = (int)Math.signum((double)($this$updateCharging.getY() - (int)this.y)));
                    if (toTile != null) {
                        ((Collection)events).add(new WallMoving($this$updateCharging, toTile));
                        this.action = new MoveWall(this.x, this.y, $this$updateCharging, toTile, new WallMoved($this$updateCharging, toTile));
                    }
                    this.chargeTile.setCharged(true);
                }
            }
        } else {
            this.chargeTile.setX($this$updateCharging.getX());
            this.chargeTile.setY($this$updateCharging.getY());
            this.chargeTile.setCharge(0L);
            this.chargeTile.setCharged(false);
        }
        return events;
    }

    private final GridzTile tile(int x, int y) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.tiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GridzTile it = (GridzTile)element$iv;
                boolean bl = false;
                if (!(it.getX() == (x + this.level.getCols()) % this.level.getCols() && it.getY() == (y + this.level.getRows()) % this.level.getRows())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final GridzItem item(int x, int y) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.items;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GridzItem it = (GridzItem)element$iv;
                boolean bl = false;
                if (!(it.getX() == x && it.getY() == y)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isBlocked(int x, int y) {
        GridzTile tile = this.tile(x, y);
        return tile instanceof Wall || tile instanceof Exit && !((Exit)tile).getOpen();
    }

    private final GridzTile isMovable(GridzTile $this$isMovable, int dx, int dy) {
        if (!($this$isMovable instanceof Wall) || dx != 0 && dy != 0) {
            return null;
        }
        if (((Wall)$this$isMovable).getX() + dx < 0 || ((Wall)$this$isMovable).getX() + dx >= this.level.getCols() || ((Wall)$this$isMovable).getY() + dy < 0 || ((Wall)$this$isMovable).getY() + dy >= this.level.getRows()) {
            return null;
        }
        GridzTile gridzTile = this.tile(((Wall)$this$isMovable).getX() + dx, ((Wall)$this$isMovable).getY() + dy);
        if (gridzTile == null) {
            return null;
        }
        GridzTile tileBehind = gridzTile;
        return tileBehind instanceof Empty ? tileBehind : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areCompleted(Map<String, Integer> $this$areCompleted) {
        boolean bl;
        if ($this$areCompleted.isEmpty()) return true;
        Map<String, Integer> $this$all$iv = $this$areCompleted;
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<String, Integer>> iterator2 = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry<String, Integer> element$iv;
            if (!iterator2.hasNext()) return true;
            Map.Entry<String, Integer> it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (((Number)it.getValue()).intValue() > 0) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lat/gnu/gridz/GridzGame$Companion;", "", "()V", "NAME", "", "TIMEOUT_NOT_MOVING", "", "gridz"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lat/gnu/gridz/GridzGame$State;", "", "(Ljava/lang/String;I)V", "INIT", "LOADED", "RUNNING", "ENDED", "PAUSED", "UNKNOWN", "gridz"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INIT = new State();
        public static final /* enum */ State LOADED = new State();
        public static final /* enum */ State RUNNING = new State();
        public static final /* enum */ State ENDED = new State();
        public static final /* enum */ State PAUSED = new State();
        public static final /* enum */ State UNKNOWN = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.INIT, State.LOADED, State.RUNNING, State.ENDED, State.PAUSED, State.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

