/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.NumberInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class JsonPointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final int _asStringOffset;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;
    protected int _hashCode;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = null;
        this._matchingElementIndex = -1;
        this._asString = "";
        this._asStringOffset = 0;
    }

    protected JsonPointer(String fullString, int fullStringOffset, String segment, JsonPointer next) {
        this._asString = fullString;
        this._asStringOffset = fullStringOffset;
        this._nextSegment = next;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = JsonPointer._parseIndex(segment);
    }

    protected JsonPointer(String fullString, int fullStringOffset, String segment, int matchIndex, JsonPointer next) {
        this._asString = fullString;
        this._asStringOffset = fullStringOffset;
        this._nextSegment = next;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = matchIndex;
    }

    public static JsonPointer compile(String expr2) throws IllegalArgumentException {
        if (expr2 == null || expr2.length() == 0) {
            return EMPTY;
        }
        if (expr2.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + expr2 + "\"");
        }
        return JsonPointer._parseTail(expr2);
    }

    public static JsonPointer valueOf(String expr2) {
        return JsonPointer.compile(expr2);
    }

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer forPath(JsonStreamContext context2, boolean includeRoot) {
        if (context2 == null) {
            return EMPTY;
        }
        if (!(context2.hasPathSegment() || includeRoot && context2.inRoot() && context2.hasCurrentIndex())) {
            context2 = context2.getParent();
        }
        PointerSegment next = null;
        int approxLength = 0;
        while (context2 != null) {
            if (context2.inObject()) {
                String propName = context2.getCurrentName();
                if (propName == null) {
                    propName = "";
                }
                approxLength += 2 + propName.length();
                next = new PointerSegment(next, propName, -1);
            } else if (context2.inArray() || includeRoot) {
                int ix = context2.getCurrentIndex();
                approxLength += 6;
                next = new PointerSegment(next, null, ix);
            }
            context2 = context2.getParent();
        }
        if (next == null) {
            return EMPTY;
        }
        StringBuilder pathBuilder = new StringBuilder(approxLength);
        PointerSegment last2 = null;
        while (next != null) {
            last2 = next;
            next.pathOffset = pathBuilder.length();
            pathBuilder.append('/');
            if (next.property != null) {
                JsonPointer._appendEscaped(pathBuilder, next.property);
            } else {
                pathBuilder.append(next.index);
            }
            next = next.next;
        }
        String fullPath = pathBuilder.toString();
        PointerSegment currSegment = last2;
        JsonPointer currPtr = EMPTY;
        while (currSegment != null) {
            if (currSegment.property != null) {
                currPtr = new JsonPointer(fullPath, currSegment.pathOffset, currSegment.property, currPtr);
            } else {
                int index2 = currSegment.index;
                currPtr = new JsonPointer(fullPath, currSegment.pathOffset, String.valueOf(index2), index2, currPtr);
            }
            currSegment = currSegment.prev;
        }
        return currPtr;
    }

    private static void _appendEscaped(StringBuilder sb, String segment) {
        int end2 = segment.length();
        for (int i2 = 0; i2 < end2; ++i2) {
            char c = segment.charAt(i2);
            if (c == '/') {
                sb.append("~1");
                continue;
            }
            if (c == '~') {
                sb.append("~0");
                continue;
            }
            sb.append(c);
        }
    }

    public int length() {
        return this._asString.length() - this._asStringOffset;
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer next;
        JsonPointer current2 = this;
        if (current2 == EMPTY) {
            return null;
        }
        while ((next = current2._nextSegment) != EMPTY) {
            current2 = next;
        }
        return current2;
    }

    public JsonPointer append(JsonPointer tail) {
        if (this == EMPTY) {
            return tail;
        }
        if (tail == EMPTY) {
            return this;
        }
        String currentJsonPointer = this._asString;
        if (currentJsonPointer.endsWith("/")) {
            currentJsonPointer = currentJsonPointer.substring(0, currentJsonPointer.length() - 1);
        }
        return JsonPointer.compile(currentJsonPointer + tail._asString);
    }

    public JsonPointer appendProperty(String property) {
        String currentJsonPointer;
        if (property == null || property.isEmpty()) {
            return this;
        }
        if (property.charAt(0) != '/') {
            property = '/' + property;
        }
        if ((currentJsonPointer = this._asString).endsWith("/")) {
            currentJsonPointer = currentJsonPointer.substring(0, currentJsonPointer.length() - 1);
        }
        return JsonPointer.compile(currentJsonPointer + property);
    }

    public JsonPointer appendIndex(int index2) {
        if (index2 < 0) {
            throw new IllegalArgumentException("Negative index cannot be appended");
        }
        String currentJsonPointer = this._asString;
        if (currentJsonPointer.endsWith("/")) {
            currentJsonPointer = currentJsonPointer.substring(0, currentJsonPointer.length() - 1);
        }
        return JsonPointer.compile(currentJsonPointer + '/' + index2);
    }

    public boolean matchesProperty(String name2) {
        return this._nextSegment != null && this._matchingPropertyName.equals(name2);
    }

    public JsonPointer matchProperty(String name2) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(name2)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int index2) {
        return index2 == this._matchingElementIndex && index2 >= 0;
    }

    public JsonPointer matchElement(int index2) {
        if (index2 != this._matchingElementIndex || index2 < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer h = this._head;
        if (h == null) {
            if (this != EMPTY) {
                h = this._constructHead();
            }
            this._head = h;
        }
        return h;
    }

    public String toString() {
        if (this._asStringOffset <= 0) {
            return this._asString;
        }
        return this._asString.substring(this._asStringOffset);
    }

    public int hashCode() {
        int h = this._hashCode;
        if (h == 0) {
            h = this.toString().hashCode();
            if (h == 0) {
                h = -1;
            }
            this._hashCode = h;
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JsonPointer)) {
            return false;
        }
        JsonPointer other = (JsonPointer)o;
        return this._compare(this._asString, this._asStringOffset, other._asString, other._asStringOffset);
    }

    private final boolean _compare(String str1, int offset1, String str2, int offset2) {
        int end1 = str1.length();
        if (end1 - offset1 != str2.length() - offset2) {
            return false;
        }
        while (offset1 < end1) {
            if (str1.charAt(offset1++) == str2.charAt(offset2++)) continue;
            return false;
        }
        return true;
    }

    private static final int _parseIndex(String str) {
        long l;
        int len = str.length();
        if (len == 0 || len > 10) {
            return -1;
        }
        char c = str.charAt(0);
        if (c <= '0') {
            return len == 1 && c == '0' ? 0 : -1;
        }
        if (c > '9') {
            return -1;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            c = str.charAt(i2);
            if (c <= '9' && c >= '0') continue;
            return -1;
        }
        if (len == 10 && (l = NumberInput.parseLong(str)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(str);
    }

    protected static JsonPointer _parseTail(String fullPath) {
        PointerParent parent2 = null;
        int i2 = 1;
        int end2 = fullPath.length();
        int startOffset = 0;
        while (i2 < end2) {
            char c = fullPath.charAt(i2);
            if (c == '/') {
                parent2 = new PointerParent(parent2, startOffset, fullPath.substring(startOffset + 1, i2));
                startOffset = i2++;
                continue;
            }
            if (c != '~' || ++i2 >= end2) continue;
            StringBuilder sb = new StringBuilder(32);
            i2 = JsonPointer._extractEscapedSegment(fullPath, startOffset + 1, i2, sb);
            String segment = sb.toString();
            if (i2 < 0) {
                return JsonPointer._buildPath(fullPath, startOffset, segment, parent2);
            }
            parent2 = new PointerParent(parent2, startOffset, segment);
            startOffset = i2++;
        }
        return JsonPointer._buildPath(fullPath, startOffset, fullPath.substring(startOffset + 1), parent2);
    }

    private static JsonPointer _buildPath(String fullPath, int fullPathOffset, String segment, PointerParent parent2) {
        JsonPointer curr = new JsonPointer(fullPath, fullPathOffset, segment, EMPTY);
        while (parent2 != null) {
            curr = new JsonPointer(fullPath, parent2.fullPathOffset, parent2.segment, curr);
            parent2 = parent2.parent;
        }
        return curr;
    }

    protected static int _extractEscapedSegment(String input, int firstCharOffset, int i2, StringBuilder sb) {
        int end2 = input.length();
        int toCopy = i2 - 1 - firstCharOffset;
        if (toCopy > 0) {
            sb.append(input, firstCharOffset, i2 - 1);
        }
        JsonPointer._appendEscape(sb, input.charAt(i2++));
        while (i2 < end2) {
            char c = input.charAt(i2);
            if (c == '/') {
                return i2;
            }
            if (c == '~' && ++i2 < end2) {
                JsonPointer._appendEscape(sb, input.charAt(i2++));
                continue;
            }
            sb.append(c);
        }
        return -1;
    }

    private static void _appendEscape(StringBuilder sb, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            sb.append('~');
        }
        sb.append(c);
    }

    protected JsonPointer _constructHead() {
        JsonPointer last2 = this.last();
        if (last2 == this) {
            return EMPTY;
        }
        int suffixLength = last2.length();
        JsonPointer next = this._nextSegment;
        String fullString = this.toString();
        return new JsonPointer(fullString.substring(0, fullString.length() - suffixLength), 0, this._matchingPropertyName, this._matchingElementIndex, next._constructHead(suffixLength, last2));
    }

    protected JsonPointer _constructHead(int suffixLength, JsonPointer last2) {
        if (this == last2) {
            return EMPTY;
        }
        JsonPointer next = this._nextSegment;
        String str = this.toString();
        return new JsonPointer(str.substring(0, str.length() - suffixLength), 0, this._matchingPropertyName, this._matchingElementIndex, next._constructHead(suffixLength, last2));
    }

    private Object writeReplace() {
        return new Serialization(this.toString());
    }

    static class Serialization
    implements Externalizable {
        private String _fullPath;

        public Serialization() {
        }

        Serialization(String fullPath) {
            this._fullPath = fullPath;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._fullPath);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._fullPath = in.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return JsonPointer.compile(this._fullPath);
        }
    }

    private static class PointerSegment {
        public final PointerSegment next;
        public final String property;
        public final int index;
        public int pathOffset;
        public PointerSegment prev;

        public PointerSegment(PointerSegment next, String pn, int ix) {
            this.next = next;
            this.property = pn;
            this.index = ix;
            if (next != null) {
                next.prev = this;
            }
        }
    }

    private static class PointerParent {
        public final PointerParent parent;
        public final int fullPathOffset;
        public final String segment;

        PointerParent(PointerParent pp, int fpo, String sgm) {
            this.parent = pp;
            this.fullPathOffset = fpo;
            this.segment = sgm;
        }
    }
}

