/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

class FastDoubleSwar {
    FastDoubleSwar() {
    }

    protected static boolean isDigit(char c) {
        return (char)(c - 48) < '\n';
    }

    protected static boolean isDigit(byte c) {
        return (char)(c - 48) < '\n';
    }

    public static boolean isEightDigits(byte[] a, int offset2) {
        return FastDoubleSwar.isEightDigitsUtf8(FastDoubleSwar.readLongLE(a, offset2));
    }

    public static boolean isEightDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.isEightDigitsUtf16(first2, second2);
    }

    public static boolean isEightDigits(CharSequence a, int offset2) {
        boolean success = true;
        for (int i2 = 0; i2 < 8; ++i2) {
            char ch = a.charAt(i2 + offset2);
            success &= FastDoubleSwar.isDigit(ch);
        }
        return success;
    }

    public static boolean isEightDigitsUtf16(long first2, long second2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        long sval = second2 - 0x30003000300030L;
        long spre = second2 + 0x46004600460046L | sval;
        return ((fpre | spre) & 0xFF80FF80FF80FF80L) == 0L;
    }

    public static boolean isEightDigitsUtf8(long chunk) {
        long val = chunk - 0x3030303030303030L;
        long predicate = (chunk + 0x4646464646464646L | val) & 0x8080808080808080L;
        return predicate == 0L;
    }

    public static boolean isEightZeroes(byte[] a, int offset2) {
        return FastDoubleSwar.isEightZeroesUtf8(FastDoubleSwar.readLongLE(a, offset2));
    }

    public static boolean isEightZeroes(CharSequence a, int offset2) {
        boolean success = true;
        for (int i2 = 0; i2 < 8; ++i2) {
            success &= '0' == a.charAt(i2 + offset2);
        }
        return success;
    }

    public static boolean isEightZeroes(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.isEightZeroesUtf16(first2, second2);
    }

    public static boolean isEightZeroesUtf16(long first2, long second2) {
        return first2 == 0x30003000300030L && second2 == 0x30003000300030L;
    }

    public static boolean isEightZeroesUtf8(long chunk) {
        return chunk == 0x3030303030303030L;
    }

    public static int parseEightDigitsUtf16(long first2, long second2) {
        long fval = first2 - 0x30003000300030L;
        long sval = second2 - 0x30003000300030L;
        return (int)(sval * 281475406208040961L >>> 48) + (int)(fval * 281475406208040961L >>> 48) * 10000;
    }

    public static int readIntBE(byte[] a, int offset2) {
        return (a[offset2] & 0xFF) << 24 | (a[offset2 + 1] & 0xFF) << 16 | (a[offset2 + 2] & 0xFF) << 8 | a[offset2 + 3] & 0xFF;
    }

    public static int readIntLE(byte[] a, int offset2) {
        return (a[offset2 + 3] & 0xFF) << 24 | (a[offset2 + 2] & 0xFF) << 16 | (a[offset2 + 1] & 0xFF) << 8 | a[offset2] & 0xFF;
    }

    public static long readLongBE(byte[] a, int offset2) {
        return ((long)a[offset2] & 0xFFL) << 56 | ((long)a[offset2 + 1] & 0xFFL) << 48 | ((long)a[offset2 + 2] & 0xFFL) << 40 | ((long)a[offset2 + 3] & 0xFFL) << 32 | ((long)a[offset2 + 4] & 0xFFL) << 24 | ((long)a[offset2 + 5] & 0xFFL) << 16 | ((long)a[offset2 + 6] & 0xFFL) << 8 | (long)a[offset2 + 7] & 0xFFL;
    }

    public static long readLongLE(byte[] a, int offset2) {
        return ((long)a[offset2 + 7] & 0xFFL) << 56 | ((long)a[offset2 + 6] & 0xFFL) << 48 | ((long)a[offset2 + 5] & 0xFFL) << 40 | ((long)a[offset2 + 4] & 0xFFL) << 32 | ((long)a[offset2 + 3] & 0xFFL) << 24 | ((long)a[offset2 + 2] & 0xFFL) << 16 | ((long)a[offset2 + 1] & 0xFFL) << 8 | (long)a[offset2] & 0xFFL;
    }

    public static int tryToParseEightDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        long second2 = (long)a[offset2 + 4] | (long)a[offset2 + 5] << 16 | (long)a[offset2 + 6] << 32 | (long)a[offset2 + 7] << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first2, second2);
    }

    public static int tryToParseEightDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(FastDoubleSwar.readLongLE(a, offset2));
    }

    public static int tryToParseEightDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) | (long)str.charAt(offset2 + 1) << 16 | (long)str.charAt(offset2 + 2) << 32 | (long)str.charAt(offset2 + 3) << 48;
        long second2 = (long)str.charAt(offset2 + 4) | (long)str.charAt(offset2 + 5) << 16 | (long)str.charAt(offset2 + 6) << 32 | (long)str.charAt(offset2 + 7) << 48;
        return FastDoubleSwar.tryToParseEightDigitsUtf16(first2, second2);
    }

    public static int tryToParseEightDigitsUtf16(long first2, long second2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        long sval = second2 - 0x30003000300030L;
        long spre = second2 + 0x46004600460046L | sval;
        if (((fpre | spre) & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(sval * 281475406208040961L >>> 48) + (int)(fval * 281475406208040961L >>> 48) * 10000;
    }

    public static int tryToParseEightDigitsUtf8(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(FastDoubleSwar.readLongLE(a, offset2));
    }

    public static int tryToParseEightDigitsUtf8(long chunk) {
        long val = chunk - 0x3030303030303030L;
        long predicate = (chunk + 0x4646464646464646L | val) & 0x8080808080808080L;
        if (predicate != 0L) {
            return -1;
        }
        long mask = 0xFF000000FFL;
        long mul1 = 4294967296000100L;
        long mul2 = 42949672960001L;
        val = val * 10L + (val >>> 8);
        val = (val & mask) * mul1 + (val >>> 16 & mask) * mul2 >>> 32;
        return (int)val;
    }

    public static long tryToParseEightHexDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) << 48 | (long)str.charAt(offset2 + 1) << 32 | (long)str.charAt(offset2 + 2) << 16 | (long)str.charAt(offset2 + 3);
        long second2 = (long)str.charAt(offset2 + 4) << 48 | (long)str.charAt(offset2 + 5) << 32 | (long)str.charAt(offset2 + 6) << 16 | (long)str.charAt(offset2 + 7);
        return FastDoubleSwar.tryToParseEightHexDigitsUtf16(first2, second2);
    }

    public static long tryToParseEightHexDigits(char[] chars, int offset2) {
        long first2 = (long)chars[offset2] << 48 | (long)chars[offset2 + 1] << 32 | (long)chars[offset2 + 2] << 16 | (long)chars[offset2 + 3];
        long second2 = (long)chars[offset2 + 4] << 48 | (long)chars[offset2 + 5] << 32 | (long)chars[offset2 + 6] << 16 | (long)chars[offset2 + 7];
        return FastDoubleSwar.tryToParseEightHexDigitsUtf16(first2, second2);
    }

    public static long tryToParseEightHexDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseEightHexDigitsUtf8(FastDoubleSwar.readLongBE(a, offset2));
    }

    public static long tryToParseEightHexDigitsUtf16(long first2, long second2) {
        long lfirst = FastDoubleSwar.tryToParseFourHexDigitsUtf16(first2);
        long lsecond = FastDoubleSwar.tryToParseFourHexDigitsUtf16(second2);
        return lfirst << 16 | lsecond;
    }

    public static long tryToParseEightHexDigitsUtf8(long chunk) {
        long vec = (chunk | 0x2020202020202020L) - 0x3030303030303030L;
        long gt_09 = vec + 0x7676767676767676L;
        long ge_30 = vec + 0x4F4F4F4F4F4F4F4FL;
        long le_37 = 0x3737373737373737L + (vec ^ 0x7F7F7F7F7F7F7F7FL);
        if ((gt_09 &= 0x8080808080808080L) != ((ge_30 &= 0x8080808080808080L) & le_37)) {
            return -1L;
        }
        long gt_09mask = (gt_09 >>> 7) * 255L;
        long v = vec & (gt_09mask ^ 0xFFFFFFFFFFFFFFFFL) | vec - (0x2727272727272727L & gt_09mask);
        long v2 = v | v >>> 4;
        long v3 = v2 & 0xFF00FF00FF00FFL;
        long v4 = v3 | v3 >>> 8;
        long v5 = v4 >>> 16 & 0xFFFF0000L | v4 & 0xFFFFL;
        return v5;
    }

    public static int tryToParseFourDigits(char[] a, int offset2) {
        long first2 = (long)a[offset2] | (long)a[offset2 + 1] << 16 | (long)a[offset2 + 2] << 32 | (long)a[offset2 + 3] << 48;
        return FastDoubleSwar.tryToParseFourDigitsUtf16(first2);
    }

    public static int tryToParseFourDigits(CharSequence str, int offset2) {
        long first2 = (long)str.charAt(offset2) | (long)str.charAt(offset2 + 1) << 16 | (long)str.charAt(offset2 + 2) << 32 | (long)str.charAt(offset2 + 3) << 48;
        return FastDoubleSwar.tryToParseFourDigitsUtf16(first2);
    }

    public static int tryToParseFourDigits(byte[] a, int offset2) {
        return FastDoubleSwar.tryToParseFourDigitsUtf8(FastDoubleSwar.readIntLE(a, offset2));
    }

    public static int tryToParseFourDigitsUtf16(long first2) {
        long fval = first2 - 0x30003000300030L;
        long fpre = first2 + 0x46004600460046L | fval;
        if ((fpre & 0xFF80FF80FF80FF80L) != 0L) {
            return -1;
        }
        return (int)(fval * 281475406208040961L >>> 48);
    }

    public static int tryToParseFourDigitsUtf8(int chunk) {
        int val = chunk - 0x30303030;
        int predicate = (chunk + 0x46464646 | val) & 0x80808080;
        if ((long)predicate != 0L) {
            return -1;
        }
        val = val * 2561 >>> 8;
        val = (val & 0xFF) * 100 + ((val & 0xFF0000) >> 16);
        return val;
    }

    public static long tryToParseFourHexDigitsUtf16(long chunk) {
        long vec = chunk - 0x30003000300030L;
        long gt_09 = vec + 0x7FF67FF67FF67FF6L;
        long ge_30 = vec + 0x7FCF7FCF7FCF7FCFL;
        long le_37 = 0x37003700370037L + (vec ^ 0x7FFF7FFF7FFF7FFFL);
        if ((gt_09 &= 0x8000800080008000L) != ((ge_30 &= 0x8000800080008000L) & le_37)) {
            return -1L;
        }
        long gt_09mask = (gt_09 >>> 15) * 65535L;
        long v = vec & (gt_09mask ^ 0xFFFFFFFFFFFFFFFFL) | vec - (0x27002700270027L & gt_09mask);
        long v2 = v | v >>> 12;
        long v5 = (v2 | v2 >>> 24) & 0xFFFFL;
        return v5;
    }

    public static int tryToParseUpTo7Digits(byte[] str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            byte ch = str[from];
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static int tryToParseUpTo7Digits(char[] str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            char ch = str[from];
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static int tryToParseUpTo7Digits(CharSequence str, int from, int to) {
        int result2 = 0;
        boolean success = true;
        while (from < to) {
            char ch = str.charAt(from);
            success &= FastDoubleSwar.isDigit(ch);
            result2 = 10 * result2 + ch - 48;
            ++from;
        }
        return success ? result2 : -1;
    }

    public static void writeIntBE(byte[] a, int offset2, int v) {
        a[offset2] = (byte)(v >>> 24);
        a[offset2 + 1] = (byte)(v >>> 16);
        a[offset2 + 2] = (byte)(v >>> 8);
        a[offset2 + 3] = (byte)v;
    }

    public static void writeLongBE(byte[] a, int offset2, long v) {
        a[offset2] = (byte)(v >>> 56);
        a[offset2 + 1] = (byte)(v >>> 48);
        a[offset2 + 2] = (byte)(v >>> 40);
        a[offset2 + 3] = (byte)(v >>> 32);
        a[offset2 + 4] = (byte)(v >>> 24);
        a[offset2 + 5] = (byte)(v >>> 16);
        a[offset2 + 6] = (byte)(v >>> 8);
        a[offset2 + 7] = (byte)v;
    }

    public static double fma(double a, double b, double c) {
        return a * b + c;
    }
}

