/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.sound.AudioData;
import korlibs.audio.sound.AudioSamples;
import korlibs.audio.sound.AudioStream;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001d\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010$R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lkorlibs/audio/sound/AudioDataStream;", "Lkorlibs/audio/sound/AudioStream;", "data", "Lkorlibs/audio/sound/AudioData;", "(Lkorlibs/audio/sound/AudioData;)V", "value", "", "currentPositionInSamples", "getCurrentPositionInSamples", "()J", "setCurrentPositionInSamples", "(J)V", "cursor", "", "getCursor", "()I", "setCursor", "(I)V", "getData", "()Lkorlibs/audio/sound/AudioData;", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "totalLengthInSamples", "getTotalLengthInSamples", "()Ljava/lang/Long;", "clone", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "out", "Lkorlibs/audio/sound/AudioSamples;", "offset", "length", "(Lkorlibs/audio/sound/AudioSamples;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "korge-core"})
public final class AudioDataStream
extends AudioStream {
    @NotNull
    private final AudioData data;
    private int cursor;
    private boolean finished;

    public AudioDataStream(@NotNull AudioData data2) {
        super(data2.getRate(), data2.getChannels());
        this.data = data2;
    }

    @NotNull
    public final AudioData getData() {
        return this.data;
    }

    public final int getCursor() {
        return this.cursor;
    }

    public final void setCursor(int n) {
        this.cursor = n;
    }

    @Override
    public boolean getFinished() {
        return this.finished;
    }

    public void setFinished(boolean bl) {
        this.finished = bl;
    }

    @Override
    @NotNull
    public Long getTotalLengthInSamples() {
        return this.data.getTotalSamples();
    }

    @Override
    public long getCurrentPositionInSamples() {
        return this.cursor;
    }

    @Override
    public void setCurrentPositionInSamples(long value) {
        this.cursor = (int)value;
        this.setFinished(false);
    }

    @Override
    @Nullable
    public Object read(@NotNull AudioSamples out, int offset2, int length2, @NotNull Continuation<? super Integer> $completion) {
        int available = this.data.getSamples().getTotalSamples() - this.cursor;
        int toread = Math.min(available, length2);
        if (toread > 0) {
            int n = this.getChannels();
            for (int n2 = 0; n2 < n; ++n2) {
                ArraysKt.arraycopy(this.data.getSamples().get(n2), this.cursor, out.get(n2), offset2, toread);
            }
            this.cursor += toread;
        }
        if (toread <= 0) {
            this.setFinished(true);
        }
        return Boxing.boxInt(toread);
    }

    @Override
    @Nullable
    public Object clone(@NotNull Continuation<? super AudioStream> $completion) {
        return new AudioDataStream(this.data);
    }
}

