/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.internal.CoerceKt;
import korlibs.audio.sound.IAudioSamples;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0017\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0011\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J!\u0010\"\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u001aH\u0096\u0002J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006*"}, d2={"Lkorlibs/audio/sound/AudioSamples;", "Lkorlibs/audio/sound/IAudioSamples;", "channels", "", "totalSamples", "data", "", "", "(II[[S)V", "getChannels", "()I", "getData", "()[[S", "[[S", "getTotalSamples", "clone", "out", "copyTo", "", "that", "equals", "", "other", "", "get", "channel", "", "sample", "hashCode", "scaleVolume", "scale", "", "channelScales", "", "set", "value", "setStereo", "valueLeft", "valueRight", "setTo", "toString", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nAudioSamples.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSamples.kt\nkorlibs/audio/sound/AudioSamples\n+ 2 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n*L\n1#1,271:1\n66#2,3:272\n115#2,6:275\n*S KotlinDebug\n*F\n+ 1 AudioSamples.kt\nkorlibs/audio/sound/AudioSamples\n*L\n107#1:272,3\n115#1:275,6\n*E\n"})
public final class AudioSamples
implements IAudioSamples {
    private final int channels;
    private final int totalSamples;
    @NotNull
    private final short[][] data;

    public AudioSamples(int channels, int totalSamples, @NotNull short[][] data2) {
        this.channels = channels;
        this.totalSamples = totalSamples;
        this.data = data2;
    }

    public /* synthetic */ AudioSamples(int n, int n2, short[][] object, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            int n4 = 0;
            short[][] sArrayArray = new short[n][];
            while (n4 < n) {
                int n5 = n4++;
                sArrayArray[n5] = new short[n2];
            }
            object = sArrayArray;
        }
        this(n, n2, (short[][])object);
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getTotalSamples() {
        return this.totalSamples;
    }

    @NotNull
    public final short[][] getData() {
        return this.data;
    }

    @NotNull
    public final short[] get(int channel) {
        return this.data[channel];
    }

    @Override
    public short get(int channel, int sample2) {
        return this.data[channel][sample2];
    }

    @Override
    public void set(int channel, int sample2, short value) {
        this.data[channel][sample2] = value;
    }

    public final void setStereo(int sample2, short valueLeft, short valueRight) {
        this.set(0, sample2, valueLeft);
        this.set(1, sample2, valueRight);
    }

    @Override
    @NotNull
    public AudioSamples scaleVolume(float scale) {
        Object[] $this$fastForEach$iv = (Object[])this.data;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.length) {
            short[] channel = (short[])$this$fastForEach$iv[n$iv++];
            boolean bl = false;
            int n = channel.length;
            for (int n2 = 0; n2 < n; ++n2) {
                channel[n2] = CoerceKt.coerceToShort((int)((float)channel[n2] * scale));
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AudioSamples scaleVolume(@NotNull float[] channelScales) {
        Object[] $this$fastForEachWithIndex$iv = (Object[])this.data;
        boolean $i$f$fastForEachWithIndex = false;
        for (int n$iv = 0; n$iv < $this$fastForEachWithIndex$iv.length; ++n$iv) {
            void channel;
            short[] sArray = (short[])$this$fastForEachWithIndex$iv[n$iv];
            int ch = n$iv;
            boolean bl = false;
            int n = ((void)channel).length;
            for (int n2 = 0; n2 < n; ++n2) {
                channel[n2] = CoerceKt.coerceToShort((int)((float)channel[n2] * channelScales[ch]));
            }
        }
        return this;
    }

    @NotNull
    public final AudioSamples setTo(@NotNull AudioSamples that) {
        that.copyTo(this);
        return this;
    }

    public final void copyTo(@NotNull AudioSamples that) {
        int n = Math.min(this.getChannels(), that.getChannels());
        for (int ch = 0; ch < n; ++ch) {
            ArraysKt.arraycopy(this.data[ch], 0, that.data[ch], 0, Math.min(this.getTotalSamples(), that.getTotalSamples()));
        }
    }

    @NotNull
    public final AudioSamples clone(@NotNull AudioSamples out) {
        this.copyTo(out);
        return out;
    }

    public static /* synthetic */ AudioSamples clone$default(AudioSamples audioSamples, AudioSamples audioSamples2, int n, Object object) {
        if ((n & 1) != 0) {
            int n2 = 0;
            int n3 = ((Object[])audioSamples.data).length;
            short[][] sArrayArray = new short[n3][];
            int n4 = audioSamples.getTotalSamples();
            int n5 = audioSamples.getChannels();
            while (n2 < n3) {
                int n6 = n2++;
                sArrayArray[n6] = new short[audioSamples.data[0].length];
            }
            short[][] sArrayArray2 = sArrayArray;
            int n7 = n4;
            int n8 = n5;
            audioSamples2 = new AudioSamples(n8, n7, sArrayArray2);
        }
        return audioSamples.clone(audioSamples2);
    }

    public int hashCode() {
        Object[] objectArray = (Object[])this.data;
        return this.getChannels() + this.getTotalSamples() * 32 + kotlin.collections.ArraysKt.contentDeepHashCode(objectArray) * 64;
    }

    public boolean equals(@Nullable Object other) {
        Object[] objectArray;
        Object[] objectArray2;
        return other instanceof AudioSamples && this.getChannels() == ((AudioSamples)other).getChannels() && this.getTotalSamples() == ((AudioSamples)other).getTotalSamples() && kotlin.collections.ArraysKt.contentDeepEquals(objectArray2 = (Object[])this.data, objectArray = (Object[])((AudioSamples)other).data);
    }

    @NotNull
    public String toString() {
        return "AudioSamples(channels=" + this.getChannels() + ", totalSamples=" + this.getTotalSamples() + ")";
    }

    @Override
    @NotNull
    public IAudioSamples scaleVolume(double scale) {
        return IAudioSamples.DefaultImpls.scaleVolume((IAudioSamples)this, scale);
    }

    @Override
    @NotNull
    public IAudioSamples scaleVolume(@NotNull double[] channelScales) {
        return IAudioSamples.DefaultImpls.scaleVolume((IAudioSamples)this, channelScales);
    }

    @Override
    public boolean isEmpty() {
        return IAudioSamples.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean isNotEmpty() {
        return IAudioSamples.DefaultImpls.isNotEmpty(this);
    }

    @Override
    public float getFloat(int channel, int sample2) {
        return IAudioSamples.DefaultImpls.getFloat(this, channel, sample2);
    }

    @Override
    public void setFloat(int channel, int sample2, float value) {
        IAudioSamples.DefaultImpls.setFloat(this, channel, sample2, value);
    }

    @Override
    public void setFloatStereo(int sample2, float l, float r) {
        IAudioSamples.DefaultImpls.setFloatStereo(this, sample2, l, r);
    }
}

