/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.internal.SampleConvert;
import korlibs.audio.sound.AudioSamples;
import korlibs.audio.sound.AudioSamplesInterleaved;
import korlibs.audio.sound.IAudioSamples;
import korlibs.datastructure.ShortArrayDeque;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0003J\"\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\"\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u001d2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\"\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u001e2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0003J\b\u0010#\u001a\u00020$H\u0016J\"\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\"\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001d2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\"\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001e2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J*\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u001fJ*\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00032\u0006\u0010'\u001a\u00020*2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u0016\u0010+\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00032\u0006\u0010)\u001a\u00020\"J*\u0010,\u001a\u00020\u00122\u0006\u0010'\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006-"}, d2={"Lkorlibs/audio/sound/AudioSamplesDeque;", "", "channels", "", "(I)V", "availableRead", "getAvailableRead", "()I", "availableReadMax", "getAvailableReadMax", "buffer", "", "Lkorlibs/datastructure/ShortArrayDeque;", "getBuffer", "()[Lkorlibs/datastructure/ShortArrayDeque;", "[Lkorlibs/datastructure/ShortArrayDeque;", "getChannels", "clear", "", "clone", "copyTo", "out", "temp", "Lkorlibs/audio/sound/AudioSamples;", "createTempSamples", "size", "read", "offset", "len", "Lkorlibs/audio/sound/AudioSamplesInterleaved;", "Lkorlibs/audio/sound/IAudioSamples;", "", "channel", "readFloat", "", "toString", "", "write", "samples", "data", "", "sample", "", "writeFloat", "writeInterleaved", "korge-core"})
@SourceDebugExtension(value={"SMAP\nAudioSamplesDeque.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSamplesDeque.kt\nkorlibs/audio/sound/AudioSamplesDeque\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class AudioSamplesDeque {
    private final int channels;
    @NotNull
    private final ShortArrayDeque[] buffer;

    public AudioSamplesDeque(int channels) {
        this.channels = channels;
        int n = 0;
        int n2 = this.channels;
        ShortArrayDeque[] shortArrayDequeArray = new ShortArrayDeque[n2];
        AudioSamplesDeque audioSamplesDeque = this;
        while (n < n2) {
            int n3 = n++;
            shortArrayDequeArray[n3] = new ShortArrayDeque(0, 1, null);
        }
        audioSamplesDeque.buffer = shortArrayDequeArray;
    }

    public final int getChannels() {
        return this.channels;
    }

    @NotNull
    public final ShortArrayDeque[] getBuffer() {
        return this.buffer;
    }

    public final int getAvailableRead() {
        ShortArrayDeque shortArrayDeque = ArraysKt.getOrNull(this.buffer, 0);
        return shortArrayDeque != null ? shortArrayDeque.getAvailableRead() : 0;
    }

    public final int getAvailableReadMax() {
        Comparable comparable;
        ShortArrayDeque[] shortArrayDequeArray = this.buffer;
        if (shortArrayDequeArray.length == 0) {
            comparable = null;
        } else {
            ShortArrayDeque it = shortArrayDequeArray[0];
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getAvailableRead());
            IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex(shortArrayDequeArray)).iterator();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                ShortArrayDeque it2 = shortArrayDequeArray[n];
                $i$a$-maxOfOrNull-AudioSamplesDeque$availableReadMax$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getAvailableRead());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    @NotNull
    public final AudioSamples createTempSamples(int size2) {
        return new AudioSamples(this.channels, size2, null, 4, null);
    }

    public static /* synthetic */ AudioSamples createTempSamples$default(AudioSamplesDeque audioSamplesDeque, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        return audioSamplesDeque.createTempSamples(n);
    }

    public final void copyTo(@NotNull AudioSamplesDeque out, @NotNull AudioSamples temp) {
        int read2;
        while ((read2 = AudioSamplesDeque.read$default(this, temp, 0, 0, 6, null)) > 0) {
            out.write(temp, 0, read2);
        }
        return;
    }

    public static /* synthetic */ void copyTo$default(AudioSamplesDeque audioSamplesDeque, AudioSamplesDeque audioSamplesDeque2, AudioSamples audioSamples, int n, Object object) {
        if ((n & 2) != 0) {
            audioSamples = AudioSamplesDeque.createTempSamples$default(audioSamplesDeque, 0, 1, null);
        }
        audioSamplesDeque.copyTo(audioSamplesDeque2, audioSamples);
    }

    public final short read(int channel) {
        return this.buffer[channel].readOne();
    }

    public final void write(int channel, short sample2) {
        this.buffer[channel].writeOne(sample2);
    }

    public final float readFloat(int channel) {
        return (float)this.read(channel) / 32767.0f;
    }

    public final void writeFloat(int channel, float sample2) {
        this.write(channel, (short)(sample2 * 32767.0f));
    }

    public final void write(@NotNull AudioSamples samples, int offset2, int len) {
        int n = this.channels;
        for (int channel = 0; channel < n; ++channel) {
            this.write(channel, samples.get(channel % samples.getChannels()), offset2, len);
        }
    }

    public static /* synthetic */ void write$default(AudioSamplesDeque audioSamplesDeque, AudioSamples audioSamples, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = audioSamples.getTotalSamples() - n;
        }
        audioSamplesDeque.write(audioSamples, n, n2);
    }

    public final void write(@NotNull AudioSamplesInterleaved samples, int offset2, int len) {
        this.writeInterleaved(samples.getData(), offset2, len, samples.getChannels());
    }

    public static /* synthetic */ void write$default(AudioSamplesDeque audioSamplesDeque, AudioSamplesInterleaved audioSamplesInterleaved, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = audioSamplesInterleaved.getTotalSamples() - n;
        }
        audioSamplesDeque.write(audioSamplesInterleaved, n, n2);
    }

    public final void write(@NotNull IAudioSamples samples, int offset2, int len) {
        IAudioSamples iAudioSamples = samples;
        if (iAudioSamples instanceof AudioSamples) {
            this.write((AudioSamples)samples, offset2, len);
        } else if (iAudioSamples instanceof AudioSamplesInterleaved) {
            this.write((AudioSamplesInterleaved)samples, offset2, len);
        } else {
            int n = samples.getChannels();
            for (int c = 0; c < n; ++c) {
                for (int n2 = 0; n2 < len; ++n2) {
                    this.write(c, samples.get(c, offset2 + n2));
                }
            }
        }
    }

    public static /* synthetic */ void write$default(AudioSamplesDeque audioSamplesDeque, IAudioSamples iAudioSamples, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = iAudioSamples.getTotalSamples() - n;
        }
        audioSamplesDeque.write(iAudioSamples, n, n2);
    }

    public final void write(int channel, @NotNull short[] data2, int offset2, int len) {
        this.buffer[channel].write(data2, offset2, len);
    }

    public static /* synthetic */ void write$default(AudioSamplesDeque audioSamplesDeque, int n, short[] sArray, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = sArray.length - n2;
        }
        audioSamplesDeque.write(n, sArray, n2, n3);
    }

    public final void write(int channel, @NotNull float[] data2, int offset2, int len) {
        for (int n = 0; n < len; ++n) {
            this.write(channel, SampleConvert.INSTANCE.floatToShort(data2[offset2 + n]));
        }
    }

    public static /* synthetic */ void write$default(AudioSamplesDeque audioSamplesDeque, int n, float[] fArray, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = fArray.length - n2;
        }
        audioSamplesDeque.write(n, fArray, n2, n3);
    }

    public final void writeInterleaved(@NotNull short[] data2, int offset2, int len, int channels) {
        switch (channels) {
            case 1: {
                int n = this.channels;
                for (int n2 = 0; n2 < n; ++n2) {
                    this.buffer[n2].write(data2, offset2, len);
                }
                break;
            }
            case 2: {
                int n;
                int n3 = len / 2;
                for (n = 0; n < n3; ++n) {
                    this.write(0, data2[n * 2 + 0]);
                }
                n3 = len / 2;
                for (n = 0; n < n3; ++n) {
                    this.write(1, data2[n * 2 + 1]);
                }
                break;
            }
            default: {
                for (int c = 0; c < channels; ++c) {
                    int n = len / channels;
                    for (int n4 = 0; n4 < n; ++n4) {
                        this.write(c, data2[n4 * channels + c]);
                    }
                }
            }
        }
    }

    public static /* synthetic */ void writeInterleaved$default(AudioSamplesDeque audioSamplesDeque, short[] sArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = sArray.length - n;
        }
        if ((n4 & 8) != 0) {
            n3 = audioSamplesDeque.channels;
        }
        audioSamplesDeque.writeInterleaved(sArray, n, n2, n3);
    }

    public final int read(@NotNull AudioSamples out, int offset2, int len) {
        int rlen = Math.min(len, this.getAvailableRead());
        int n = out.getChannels();
        for (int channel = 0; channel < n; ++channel) {
            this.buffer[channel % this.channels].read(out.get(channel), offset2, rlen);
        }
        return rlen;
    }

    public static /* synthetic */ int read$default(AudioSamplesDeque audioSamplesDeque, AudioSamples audioSamples, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = audioSamples.getTotalSamples() - n;
        }
        return audioSamplesDeque.read(audioSamples, n, n2);
    }

    public final int read(@NotNull AudioSamplesInterleaved out, int offset2, int len) {
        int rlen = Math.min(len, this.getAvailableRead());
        int n = out.getChannels();
        for (int channel = 0; channel < n; ++channel) {
            for (int n2 = 0; n2 < rlen; ++n2) {
                out.set(channel, offset2 + n2, this.read(channel));
            }
        }
        return rlen;
    }

    public static /* synthetic */ int read$default(AudioSamplesDeque audioSamplesDeque, AudioSamplesInterleaved audioSamplesInterleaved, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = audioSamplesInterleaved.getTotalSamples() - n;
        }
        return audioSamplesDeque.read(audioSamplesInterleaved, n, n2);
    }

    public final int read(@NotNull IAudioSamples out, int offset2, int len) {
        int result2 = Math.min(len, this.getAvailableRead());
        IAudioSamples iAudioSamples = out;
        if (iAudioSamples instanceof AudioSamples) {
            this.read((AudioSamples)out, offset2, len);
        } else if (iAudioSamples instanceof AudioSamplesInterleaved) {
            this.read((AudioSamplesInterleaved)out, offset2, len);
        } else {
            int n = out.getChannels();
            for (int c = 0; c < n; ++c) {
                for (int n2 = 0; n2 < len; ++n2) {
                    out.set(c, offset2 + n2, this.read(c));
                }
            }
        }
        return result2;
    }

    public static /* synthetic */ int read$default(AudioSamplesDeque audioSamplesDeque, IAudioSamples iAudioSamples, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = iAudioSamples.getTotalSamples() - n;
        }
        return audioSamplesDeque.read(iAudioSamples, n, n2);
    }

    public final void clear() {
        int n = this.buffer.length;
        for (int c = 0; c < n; ++c) {
            this.buffer[c].clear();
        }
    }

    @NotNull
    public final AudioSamplesDeque clone() {
        AudioSamplesDeque audioSamplesDeque;
        AudioSamplesDeque it = audioSamplesDeque = new AudioSamplesDeque(this.channels);
        boolean bl = false;
        int n = this.buffer.length;
        for (int n2 = 0; n2 < n; ++n2) {
            it.buffer[n2] = this.buffer[n2].clone();
        }
        return audioSamplesDeque;
    }

    @NotNull
    public String toString() {
        return "AudioSamplesDeque(channels=" + this.channels + ", availableRead=" + this.getAvailableRead() + ")";
    }
}

