/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.internal.CoerceKt;
import korlibs.audio.sound.IAudioSamples;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J!\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lkorlibs/audio/sound/AudioSamplesInterleaved;", "Lkorlibs/audio/sound/IAudioSamples;", "channels", "", "totalSamples", "data", "", "(II[S)V", "getChannels", "()I", "getData", "()[S", "getTotalSamples", "get", "", "channel", "sample", "index", "scaleVolume", "scale", "", "channelScales", "", "set", "", "value", "toString", "", "korge-core"})
public final class AudioSamplesInterleaved
implements IAudioSamples {
    private final int channels;
    private final int totalSamples;
    @NotNull
    private final short[] data;

    public AudioSamplesInterleaved(int channels, int totalSamples, @NotNull short[] data2) {
        this.channels = channels;
        this.totalSamples = totalSamples;
        this.data = data2;
    }

    public /* synthetic */ AudioSamplesInterleaved(int n, int n2, short[] sArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            sArray = new short[n2 * n];
        }
        this(n, n2, sArray);
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getTotalSamples() {
        return this.totalSamples;
    }

    @NotNull
    public final short[] getData() {
        return this.data;
    }

    private final int index(int channel, int sample2) {
        return sample2 * this.getChannels() + channel;
    }

    @Override
    public short get(int channel, int sample2) {
        return this.data[this.index(channel, sample2)];
    }

    @Override
    public void set(int channel, int sample2, short value) {
        this.data[this.index((int)channel, (int)sample2)] = value;
    }

    @Override
    @NotNull
    public AudioSamplesInterleaved scaleVolume(float scale) {
        int n = this.data.length;
        for (int n2 = 0; n2 < n; ++n2) {
            this.data[n2] = CoerceKt.coerceToShort((int)((float)this.data[n2] * scale));
        }
        return this;
    }

    @Override
    @NotNull
    public AudioSamplesInterleaved scaleVolume(@NotNull float[] channelScales) {
        int n = this.getChannels();
        for (int ch = 0; ch < n; ++ch) {
            float chVolume = channelScales[ch];
            int n2 = this.getTotalSamples();
            for (int n3 = 0; n3 < n2; ++n3) {
                int i2 = n3 * this.getChannels() + ch;
                this.data[i2] = CoerceKt.coerceToShort((int)((float)this.data[i2] * chVolume));
            }
        }
        return this;
    }

    @NotNull
    public String toString() {
        return "AudioSamplesInterleaved(channels=" + this.getChannels() + ", totalSamples=" + this.getTotalSamples() + ")";
    }

    @Override
    @NotNull
    public IAudioSamples scaleVolume(double scale) {
        return IAudioSamples.DefaultImpls.scaleVolume((IAudioSamples)this, scale);
    }

    @Override
    @NotNull
    public IAudioSamples scaleVolume(@NotNull double[] channelScales) {
        return IAudioSamples.DefaultImpls.scaleVolume((IAudioSamples)this, channelScales);
    }

    @Override
    public boolean isEmpty() {
        return IAudioSamples.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean isNotEmpty() {
        return IAudioSamples.DefaultImpls.isNotEmpty(this);
    }

    @Override
    public float getFloat(int channel, int sample2) {
        return IAudioSamples.DefaultImpls.getFloat(this, channel, sample2);
    }

    @Override
    public void setFloat(int channel, int sample2, float value) {
        IAudioSamples.DefaultImpls.setFloat(this, channel, sample2, value);
    }

    @Override
    public void setFloatStereo(int sample2, float l, float r) {
        IAudioSamples.DefaultImpls.setFloatStereo(this, sample2, l, r);
    }
}

