/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.sound.AudioSamples;
import korlibs.audio.sound.AudioSamplesInterleaved;
import korlibs.audio.sound.IAudioSamples;
import korlibs.math.ClampKt;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u0001\u001a(\u0010\u000f\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\u000f\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u001a\u001a\u0010\u0014\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u001a\u0014\u0010\u0015\u001a\u00020\u0007*\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a8\u0006\u0016"}, d2={"applyProps", "Lkorlibs/audio/sound/AudioSamplesInterleaved;", "speed", "", "panning", "volume", "copyOfRange", "Lkorlibs/audio/sound/AudioSamples;", "start", "", "end", "ensureTwoChannels", "interleaved", "out", "Lkorlibs/audio/sound/IAudioSamples;", "resample", "scale", "totalSamples", "srcFreq", "dstFreq", "resampleIfRequired", "separated", "korge-core"})
@SourceDebugExtension(value={"SMAP\nAudioSamples.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSamples.kt\nkorlibs/audio/sound/AudioSamplesKt\n+ 2 Assert.kt\nkorlibs/io/lang/AssertKt\n*L\n1#1,271:1\n4#2,2:272\n4#2,2:274\n*S KotlinDebug\n*F\n+ 1 AudioSamples.kt\nkorlibs/audio/sound/AudioSamplesKt\n*L\n178#1:272,2\n203#1:274,2\n*E\n"})
public final class AudioSamplesKt {
    @NotNull
    public static final AudioSamples resample(@NotNull AudioSamples $this$resample, double scale, int totalSamples, @NotNull AudioSamples out) {
        double iscale = 1.0 / scale;
        int n = $this$resample.getChannels();
        for (int c = 0; c < n; ++c) {
            short[] inpc = $this$resample.get(c);
            short[] outc = out.get(c);
            for (int n2 = 0; n2 < totalSamples; ++n2) {
                outc[n2] = inpc[(int)((double)n2 * iscale)];
            }
        }
        return out;
    }

    public static /* synthetic */ AudioSamples resample$default(AudioSamples audioSamples, double d, int n, AudioSamples audioSamples2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = (int)((double)audioSamples.getTotalSamples() * d);
        }
        if ((n2 & 4) != 0) {
            audioSamples2 = new AudioSamples(audioSamples.getChannels(), n, null, 4, null);
        }
        return AudioSamplesKt.resample(audioSamples, d, n, audioSamples2);
    }

    @NotNull
    public static final AudioSamples resample(@NotNull AudioSamples $this$resample, int srcFreq, int dstFreq) {
        return AudioSamplesKt.resample$default($this$resample, (double)dstFreq / (double)srcFreq, 0, null, 6, null);
    }

    @NotNull
    public static final AudioSamples resampleIfRequired(@NotNull AudioSamples $this$resampleIfRequired, int srcFreq, int dstFreq) {
        return srcFreq == dstFreq ? $this$resampleIfRequired : AudioSamplesKt.resample($this$resampleIfRequired, srcFreq, dstFreq);
    }

    @NotNull
    public static final AudioSamples copyOfRange(@NotNull AudioSamples $this$copyOfRange, int start2, int end2) {
        AudioSamples out = new AudioSamples($this$copyOfRange.getChannels(), end2 - start2, null, 4, null);
        int n = $this$copyOfRange.getChannels();
        for (int n2 = 0; n2 < n; ++n2) {
            ArraysKt.arraycopy($this$copyOfRange.get(n2), start2, out.get(n2), 0, end2 - start2);
        }
        return out;
    }

    @NotNull
    public static final AudioSamplesInterleaved interleaved(@NotNull AudioSamples $this$interleaved, @NotNull AudioSamplesInterleaved out) {
        boolean cond$iv = out.getData().length >= $this$interleaved.getTotalSamples() * $this$interleaved.getChannels();
        boolean $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        switch ($this$interleaved.getChannels()) {
            case 1: {
                ArraysKt.arraycopy($this$interleaved.getData()[0], 0, out.getData(), 0, $this$interleaved.getTotalSamples());
                break;
            }
            case 2: {
                ArraysKt.arrayinterleave(out.getData(), 0, $this$interleaved.getData()[0], 0, $this$interleaved.getData()[1], 0, $this$interleaved.getTotalSamples());
                break;
            }
            default: {
                short[] outData = out.getData();
                int channels = $this$interleaved.getChannels();
                for (int c = 0; c < channels; ++c) {
                    int m = c;
                    int n = $this$interleaved.getTotalSamples();
                    for (int n2 = 0; n2 < n; ++n2) {
                        outData[m] = $this$interleaved.get(c, n2);
                        m += channels;
                    }
                }
            }
        }
        return out;
    }

    public static /* synthetic */ AudioSamplesInterleaved interleaved$default(AudioSamples audioSamples, AudioSamplesInterleaved audioSamplesInterleaved, int n, Object object) {
        if ((n & 1) != 0) {
            audioSamplesInterleaved = new AudioSamplesInterleaved(audioSamples.getChannels(), audioSamples.getTotalSamples(), null, 4, null);
        }
        return AudioSamplesKt.interleaved(audioSamples, audioSamplesInterleaved);
    }

    @NotNull
    public static final AudioSamplesInterleaved interleaved(@NotNull IAudioSamples $this$interleaved, @NotNull AudioSamplesInterleaved out) {
        boolean cond$iv = out.getData().length >= $this$interleaved.getTotalSamples() * $this$interleaved.getChannels();
        boolean $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        IAudioSamples iAudioSamples = $this$interleaved;
        if (iAudioSamples instanceof AudioSamples) {
            AudioSamplesKt.interleaved((AudioSamples)$this$interleaved, out);
        } else if (iAudioSamples instanceof AudioSamplesInterleaved) {
            ArraysKt.arraycopy(((AudioSamplesInterleaved)$this$interleaved).getData(), 0, out.getData(), 0, $this$interleaved.getTotalSamples() * $this$interleaved.getChannels());
        } else {
            short[] outData = out.getData();
            int channels = $this$interleaved.getChannels();
            for (int c = 0; c < channels; ++c) {
                int m = c;
                int n = $this$interleaved.getTotalSamples();
                for (int n2 = 0; n2 < n; ++n2) {
                    outData[m] = $this$interleaved.get(c, n2);
                    m += channels;
                }
            }
        }
        return out;
    }

    public static /* synthetic */ AudioSamplesInterleaved interleaved$default(IAudioSamples iAudioSamples, AudioSamplesInterleaved audioSamplesInterleaved, int n, Object object) {
        if ((n & 1) != 0) {
            audioSamplesInterleaved = new AudioSamplesInterleaved(iAudioSamples.getChannels(), iAudioSamples.getTotalSamples(), null, 4, null);
        }
        return AudioSamplesKt.interleaved(iAudioSamples, audioSamplesInterleaved);
    }

    @NotNull
    public static final AudioSamplesInterleaved applyProps(@NotNull AudioSamplesInterleaved $this$applyProps, double speed, double panning, double volume) {
        if (speed == 1.0 && panning == 0.0 && volume == 1.0) {
            return $this$applyProps;
        }
        float speedf = (float)speed;
        float ispeedf = (float)(1.0 / speed);
        AudioSamplesInterleaved out = new AudioSamplesInterleaved($this$applyProps.getChannels(), (int)((float)$this$applyProps.getTotalSamples() * ispeedf), null, 4, null);
        float rratio = (float)(ClampKt.clamp01((panning + 1.0) / 2.0) * volume);
        float lratio = (float)((1.0 - (double)rratio) * volume);
        short[] outData = out.getData();
        int m = 0;
        if ($this$applyProps.getChannels() == 2) {
            int n = out.getTotalSamples();
            for (int n2 = 0; n2 < n; ++n2) {
                outData[m++] = (short)((float)outData[(int)((float)n2 * speedf) * 2 + 0] * lratio);
                outData[m++] = (short)((float)outData[(int)((float)n2 * speedf) * 2 + 1] * rratio);
            }
        } else {
            int n = out.getData().length;
            for (int n3 = 0; n3 < n; ++n3) {
                outData[m++] = (short)((float)outData[(int)((float)n3 * speedf)] * lratio);
            }
        }
        return out;
    }

    @NotNull
    public static final AudioSamplesInterleaved ensureTwoChannels(@NotNull AudioSamplesInterleaved $this$ensureTwoChannels) {
        AudioSamplesInterleaved audioSamplesInterleaved;
        if ($this$ensureTwoChannels.getChannels() == 2) {
            audioSamplesInterleaved = $this$ensureTwoChannels;
        } else {
            AudioSamplesInterleaved audioSamplesInterleaved2;
            AudioSamplesInterleaved out = audioSamplesInterleaved2 = new AudioSamplesInterleaved(2, $this$ensureTwoChannels.getTotalSamples(), null, 4, null);
            boolean bl = false;
            AudioSamplesInterleaved inp = $this$ensureTwoChannels;
            int m = 0;
            int ichannels = inp.getChannels();
            short[] odata = out.getData();
            short[] idata = inp.getData();
            int n = out.getTotalSamples();
            for (int n2 = 0; n2 < n; ++n2) {
                short v = idata[n2 * ichannels];
                odata[m++] = v;
                odata[m++] = v;
            }
            audioSamplesInterleaved = audioSamplesInterleaved2;
        }
        return audioSamplesInterleaved;
    }

    @NotNull
    public static final AudioSamples separated(@NotNull IAudioSamples $this$separated, @NotNull AudioSamples out) {
        int n = $this$separated.getTotalSamples();
        for (int n2 = 0; n2 < n; ++n2) {
            int n3 = $this$separated.getChannels();
            for (int c = 0; c < n3; ++c) {
                out.set(c, n2, $this$separated.get(c, n2));
            }
        }
        return out;
    }

    public static /* synthetic */ AudioSamples separated$default(IAudioSamples iAudioSamples, AudioSamples audioSamples, int n, Object object) {
        if ((n & 1) != 0) {
            audioSamples = new AudioSamples(iAudioSamples.getChannels(), iAudioSamples.getTotalSamples(), null, 4, null);
        }
        return AudioSamplesKt.separated(iAudioSamples, audioSamples);
    }
}

