/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import korlibs.audio.internal.SampleConvert;
import korlibs.audio.sound.AudioSamples;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0018"}, d2={"Lkorlibs/audio/sound/AudioSamplesProcessor;", "", "channels", "", "totalSamples", "data", "", "", "(II[[F)V", "getChannels", "()I", "getData", "()[[F", "[[F", "getTotalSamples", "add", "samples", "Lkorlibs/audio/sound/AudioSamples;", "scale", "", "copyTo", "", "normalize", "reset", "korge-core"})
public final class AudioSamplesProcessor {
    private final int channels;
    private final int totalSamples;
    @NotNull
    private final float[][] data;

    public AudioSamplesProcessor(int channels, int totalSamples, @NotNull float[][] data2) {
        this.channels = channels;
        this.totalSamples = totalSamples;
        this.data = data2;
    }

    public /* synthetic */ AudioSamplesProcessor(int n, int n2, float[][] object, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            int n4 = 0;
            float[][] fArrayArray = new float[n][];
            while (n4 < n) {
                int n5 = n4++;
                fArrayArray[n5] = new float[n2];
            }
            object = fArrayArray;
        }
        this(n, n2, (float[][])object);
    }

    public final int getChannels() {
        return this.channels;
    }

    public final int getTotalSamples() {
        return this.totalSamples;
    }

    @NotNull
    public final float[][] getData() {
        return this.data;
    }

    @NotNull
    public final AudioSamplesProcessor reset() {
        int n = this.channels;
        for (int ch = 0; ch < n; ++ch) {
            ArraysKt.fill$default(this.data[ch], 0.0f, 0, 0, 6, null);
        }
        return this;
    }

    @NotNull
    public final AudioSamplesProcessor add(@NotNull AudioSamples samples, float scale) {
        int n = Math.min(this.channels, samples.getChannels());
        for (int ch = 0; ch < n; ++ch) {
            float[] odata = this.data[ch];
            short[] idata = samples.getData()[ch];
            int n2 = samples.getTotalSamples();
            for (int n3 = 0; n3 < n2; ++n3) {
                int n4 = n3;
                odata[n4] = odata[n4] + SampleConvert.INSTANCE.shortToFloat(idata[n3]) * scale;
            }
        }
        return this;
    }

    public static /* synthetic */ AudioSamplesProcessor add$default(AudioSamplesProcessor audioSamplesProcessor, AudioSamples audioSamples, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        return audioSamplesProcessor.add(audioSamples, f);
    }

    @NotNull
    public final AudioSamplesProcessor normalize() {
        int n = this.channels;
        for (int ch = 0; ch < n; ++ch) {
            float[] odata = this.data[ch];
            float maxAbs = 0.0f;
            int n2 = this.totalSamples;
            for (int n3 = 0; n3 < n2; ++n3) {
                maxAbs = Math.max(maxAbs, Math.abs(odata[n3]));
            }
            if (!(maxAbs > 1.0f)) continue;
            float invMaxAbs = 1.0f / maxAbs;
            int n4 = 0;
            int n5 = this.totalSamples;
            while (n4 < n5) {
                int n6 = n4++;
                odata[n6] = odata[n6] * invMaxAbs;
            }
        }
        return this;
    }

    public final void copyTo(@NotNull AudioSamples samples) {
        int n = Math.min(this.channels, samples.getChannels());
        for (int ch = 0; ch < n; ++ch) {
            float[] idata = this.data[ch];
            short[] odata = samples.getData()[ch];
            int n2 = samples.getTotalSamples();
            for (int n3 = 0; n3 < n2; ++n3) {
                odata[n3] = SampleConvert.INSTANCE.floatToShort(idata[n3]);
            }
        }
    }
}

