/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound;

import kotlin.Metadata;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lkorlibs/audio/sound/SoundUtils;", "", "()V", "convertS16ToF32", "", "channels", "", "input", "", "leftVolume", "", "rightVolume", "korge-core"})
public final class SoundUtils {
    @NotNull
    public static final SoundUtils INSTANCE = new SoundUtils();

    private SoundUtils() {
    }

    @NotNull
    public final float[] convertS16ToF32(int channels, @NotNull short[] input, float leftVolume, float rightVolume) {
        float[] output2 = new float[input.length * 2 / channels];
        boolean optimized = leftVolume == 1.0f && rightVolume == 1.0f;
        block0 : switch (channels) {
            case 2: {
                if (optimized) {
                    int n = output2.length;
                    for (int n2 = 0; n2 < n; ++n2) {
                        output2[n2] = (float)input[n2] / 32767.0f;
                    }
                    break;
                }
                IntProgression n2 = RangesKt.step(RangesKt.until(0, output2.length), 2);
                int n = n2.getFirst();
                int n3 = n2.getLast();
                int n4 = n2.getStep();
                if ((n4 <= 0 || n > n3) && (n4 >= 0 || n3 > n)) break;
                while (true) {
                    output2[n + 0] = (float)input[n + 0] / 32767.0f * leftVolume;
                    output2[n + 1] = (float)input[n + 1] / 32767.0f * rightVolume;
                    if (n == n3) break block0;
                    n += n4;
                }
            }
            case 1: {
                if (optimized) {
                    int m = 0;
                    int n = input.length;
                    for (int n5 = 0; n5 < n; ++n5) {
                        float v = (float)input[n5] / 32767.0f;
                        output2[m++] = v;
                        output2[m++] = v;
                    }
                } else {
                    int m = 0;
                    int n = input.length;
                    for (int n6 = 0; n6 < n; ++n6) {
                        float sample2 = (float)input[n6] / 32767.0f;
                        output2[m++] = sample2 * leftVolume;
                        output2[m++] = sample2 * rightVolume;
                    }
                }
                break;
            }
        }
        return output2;
    }
}

