/*
 * Decompiled with CFR 0.152.
 */
package korlibs.audio.sound.backend;

import com.sun.jna.Pointer;
import korlibs.audio.sound.AudioSamplesInterleaved;
import korlibs.audio.sound.backend.WAVEHDR;
import korlibs.audio.sound.backend.WINMM;
import korlibs.ffi.FFIArena;
import korlibs.ffi.FFILibKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020$2\b\b\u0002\u0010\u0007\u001a\u00020\u0003J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lkorlibs/audio/sound/backend/WaveHeader;", "", "id", "", "handle", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "totalSamples", "channels", "arena", "Lkorlibs/ffi/FFIArena;", "(ILcom/sun/jna/Pointer;IILkorlibs/ffi/FFIArena;)V", "getArena", "()Lkorlibs/ffi/FFIArena;", "getChannels", "()I", "dataMem", "Lkorlibs/ffi/FFITypedPointer;", "", "getDataMem-jgiHLiI", "()Lcom/sun/jna/Pointer;", "Lcom/sun/jna/Pointer;", "getHandle", "hdr", "Lkorlibs/audio/sound/backend/WAVEHDR;", "getHdr", "()Lkorlibs/audio/sound/backend/WAVEHDR;", "getId", "samples", "Lkorlibs/audio/sound/AudioSamplesInterleaved;", "getSamples", "()Lkorlibs/audio/sound/AudioSamplesInterleaved;", "totalBytes", "getTotalBytes", "getTotalSamples", "dispose", "", "prepareAndWrite", "toString", "", "korge-core"})
final class WaveHeader {
    private final int id;
    @Nullable
    private final Pointer handle;
    private final int totalSamples;
    private final int channels;
    @NotNull
    private final FFIArena arena;
    @NotNull
    private final AudioSamplesInterleaved samples;
    private final int totalBytes;
    @NotNull
    private final Pointer dataMem;
    @NotNull
    private final WAVEHDR hdr;

    /*
     * WARNING - void declaration
     */
    public WaveHeader(int id2, @Nullable Pointer handle2, int totalSamples, int channels, @NotNull FFIArena arena) {
        void hdr;
        WAVEHDR wAVEHDR;
        this.id = id2;
        this.handle = handle2;
        this.totalSamples = totalSamples;
        this.channels = channels;
        this.arena = arena;
        this.samples = new AudioSamplesInterleaved(this.channels, this.totalSamples, null, 4, null);
        this.totalBytes = this.totalSamples * this.channels * 2;
        this.dataMem = FFILibKt.typed(this.arena.allocBytes(this.totalBytes));
        WAVEHDR wAVEHDR2 = wAVEHDR = new WAVEHDR(this.arena.allocBytes(new WAVEHDR(null, 1, null).getSize()));
        WaveHeader waveHeader = this;
        boolean bl = false;
        hdr.setLpData-jNmomv8(FFILibKt.reinterpret-p0gdXDQ(this.dataMem));
        hdr.setDwBufferLength(this.totalBytes);
        hdr.setDwFlags(0);
        waveHeader.hdr = wAVEHDR;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final Pointer getHandle() {
        return this.handle;
    }

    public final int getTotalSamples() {
        return this.totalSamples;
    }

    public final int getChannels() {
        return this.channels;
    }

    @NotNull
    public final FFIArena getArena() {
        return this.arena;
    }

    @NotNull
    public final AudioSamplesInterleaved getSamples() {
        return this.samples;
    }

    public final int getTotalBytes() {
        return this.totalBytes;
    }

    @NotNull
    public final Pointer getDataMem-jgiHLiI() {
        return this.dataMem;
    }

    @NotNull
    public final WAVEHDR getHdr() {
        return this.hdr;
    }

    public final void prepareAndWrite(int totalSamples) {
        int channels = this.channels;
        this.hdr.setDwBufferLength(totalSamples * channels * 2);
        short[] samplesData = this.samples.getData();
        int n = channels * totalSamples;
        for (int n2 = 0; n2 < n; ++n2) {
            FFILibKt.set-5g6wF0o(this.dataMem, n2, samplesData[n2]);
        }
        if (!this.hdr.isPrepared()) {
            WINMM.INSTANCE.getWaveOutPrepareHeader().invoke(this.handle, this.hdr.getPtr(), this.hdr.getSize());
        }
        WINMM.INSTANCE.getWaveOutWrite().invoke(this.handle, this.hdr.getPtr(), this.hdr.getSize());
    }

    public static /* synthetic */ void prepareAndWrite$default(WaveHeader waveHeader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = waveHeader.totalSamples;
        }
        waveHeader.prepareAndWrite(n);
    }

    public final void dispose() {
        WINMM.INSTANCE.getWaveOutUnprepareHeader().invoke(this.handle, this.hdr.getPtr(), this.hdr.getSize());
    }

    @NotNull
    public String toString() {
        return "WaveHeader(id=" + this.id + ", totalSamples=" + this.totalSamples + ", nchannels=" + this.channels + ", hdr=" + this.hdr + ")";
    }
}

