/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber;

import korlibs.bignumber.BigInt;
import korlibs.bignumber.BigIntInvalidFormatException;
import korlibs.bignumber.BigIntKt;
import korlibs.bignumber.CommonBigIntKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lkorlibs/bignumber/BigIntConstructor;", "", "create", "Lkorlibs/bignumber/BigInt;", "value", "", "", "", "radix", "korge-foundation"})
public interface BigIntConstructor {
    @NotNull
    public BigInt create(int var1);

    @NotNull
    public BigInt create(long var1);

    @NotNull
    public BigInt create(@NotNull String var1, int var2);

    @NotNull
    public BigInt create(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static BigInt create(@NotNull BigIntConstructor $this, long value) {
            if ((long)((int)value) == value) {
                return $this.create((int)value);
            }
            String string = Long.toString(value, CharsKt.checkRadix(10));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return $this.create(string, 10);
        }

        @NotNull
        public static BigInt create(@NotNull BigIntConstructor $this, @NotNull String value, int radix) {
            if (((CharSequence)value).length() == 0) {
                throw new BigIntInvalidFormatException("Zero length BigInteger");
            }
            if (StringsKt.startsWith$default((CharSequence)value, '-', false, 2, null)) {
                String string = value.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                return $this.create(string, radix).unaryMinus();
            }
            if (Intrinsics.areEqual(value, "0")) {
                return $this.create(0);
            }
            BigInt out = $this.create(0);
            int sum = 0;
            int mul = 1;
            int n = value.length();
            for (int n2 = 0; n2 < n; ++n2) {
                boolean last2 = n2 == value.length() - 1;
                char c = value.charAt(n2);
                int d = CommonBigIntKt.digit(c, radix);
                sum *= radix;
                sum += d;
                if (!last2 && (mul *= radix) * radix < 0x1FFFFFF) continue;
                out = out.times(mul);
                out = out.plus(sum);
                sum = 0;
                mul = 1;
            }
            return out;
        }

        @NotNull
        public static BigInt create(@NotNull BigIntConstructor $this, @NotNull String value) {
            if (StringsKt.startsWith$default(value, "-", false, 2, null)) {
                String string = value.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                return $this.create(string).unaryMinus();
            }
            return (BigInt)BigIntKt.parseWithNumberPrefix(value, (Function2)new Function2<String, Integer, BigInt>($this){
                final /* synthetic */ BigIntConstructor this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final BigInt invoke(@NotNull String sub, int radix) {
                    return this.this$0.create(sub, radix);
                }
            });
        }
    }
}

