/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber;

import java.util.Locale;
import korlibs.bignumber.BigInt;
import korlibs.bignumber.BigIntKt;
import korlibs.bignumber.ranges.ClosedBigNumRange;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JI\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000026\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00030\u0010H\u0082\bJ\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0000H\u0002J\u0011\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0005J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005H\u0086\u0004J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\u0003J\u0006\u0010*\u001a\u00020\u0003J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006."}, d2={"Lkorlibs/bignumber/BigNum;", "", "int", "Lkorlibs/bignumber/BigInt;", "scale", "", "(Lkorlibs/bignumber/BigInt;I)V", "decimalPart", "getDecimalPart", "()Lkorlibs/bignumber/BigInt;", "getInt", "getScale", "()I", "binary", "other", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "l", "r", "commonScale", "compareTo", "convertToScale", "otherScale", "div", "precision", "equals", "", "", "hashCode", "minus", "plus", "pow", "exponent", "rangeTo", "Lkorlibs/bignumber/ranges/ClosedBigNumRange;", "that", "times", "toBigInt", "toBigIntCeil", "toBigIntFloor", "toBigIntRound", "toString", "", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\nBigNum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigNum.kt\nkorlibs/bignumber/BigNum\n*L\n1#1,163:1\n123#1,6:164\n123#1,6:170\n*S KotlinDebug\n*F\n+ 1 BigNum.kt\nkorlibs/bignumber/BigNum\n*L\n68#1:164,6\n70#1:170,6\n*E\n"})
public final class BigNum
implements Comparable<BigNum> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInt int;
    private final int scale;
    @NotNull
    private static final BigNum ZERO = new BigNum(BigIntKt.BigInt(0), 0);
    @NotNull
    private static final BigNum ONE = new BigNum(BigIntKt.BigInt(1), 0);
    @NotNull
    private static final BigNum TWO = new BigNum(BigIntKt.BigInt(2), 0);

    public BigNum(@NotNull BigInt bigInt, int scale) {
        this.int = bigInt;
        this.scale = scale;
    }

    @NotNull
    public final BigInt getInt() {
        return this.int;
    }

    public final int getScale() {
        return this.scale;
    }

    @NotNull
    public final BigNum convertToScale(int otherScale) {
        return this.scale == otherScale ? this : (otherScale > this.scale ? new BigNum(this.int.times(BigIntKt.getBi(10).pow(otherScale - this.scale)), otherScale) : new BigNum(this.int.div(BigIntKt.getBi(10).pow(this.scale - otherScale)), otherScale));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigNum plus(@NotNull BigNum other) {
        void p1;
        BigInt ri$iv;
        BigNum this_$iv = this;
        boolean $i$f$binary = false;
        int commonScale$iv = this_$iv.commonScale(other);
        BigNum l$iv = this_$iv.convertToScale(commonScale$iv);
        BigNum r$iv = other.convertToScale(commonScale$iv);
        BigInt li$iv = l$iv.int;
        BigInt bigInt = ri$iv = r$iv.int;
        BigInt p0 = li$iv;
        boolean bl = false;
        int n = commonScale$iv;
        BigInt bigInt2 = p0.plus((BigInt)p1);
        return new BigNum(bigInt2, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigNum minus(@NotNull BigNum other) {
        void p1;
        BigInt ri$iv;
        BigNum this_$iv = this;
        boolean $i$f$binary = false;
        int commonScale$iv = this_$iv.commonScale(other);
        BigNum l$iv = this_$iv.convertToScale(commonScale$iv);
        BigNum r$iv = other.convertToScale(commonScale$iv);
        BigInt li$iv = l$iv.int;
        BigInt bigInt = ri$iv = r$iv.int;
        BigInt p0 = li$iv;
        boolean bl = false;
        int n = commonScale$iv;
        BigInt bigInt2 = p0.minus((BigInt)p1);
        return new BigNum(bigInt2, n);
    }

    @NotNull
    public final BigNum times(@NotNull BigNum other) {
        return new BigNum(this.int.times(other.int), this.scale + other.scale);
    }

    @NotNull
    public final BigNum div(@NotNull BigNum other) {
        return this.div(other, 0);
    }

    @NotNull
    public final BigNum div(@NotNull BigNum other, int precision) {
        BigInt scale = BigIntKt.getBi(10).pow(other.scale + precision);
        BigInt li = this.int.times(scale);
        BigInt ri = other.int;
        BigInt res = li.div(ri);
        return new BigNum(res, this.scale).times(new BigNum(BigIntKt.getBi(1), precision));
    }

    @NotNull
    public final BigNum pow(int exponent) {
        return this.pow(exponent, 32);
    }

    @NotNull
    public final BigNum pow(int exponent, int precision) {
        if (exponent < 0) {
            return ONE.div(this.pow(-exponent, precision), 0);
        }
        BigNum result2 = ONE;
        BigNum base2 = this;
        int exp = exponent;
        while (exp != 0) {
            if ((exp & 1) != 0) {
                result2 = result2.times(base2);
            }
            exp >>= 1;
            base2 = base2.times(base2);
        }
        return result2;
    }

    @Override
    public int compareTo(@NotNull BigNum other) {
        int commonScale = this.commonScale(other);
        return this.convertToScale((int)commonScale).int.compareTo(other.convertToScale((int)commonScale).int);
    }

    @NotNull
    public final ClosedBigNumRange rangeTo(@NotNull BigNum that) {
        return new ClosedBigNumRange(this, that);
    }

    public int hashCode() {
        return this.int.hashCode() + 3 * Integer.hashCode(this.scale);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BigNum && this.compareTo((BigNum)other) == 0;
    }

    private final int commonScale(BigNum other) {
        return Math.max(this.scale, other.scale);
    }

    private final BigNum binary(BigNum other, Function2<? super BigInt, ? super BigInt, ? extends BigInt> callback) {
        boolean $i$f$binary = false;
        int commonScale = this.commonScale(other);
        BigNum l = this.convertToScale(commonScale);
        BigNum r = other.convertToScale(commonScale);
        BigInt li = l.int;
        BigInt ri = r.int;
        return new BigNum(callback.invoke(li, ri), commonScale);
    }

    @NotNull
    public String toString() {
        Object object;
        String negativePart;
        boolean isNegative = this.int.isNegative();
        String out = String.valueOf(this.int.abs());
        int pos = out.length() - this.scale;
        String string = negativePart = isNegative ? "-" : "";
        if (pos <= 0) {
            object = "0." + StringsKt.repeat("0", -pos) + out;
        } else if (pos >= out.length()) {
            object = out + StringsKt.repeat("0", pos - out.length());
        } else {
            String string2 = out.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String string3 = out.substring(pos);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            char[] cArray = new char[]{'.'};
            object = StringsKt.trimEnd(string2 + "." + string3, cArray);
        }
        return negativePart + (String)object;
    }

    @NotNull
    public final BigInt toBigInt() {
        return this.convertToScale((int)0).int;
    }

    @NotNull
    public final BigInt toBigIntFloor() {
        return this.toBigInt();
    }

    @NotNull
    public final BigInt toBigIntCeil() {
        BigInt it = this.toBigInt();
        BigInt decimal = this.getDecimalPart();
        return decimal.isZero() ? it : it.plus(BigIntKt.getBi(1));
    }

    @NotNull
    public final BigInt toBigIntRound() {
        BigInt firstDigit = this.getDecimalPart().div(BigIntKt.getBi(10).pow(this.scale - 1));
        return firstDigit.toInt() >= 5 ? this.toBigIntCeil() : this.toBigIntFloor();
    }

    @NotNull
    public final BigInt getDecimalPart() {
        return this.int.rem(BigIntKt.getBi(10).pow(this.scale));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkorlibs/bignumber/BigNum$Companion;", "", "()V", "ONE", "Lkorlibs/bignumber/BigNum;", "getONE", "()Lkorlibs/bignumber/BigNum;", "TWO", "getTWO", "ZERO", "getZERO", "invoke", "str", "", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nBigNum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigNum.kt\nkorlibs/bignumber/BigNum$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigNum getZERO() {
            return ZERO;
        }

        @NotNull
        public final BigNum getONE() {
            return ONE;
        }

        @NotNull
        public final BigNum getTWO() {
            return TWO;
        }

        @NotNull
        public final BigNum invoke(@NotNull String str) {
            String string;
            String string2 = str.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String str2 = string2;
            Object object = StringsKt.substringAfter(str2, 'e', "");
            String it = object;
            boolean bl = false;
            Object object2 = ((CharSequence)it).length() > 0 ? object : null;
            if (object2 != null) {
                object = new char[1];
                object[0] = 43;
                string = StringsKt.trimStart((String)object2, (char[])object);
            } else {
                string = null;
            }
            String exponentPartStr = string;
            String ss2 = StringsKt.substringBefore$default(str2, 'e', null, 2, null);
            int point2 = StringsKt.indexOf$default((CharSequence)ss2, '.', 0, false, 6, null);
            String strBase = StringsKt.replace$default(ss2, ".", "", false, 4, null);
            String string3 = exponentPartStr;
            int exponent = string3 != null ? Integer.parseInt(string3) : 0;
            BigInt bigInt = BigIntKt.BigInt(strBase);
            return point2 < 0 ? new BigNum(bigInt, -exponent) : new BigNum(bigInt, ss2.length() - point2 - 1 - exponent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

