/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber.ranges;

import java.util.Iterator;
import java.util.NoSuchElementException;
import korlibs.bignumber.BigInt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\t\u0010\n\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lkorlibs/bignumber/ranges/BigIntProgressionIterator;", "", "Lkorlibs/bignumber/BigInt;", "first", "last", "step", "(Lkorlibs/bignumber/BigInt;Lkorlibs/bignumber/BigInt;Lkorlibs/bignumber/BigInt;)V", "finalElement", "hasNext", "", "next", "getStep", "()Lkorlibs/bignumber/BigInt;", "korge-foundation"})
public final class BigIntProgressionIterator
implements Iterator<BigInt>,
KMappedMarker {
    @NotNull
    private final BigInt step;
    @NotNull
    private final BigInt finalElement;
    private boolean hasNext;
    @NotNull
    private BigInt next;

    public BigIntProgressionIterator(@NotNull BigInt first2, @NotNull BigInt last2, @NotNull BigInt step2) {
        this.step = step2;
        this.finalElement = last2;
        this.hasNext = this.step.compareTo(BigInt.Companion.getZERO()) > 0 ? first2.compareTo(last2) <= 0 : first2.compareTo(last2) >= 0;
        this.next = this.hasNext ? first2 : this.finalElement;
    }

    @NotNull
    public final BigInt getStep() {
        return this.step;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NotNull
    public BigInt next() {
        BigInt value = this.next;
        if (Intrinsics.areEqual(value, this.finalElement)) {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
        } else {
            this.next = this.next.plus(this.step);
        }
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

