/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.Arrays;
import korlibs.crypto.Cipher;
import korlibs.crypto.CipherMode;
import korlibs.crypto.CipherPadding;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a0\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u001a0\u0010\u0014\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u001a\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"arrayxor", "", "data", "", "offset", "", "xor", "size", "xoroffset", "getIV", "srcIV", "blockSize", "decryptSafe", "Lkorlibs/crypto/CipherMode;", "cipher", "Lkorlibs/crypto/Cipher;", "padding", "Lkorlibs/crypto/CipherPadding;", "Lkorlibs/crypto/Padding;", "iv", "encryptSafe", "nextMultipleOf", "multiple", "korlibs-crypto"})
public final class CipherModeKt {
    private static final int nextMultipleOf(int $this$nextMultipleOf, int multiple) {
        return $this$nextMultipleOf % multiple == 0 ? $this$nextMultipleOf : ($this$nextMultipleOf / multiple + 1) * multiple;
    }

    @NotNull
    public static final byte[] encryptSafe(@NotNull CipherMode $this$encryptSafe, @NotNull byte[] data2, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        if (Intrinsics.areEqual(padding, CipherPadding.Companion.getNoPadding())) {
            byte[] byArray = Arrays.copyOf($this$encryptSafe.encrypt(data2, cipher, CipherPadding.Companion.getZeroPadding(), iv), data2.length);
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
            return byArray;
        }
        return $this$encryptSafe.encrypt(data2, cipher, padding, iv);
    }

    @NotNull
    public static final byte[] decryptSafe(@NotNull CipherMode $this$decryptSafe, @NotNull byte[] data2, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        if (Intrinsics.areEqual(padding, CipherPadding.Companion.getNoPadding())) {
            byte[] byArray = Arrays.copyOf(data2, CipherModeKt.nextMultipleOf(data2.length, cipher.getBlockSize()));
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
            byte[] byArray2 = Arrays.copyOf($this$decryptSafe.decrypt(byArray, cipher, CipherPadding.Companion.getZeroPadding(), iv), data2.length);
            Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
            return byArray2;
        }
        return $this$decryptSafe.decrypt(data2, cipher, padding, iv);
    }

    private static final void arrayxor(byte[] data2, int offset2, byte[] xor) {
        int n = xor.length;
        for (int n2 = 0; n2 < n; ++n2) {
            data2[offset2 + n2] = (byte)(data2[offset2 + n2] ^ xor[n2]);
        }
    }

    private static final void arrayxor(byte[] data2, int offset2, int size2, byte[] xor, int xoroffset) {
        for (int n = 0; n < size2; ++n) {
            data2[offset2 + n] = (byte)(data2[offset2 + n] ^ xor[xoroffset + n]);
        }
    }

    private static final byte[] getIV(byte[] srcIV, int blockSize) {
        if (srcIV == null) {
            String string = "IV not provided";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        if (srcIV.length < blockSize) {
            throw new IllegalArgumentException("Wrong IV length: must be " + blockSize + " bytes long");
        }
        byte[] byArray = Arrays.copyOf(srcIV, blockSize);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return byArray;
    }

    public static final /* synthetic */ void access$arrayxor(byte[] data2, int offset2, byte[] xor) {
        CipherModeKt.arrayxor(data2, offset2, xor);
    }

    public static final /* synthetic */ void access$arrayxor(byte[] data2, int offset2, int size2, byte[] xor, int xoroffset) {
        CipherModeKt.arrayxor(data2, offset2, size2, xor, xoroffset);
    }

    public static final /* synthetic */ byte[] access$getIV(byte[] srcIV, int blockSize) {
        return CipherModeKt.getIV(srcIV, blockSize);
    }
}

