/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import korlibs.crypto.Hash;
import korlibs.internal.InternalCryptoArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH$J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H$J\b\u0010\u001c\u001a\u00020\u0019H$J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH$J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\fJ \u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkorlibs/crypto/Hasher;", "", "chunkSize", "", "digestSize", "name", "", "(IILjava/lang/String;)V", "blockSize", "getBlockSize", "()I", "chunk", "", "getChunkSize", "getDigestSize", "getName", "()Ljava/lang/String;", "totalWritten", "", "getTotalWritten", "()J", "setTotalWritten", "(J)V", "writtenInChunk", "coreDigest", "", "out", "corePadding", "coreReset", "coreUpdate", "digest", "Lkorlibs/crypto/Hash;", "digestOut", "reset", "toString", "update", "data", "offset", "count", "korlibs-crypto"})
@SourceDebugExtension(value={"SMAP\nHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hasher.kt\nkorlibs/crypto/Hasher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public abstract class Hasher {
    private final int chunkSize;
    private final int digestSize;
    @NotNull
    private final String name;
    @NotNull
    private final byte[] chunk;
    private int writtenInChunk;
    private long totalWritten;

    public Hasher(int chunkSize, int digestSize, @NotNull String name2) {
        this.chunkSize = chunkSize;
        this.digestSize = digestSize;
        this.name = name2;
        this.chunk = new byte[this.chunkSize];
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final int getDigestSize() {
        return this.digestSize;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getBlockSize() {
        return this.chunkSize * 8;
    }

    protected final long getTotalWritten() {
        return this.totalWritten;
    }

    protected final void setTotalWritten(long l) {
        this.totalWritten = l;
    }

    @NotNull
    public Hasher reset() {
        this.coreReset();
        this.writtenInChunk = 0;
        this.totalWritten = 0L;
        return this;
    }

    @NotNull
    public Hasher update(@NotNull byte[] data2, int offset2, int count2) {
        int curr = offset2;
        int left = count2;
        while (left > 0) {
            int remainingInChunk = this.chunkSize - this.writtenInChunk;
            int toRead = Math.min(remainingInChunk, left);
            InternalCryptoArraysKt.arraycopy(data2, curr, this.chunk, this.writtenInChunk, toRead);
            left -= toRead;
            curr += toRead;
            this.writtenInChunk += toRead;
            if (this.writtenInChunk < this.chunkSize) continue;
            this.writtenInChunk -= this.chunkSize;
            this.coreUpdate(this.chunk);
        }
        this.totalWritten += (long)count2;
        return this;
    }

    public void digestOut(@NotNull byte[] out) {
        int padSize;
        byte[] pad = this.corePadding(this.totalWritten);
        for (int padPos = 0; padPos < pad.length; padPos += padSize) {
            padSize = this.chunkSize - this.writtenInChunk;
            InternalCryptoArraysKt.arraycopy(pad, padPos, this.chunk, this.writtenInChunk, padSize);
            this.coreUpdate(this.chunk);
            this.writtenInChunk = 0;
        }
        this.coreDigest(out);
        this.coreReset();
    }

    protected abstract void coreReset();

    @NotNull
    protected abstract byte[] corePadding(long var1);

    protected abstract void coreUpdate(@NotNull byte[] var1);

    protected abstract void coreDigest(@NotNull byte[] var1);

    @NotNull
    public final Hasher update(@NotNull byte[] data2) {
        return this.update(data2, 0, data2.length);
    }

    @NotNull
    public final Hash digest() {
        byte[] byArray;
        byte[] it = byArray = new byte[this.digestSize];
        boolean bl = false;
        this.digestOut(it);
        byte[] byArray2 = byArray;
        return new Hash(byArray2);
    }

    @NotNull
    public String toString() {
        return "Hasher(" + this.name + ")";
    }
}

