/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import korlibs.datastructure.BaseMutableMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u001d\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0012H\u0016J\u001d\u0010&\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u001c2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010'J\u001e\u0010+\u001a\u00020\u001a2\u0014\u0010,\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-H\u0016J\u001d\u0010.\u001a\u00020\u001a2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\"J\u0017\u0010/\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\b\u00100\u001a\u000201H\u0016R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lkorlibs/datastructure/BaseCacheMap;", "K", "V", "Lkorlibs/datastructure/BaseMutableMap;", "()V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "map", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getMap", "()Ljava/util/LinkedHashMap;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "equals", "", "other", "", "freed", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "keyToRemove", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "mustFree", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "put", "putAll", "from", "", "putNew", "remove", "toString", "", "korlibs-datastructure"})
public class BaseCacheMap<K, V>
implements BaseMutableMap<K, V> {
    @NotNull
    private final LinkedHashMap<K, V> map = new LinkedHashMap();

    @NotNull
    public final LinkedHashMap<K, V> getMap() {
        return this.map;
    }

    protected boolean mustFree(K key, V value) {
        return false;
    }

    protected K keyToRemove(K key, V value) {
        Set<K> set = this.map.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return (K)CollectionsKt.first((Iterable)set);
    }

    protected void freed(K key, V value) {
    }

    public int getSize() {
        return this.map.size();
    }

    @Override
    @Nullable
    public V remove(Object key) {
        Object value = this.map.remove(key);
        if (value != null) {
            this.freed(key, value);
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        for (Map.Entry<K, V> entry2 : from.entrySet()) {
            K k = entry2.getKey();
            V v = entry2.getValue();
            this.put(k, v);
        }
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V oldValue = this.map.get(key);
        if (!Intrinsics.areEqual(oldValue, value)) {
            this.remove(key);
            ((Map)this.map).put(key, value);
            this.putNew(key, value);
        }
        while (!((Map)this).isEmpty() && this.mustFree(key, value)) {
            K keyToRemove = this.keyToRemove(key, value);
            this.remove(keyToRemove);
        }
        return oldValue;
    }

    protected void putNew(K key, V value) {
    }

    @Override
    public void clear() {
        Set<K> set = this.map.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        List keys2 = CollectionsKt.toList((Iterable)set);
        for (Object key : keys2) {
            this.remove(key);
        }
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        Set<Map.Entry<K, V>> set = this.map.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        return set;
    }

    @NotNull
    public Set<K> getKeys() {
        Set<K> set = this.map.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return set;
    }

    @NotNull
    public Collection<V> getValues() {
        Collection<V> collection = this.map.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.map.get(key);
    }

    @NotNull
    public String toString() {
        String string = this.map.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof BaseCacheMap && Intrinsics.areEqual(this.map, ((BaseCacheMap)other).map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return BaseMutableMap.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return BaseMutableMap.DefaultImpls.containsKey(this, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return BaseMutableMap.DefaultImpls.containsValue(this, value);
    }
}

