/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import korlibs.datastructure.MutableListEx;
import korlibs.datastructure.internal.memory.Memory;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00060\u0004j\u0002`\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0015\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0000\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u001d\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J&\u0010*\u001a\u00020'2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J\u001e\u0010*\u001a\u00020!2\u0006\u0010(\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016J\u0016\u0010*\u001a\u00020!2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016J\u0018\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020'H\u0016J\u0016\u0010/\u001a\u00020!2\u0006\u0010%\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u000e\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\bJ\u001d\u00102\u001a\u00020'2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020'04H\u0086\bJ\u001d\u00105\u001a\u00020'2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020'04H\u0086\bJA\u00106\u001a\u00020'26\u00103\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b((\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020'07H\u0086\bJA\u0010;\u001a\u00020'26\u00103\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b((\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020'07H\u0086\bJ\u0016\u0010<\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010=J\u0015\u0010>\u001a\u00020\b2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010?J\u0015\u0010@\u001a\u00020\b2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010?J\u0011\u0010A\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0082\bJ\u0015\u0010B\u001a\u00020!2\u0006\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0015\u0010C\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010=J\u0018\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020\bH\u0016J\u001e\u0010G\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\b2\u0006\u0010%\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010HJ.\u0010I\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010+\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010J\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010K\u001a\u00020LH\u0016J\u0006\u0010M\u001a\u00020'R$\u0010\u0010\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\tR.\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u001c\u0012\u0004\b\u0017\u0010\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u0011\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001d\u0010\u0006\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\tR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015\u00a8\u0006N"}, d2={"Lkorlibs/datastructure/FastArrayList;", "E", "Lkotlin/collections/AbstractMutableList;", "Lkorlibs/datastructure/MutableListEx;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "()V", "initialCapacity", "", "(I)V", "elements", "", "(Ljava/util/Collection;)V", "array", "", "", "_size", "arrayCapacity", "([Ljava/lang/Object;II)V", "get_size$annotations", "get_size", "()I", "set_size", "getArray$annotations", "getArray", "()[Ljava/lang/Object;", "setArray", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getArrayCapacity$annotations", "getArrayCapacity", "setArrayCapacity", "isReadOnly", "", "size", "getSize", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "offset", "allocSpace", "count", "clear", "contains", "ensureCapacity", "minCapacity", "fastForEach", "callback", "Lkotlin/Function1;", "fastForEachReverse", "fastForEachReverseWithIndex", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "fastForEachWithIndex", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "rangeCheck", "remove", "removeAt", "removeRange", "fromIndex", "toIndex", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setAll", "throwIndexOtOfBounds", "toString", "", "trimToSize", "korlibs-datastructure"})
@SourceDebugExtension(value={"SMAP\nNonJs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonJs.kt\nkorlibs/datastructure/FastArrayList\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,268:1\n210#1,4:271\n210#1,4:275\n210#1,4:281\n210#1,4:285\n210#1,4:289\n210#1,4:293\n172#1,10:297\n37#2,2:269\n37#2,2:279\n*S KotlinDebug\n*F\n+ 1 NonJs.kt\nkorlibs/datastructure/FastArrayList\n*L\n49#1:271,4\n51#1:275,4\n95#1:281,4\n104#1:285,4\n105#1:289,4\n113#1:293,4\n150#1:297,10\n32#1:269,2\n74#1:279,2\n*E\n"})
public class FastArrayList<E>
extends AbstractMutableList<E>
implements MutableListEx<E>,
RandomAccess {
    @NotNull
    private Object[] array;
    private int _size;
    private int arrayCapacity;
    private boolean isReadOnly;

    public FastArrayList(@NotNull Object[] array, int _size, int arrayCapacity) {
        this.array = array;
        this._size = _size;
        this.arrayCapacity = arrayCapacity;
    }

    public /* synthetic */ FastArrayList(Object[] objectArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = objectArray.length;
        }
        if ((n3 & 4) != 0) {
            n2 = objectArray.length;
        }
        this(objectArray, n, n2);
    }

    @NotNull
    public final Object[] getArray() {
        return this.array;
    }

    public final void setArray(@NotNull Object[] objectArray) {
        this.array = objectArray;
    }

    @PublishedApi
    public static /* synthetic */ void getArray$annotations() {
    }

    public final int get_size() {
        return this._size;
    }

    public final void set_size(int n) {
        this._size = n;
    }

    @PublishedApi
    public static /* synthetic */ void get_size$annotations() {
    }

    public final int getArrayCapacity() {
        return this.arrayCapacity;
    }

    public final void setArrayCapacity(int n) {
        this.arrayCapacity = n;
    }

    @PublishedApi
    public static /* synthetic */ void getArrayCapacity$annotations() {
    }

    public FastArrayList() {
        this(new Object[16], 0, 0, 4, null);
    }

    public FastArrayList(int initialCapacity) {
        this(new Object[initialCapacity], 0, 0, 4, null);
    }

    public FastArrayList(@NotNull Collection<? extends E> elements) {
        Collection<E> $this$toTypedArray$iv = elements;
        boolean $i$f$toTypedArray = false;
        Collection<E> thisCollection$iv = $this$toTypedArray$iv;
        this(thisCollection$iv.toArray(new Object[0]), 0, 0, 6, null);
    }

    public final void trimToSize() {
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.arrayCapacity >= minCapacity) {
            return;
        }
        int newSize = Math.max(this.arrayCapacity * 2, minCapacity);
        Object[] objectArray = Arrays.copyOf(this.array, newSize);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newArray = objectArray;
        this.array = newArray;
        this.arrayCapacity = newSize;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public E get(int index2) {
        FastArrayList this_$iv = this;
        boolean $i$f$rangeCheck = false;
        if (index2 < 0 || index2 >= this_$iv.size()) {
            this_$iv.throwIndexOtOfBounds(index2);
        }
        return (E)this.array[index2];
    }

    @Override
    public E set(int index2, E element) {
        FastArrayList this_$iv = this;
        boolean $i$f$rangeCheck = false;
        if (index2 < 0 || index2 >= this_$iv.size()) {
            this_$iv.throwIndexOtOfBounds(index2);
        }
        this.array[index2] = element;
        return element;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.size() + 1);
        int n = this._size;
        this._size = n + 1;
        this.array[n] = element;
        return true;
    }

    @Override
    public void add(int index2, E element) {
        this.allocSpace(index2, 1);
        this.array[index2] = element;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        return this.addAll(this.size(), elements);
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        int elementsCount = elements.size();
        this.allocSpace(index2, elementsCount);
        Collection<E> $this$toTypedArray$iv = elements;
        boolean $i$f$toTypedArray = false;
        Collection<E> thisCollection$iv = $this$toTypedArray$iv;
        Memory.INSTANCE.arraycopy(thisCollection$iv.toArray(new Object[0]), 0, this.array, index2, elementsCount);
        return true;
    }

    private final void allocSpace(int index2, int count2) {
        this.ensureCapacity(this.size() + count2);
        int displaceCount = this._size - index2;
        if (displaceCount > 0) {
            Memory.INSTANCE.arraycopy(this.array, index2, this.array, index2 + count2, displaceCount);
        }
        this._size += count2;
    }

    @Override
    public boolean remove(Object element) {
        int index2 = this.indexOf(element);
        if (index2 < 0) {
            return false;
        }
        this.remove(index2);
        return true;
    }

    @Override
    public E removeAt(int index2) {
        FastArrayList this_$iv = this;
        boolean $i$f$rangeCheck = false;
        if (index2 < 0 || index2 >= this_$iv.size()) {
            this_$iv.throwIndexOtOfBounds(index2);
        }
        Object out = this.array[index2];
        this.removeRange(index2, index2 + 1);
        return (E)out;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        int count2 = toIndex - fromIndex;
        if (count2 <= 0) {
            return;
        }
        Object[] array = this.array;
        FastArrayList this_$iv = this;
        boolean $i$f$rangeCheck = false;
        if (fromIndex < 0 || fromIndex >= this_$iv.size()) {
            this_$iv.throwIndexOtOfBounds(fromIndex);
        }
        this_$iv = this;
        int index$iv = toIndex - 1;
        boolean $i$f$rangeCheck2 = false;
        if (index$iv < 0 || index$iv >= this_$iv.size()) {
            this_$iv.throwIndexOtOfBounds(index$iv);
        }
        Memory.INSTANCE.arraycopy(array, toIndex, array, fromIndex, this._size - toIndex);
        this._size -= count2;
        ArraysKt.fill(array, null, this._size, this._size + count2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAll(int index2, @NotNull FastArrayList<E> elements, int offset2, int size2) {
        void this_$iv;
        if (size2 == 0) {
            return;
        }
        FastArrayList fastArrayList = this;
        int index$iv = index2 + size2 - 1;
        boolean $i$f$rangeCheck = false;
        if (index$iv < 0 || index$iv >= this_$iv.size()) {
            super.throwIndexOtOfBounds(index$iv);
        }
        Memory.INSTANCE.arraycopy(elements.array, offset2, this.array, index2, size2);
    }

    @Override
    public void addAll(@NotNull FastArrayList<E> elements, int offset2, int size2) {
        this.ensureCapacity(this._size + size2);
        Memory.INSTANCE.arraycopy(elements.array, offset2, this.array, this.size(), size2);
        this._size += size2;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public int indexOf(Object element) {
        int n = this.size();
        for (int index2 = 0; index2 < n; ++index2) {
            if (!Intrinsics.areEqual(this.get(index2), element)) continue;
            return index2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        int n = this.size();
        for (int index2 = 0; index2 < n; ++index2) {
            int i2 = this.size() - index2 - 1;
            if (!Intrinsics.areEqual(this.get(i2), element)) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        int size$iv;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        FastArrayList this_$iv = this;
        boolean $i$f$fastForEachWithIndex = false;
        Object[] array$iv = this_$iv.getArray();
        int initialSize$iv = this_$iv.get_size();
        for (int n$iv = 0; n$iv < (size$iv = Math.min(initialSize$iv, this_$iv.get_size())); ++n$iv) {
            void value;
            Object object = array$iv[n$iv];
            int index2 = n$iv;
            boolean bl = false;
            if (index2 != 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void fastForEach(@NotNull Function1<? super E, Unit> callback) {
        int size2;
        boolean $i$f$fastForEach = false;
        Object[] array = this.getArray();
        int initialSize = this.get_size();
        int n = 0;
        while (n < (size2 = Math.min(initialSize, this.get_size()))) {
            callback.invoke(array[n++]);
        }
    }

    public final void fastForEachWithIndex(@NotNull Function2<? super Integer, ? super E, Unit> callback) {
        int size2;
        boolean $i$f$fastForEachWithIndex = false;
        Object[] array = this.getArray();
        int initialSize = this.get_size();
        for (int n = 0; n < (size2 = Math.min(initialSize, this.get_size())); ++n) {
            callback.invoke(n, array[n]);
        }
    }

    public final void fastForEachReverse(@NotNull Function1<? super E, Unit> callback) {
        int size2;
        boolean $i$f$fastForEachReverse = false;
        Object[] array = this.getArray();
        int initialSize = this.get_size();
        for (int n = 0; n < (size2 = Math.min(initialSize, this.get_size())); ++n) {
            int index2 = size2 - n - 1;
            callback.invoke(array[index2]);
        }
    }

    public final void fastForEachReverseWithIndex(@NotNull Function2<? super Integer, ? super E, Unit> callback) {
        int size2;
        boolean $i$f$fastForEachReverseWithIndex = false;
        Object[] array = this.getArray();
        int initialSize = this.get_size();
        for (int n = 0; n < (size2 = Math.min(initialSize, this.get_size())); ++n) {
            int index2 = size2 - n - 1;
            callback.invoke(index2, array[index2]);
        }
    }

    private final int rangeCheck(int index2) {
        boolean $i$f$rangeCheck = false;
        if (index2 < 0 || index2 >= this.size()) {
            this.throwIndexOtOfBounds(index2);
        }
        return index2;
    }

    private final void throwIndexOtOfBounds(int index2) {
        throw new IndexOutOfBoundsException("index: " + index2 + ", size: " + this.size());
    }

    @Override
    public boolean addAll(@NotNull FastArrayList<E> elements) {
        return MutableListEx.DefaultImpls.addAll(this, elements);
    }

    @Override
    public void setAddAll(int index2, @NotNull FastArrayList<E> elements, int offset2, int size2) {
        MutableListEx.DefaultImpls.setAddAll(this, index2, elements, offset2, size2);
    }

    @Override
    public void removeToSize(int size2) {
        MutableListEx.DefaultImpls.removeToSize(this, size2);
    }
}

