/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import korlibs.datastructure.FloatList;
import korlibs.datastructure.internal._Datastructure_internalKt;
import korlibs.datastructure.internal.memory.Memory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u00020\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\bJ\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fJ\u0006\u0010 \u001a\u00020\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\u0011\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0096\u0002J\u0016\u0010%\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0016J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\bH\u0002J\u0013\u0010,\u001a\u00020#2\b\u0010\u0002\u001a\u0004\u0018\u00010-H\u0096\u0002J\u0011\u0010.\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\bH\u0096\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0005H\u0016J \u00101\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bH\u0016J\u0016\u00104\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u00104\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J*\u00104\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u00102\u001a\u00020\b2\b\b\u0002\u00103\u001a\u00020\bJ\b\u00105\u001a\u00020#H\u0016J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000507H\u0096\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0005H\u0016J \u00108\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bH\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050:H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050:2\u0006\u0010)\u001a\u00020\bH\u0016J\u0011\u0010;\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010;\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010;\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0004H\u0086\u0002J\u0017\u0010;\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fH\u0086\u0002J\u000e\u0010<\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\bJ\u0016\u0010<\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bJ\u0019\u0010=\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010>\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0016J\u0016\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\bJ\b\u0010F\u001a\u00020\u0004H\u0016J\b\u0010G\u001a\u00020HH\u0016R\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\t\u00a8\u0006J"}, d2={"Lkorlibs/datastructure/FloatArrayList;", "Lkorlibs/datastructure/FloatList;", "other", "(Lkorlibs/datastructure/FloatArrayList;)V", "", "", "([F)V", "capacity", "", "(I)V", "getCapacity$korlibs_datastructure", "()I", "<set-?>", "data", "getData", "()[F", "length", "value", "size", "getSize", "setSize", "add", "", "values", "v0", "v1", "v2", "v3", "v4", "v5", "offset", "", "clear", "clone", "contains", "", "element", "containsAll", "elements", "", "createHoleAt", "index", "count", "ensure", "equals", "", "get", "getAt", "hashCode", "indexOf", "start", "end", "insertAt", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "plusAssign", "removeAt", "set", "setAt", "subList", "", "fromIndex", "toIndex", "swap", "indexA", "indexB", "toFloatArray", "toString", "", "Companion", "korlibs-datastructure"})
@SourceDebugExtension(value={"SMAP\nArrayList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayList.kt\nkorlibs/datastructure/FloatArrayList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,679:1\n1#2:680\n*E\n"})
public final class FloatArrayList
implements FloatList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private float[] data;
    private int length;

    public FloatArrayList(int capacity) {
        this.data = new float[capacity];
    }

    public /* synthetic */ FloatArrayList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 7;
        }
        this(n);
    }

    @Override
    @NotNull
    public FloatArrayList clone() {
        return new FloatArrayList(this);
    }

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    public final int getCapacity$korlibs_datastructure() {
        return this.data.length;
    }

    public int getSize() {
        return this.length;
    }

    public void setSize(int value) {
        this.ensure(value);
        this.length = value;
    }

    public FloatArrayList(@NotNull FloatArrayList other) {
        this(0, 1, null);
        this.add(other);
    }

    public FloatArrayList(float ... other) {
        this(0, 1, null);
        FloatArrayList.add$default(this, other, 0, 0, 6, null);
    }

    private final void ensure(int count2) {
        if (this.length + count2 > this.data.length) {
            float[] fArray = Arrays.copyOf(this.data, Math.max(this.length + count2, this.data.length * 3));
            Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(...)");
            Intrinsics.checkNotNull(fArray, "null cannot be cast to non-null type kotlin.FloatArray");
            this.data = fArray;
        }
    }

    @Override
    public final void clear() {
        this.length = 0;
    }

    public final void add(float value) {
        this.ensure(1);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = value;
    }

    public final void add(float v0, float v1) {
        this.ensure(2);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = v0;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v1;
    }

    public final void add(float v0, float v1, float v2) {
        this.ensure(3);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = v0;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v1;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v2;
    }

    public final void add(float v0, float v1, float v2, float v3) {
        this.ensure(4);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = v0;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v1;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v2;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v3;
    }

    public final void add(float v0, float v1, float v2, float v3, float v4) {
        this.ensure(5);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = v0;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v1;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v2;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v3;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v4;
    }

    public final void add(float v0, float v1, float v2, float v3, float v4, float v5) {
        this.ensure(6);
        int n = this.length;
        this.length = n + 1;
        this.data[n] = v0;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v1;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v2;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v3;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v4;
        n = this.length;
        this.length = n + 1;
        this.data[n] = v5;
    }

    public final void plusAssign(float value) {
        this.add(value);
    }

    public final void plusAssign(@NotNull float[] value) {
        FloatArrayList.add$default(this, value, 0, 0, 6, null);
    }

    public final void plusAssign(@NotNull FloatArrayList value) {
        this.add(value);
    }

    public final void plusAssign(@NotNull Iterable<Float> value) {
        this.add(value);
    }

    public final void add(@NotNull float[] values2, int offset2, int length2) {
        this.ensure(length2);
        Intrinsics.checkNotNull(values2, "null cannot be cast to non-null type kotlin.FloatArray");
        Memory.INSTANCE.arraycopy(values2, offset2, this.data, this.size(), length2);
        this.setSize(this.size() + length2);
    }

    public static /* synthetic */ void add$default(FloatArrayList floatArrayList, float[] fArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = fArray.length;
        }
        floatArrayList.add(fArray, n, n2);
    }

    public final void add(@NotNull FloatArrayList values2) {
        this.add(values2.data, 0, values2.size());
    }

    public final void add(@NotNull Iterable<Float> values2) {
        Iterator<Float> iterator2 = values2.iterator();
        while (iterator2.hasNext()) {
            float v = ((Number)iterator2.next()).floatValue();
            this.add(v);
        }
    }

    @Override
    public float get(int index2) {
        return this.data[index2];
    }

    @Override
    public float getAt(int index2) {
        return this.data[index2];
    }

    public final float setAt(int index2, float value) {
        float f;
        float it = f = value;
        boolean bl = false;
        this.set(index2, value);
        return f;
    }

    public final void set(int index2, float value) {
        if (index2 >= this.length) {
            this.ensure(index2 + 1);
            this.length = index2 + 1;
        }
        this.data[index2] = value;
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        return this.listIterator(0);
    }

    public boolean contains(float element) {
        int n = this.length;
        for (int n2 = 0; n2 < n; ++n2) {
            if (!(this.data[n2] == element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Iterator<? extends Object> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            float e = ((Number)iterator2.next()).floatValue();
            if (this.contains(Float.valueOf(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int indexOf(float value, int start2, int end2) {
        for (int n = start2; n < end2; ++n) {
            if (!(this.data[n] == value)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float value, int start2, int end2) {
        int n = end2 - 1;
        if (start2 <= n) {
            while (true) {
                if (this.data[n] == value) {
                    return n;
                }
                if (n == start2) break;
                --n;
            }
        }
        return -1;
    }

    private final void createHoleAt(int index2, int count2) {
        this.ensure(count2);
        if (!((Collection)this).isEmpty()) {
            Memory.INSTANCE.arraycopy(this.data, index2, this.data, index2 + count2, this.length - index2);
        }
    }

    @NotNull
    public final FloatArrayList insertAt(int index2, float value) {
        this.createHoleAt(index2, 1);
        this.data[index2] = value;
        int n = this.length;
        this.length = n + 1;
        return this;
    }

    @NotNull
    public final FloatArrayList insertAt(int index2, float v0, float v1) {
        this.createHoleAt(index2, 2);
        this.data[index2 + 0] = v0;
        this.data[index2 + 1] = v1;
        this.length += 2;
        return this;
    }

    @NotNull
    public final FloatArrayList insertAt(int index2, @NotNull float[] value, int start2, int end2) {
        FloatArrayList floatArrayList;
        FloatArrayList $this$insertAt_u24lambda_u241 = floatArrayList = this;
        boolean bl = false;
        int count2 = end2 - start2;
        $this$insertAt_u24lambda_u241.ensure(count2);
        if (!((Collection)$this$insertAt_u24lambda_u241).isEmpty()) {
            Memory.INSTANCE.arraycopy($this$insertAt_u24lambda_u241.data, index2, $this$insertAt_u24lambda_u241.data, index2 + count2, $this$insertAt_u24lambda_u241.length - index2);
        }
        for (int n = 0; n < count2; ++n) {
            $this$insertAt_u24lambda_u241.data[index2 + n] = value[start2 + n];
        }
        $this$insertAt_u24lambda_u241.length += count2;
        return floatArrayList;
    }

    public static /* synthetic */ FloatArrayList insertAt$default(FloatArrayList floatArrayList, int n, float[] fArray, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = fArray.length;
        }
        return floatArrayList.insertAt(n, fArray, n2, n3);
    }

    public final void swap(int indexA, int indexB) {
        float l = this.getAt(indexA);
        float r = this.getAt(indexB);
        this.set(indexA, r);
        this.set(indexB, l);
    }

    public final float removeAt(int index2) {
        return this.removeAt(index2, 1);
    }

    public final float removeAt(int index2, int count2) {
        if (index2 < 0 || index2 >= this.length || index2 + count2 > this.length) {
            throw new IndexOutOfBoundsException();
        }
        float out = this.data[index2];
        if (count2 > 0) {
            if (index2 < this.length - count2) {
                Memory.INSTANCE.arraycopy(this.data, index2 + count2, this.data, index2, this.length - index2 - count2);
            }
            this.length -= count2;
        }
        return out;
    }

    @Override
    @NotNull
    public float[] toFloatArray() {
        float[] fArray = Arrays.copyOf(this.data, this.length);
        Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(...)");
        return fArray;
    }

    @Override
    public int indexOf(float element) {
        return this.indexOf(element, 0, this.size());
    }

    @Override
    public int lastIndexOf(float element) {
        return this.lastIndexOf(element, 0, this.size());
    }

    @Override
    @NotNull
    public ListIterator<Float> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<Float> listIterator(int index2) {
        return ArraysKt.take(this.data, this.length).listIterator(index2);
    }

    @Override
    @NotNull
    public List<Float> subList(int fromIndex, int toIndex) {
        return ArraysKt.asList(this.data).subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return _Datastructure_internalKt.contentHashCode(this.data, 0, this.size());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof FloatArrayList) {
            return this.size() == ((FloatArrayList)other).size() && _Datastructure_internalKt.contentEquals(this.data, ((FloatArrayList)other).data, 0, this.size());
        }
        if (other instanceof List) {
            return Intrinsics.areEqual(other, this);
        }
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder sb = stringBuilder = new StringBuilder(2 + 5 * this.size());
        boolean bl = false;
        sb.append('[');
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (n2 != 0) {
                sb.append(", ");
            }
            sb.append(this.getAt(n2));
        }
        sb.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean isAlmostEquals(@NotNull FloatList other, float epsilon) {
        return FloatList.DefaultImpls.isAlmostEquals(this, other, epsilon);
    }

    @Override
    public boolean add(float element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Float> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super Float> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public FloatArrayList() {
        this(0, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkorlibs/datastructure/FloatArrayList$Companion;", "", "()V", "korlibs-datastructure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

