/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import korlibs.datastructure._ExtensionsKt;
import korlibs.datastructure.annotations.Template;
import korlibs.datastructure.internal.math.Math;
import korlibs.datastructure.internal.memory.Memory;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Template
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001aH\u0082\bJ%\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001aH\u0082\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u001e\u0010\u001f\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0002H\u0016J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\u0014\u0010%\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(J\u0014\u0010%\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*J\u000e\u0010+\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0007J\u0014\u0010+\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020!J\u0014\u0010+\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(J\u0014\u0010+\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020*J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002J\b\u0010.\u001a\u00020\u001dH\u0016J\u0011\u0010/\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0002H\u0096\u0002J\u0016\u00100\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J(\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0013\u00105\u001a\u00020\u00172\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\u0011\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0002H\u0086\u0002J\u0015\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u00109\u001a\u00020\u0002\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020\u0002H\u0016J\u000e\u0010=\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002J\u0010\u0010>\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0002H\u0002J\b\u0010?\u001a\u00020\u0017H\u0016J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00020AH\u0096\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0002H\u0002J\u0015\u0010C\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\u000e\u0010F\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0002J\u0006\u0010G\u001a\u00020\u0002J\u0006\u0010H\u001a\u00020\u0002J\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0016\u0010J\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\u0019\u0010K\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u0002H\u0086\u0002J\b\u0010M\u001a\u00020NH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006O"}, d2={"Lkorlibs/datastructure/IntDeque;", "", "", "()V", "initialCapacity", "(I)V", "_data", "", "get_data", "()[I", "_size", "_start", "capacity", "getCapacity", "()I", "data", "first", "getFirst", "last", "getLast", "size", "getSize", "_addAll", "", "count", "block", "Lkotlin/Function1;", "_addAllFirst", "_addLast", "", "item", "_removeRetainAll", "elements", "", "retain", "add", "element", "addAll", "array", "items", "", "list", "", "addAllFirst", "addFirst", "addLast", "clear", "contains", "containsAll", "copyCyclic", "i", "istart", "o", "equals", "other", "", "get", "index", "getOrNull", "(I)Ljava/lang/Integer;", "hashCode", "indexOf", "internalIndex", "isEmpty", "iterator", "", "nullify", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "removeAt", "removeFirst", "removeLast", "resizeIfRequiredFor", "retainAll", "set", "value", "toString", "", "korlibs-datastructure"})
@SourceDebugExtension(value={"SMAP\nDeque.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Deque.kt\nkorlibs/datastructure/IntDeque\n+ 2 NonJs.kt\nkorlibs/datastructure/NonJsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Datastructure_internal.kt\nkorlibs/datastructure/internal/_Datastructure_internalKt\n*L\n1#1,1909:1\n295#1,5:1911\n295#1,5:1916\n303#1,6:1921\n303#1,6:1927\n6#2:1910\n1#3:1933\n1747#4,3:1934\n1549#4:1937\n1620#4,3:1938\n1726#4,3:1941\n13#5,3:1944\n*S KotlinDebug\n*F\n+ 1 Deque.kt\nkorlibs/datastructure/IntDeque\n*L\n284#1:1911,5\n285#1:1916,5\n289#1:1921,6\n290#1:1927,6\n244#1:1910\n393#1:1934,3\n401#1:1937\n401#1:1938,3\n406#1:1941,3\n419#1:1944,3\n*E\n"})
public class IntDeque
implements Collection<Integer>,
KMutableCollection {
    private int _start;
    private int _size;
    @NotNull
    private int[] data;

    public IntDeque(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    private final int[] get_data() {
        int[] $this$fastCastTo$iv = this.data;
        boolean $i$f$fastCastTo = false;
        return (int[])((Object)$this$fastCastTo$iv);
    }

    private final int getCapacity() {
        return this.data.length;
    }

    public IntDeque() {
        this(16);
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private final void resizeIfRequiredFor(int count2) {
        if (this.size() + count2 > this.getCapacity()) {
            int[] _o;
            int[] i2 = this.data;
            int istart = this._start;
            int[] o = _o = new int[java.lang.Math.max(this.data.length + 7, java.lang.Math.max(this.size() + count2, this.data.length * 2))];
            this.copyCyclic(i2, istart, o, this._size);
            this.data = o;
            this._start = 0;
        }
    }

    private final void copyCyclic(int[] i2, int istart, int[] o, int count2) {
        int size1 = java.lang.Math.min(i2.length - istart, count2);
        int size2 = count2 - size1;
        Memory.INSTANCE.arraycopy(i2, istart, o, 0, size1);
        if (size2 > 0) {
            Memory.INSTANCE.arraycopy(i2, 0, o, size1, size2);
        }
    }

    public final void addLast(int item2) {
        this.resizeIfRequiredFor(1);
        this._addLast(item2);
    }

    public final void addFirst(int item2) {
        this.resizeIfRequiredFor(1);
        this._start = Math.INSTANCE.umod(this._start - 1, this.getCapacity());
        int n = this._size;
        this._size = n + 1;
        this.data[this._start] = item2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@NotNull int[] array) {
        void this_$iv;
        IntDeque intDeque = this;
        int count$iv = array.length;
        boolean $i$f$_addAll = false;
        super.resizeIfRequiredFor(count$iv);
        int base$iv = this_$iv._start + this_$iv._size;
        for (int n$iv = 0; n$iv < count$iv; ++n$iv) {
            void it;
            int n;
            int n2 = n$iv;
            int n3 = (base$iv + n$iv) % super.getCapacity();
            int[] nArray = this_$iv.data;
            boolean bl = false;
            nArray[n3] = n = array[it];
        }
        this_$iv._size += count$iv;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(@NotNull List<Integer> list2) {
        void this_$iv;
        IntDeque intDeque = this;
        int count$iv = list2.size();
        boolean $i$f$_addAll = false;
        super.resizeIfRequiredFor(count$iv);
        int base$iv = this_$iv._start + this_$iv._size;
        for (int n$iv = 0; n$iv < count$iv; ++n$iv) {
            void it;
            int n;
            int n2 = n$iv;
            int n3 = (base$iv + n$iv) % super.getCapacity();
            int[] nArray = this_$iv.data;
            boolean bl = false;
            nArray[n3] = n = ((Number)list2.get((int)it)).intValue();
        }
        this_$iv._size += count$iv;
        return true;
    }

    @Override
    public final boolean addAll(@NotNull Iterable<Integer> items2) {
        return this.addAll(CollectionsKt.toList(items2));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> elements) {
        return this.addAll(CollectionsKt.toList((Iterable)elements));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAllFirst(@NotNull int[] items2) {
        void this_$iv;
        IntDeque intDeque = this;
        int count$iv = items2.length;
        boolean $i$f$_addAllFirst = false;
        super.resizeIfRequiredFor(count$iv);
        this_$iv._start = Math.INSTANCE.umod(this_$iv._start - count$iv, super.getCapacity());
        this_$iv._size += count$iv;
        int pos$iv = this_$iv._start;
        int n$iv = 0;
        while (n$iv < count$iv) {
            void it;
            int n;
            int n2 = pos$iv++;
            int n3 = n$iv++;
            int n4 = Math.INSTANCE.umod(n2, super.getCapacity());
            int[] nArray = this_$iv.data;
            boolean bl = false;
            nArray[n4] = n = items2[it];
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAllFirst(@NotNull List<Integer> items2) {
        void this_$iv;
        IntDeque intDeque = this;
        int count$iv = items2.size();
        boolean $i$f$_addAllFirst = false;
        super.resizeIfRequiredFor(count$iv);
        this_$iv._start = Math.INSTANCE.umod(this_$iv._start - count$iv, super.getCapacity());
        this_$iv._size += count$iv;
        int pos$iv = this_$iv._start;
        int n$iv = 0;
        while (n$iv < count$iv) {
            void it;
            int n;
            int n2 = pos$iv++;
            int n3 = n$iv++;
            int n4 = Math.INSTANCE.umod(n2, super.getCapacity());
            int[] nArray = this_$iv.data;
            boolean bl = false;
            nArray[n4] = n = ((Number)items2.get((int)it)).intValue();
        }
        return true;
    }

    public final boolean addAllFirst(@NotNull Iterable<Integer> items2) {
        return this.addAllFirst(CollectionsKt.toList(items2));
    }

    public final boolean addAllFirst(@NotNull Collection<Integer> items2) {
        return this.addAllFirst(CollectionsKt.toList((Iterable)items2));
    }

    private final boolean _addAll(int count2, Function1<? super Integer, Integer> block2) {
        boolean $i$f$_addAll = false;
        this.resizeIfRequiredFor(count2);
        int base2 = this._start + this._size;
        for (int n = 0; n < count2; ++n) {
            this.data[(base2 + n) % this.getCapacity()] = ((Number)block2.invoke((Integer)n)).intValue();
        }
        this._size += count2;
        return true;
    }

    private final boolean _addAllFirst(int count2, Function1<? super Integer, Integer> block2) {
        boolean $i$f$_addAllFirst = false;
        this.resizeIfRequiredFor(count2);
        this._start = Math.INSTANCE.umod(this._start - count2, this.getCapacity());
        this._size += count2;
        int pos = this._start;
        for (int n = 0; n < count2; ++n) {
            this.data[Math.INSTANCE.umod((int)pos++, (int)this.getCapacity())] = ((Number)block2.invoke((Integer)n)).intValue();
        }
        return true;
    }

    private final void _addLast(int item2) {
        this.data[(this._start + this._size) % this.getCapacity()] = item2;
        int n = this._size;
        this._size = n + 1;
    }

    private final void nullify(int index2) {
        this.get_data()[index2] = 0;
    }

    public final int removeFirst() {
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        int out = this.getFirst();
        this.nullify(this._start);
        this._start = (this._start + 1) % this.getCapacity();
        int n = this._size;
        this._size = n + -1;
        return out;
    }

    public final int removeLast() {
        if (this._size <= 0) {
            throw new IndexOutOfBoundsException();
        }
        int out = this.getLast();
        this.nullify(this.internalIndex(this.size() - 1));
        int n = this._size;
        this._size = n + -1;
        return out;
    }

    public final int removeAt(int index2) {
        int n;
        if (index2 < 0 || index2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index2 == 0) {
            return this.removeFirst();
        }
        if (index2 == this.size() - 1) {
            return this.removeLast();
        }
        int old = this.get(index2);
        if (index2 < this.size() / 2) {
            for (n = index2; 0 < n; --n) {
                this.set(n, this.get(n - 1));
            }
            this._start = Math.INSTANCE.umod(this._start + 1, this.getCapacity());
        } else {
            int n2 = this.size() - 1;
            for (n = index2; n < n2; ++n) {
                this.set(n, this.get(n + 1));
            }
        }
        int n3 = this._size;
        this._size = n3 + -1;
        return old;
    }

    @Override
    public boolean add(int element) {
        boolean bl;
        boolean $this$add_u24lambda_u244 = bl = true;
        boolean bl2 = false;
        this.addLast(element);
        return bl;
    }

    @Override
    public void clear() {
        this._size = 0;
    }

    public boolean remove(@Nullable Integer element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
        }
        return index2 >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        return this._removeRetainAll(elements, true);
    }

    private final boolean _removeRetainAll(Collection<Integer> elements, boolean retain) {
        Set eset = CollectionsKt.toSet((Iterable)elements);
        int[] nArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        int[] _temp = nArray;
        int tsize = 0;
        int osize = this.size();
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            int c = this.get(n2);
            if (eset.contains(c) != retain) continue;
            _temp[tsize++] = c;
        }
        this.data = _temp;
        this._start = 0;
        this._size = tsize;
        return tsize != osize;
    }

    public final int getFirst() {
        return this.data[this._start];
    }

    public final int getLast() {
        return this.data[this.internalIndex(this.size() - 1)];
    }

    private final int internalIndex(int index2) {
        return Math.INSTANCE.umod(this._start + index2, this.getCapacity());
    }

    public final void set(int index2, int value) {
        this.data[this.internalIndex((int)index2)] = value;
    }

    public final int get(int index2) {
        return this.data[this.internalIndex(index2)];
    }

    @Nullable
    public final Integer getOrNull(int index2) {
        return (0 <= index2 ? index2 < this.size() : false) ? Integer.valueOf(this.get(index2)) : null;
    }

    public boolean contains(int element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RangesKt.until(0, this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.get(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int indexOf(int element) {
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.get(n2) != element) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = elements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((int)it, 0));
            }
            LinkedHashMap emap = _ExtensionsKt.toLinkedMap((List)destination$iv$iv);
            $i$f$map = this.size();
            for (int it = 0; it < $i$f$map; ++it) {
                int e = this.get(it);
                Integer $i$f$mapTo2 = e;
                if (!((Map)emap).containsKey($i$f$mapTo2)) continue;
                $i$f$mapTo2 = e;
                ((Map)emap).put($i$f$mapTo2, 1);
            }
            Collection collection = emap.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    Integer n = it;
                    int n2 = 1;
                    if (n != null && n == n2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        IntDeque that = this;
        return new Iterator<Integer>(that, this){
            private int index;
            final /* synthetic */ IntDeque $that;
            final /* synthetic */ IntDeque this$0;
            {
                this.$that = $that;
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @NotNull
            public Integer next() {
                int n = this.index;
                this.index = n + 1;
                return this.$that.get(n);
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public void remove() {
                this.index += -1;
                this.this$0.removeAt(this.index);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var3_3;
        int size$iv = this.size();
        boolean $i$f$contentHashCode = false;
        int result$iv = 1;
        int n$iv = 0;
        while (n$iv < size$iv) {
            void it;
            int n = n$iv++;
            int n2 = 31 * result$iv;
            boolean bl = false;
            Integer n3 = this.get((int)it);
            result$iv = n2 + ((Object)n3).hashCode();
        }
        return (int)var3_3;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IntDeque)) {
            return false;
        }
        if (((IntDeque)other).size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            if (this.get(n2) == ((IntDeque)other).get(n2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = this.size();
        for (int n2 = 0; n2 < n; ++n2) {
            sb.append(this.get(n2));
            if (n2 == this.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

