/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import korlibs.datastructure.ShortRingBuffer;
import korlibs.datastructure.internal.math.Math;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0013\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\u0003H\u0016J$\u0010\u0013\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003H\u0007J\u0006\u0010'\u001a\u00020(J$\u0010)\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003H\u0007J$\u0010*\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003H\u0007J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020(R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006-"}, d2={"Lkorlibs/datastructure/ShortArrayDeque;", "", "initialBits", "", "(I)V", "availableRead", "getAvailableRead", "()I", "availableWriteWithoutAllocating", "getAvailableWriteWithoutAllocating", "hasMoreToRead", "", "getHasMoreToRead", "()Z", "hasMoreToWrite", "getHasMoreToWrite", "getInitialBits", "<set-?>", "", "read", "getRead", "()J", "ring", "Lkorlibs/datastructure/ShortRingBuffer;", "tempBuffer", "", "written", "getWritten", "clear", "", "clone", "ensureWrite", "count", "equals", "other", "hashCode", "buffer", "offset", "size", "readOne", "", "write", "writeHead", "writeOne", "value", "korlibs-datastructure"})
public final class ShortArrayDeque {
    private final int initialBits;
    @NotNull
    private ShortRingBuffer ring;
    @NotNull
    private final short[] tempBuffer;
    private long written;
    private long read;

    public ShortArrayDeque(int initialBits) {
        this.initialBits = initialBits;
        this.ring = new ShortRingBuffer(this.initialBits);
        this.tempBuffer = new short[1024];
    }

    public /* synthetic */ ShortArrayDeque(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public final int getInitialBits() {
        return this.initialBits;
    }

    public final long getWritten() {
        return this.written;
    }

    public final long getRead() {
        return this.read;
    }

    public final int getAvailableWriteWithoutAllocating() {
        return this.ring.getAvailableWrite();
    }

    public final int getAvailableRead() {
        return this.ring.getAvailableRead();
    }

    @NotNull
    public final ShortArrayDeque clone() {
        ShortArrayDeque shortArrayDeque;
        ShortArrayDeque out = shortArrayDeque = new ShortArrayDeque(this.initialBits);
        boolean bl = false;
        out.ring = this.ring.clone();
        out.written = this.written;
        out.read = this.read;
        return shortArrayDeque;
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] buffer, int offset2, int size2) {
        int out = this.ensureWrite((int)size2).ring.writeHead(buffer, offset2, size2);
        if (out > 0) {
            this.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int writeHead$default(ShortArrayDeque shortArrayDeque, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortArrayDeque.writeHead(sArray, n, n2);
    }

    @JvmOverloads
    public final int write(@NotNull short[] buffer, int offset2, int size2) {
        int out = this.ensureWrite((int)size2).ring.write(buffer, offset2, size2);
        if (out > 0) {
            this.written += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int write$default(ShortArrayDeque shortArrayDeque, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortArrayDeque.write(sArray, n, n2);
    }

    @JvmOverloads
    public final int read(@NotNull short[] buffer, int offset2, int size2) {
        int out = this.ring.read(buffer, offset2, size2);
        if (out > 0) {
            this.read += (long)out;
        }
        return out;
    }

    public static /* synthetic */ int read$default(ShortArrayDeque shortArrayDeque, short[] sArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = sArray.length - n;
        }
        return shortArrayDeque.read(sArray, n, n2);
    }

    private final ShortArrayDeque ensureWrite(int count2) {
        if (count2 > this.ring.getAvailableWrite()) {
            int minNewSize = this.ring.getAvailableRead() + count2;
            int newBits = Math.INSTANCE.ilog2(minNewSize) + 2;
            ShortRingBuffer newRing = new ShortRingBuffer(newBits);
            while (this.ring.getAvailableRead() > 0) {
                int read2 = this.ring.read(this.tempBuffer, 0, this.tempBuffer.length);
                newRing.write(this.tempBuffer, 0, read2);
            }
            this.ring = newRing;
        }
        return this;
    }

    public final void clear() {
        this.ring.clear();
    }

    public final boolean getHasMoreToWrite() {
        return this.ring.getAvailableWrite() > 0;
    }

    public final boolean getHasMoreToRead() {
        return this.ring.getAvailableRead() > 0;
    }

    public final short readOne() {
        this.read(this.tempBuffer, 0, 1);
        return this.tempBuffer[0];
    }

    public final void writeOne(short value) {
        this.tempBuffer[0] = value;
        this.write(this.tempBuffer, 0, 1);
    }

    public int hashCode() {
        return this.ring.contentHashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ShortArrayDeque && Intrinsics.areEqual(this.ring, ((ShortArrayDeque)other).ring);
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] buffer, int offset2) {
        return ShortArrayDeque.writeHead$default(this, buffer, offset2, 0, 4, null);
    }

    @JvmOverloads
    public final int writeHead(@NotNull short[] buffer) {
        return ShortArrayDeque.writeHead$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int write(@NotNull short[] buffer, int offset2) {
        return ShortArrayDeque.write$default(this, buffer, offset2, 0, 4, null);
    }

    @JvmOverloads
    public final int write(@NotNull short[] buffer) {
        return ShortArrayDeque.write$default(this, buffer, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int read(@NotNull short[] buffer, int offset2) {
        return ShortArrayDeque.read$default(this, buffer, offset2, 0, 4, null);
    }

    @JvmOverloads
    public final int read(@NotNull short[] buffer) {
        return ShortArrayDeque.read$default(this, buffer, 0, 0, 6, null);
    }

    public ShortArrayDeque() {
        this(0, 1, null);
    }
}

