/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure;

import java.util.List;
import korlibs.datastructure.IStackedArray2Base;
import korlibs.datastructure.ds.BVH;
import korlibs.datastructure.ds.BVHIntervals;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J@\u00102\u001a\u00020326\u00104\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020305H\u0016J\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000;J\u001d\u0010<\u001a\u0004\u0018\u00018\u00002\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t\u00a2\u0006\u0002\u0010=J\u0018\u0010>\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0016J\u0013\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010C\u001a\u0002032\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0016J\u0015\u0010D\u001a\u0002032\u0006\u0010B\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010E\u001a\u00020\t*\u00028\u00002\u0006\u00108\u001a\u00020\tH\u0004\u00a2\u0006\u0002\u0010FJ\u0019\u0010G\u001a\u00020\t*\u00028\u00002\u0006\u00109\u001a\u00020\tH\u0004\u00a2\u0006\u0002\u0010FJ!\u0010H\u001a\u00020@*\u00028\u00002\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0004\u00a2\u0006\u0002\u0010IR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u001e\u0010\u0017\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001e\u0010\u001a\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u001a\u0010 \u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u000eR\u001a\u0010#\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\f\"\u0004\b%\u0010\u000eR\u001a\u0010&\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010\u000eR\u001a\u0010)\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\f\"\u0004\b+\u0010\u000eR\u0014\u0010,\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u0014\u0010.\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u0014\u00100\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\f\u00a8\u0006J"}, d2={"Lkorlibs/datastructure/SparseChunkedStackedArray2;", "TStackedArray2", "Lkorlibs/datastructure/IStackedArray2Base;", "()V", "bvh", "Lkorlibs/datastructure/ds/BVH;", "getBvh", "()Lkorlibs/datastructure/ds/BVH;", "<set-?>", "", "contentVersion", "getContentVersion", "()I", "setContentVersion", "(I)V", "first", "getFirst", "()Lkorlibs/datastructure/IStackedArray2Base;", "setFirst", "(Lkorlibs/datastructure/IStackedArray2Base;)V", "Lkorlibs/datastructure/IStackedArray2Base;", "height", "getHeight", "last", "getLast", "setLast", "lastSearchChunk", "getLastSearchChunk", "setLastSearchChunk", "maxLevel", "getMaxLevel", "setMaxLevel", "maxX", "getMaxX", "setMaxX", "maxY", "getMaxY", "setMaxY", "minX", "getMinX", "setMinX", "minY", "getMinY", "setMinY", "startX", "getStartX", "startY", "getStartY", "width", "getWidth", "eachPosition", "", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "findAllChunks", "", "getChunkAt", "(II)Lkorlibs/datastructure/IStackedArray2Base;", "getStackLevel", "inside", "", "putChunk", "chunk", "removeLast", "setEmptyFromChunk", "chunkX", "(Lkorlibs/datastructure/IStackedArray2Base;I)I", "chunkY", "containsChunk", "(Lkorlibs/datastructure/IStackedArray2Base;II)Z", "korlibs-datastructure"})
public abstract class SparseChunkedStackedArray2<TStackedArray2 extends IStackedArray2Base>
implements IStackedArray2Base {
    private int contentVersion;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int maxLevel;
    @NotNull
    private final BVH<TStackedArray2> bvh = new BVH(2, 0, false, 6, null);
    @Nullable
    private TStackedArray2 first;
    @Nullable
    private TStackedArray2 last;
    @Nullable
    private TStackedArray2 lastSearchChunk;

    @Override
    public int getContentVersion() {
        return this.contentVersion;
    }

    protected void setContentVersion(int n) {
        this.contentVersion = n;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final void setMinX(int n) {
        this.minX = n;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final void setMinY(int n) {
        this.minY = n;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final void setMaxX(int n) {
        this.maxX = n;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final void setMaxY(int n) {
        this.maxY = n;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    @NotNull
    public final BVH<TStackedArray2> getBvh() {
        return this.bvh;
    }

    @Nullable
    public final TStackedArray2 getFirst() {
        return this.first;
    }

    public final void setFirst(@Nullable TStackedArray2 TStackedArray2) {
        this.first = TStackedArray2;
    }

    @Nullable
    public final TStackedArray2 getLast() {
        return this.last;
    }

    public final void setLast(@Nullable TStackedArray2 TStackedArray2) {
        this.last = TStackedArray2;
    }

    protected abstract void setEmptyFromChunk(@NotNull TStackedArray2 var1);

    public final void putChunk(@NotNull TStackedArray2 chunk) {
        if (this.first == null) {
            this.first = chunk;
            this.setEmptyFromChunk(chunk);
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxY = Integer.MIN_VALUE;
        }
        this.last = chunk;
        int[] nArray = new int[]{chunk.getStartX(), chunk.getWidth(), chunk.getStartY(), chunk.getHeight()};
        this.bvh.insertOrUpdate(BVHIntervals.Companion.invoke(nArray), chunk);
        this.minX = Math.min(this.minX, chunk.getStartX());
        this.minY = Math.min(this.minY, chunk.getStartY());
        this.maxX = Math.max(this.maxX, chunk.getEndX());
        this.maxY = Math.max(this.maxY, chunk.getEndY());
        this.setMaxLevel(Math.max(this.getMaxLevel(), chunk.getMaxLevel()));
        int n = this.getContentVersion();
        this.setContentVersion(n + 1);
    }

    @Override
    public int getStartX() {
        return this.minX;
    }

    @Override
    public int getStartY() {
        return this.minY;
    }

    @Override
    public int getWidth() {
        return this.maxX - this.minX;
    }

    @Override
    public int getHeight() {
        return this.maxY - this.minY;
    }

    @NotNull
    public final List<TStackedArray2> findAllChunks() {
        return this.bvh.findAllValues();
    }

    @Nullable
    protected final TStackedArray2 getLastSearchChunk() {
        return this.lastSearchChunk;
    }

    protected final void setLastSearchChunk(@Nullable TStackedArray2 TStackedArray2) {
        this.lastSearchChunk = TStackedArray2;
    }

    protected final int chunkX(@NotNull TStackedArray2 $this$chunkX, int x) {
        return x - $this$chunkX.getStartX();
    }

    protected final int chunkY(@NotNull TStackedArray2 $this$chunkY, int y) {
        return y - $this$chunkY.getStartY();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean containsChunk(@NotNull TStackedArray2 $this$containsChunk, int x, int y) {
        int n = $this$containsChunk.getStartX();
        if (x >= $this$containsChunk.getEndX()) return false;
        if (n > x) return false;
        boolean bl = true;
        if (!bl) return false;
        n = $this$containsChunk.getStartY();
        if (y >= $this$containsChunk.getEndY()) return false;
        if (n > y) return false;
        return true;
    }

    @Nullable
    public final TStackedArray2 getChunkAt(int x, int y) {
        TStackedArray2 TStackedArray2 = this.lastSearchChunk;
        if (TStackedArray2 != null) {
            TStackedArray2 it = TStackedArray2;
            boolean bl = false;
            if (this.containsChunk(it, x, y)) {
                return it;
            }
        }
        int[] nArray = new int[]{x, 1, y, 1};
        this.lastSearchChunk = (IStackedArray2Base)CollectionsKt.firstOrNull(BVH.searchValues$default(this.bvh, BVHIntervals.Companion.invoke(nArray), null, 2, null));
        return this.lastSearchChunk;
    }

    @Override
    public boolean inside(int x, int y) {
        return this.getChunkAt(x, y) != null;
    }

    @Override
    public int getStackLevel(int x, int y) {
        TStackedArray2 TStackedArray2 = this.getChunkAt(x, y);
        if (TStackedArray2 != null) {
            TStackedArray2 chunk = TStackedArray2;
            boolean bl = false;
            return chunk.getStackLevel(this.chunkX(chunk, x), this.chunkY(chunk, y));
        }
        return 0;
    }

    @Override
    public void removeLast(int x, int y) {
        block0: {
            TStackedArray2 TStackedArray2 = this.getChunkAt(x, y);
            if (TStackedArray2 == null) break block0;
            TStackedArray2 chunk = TStackedArray2;
            boolean bl = false;
            chunk.removeLast(this.chunkX(chunk, x), this.chunkY(chunk, y));
            int n = this.getContentVersion();
            this.setContentVersion(n + 1);
        }
    }

    @Override
    public void eachPosition(@NotNull Function2<? super Integer, ? super Integer, Unit> block2) {
        for (IStackedArray2Base chunk : this.findAllChunks()) {
            chunk.eachPosition((Function2<? super Integer, ? super Integer, Unit>)new Function2<Integer, Integer, Unit>(block2, chunk){
                final /* synthetic */ Function2<Integer, Integer, Unit> $block;
                final /* synthetic */ TStackedArray2 $chunk;
                {
                    this.$block = $block;
                    this.$chunk = $chunk;
                    super(2);
                }

                public final void invoke(int x, int y) {
                    this.$block.invoke(this.$chunk.getStartX() + x, this.$chunk.getStartY() + y);
                }
            });
        }
    }

    @Override
    public int getEndX() {
        return IStackedArray2Base.DefaultImpls.getEndX(this);
    }

    @Override
    public int getEndY() {
        return IStackedArray2Base.DefaultImpls.getEndY(this);
    }
}

