/*
 * Decompiled with CFR 0.152.
 */
package korlibs.datastructure.internal.math;

import korlibs.datastructure.internal.memory.Memory;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0086\u0004J\u0015\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0086\u0004J\u0015\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0086\u0004J\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0086\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkorlibs/datastructure/internal/math/Math;", "", "()V", "MINUS_ZERO_F", "", "ilog2", "", "v", "ilog2Ceil", "divCeil", "that", "umod", "", "other", "korlibs-datastructure"})
@SourceDebugExtension(value={"SMAP\nMath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Math.kt\nkorlibs/datastructure/internal/math/Math\n+ 2 Memory.kt\nkorlibs/datastructure/internal/memory/Memory\n*L\n1#1,80:1\n78#2:81\n*S KotlinDebug\n*F\n+ 1 Math.kt\nkorlibs/datastructure/internal/math/Math\n*L\n7#1:81\n*E\n"})
public final class Math {
    @NotNull
    public static final Math INSTANCE = new Math();
    private static final float MINUS_ZERO_F = -0.0f;

    private Math() {
    }

    public final int ilog2(int v) {
        int n;
        if (v == 0) {
            n = -1;
        } else {
            Memory memory = Memory.INSTANCE;
            int $this$countLeadingZeros$iv = v;
            boolean $i$f$countLeadingZeros = false;
            n = 31 - Integer.numberOfLeadingZeros($this$countLeadingZeros$iv);
        }
        return n;
    }

    public final int umod(int $this$umod, int other) {
        int rm = $this$umod % other;
        int remainder = rm == 0 ? 0 : rm;
        return remainder < 0 ? remainder + other : remainder;
    }

    public final double umod(double $this$umod, double other) {
        double rm = $this$umod % other;
        double remainder = rm == -0.0 ? 0.0 : rm;
        return remainder < 0.0 ? remainder + other : remainder;
    }

    public final float umod(float $this$umod, float other) {
        float rm = $this$umod % other;
        float remainder = rm == MINUS_ZERO_F ? 0.0f : rm;
        return remainder < 0.0f ? remainder + other : remainder;
    }

    public final int divCeil(int $this$divCeil, int that) {
        return $this$divCeil % that != 0 ? $this$divCeil / that + 1 : $this$divCeil / that;
    }

    public final int ilog2Ceil(int v) {
        return (int)java.lang.Math.ceil(MathKt.log2((double)v));
    }
}

