/*
 * Decompiled with CFR 0.152.
 */
package korlibs.encoding;

import java.util.Arrays;
import korlibs.encoding.Base64Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\fJ \u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\fJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\fJ\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\fJ\"\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\fJ\u001b\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0086\u0002J\u001b\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0086\u0002J\u0014\u0010\u0017\u001a\u00020\u000f*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0014\u0010\u0019\u001a\u00020\u000f*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkorlibs/encoding/Base64;", "", "()V", "DECODE", "", "DECODE_URL", "TABLE", "", "TABLE_URL", "decode", "", "ignoreSpaces", "", "str", "url", "", "src", "dst", "decodeIgnoringSpaces", "encode", "doPadding", "invoke", "v", "readU24BE", "index", "readU8", "korlibs-crypto"})
public final class Base64 {
    @NotNull
    public static final Base64 INSTANCE = new Base64();
    @NotNull
    private static final String TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    @NotNull
    private static final String TABLE_URL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=";
    @NotNull
    private static final int[] DECODE = Base64Kt.access$toDecodeArray(TABLE);
    @NotNull
    private static final int[] DECODE_URL = Base64Kt.access$toDecodeArray(TABLE_URL);

    private Base64() {
    }

    @NotNull
    public final byte[] invoke(@NotNull String v, boolean url) {
        return this.decodeIgnoringSpaces(v, url);
    }

    public static /* synthetic */ byte[] invoke$default(Base64 base64, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return base64.invoke(string, bl);
    }

    @NotNull
    public final String invoke(@NotNull byte[] v, boolean url) {
        return Base64.encode$default(this, v, url, false, 4, null);
    }

    public static /* synthetic */ String invoke$default(Base64 base64, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return base64.invoke(byArray, bl);
    }

    @NotNull
    public final byte[] decode(@NotNull String str, boolean url) {
        int n = 0;
        int n2 = str.length();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = (byte)str.charAt(n3);
        }
        byte[] src = byArray;
        byte[] dst = new byte[src.length];
        byte[] byArray2 = Arrays.copyOf(dst, this.decode(src, dst, url));
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        return byArray2;
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return base64.decode(string, bl);
    }

    @NotNull
    public final byte[] decode(boolean ignoreSpaces, @NotNull String str, boolean url) {
        return ignoreSpaces ? INSTANCE.decodeIgnoringSpaces(str, url) : INSTANCE.decode(str, url);
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return base64.decode(bl, string, bl2);
    }

    @NotNull
    public final byte[] decodeIgnoringSpaces(@NotNull String str, boolean url) {
        return this.decode(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(str, " ", "", false, 4, null), "\n", "", false, 4, null), "\r", "", false, 4, null), "\t", "", false, 4, null), url);
    }

    public static /* synthetic */ byte[] decodeIgnoringSpaces$default(Base64 base64, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return base64.decodeIgnoringSpaces(string, bl);
    }

    public final int decode(@NotNull byte[] src, @NotNull byte[] dst, boolean url) {
        int[] decodeArray = url ? DECODE_URL : DECODE;
        int m = 0;
        int n = 0;
        while (n < src.length) {
            int d = decodeArray[this.readU8(src, n)];
            if (d < 0) {
                ++n;
                continue;
            }
            int b0 = n < src.length ? decodeArray[this.readU8(src, n++)] : 64;
            int b1 = n < src.length ? decodeArray[this.readU8(src, n++)] : 64;
            int b2 = n < src.length ? decodeArray[this.readU8(src, n++)] : 64;
            int b3 = n < src.length ? decodeArray[this.readU8(src, n++)] : 64;
            dst[m++] = (byte)(b0 << 2 | b1 >> 4);
            if (b2 >= 64) continue;
            dst[m++] = (byte)(b1 << 4 | b2 >> 2);
            if (b3 >= 64) continue;
            dst[m++] = (byte)(b2 << 6 | b3);
        }
        return m;
    }

    public static /* synthetic */ int decode$default(Base64 base64, byte[] byArray, byte[] byArray2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return base64.decode(byArray, byArray2, bl);
    }

    @NotNull
    public final String encode(@NotNull byte[] src, boolean url, boolean doPadding) {
        int num;
        int ipos;
        String encodeTable = url ? TABLE_URL : TABLE;
        StringBuilder out = new StringBuilder(src.length * 4 / 3 + 4);
        int extraBytes = src.length % 3;
        for (ipos = 0; ipos < src.length - 2; ipos += 3) {
            num = this.readU24BE(src, ipos);
            out.append(encodeTable.charAt(num >>> 18 & 0x3F));
            out.append(encodeTable.charAt(num >>> 12 & 0x3F));
            out.append(encodeTable.charAt(num >>> 6 & 0x3F));
            out.append(encodeTable.charAt(num >>> 0 & 0x3F));
        }
        switch (extraBytes) {
            case 1: {
                num = this.readU8(src, ipos++);
                out.append(encodeTable.charAt(num >>> 2));
                out.append(encodeTable.charAt(num << 4 & 0x3F));
                if (url && (!url || !doPadding)) break;
                out.append('=');
                out.append('=');
                break;
            }
            case 2: {
                int tmp = this.readU8(src, ipos++) << 8 | this.readU8(src, ipos++);
                out.append(encodeTable.charAt(tmp >>> 10));
                out.append(encodeTable.charAt(tmp >>> 4 & 0x3F));
                out.append(encodeTable.charAt(tmp << 2 & 0x3F));
                if (url && (!url || !doPadding)) break;
                out.append('=');
            }
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String encode$default(Base64 base64, byte[] byArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return base64.encode(byArray, bl, bl2);
    }

    private final int readU8(byte[] $this$readU8, int index2) {
        return $this$readU8[index2] & 0xFF;
    }

    private final int readU24BE(byte[] $this$readU24BE, int index2) {
        return this.readU8($this$readU24BE, index2 + 0) << 16 | this.readU8($this$readU24BE, index2 + 1) << 8 | this.readU8($this$readU24BE, index2 + 2) << 0;
    }
}

