/*
 * Decompiled with CFR 0.152.
 */
package korlibs.event.gamepad;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import korlibs.datastructure.Extra;
import korlibs.datastructure.ExtraObject;
import korlibs.datastructure.closeable.Closeable;
import korlibs.event.GameButton;
import korlibs.event.GamepadInfo;
import korlibs.event.GamepadInfoEmitter;
import korlibs.io.concurrent.DispatchersExtKt;
import korlibs.io.concurrent.atomic.KorAtomicInt;
import korlibs.io.concurrent.atomic.KorAtomicKt;
import korlibs.io.file.PathInfo;
import korlibs.io.file.PathInfoKt;
import korlibs.io.file.sync.SyncIO;
import korlibs.io.file.sync.SyncIOFD;
import korlibs.io.lang.ThreadKt;
import korlibs.math.ClampKt;
import korlibs.math.ConvertRangeKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.BitsKt;
import korlibs.memory.ByteArrayGetSetKt;
import korlibs.platform.Endian;
import korlibs.time.DateTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 #2\u00060\u0001j\u0002`\u0002:\u0004#$%&B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\fH\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R-\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lkorlibs/event/gamepad/LinuxJoyEventAdapter;", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "syncIO", "Lkorlibs/io/file/sync/SyncIO;", "(Lkorlibs/io/file/sync/SyncIO;)V", "checkGamepadsRun", "Lkorlibs/event/gamepad/LinuxJoyEventAdapter$RunEvery;", "gamepad", "Lkorlibs/event/GamepadInfo;", "joysticks", "", "Lkorlibs/event/gamepad/LinuxJoyEventAdapter$DeviceInfo;", "getJoysticks", "()Ljava/util/List;", "setJoysticks", "(Ljava/util/List;)V", "readers", "Ljava/util/LinkedHashMap;", "", "Lkorlibs/event/gamepad/LinuxJoyEventAdapter$X11JoystickReader;", "Lkotlin/collections/LinkedHashMap;", "getReaders", "()Ljava/util/LinkedHashMap;", "getSyncIO", "()Lkorlibs/io/file/sync/SyncIO;", "close", "", "ensureJoysticks", "getReader", "device", "listJoysticks", "updateGamepads", "emitter", "Lkorlibs/event/GamepadInfoEmitter;", "Companion", "DeviceInfo", "RunEvery", "X11JoystickReader", "korge"})
@SourceDebugExtension(value={"SMAP\nX11JoyGameControllerCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 X11JoyGameControllerCommon.kt\nkorlibs/event/gamepad/LinuxJoyEventAdapter\n+ 2 TimeSpan.kt\nkorlibs/time/TimeSpanKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,212:1\n72#2:213\n1549#3:214\n1620#3,3:215\n766#3:218\n857#3,2:219\n1549#3:221\n1620#3,3:222\n766#3:225\n857#3,2:226\n1045#3:228\n1549#3:239\n1620#3,3:240\n766#3:243\n857#3,2:244\n372#4,7:229\n61#5,3:236\n61#5,3:246\n215#6,2:249\n*S KotlinDebug\n*F\n+ 1 X11JoyGameControllerCommon.kt\nkorlibs/event/gamepad/LinuxJoyEventAdapter\n*L\n55#1:213\n37#1:214\n37#1:215,3\n38#1:218\n38#1:219,2\n39#1:221\n39#1:222,3\n40#1:225\n40#1:226,2\n41#1:228\n83#1:239\n83#1:240,3\n84#1:243\n84#1:244,2\n67#1:229,7\n75#1:236,3\n85#1:246,3\n89#1:249,2\n*E\n"})
public final class LinuxJoyEventAdapter
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SyncIO syncIO;
    @NotNull
    private final RunEvery checkGamepadsRun;
    @NotNull
    private List<DeviceInfo> joysticks;
    @NotNull
    private final LinkedHashMap<Integer, X11JoystickReader> readers;
    @NotNull
    private final GamepadInfo gamepad;
    public static final int JS_EVENT_BUTTON = 1;
    public static final int JS_EVENT_AXIS = 2;
    public static final int JS_EVENT_INIT = 128;

    public LinuxJoyEventAdapter(@NotNull SyncIO syncIO) {
        this.syncIO = syncIO;
        double $this$seconds$iv = 0.1;
        boolean $i$f$getSeconds = false;
        this.checkGamepadsRun = new RunEvery(DurationKt.toDuration($this$seconds$iv, DurationUnit.SECONDS), null);
        this.joysticks = CollectionsKt.emptyList();
        this.readers = new LinkedHashMap();
        this.gamepad = new GamepadInfo(0, false, null, null, 0.0f, null, null, 127, null);
    }

    public /* synthetic */ LinuxJoyEventAdapter(SyncIO syncIO, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            syncIO = SyncIO.Companion;
        }
        this(syncIO);
    }

    @NotNull
    public final SyncIO getSyncIO() {
        return this.syncIO;
    }

    @NotNull
    public final List<DeviceInfo> listJoysticks() {
        Iterable $this$filterTo$iv$iv;
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String base2 = "/dev/input/by-id";
        Iterable $this$map$iv = this.syncIO.list(base2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(base2 + "/" + (String)it);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, "-joystick", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = this.syncIO.readlink((String)it);
            if (string == null) {
                string = "";
            }
            collection.add(new DeviceInfo((String)it, string));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeviceInfo)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((DeviceInfo)it).getFinalDevice(), "/js", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                DeviceInfo it = (DeviceInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getId());
                it = (DeviceInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getId());
            }
        });
    }

    @NotNull
    public final List<DeviceInfo> getJoysticks() {
        return this.joysticks;
    }

    public final void setJoysticks(@NotNull List<DeviceInfo> list2) {
        this.joysticks = list2;
    }

    @NotNull
    public final LinkedHashMap<Integer, X11JoystickReader> getReaders() {
        return this.readers;
    }

    public final void ensureJoysticks() {
        this.joysticks = this.listJoysticks();
    }

    /*
     * WARNING - void declaration
     */
    private final X11JoystickReader getReader(DeviceInfo device) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.readers;
        Integer key$iv = device.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            X11JoystickReader answer$iv = new X11JoystickReader(device, this.syncIO);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (X11JoystickReader)object;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateGamepads(@NotNull GamepadInfoEmitter emitter) {
        List deletedDeviceIds;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object device;
        this.checkGamepadsRun.invoke(new Function0<Unit>(this){
            final /* synthetic */ LinuxJoyEventAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.ensureJoysticks();
            }
        });
        emitter.dispatchGamepadUpdateStart();
        List<DeviceInfo> $this$fastForEach$iv = this.joysticks;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.size()) {
            device = $this$fastForEach$iv.get(n$iv++);
            boolean bl = false;
            X11JoystickReader reader = this.getReader((DeviceInfo)device);
            reader.read(this.gamepad);
            emitter.dispatchGamepadUpdateAdd(this.gamepad);
            reader.getDispatcher();
        }
        GamepadInfoEmitter.dispatchGamepadUpdateEnd$default(emitter, null, 1, null);
        Iterable $this$map$iv = this.joysticks;
        boolean $i$f$map = false;
        device = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeviceInfo deviceInfo = (DeviceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set joystickDeviceIds = CollectionsKt.toSet((List)destination$iv$iv);
        Set<Integer> set = this.readers.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Integer it = (Integer)element$iv$iv;
            boolean bl = false;
            if (!(!joystickDeviceIds.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List $this$fastForEach$iv2 = deletedDeviceIds = (List)destination$iv$iv2;
        boolean $i$f$fastForEach2 = false;
        int n$iv2 = 0;
        while (n$iv2 < $this$fastForEach$iv2.size()) {
            Integer it = (Integer)$this$fastForEach$iv2.get(n$iv2++);
            boolean bl = false;
            X11JoystickReader x11JoystickReader = (X11JoystickReader)this.readers.remove(it);
            if (x11JoystickReader == null) continue;
            x11JoystickReader.close();
        }
    }

    @Override
    public void close() {
        Map $this$forEach$iv = this.readers;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((X11JoystickReader)it.getValue()).close();
        }
        this.readers.clear();
    }

    public LinuxJoyEventAdapter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkorlibs/event/gamepad/LinuxJoyEventAdapter$Companion;", "", "()V", "JS_EVENT_AXIS", "", "JS_EVENT_BUTTON", "JS_EVENT_INIT", "korge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\b\u0018\u00010\nj\u0002`\u000bX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u001f"}, d2={"Lkorlibs/event/gamepad/LinuxJoyEventAdapter$DeviceInfo;", "Lkorlibs/datastructure/Extra;", "namedDevice", "", "finalDevice", "(Ljava/lang/String;Ljava/lang/String;)V", "baseName", "getBaseName", "()Ljava/lang/String;", "extra", "Lkorlibs/datastructure/ExtraObject;", "Lkorlibs/datastructure/ExtraType;", "getExtra", "()Lkorlibs/datastructure/ExtraObject;", "setExtra", "(Lkorlibs/datastructure/ExtraObject;)V", "getFinalDevice", "id", "", "getId", "()I", "getNamedDevice", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "korge"})
    public static final class DeviceInfo
    implements Extra {
        @NotNull
        private final String namedDevice;
        @NotNull
        private final String finalDevice;
        private final /* synthetic */ Extra.Mixin $$delegate_0;
        @NotNull
        private final String baseName;
        private final int id;

        public DeviceInfo(@NotNull String namedDevice, @NotNull String finalDevice) {
            this.namedDevice = namedDevice;
            this.finalDevice = finalDevice;
            this.$$delegate_0 = new Extra.Mixin(null, 1, null);
            this.baseName = StringsKt.replace$default(StringsKt.removeSuffix(StringsKt.removePrefix(PathInfoKt.getBaseName-pnq4Q78(PathInfo.constructor-impl(this.namedDevice)), (CharSequence)"usb-"), (CharSequence)"-joystick"), "_", " ", false, 4, null);
            Object object = Regex.find$default(new Regex("\\d+$"), this.finalDevice, 0, 2, null);
            this.id = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : -1;
        }

        @NotNull
        public final String getNamedDevice() {
            return this.namedDevice;
        }

        @NotNull
        public final String getFinalDevice() {
            return this.finalDevice;
        }

        @Override
        @Nullable
        public ExtraObject getExtra() {
            return this.$$delegate_0.getExtra();
        }

        @Override
        public void setExtra(@Nullable ExtraObject extraObject) {
            this.$$delegate_0.setExtra(extraObject);
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "DeviceInfo[" + this.id + "](" + this.baseName + ")";
        }

        @NotNull
        public final String component1() {
            return this.namedDevice;
        }

        @NotNull
        public final String component2() {
            return this.finalDevice;
        }

        @NotNull
        public final DeviceInfo copy(@NotNull String namedDevice, @NotNull String finalDevice) {
            return new DeviceInfo(namedDevice, finalDevice);
        }

        public static /* synthetic */ DeviceInfo copy$default(DeviceInfo deviceInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = deviceInfo.namedDevice;
            }
            if ((n & 2) != 0) {
                string2 = deviceInfo.finalDevice;
            }
            return deviceInfo.copy(string, string2);
        }

        public int hashCode() {
            int result2 = this.namedDevice.hashCode();
            result2 = result2 * 31 + this.finalDevice.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceInfo)) {
                return false;
            }
            DeviceInfo deviceInfo = (DeviceInfo)other;
            if (!Intrinsics.areEqual(this.namedDevice, deviceInfo.namedDevice)) {
                return false;
            }
            return Intrinsics.areEqual(this.finalDevice, deviceInfo.finalDevice);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0086\u0002R\"\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lkorlibs/event/gamepad/LinuxJoyEventAdapter$RunEvery;", "", "time", "Lkotlin/time/Duration;", "Lkorlibs/time/TimeSpan;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "lastRun", "Lkorlibs/time/DateTime;", "getLastRun-Wg0KzQs", "()D", "setLastRun-wTNfQOg", "(D)V", "D", "getTime-UwyO8pc", "()J", "J", "invoke", "", "block", "Lkotlin/Function0;", "korge"})
    public static final class RunEvery {
        private final long time;
        private double lastRun;

        private RunEvery(long time) {
            this.time = time;
            this.lastRun = DateTime.Companion.getEPOCH-Wg0KzQs();
        }

        public final long getTime-UwyO8pc() {
            return this.time;
        }

        public final double getLastRun-Wg0KzQs() {
            return this.lastRun;
        }

        public final void setLastRun-wTNfQOg(double d) {
            this.lastRun = d;
        }

        public final void invoke(@NotNull Function0<Unit> block2) {
            double now = DateTime.Companion.now-Wg0KzQs();
            if (Duration.compareTo-LRDsOJo(DateTime.minus-mmBi2yg(now, this.lastRun), this.time) >= 0) {
                this.lastRun = now;
                block2.invoke();
                return;
            }
        }

        public /* synthetic */ RunEvery(long time, DefaultConstructorMarker $constructor_marker) {
            this(time);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\"\u001a\u00020\u0017H\u0016J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!J\u0006\u0010*\u001a\u00020\u0017R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkorlibs/event/gamepad/LinuxJoyEventAdapter$X11JoystickReader;", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "info", "Lkorlibs/event/gamepad/LinuxJoyEventAdapter$DeviceInfo;", "platformSyncIO", "Lkorlibs/io/file/sync/SyncIO;", "(Lkorlibs/event/gamepad/LinuxJoyEventAdapter$DeviceInfo;Lkorlibs/io/file/sync/SyncIO;)V", "_dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "buttonsPressure", "", "dispatcher", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "index", "", "getIndex", "()I", "getInfo", "()Lkorlibs/event/gamepad/LinuxJoyEventAdapter$DeviceInfo;", "once", "Lkotlinx/coroutines/CompletableDeferred;", "", "getOnce", "()Lkotlinx/coroutines/CompletableDeferred;", "getPlatformSyncIO", "()Lkorlibs/io/file/sync/SyncIO;", "readCount", "Lkorlibs/io/concurrent/atomic/KorAtomicInt;", "getReadCount", "()Lkorlibs/io/concurrent/atomic/KorAtomicInt;", "running", "", "close", "read", "gamepad", "Lkorlibs/event/GamepadInfo;", "setButton", "button", "Lkorlibs/event/GameButton;", "value", "threadMain", "korge"})
    @SourceDebugExtension(value={"SMAP\nX11JoyGameControllerCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 X11JoyGameControllerCommon.kt\nkorlibs/event/gamepad/LinuxJoyEventAdapter$X11JoystickReader\n+ 2 Runnable.kt\nkotlinx/coroutines/RunnableKt\n+ 3 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,212:1\n13#2:213\n7#3:214\n7#3:215\n7#3:216\n7#3:217\n*S KotlinDebug\n*F\n+ 1 X11JoyGameControllerCommon.kt\nkorlibs/event/gamepad/LinuxJoyEventAdapter$X11JoystickReader\n*L\n120#1:213\n156#1:214\n157#1:215\n161#1:216\n162#1:217\n*E\n"})
    public static final class X11JoystickReader
    implements Closeable {
        @NotNull
        private final DeviceInfo info;
        @NotNull
        private final SyncIO platformSyncIO;
        private final int index;
        @NotNull
        private final float[] buttonsPressure;
        private boolean running;
        @NotNull
        private final KorAtomicInt readCount;
        @NotNull
        private final CompletableDeferred<Unit> once;
        @Nullable
        private CoroutineDispatcher _dispatcher;

        public X11JoystickReader(@NotNull DeviceInfo info2, @NotNull SyncIO platformSyncIO2) {
            this.info = info2;
            this.platformSyncIO = platformSyncIO2;
            this.index = this.info.getId();
            this.buttonsPressure = new float[32];
            this.running = true;
            this.readCount = KorAtomicKt.KorAtomicInt(0);
            this.once = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        }

        @NotNull
        public final DeviceInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final SyncIO getPlatformSyncIO() {
            return this.platformSyncIO;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setButton(@NotNull GameButton button2, boolean value) {
            this.buttonsPressure[button2.getIndex()] = value ? 1.0f : 0.0f;
        }

        public final void read(@NotNull GamepadInfo gamepad2) {
            gamepad2.setName(this.info.getBaseName());
            ArraysKt.arraycopy(this.buttonsPressure, 0, gamepad2.getRawButtons(), 0, this.buttonsPressure.length);
        }

        @NotNull
        public final KorAtomicInt getReadCount() {
            return this.readCount;
        }

        @NotNull
        public final CompletableDeferred<Unit> getOnce() {
            return this.once;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CoroutineDispatcher getDispatcher() {
            if (this._dispatcher == null) {
                void it;
                CoroutineDispatcher coroutineDispatcher2;
                CoroutineDispatcher coroutineDispatcher3 = coroutineDispatcher2 = DispatchersExtKt.createSingleThreadedDispatcher(Dispatchers.INSTANCE, "index");
                X11JoystickReader x11JoystickReader = this;
                boolean bl = false;
                boolean $i$f$Runnable = false;
                it.dispatch(EmptyCoroutineContext.INSTANCE, new Runnable(this){
                    final /* synthetic */ X11JoystickReader this$0;
                    {
                        this.this$0 = x11JoystickReader;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.this$0.threadMain();
                    }
                });
                x11JoystickReader._dispatcher = coroutineDispatcher2;
            }
            CoroutineDispatcher coroutineDispatcher4 = this._dispatcher;
            Intrinsics.checkNotNull(coroutineDispatcher4);
            return coroutineDispatcher4;
        }

        public final void threadMain() {
            boolean isLittleEndian;
            byte[] packet = new byte[8];
            boolean bl = isLittleEndian = Endian.Companion.getNATIVE() == Endian.LITTLE_ENDIAN;
            while (this.running) {
                try {
                    SyncIOFD raf2 = this.platformSyncIO.open("/dev/input/js" + this.index, "r");
                    while (this.running) {
                        if (SyncIOFD.DefaultImpls.read$default(raf2, packet, 0, 0, 6, null) == 8) {
                            GameButton button2;
                            int time = ByteArrayGetSetKt.getS32(packet, 0, isLittleEndian);
                            int value = ByteArrayGetSetKt.getS16(packet, 4, isLittleEndian);
                            int type2 = ByteArrayGetSetKt.getU8(packet, 6);
                            int number = ByteArrayGetSetKt.getU8(packet, 7);
                            if (BitsKt.hasFlags(type2, 2)) {
                                GameButton gameButton;
                                switch (number) {
                                    case 0: {
                                        gameButton = GameButton.LX;
                                        break;
                                    }
                                    case 1: {
                                        gameButton = GameButton.LY;
                                        break;
                                    }
                                    case 2: {
                                        gameButton = GameButton.L2;
                                        break;
                                    }
                                    case 3: {
                                        gameButton = GameButton.RX;
                                        break;
                                    }
                                    case 4: {
                                        gameButton = GameButton.RY;
                                        break;
                                    }
                                    case 5: {
                                        gameButton = GameButton.R2;
                                        break;
                                    }
                                    case 6: {
                                        gameButton = GameButton.DPADX;
                                        break;
                                    }
                                    case 7: {
                                        gameButton = GameButton.DPADY;
                                        break;
                                    }
                                    default: {
                                        gameButton = GameButton.BUTTON8;
                                    }
                                }
                                button2 = gameButton;
                                float fvalue = ClampKt.clamp((float)value / (float)Short.MAX_VALUE, -1.0f, 1.0f);
                                block11 : switch (WhenMappings.$EnumSwitchMapping$0[button2.ordinal()]) {
                                    case 7: {
                                        boolean $this$toInt$iv = fvalue < 0.0f;
                                        boolean $i$f$toInt = false;
                                        this.buttonsPressure[GameButton.LEFT.getIndex()] = $this$toInt$iv ? 1 : 0;
                                        $this$toInt$iv = fvalue > 0.0f;
                                        $i$f$toInt = false;
                                        this.buttonsPressure[GameButton.RIGHT.getIndex()] = $this$toInt$iv ? 1 : 0;
                                        break;
                                    }
                                    case 8: {
                                        boolean $this$toInt$iv = fvalue < 0.0f;
                                        boolean $i$f$toInt = false;
                                        this.buttonsPressure[GameButton.UP.getIndex()] = $this$toInt$iv ? 1 : 0;
                                        $this$toInt$iv = fvalue > 0.0f;
                                        $i$f$toInt = false;
                                        this.buttonsPressure[GameButton.DOWN.getIndex()] = $this$toInt$iv ? 1 : 0;
                                        break;
                                    }
                                    default: {
                                        switch (WhenMappings.$EnumSwitchMapping$0[button2.ordinal()]) {
                                            case 1: 
                                            case 2: {
                                                float f = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, fvalue, 0.0f, false, 6, null);
                                                break block11;
                                            }
                                            case 3: 
                                            case 4: {
                                                float f = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, -fvalue, 0.0f, false, 6, null);
                                                break block11;
                                            }
                                            case 5: 
                                            case 6: {
                                                float f = ConvertRangeKt.convertRange(fvalue, -1.0f, 1.0f, 0.0f, 1.0f);
                                                break block11;
                                            }
                                            default: {
                                                float f = this.buttonsPressure[button2.getIndex()] = fvalue;
                                            }
                                        }
                                    }
                                }
                            }
                            if (BitsKt.hasFlags(type2, 1)) {
                                GameButton gameButton;
                                switch (number) {
                                    case 0: {
                                        gameButton = GameButton.Companion.getXBOX_A();
                                        break;
                                    }
                                    case 1: {
                                        gameButton = GameButton.Companion.getXBOX_B();
                                        break;
                                    }
                                    case 2: {
                                        gameButton = GameButton.Companion.getXBOX_X();
                                        break;
                                    }
                                    case 3: {
                                        gameButton = GameButton.Companion.getXBOX_Y();
                                        break;
                                    }
                                    case 4: {
                                        gameButton = GameButton.L1;
                                        break;
                                    }
                                    case 5: {
                                        gameButton = GameButton.R1;
                                        break;
                                    }
                                    case 6: {
                                        gameButton = GameButton.SELECT;
                                        break;
                                    }
                                    case 7: {
                                        gameButton = GameButton.START;
                                        break;
                                    }
                                    case 8: {
                                        gameButton = GameButton.SYSTEM;
                                        break;
                                    }
                                    case 9: {
                                        gameButton = GameButton.L3;
                                        break;
                                    }
                                    case 10: {
                                        gameButton = GameButton.R3;
                                        break;
                                    }
                                    default: {
                                        gameButton = GameButton.BUTTON8;
                                    }
                                }
                                button2 = gameButton;
                                this.setButton(button2, value != 0);
                            }
                        } else {
                            ThreadKt.Thread_sleep(10L);
                        }
                        KorAtomicKt.incrementAndGet(this.readCount);
                        this.once.complete(Unit.INSTANCE);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    ThreadKt.Thread_sleep(100L);
                }
            }
        }

        @Override
        public void close() {
            this.running = false;
            DispatchersExtKt.close(this.getDispatcher());
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GameButton.values().length];
                try {
                    nArray[GameButton.LX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.RX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.LY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.RY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.L2.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.R2.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.DPADX.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GameButton.DPADY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

