/*
 * Decompiled with CFR 0.152.
 */
package korlibs.event.gamepad;

import com.sun.jna.Pointer;
import korlibs.datastructure.IntArrayList;
import korlibs.event.GameButton;
import korlibs.event.GamepadInfo;
import korlibs.event.GamepadInfoEmitter;
import korlibs.ffi.FFIArena;
import korlibs.ffi.FFIDelegateByteProperty;
import korlibs.ffi.FFIDelegateFixedBytesProperty;
import korlibs.ffi.FFIDelegateIntProperty;
import korlibs.ffi.FFIDelegateShortProperty;
import korlibs.ffi.FFIFuncConfig;
import korlibs.ffi.FFILib;
import korlibs.ffi.FFIStructure;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.Charsets;
import korlibs.math.ConvertRangeKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.BitsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter;", "", "()V", "controllers", "", "Lkorlibs/event/GamepadInfo;", "[Lkorlibs/event/GamepadInfo;", "convertShortRangeToDouble", "", "value", "", "convertUByteRangeToDouble", "", "updateGamepads", "", "emitter", "Lkorlibs/event/GamepadInfoEmitter;", "setDigital", "button", "Lkorlibs/event/GameButton;", "buttons", "", "bit", "JoyCapsW", "Win32Joy", "XInput", "XInputState", "korge"})
@SourceDebugExtension(value={"SMAP\nXInputGamepadEventAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter\n+ 2 FFILib.kt\nkorlibs/ffi/FFILibKt\n*L\n1#1,138:1\n62#2,3:139\n62#2,5:142\n66#2:147\n*S KotlinDebug\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter\n*L\n16#1:139,3\n46#1:142,5\n16#1:147\n*E\n"})
public final class XInputGamepadEventAdapter {
    @NotNull
    private final GamepadInfo[] controllers;

    public XInputGamepadEventAdapter() {
        int n = 0;
        GamepadInfo[] gamepadInfoArray = new GamepadInfo[4];
        XInputGamepadEventAdapter xInputGamepadEventAdapter = this;
        while (n < 4) {
            int n2 = n++;
            gamepadInfoArray[n2] = new GamepadInfo(n2, false, null, null, 0.0f, null, null, 126, null);
        }
        xInputGamepadEventAdapter.controllers = gamepadInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateGamepads(@NotNull GamepadInfoEmitter emitter) {
        if (!XInput.INSTANCE.getLoaded()) {
            return;
        }
        emitter.dispatchGamepadUpdateStart();
        boolean $i$f$ffiScoped = false;
        FFIArena arena$iv = new FFIArena();
        try {
            FFIArena $this$updateGamepads_u24lambda_u241 = arena$iv;
            boolean bl = false;
            XInputState state2 = new XInputState($this$updateGamepads_u24lambda_u241.allocBytes(new XInputState(null, 1, null).getSize()));
            for (int n = 0; n < 4; ++n) {
                boolean connected2 = ((Number)XInput.INSTANCE.getXInputGetState().invoke(n, state2.getPtr())).intValue() == 0;
                GamepadInfo gamepad2 = this.controllers[n];
                if (!connected2) continue;
                int buttons = state2.getWButtons() & 0xFFFF;
                this.setDigital(gamepad2, GameButton.UP, buttons, 0);
                this.setDigital(gamepad2, GameButton.DOWN, buttons, 1);
                this.setDigital(gamepad2, GameButton.LEFT, buttons, 2);
                this.setDigital(gamepad2, GameButton.RIGHT, buttons, 3);
                this.setDigital(gamepad2, GameButton.Companion.getBACK(), buttons, 5);
                this.setDigital(gamepad2, GameButton.START, buttons, 4);
                this.setDigital(gamepad2, GameButton.Companion.getLEFT_THUMB(), buttons, 6);
                this.setDigital(gamepad2, GameButton.Companion.getRIGHT_THUMB(), buttons, 7);
                this.setDigital(gamepad2, GameButton.Companion.getLEFT_SHOULDER(), buttons, 8);
                this.setDigital(gamepad2, GameButton.Companion.getRIGHT_SHOULDER(), buttons, 9);
                this.setDigital(gamepad2, GameButton.Companion.getXBOX_A(), buttons, 12);
                this.setDigital(gamepad2, GameButton.Companion.getXBOX_B(), buttons, 13);
                this.setDigital(gamepad2, GameButton.Companion.getXBOX_X(), buttons, 14);
                this.setDigital(gamepad2, GameButton.Companion.getXBOX_Y(), buttons, 15);
                gamepad2.getRawButtons()[GameButton.Companion.getLEFT_TRIGGER().getIndex()] = this.convertUByteRangeToDouble(state2.getBLeftTrigger());
                gamepad2.getRawButtons()[GameButton.Companion.getRIGHT_TRIGGER().getIndex()] = this.convertUByteRangeToDouble(state2.getBRightTrigger());
                gamepad2.getRawButtons()[GameButton.LX.getIndex()] = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, this.convertShortRangeToDouble(state2.getSThumbLX()), 0.0f, false, 6, null);
                gamepad2.getRawButtons()[GameButton.LY.getIndex()] = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, this.convertShortRangeToDouble(state2.getSThumbLY()), 0.0f, false, 6, null);
                gamepad2.getRawButtons()[GameButton.RX.getIndex()] = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, this.convertShortRangeToDouble(state2.getSThumbRX()), 0.0f, false, 6, null);
                gamepad2.getRawButtons()[GameButton.RY.getIndex()] = GamepadInfo.Companion.withoutDeadRange$default(GamepadInfo.Companion, this.convertShortRangeToDouble(state2.getSThumbRY()), 0.0f, false, 6, null);
                if (gamepad2.getName() == null) {
                    boolean $i$f$ffiScoped2 = false;
                    FFIArena arena$iv2 = new FFIArena();
                    try {
                        FFIArena $this$updateGamepads_u24lambda_u241_u24lambda_u240 = arena$iv2;
                        boolean bl2 = false;
                        JoyCapsW joyCapsW = new JoyCapsW($this$updateGamepads_u24lambda_u241_u24lambda_u240.allocBytes(JoyCapsW.Companion.getSIZE()));
                        if (((Number)Win32Joy.INSTANCE.getJoyGetDevCapsW().invoke(n, joyCapsW.getPtr(), JoyCapsW.Companion.getSIZE())).intValue() == 0) {
                            gamepad2.setName(joyCapsW.getName());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        arena$iv2.clear();
                    }
                }
                emitter.dispatchGamepadUpdateAdd(gamepad2);
            }
            IntArrayList intArrayList = GamepadInfoEmitter.dispatchGamepadUpdateEnd$default(emitter, null, 1, null);
        }
        finally {
            arena$iv.clear();
        }
    }

    private final void setDigital(GamepadInfo $this$setDigital, GameButton button2, int buttons, int bit) {
        $this$setDigital.getRawButtons()[button2.getIndex()] = BitsKt.hasBitSet(buttons, bit) ? 1.0f : 0.0f;
    }

    private final float convertShortRangeToDouble(short value) {
        return ConvertRangeKt.convertRangeClamped((float)value, -32768.0f, 32767.0f, -1.0f, 1.0f);
    }

    private final float convertUByteRangeToDouble(byte value) {
        return ConvertRangeKt.convertRangeClamped((float)(value & 0xFF), 0.0f, 255.0f, 0.0f, 1.0f);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u000e\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\"\u001a\u00020\u0007H\u0016R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR+\u0010\u001e\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u001d\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001b\u00a8\u0006$"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter$JoyCapsW;", "Lkorlibs/ffi/FFIStructure;", "pointer", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "(Lcom/sun/jna/Pointer;)V", "value", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "<set-?>", "", "szPname", "getSzPname", "()[B", "setSzPname", "([B)V", "szPname$delegate", "Lkorlibs/ffi/FFIDelegateFixedBytesProperty;", "", "wMid", "getWMid", "()S", "setWMid", "(S)V", "wMid$delegate", "I", "wPid", "getWPid", "setWPid", "wPid$delegate", "toString", "Companion", "korge"})
    public static final class JoyCapsW
    extends FFIStructure {
        @NotNull
        public static final Companion Companion;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        private final int wMid$delegate;
        private final int wPid$delegate;
        @NotNull
        private final FFIDelegateFixedBytesProperty szPname$delegate;
        private static final int SIZE;

        public JoyCapsW(@Nullable Pointer pointer) {
            super(pointer);
            this.wMid$delegate = this.short-y2FZdbA();
            this.wPid$delegate = this.short-y2FZdbA();
            this.szPname$delegate = this.fixedBytes(64);
        }

        public /* synthetic */ JoyCapsW(Pointer pointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                pointer = null;
            }
            this(pointer);
        }

        public final short getWMid() {
            return FFIDelegateShortProperty.getValue-impl(this.wMid$delegate, this, $$delegatedProperties[0]);
        }

        public final void setWMid(short s) {
            FFIDelegateShortProperty.setValue-impl(this.wMid$delegate, this, $$delegatedProperties[0], s);
        }

        public final short getWPid() {
            return FFIDelegateShortProperty.getValue-impl(this.wPid$delegate, this, $$delegatedProperties[1]);
        }

        public final void setWPid(short s) {
            FFIDelegateShortProperty.setValue-impl(this.wPid$delegate, this, $$delegatedProperties[1], s);
        }

        @NotNull
        public final byte[] getSzPname() {
            return this.szPname$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setSzPname(@NotNull byte[] byArray) {
            this.szPname$delegate.setValue(this, $$delegatedProperties[2], byArray);
        }

        @NotNull
        public final String getName() {
            Object object = new char[]{'\u0000'};
            Object it = object = (Object)StringsKt.trimEnd(CharsetKt.toString$default(this.getSzPname(), Charsets.INSTANCE.getUTF16_LE(), 0, 0, 6, null), object);
            boolean bl = false;
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public final void setName(@NotNull String value) {
            void $this$_set_name__u24lambda_u242;
            byte[] byArray;
            JoyCapsW joyCapsW = this;
            JoyCapsW joyCapsW2 = this;
            boolean bl = false;
            byte[] it = byArray = new byte[$this$_set_name__u24lambda_u242.getSzPname().length];
            boolean bl2 = false;
            byte[] byArray2 = CharsetKt.toByteArray$default(value, Charsets.INSTANCE.getUTF16_LE(), 0, 0, 6, null);
            ArraysKt.arraycopy(byArray2, 0, it, 0, byArray2.length);
            joyCapsW2.setSzPname(byArray);
        }

        @NotNull
        public String toString() {
            return "JoyCapsW(name=" + this.getName() + ")";
        }

        public JoyCapsW() {
            this(null, 1, null);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(JoyCapsW.class, "wMid", "getWMid()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(JoyCapsW.class, "wPid", "getWPid()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(JoyCapsW.class, "szPname", "getSzPname()[B", 0))};
            $$delegatedProperties = kPropertyArray;
            Companion = new Companion(null);
            SIZE = 728;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter$JoyCapsW$Companion;", "", "()V", "SIZE", "", "getSIZE", "()I", "korge"})
        public static final class Companion {
            private Companion() {
            }

            public final int getSIZE() {
                return SIZE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rh\u0010\u0003\u001aO\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u001b\u0012\u0019\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter$Win32Joy;", "Lkorlibs/ffi/FFILib;", "()V", "joyGetDevCapsW", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "uJoyID", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "pjc", "cbjc", "getJoyGetDevCapsW", "()Lkotlin/jvm/functions/Function3;", "joyGetDevCapsW$delegate", "Lkotlin/properties/ReadOnlyProperty;", "korge"})
    @SourceDebugExtension(value={"SMAP\nXInputGamepadEventAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter$Win32Joy\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,138:1\n234#2:139\n*S KotlinDebug\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter$Win32Joy\n*L\n94#1:139\n*E\n"})
    public static final class Win32Joy
    extends FFILib {
        @NotNull
        public static final Win32Joy INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty joyGetDevCapsW$delegate;

        private Win32Joy() {
            String[] stringArray = new String[]{"Winmm.dll"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function3<Integer, Pointer, Integer, Integer> getJoyGetDevCapsW() {
            return (Function3)joyGetDevCapsW$delegate.getValue(this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Win32Joy.class, "joyGetDevCapsW", "getJoyGetDevCapsW()Lkotlin/jvm/functions/Function3;", 0))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new Win32Joy();
            FFILib $this$iv = INSTANCE;
            String name$iv = null;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getDEFAULT();
            boolean required$iv = true;
            boolean $i$f$func = false;
            joyGetDevCapsW$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function3.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000RS\u0010\u0017\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u001b\u0012\u0019\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00040\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter$XInput;", "Lkorlibs/ffi/FFILib;", "()V", "ERROR_DEVICE_NOT_CONNECTED", "", "GAMEPAD_A", "GAMEPAD_B", "GAMEPAD_BACK", "GAMEPAD_DPAD_DOWN", "GAMEPAD_DPAD_LEFT", "GAMEPAD_DPAD_RIGHT", "GAMEPAD_DPAD_UP", "GAMEPAD_LEFT_SHOULDER", "GAMEPAD_LEFT_THUMB", "GAMEPAD_RIGHT_SHOULDER", "GAMEPAD_RIGHT_THUMB", "GAMEPAD_START", "GAMEPAD_UNKNOWN_10", "GAMEPAD_UNKNOWN_11", "GAMEPAD_X", "GAMEPAD_Y", "SIZE", "SUCCESS", "XInputGetState", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "dwUserIndex", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "pState", "getXInputGetState", "()Lkotlin/jvm/functions/Function2;", "XInputGetState$delegate", "Lkotlin/properties/ReadOnlyProperty;", "korge"})
    @SourceDebugExtension(value={"SMAP\nXInputGamepadEventAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter$XInput\n+ 2 FFILib.kt\nkorlibs/ffi/FFILib\n*L\n1#1,138:1\n234#2:139\n*S KotlinDebug\n*F\n+ 1 XInputGamepadEventAdapter.kt\nkorlibs/event/gamepad/XInputGamepadEventAdapter$XInput\n*L\n68#1:139\n*E\n"})
    public static final class XInput
    extends FFILib {
        @NotNull
        public static final XInput INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final ReadOnlyProperty XInputGetState$delegate;
        public static final int SUCCESS = 0;
        public static final int ERROR_DEVICE_NOT_CONNECTED = 1167;
        public static final int GAMEPAD_DPAD_UP = 0;
        public static final int GAMEPAD_DPAD_DOWN = 1;
        public static final int GAMEPAD_DPAD_LEFT = 2;
        public static final int GAMEPAD_DPAD_RIGHT = 3;
        public static final int GAMEPAD_START = 4;
        public static final int GAMEPAD_BACK = 5;
        public static final int GAMEPAD_LEFT_THUMB = 6;
        public static final int GAMEPAD_RIGHT_THUMB = 7;
        public static final int GAMEPAD_LEFT_SHOULDER = 8;
        public static final int GAMEPAD_RIGHT_SHOULDER = 9;
        public static final int GAMEPAD_UNKNOWN_10 = 10;
        public static final int GAMEPAD_UNKNOWN_11 = 11;
        public static final int GAMEPAD_A = 12;
        public static final int GAMEPAD_B = 13;
        public static final int GAMEPAD_X = 14;
        public static final int GAMEPAD_Y = 15;
        public static final int SIZE = 16;

        private XInput() {
            String[] stringArray = new String[]{"xinput9_1_0.dll"};
            super(stringArray, false, 2, null);
        }

        @NotNull
        public final Function2<Integer, Pointer, Integer> getXInputGetState() {
            return (Function2)XInputGetState$delegate.getValue(this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(XInput.class, "XInputGetState", "getXInputGetState()Lkotlin/jvm/functions/Function2;", 0))};
            $$delegatedProperties = kPropertyArray;
            INSTANCE = new XInput();
            FFILib $this$iv = INSTANCE;
            String name$iv = null;
            FFIFuncConfig config$iv = FFIFuncConfig.Companion.getDEFAULT();
            boolean required$iv = true;
            boolean $i$f$func = false;
            XInputGetState$delegate = new FFILib.FuncInfo(Reflection.typeOf(Function2.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE)), KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Pointer.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))), name$iv, config$iv, required$iv).provideDelegate(INSTANCE, $$delegatedProperties[0]);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00101\u001a\u000202H\u0016R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR)\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0010\n\u0002\b\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R+\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u000e\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR+\u0010!\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u000e\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR+\u0010%\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u000e\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001fR+\u0010)\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010\u000e\u001a\u0004\b*\u0010\u001d\"\u0004\b+\u0010\u001fR+\u0010-\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010\u000e\u001a\u0004\b.\u0010\u001d\"\u0004\b/\u0010\u001f\u00a8\u00063"}, d2={"Lkorlibs/event/gamepad/XInputGamepadEventAdapter$XInputState;", "Lkorlibs/ffi/FFIStructure;", "pointer", "Lcom/sun/jna/Pointer;", "Lkorlibs/ffi/FFIPointer;", "(Lcom/sun/jna/Pointer;)V", "<set-?>", "", "bLeftTrigger", "getBLeftTrigger", "()B", "setBLeftTrigger", "(B)V", "bLeftTrigger$delegate", "I", "bRightTrigger", "getBRightTrigger", "setBRightTrigger", "bRightTrigger$delegate", "", "dwPacketNumber", "getDwPacketNumber", "()I", "setDwPacketNumber", "(I)V", "dwPacketNumber$delegate", "", "sThumbLX", "getSThumbLX", "()S", "setSThumbLX", "(S)V", "sThumbLX$delegate", "sThumbLY", "getSThumbLY", "setSThumbLY", "sThumbLY$delegate", "sThumbRX", "getSThumbRX", "setSThumbRX", "sThumbRX$delegate", "sThumbRY", "getSThumbRY", "setSThumbRY", "sThumbRY$delegate", "wButtons", "getWButtons", "setWButtons", "wButtons$delegate", "toString", "", "korge"})
    public static final class XInputState
    extends FFIStructure {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        private final int dwPacketNumber$delegate;
        private final int wButtons$delegate;
        private final int bLeftTrigger$delegate;
        private final int bRightTrigger$delegate;
        private final int sThumbLX$delegate;
        private final int sThumbLY$delegate;
        private final int sThumbRX$delegate;
        private final int sThumbRY$delegate;

        public XInputState(@Nullable Pointer pointer) {
            super(pointer);
            this.dwPacketNumber$delegate = this.int-4vUtyEE();
            this.wButtons$delegate = this.short-y2FZdbA();
            this.bLeftTrigger$delegate = this.byte-Rg5Sx7g();
            this.bRightTrigger$delegate = this.byte-Rg5Sx7g();
            this.sThumbLX$delegate = this.short-y2FZdbA();
            this.sThumbLY$delegate = this.short-y2FZdbA();
            this.sThumbRX$delegate = this.short-y2FZdbA();
            this.sThumbRY$delegate = this.short-y2FZdbA();
        }

        public /* synthetic */ XInputState(Pointer pointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                pointer = null;
            }
            this(pointer);
        }

        public final int getDwPacketNumber() {
            return FFIDelegateIntProperty.getValue-impl(this.dwPacketNumber$delegate, this, $$delegatedProperties[0]);
        }

        public final void setDwPacketNumber(int n) {
            FFIDelegateIntProperty.setValue-impl(this.dwPacketNumber$delegate, this, $$delegatedProperties[0], n);
        }

        public final short getWButtons() {
            return FFIDelegateShortProperty.getValue-impl(this.wButtons$delegate, this, $$delegatedProperties[1]);
        }

        public final void setWButtons(short s) {
            FFIDelegateShortProperty.setValue-impl(this.wButtons$delegate, this, $$delegatedProperties[1], s);
        }

        public final byte getBLeftTrigger() {
            return FFIDelegateByteProperty.getValue-impl(this.bLeftTrigger$delegate, this, $$delegatedProperties[2]);
        }

        public final void setBLeftTrigger(byte by) {
            FFIDelegateByteProperty.setValue-impl(this.bLeftTrigger$delegate, this, $$delegatedProperties[2], by);
        }

        public final byte getBRightTrigger() {
            return FFIDelegateByteProperty.getValue-impl(this.bRightTrigger$delegate, this, $$delegatedProperties[3]);
        }

        public final void setBRightTrigger(byte by) {
            FFIDelegateByteProperty.setValue-impl(this.bRightTrigger$delegate, this, $$delegatedProperties[3], by);
        }

        public final short getSThumbLX() {
            return FFIDelegateShortProperty.getValue-impl(this.sThumbLX$delegate, this, $$delegatedProperties[4]);
        }

        public final void setSThumbLX(short s) {
            FFIDelegateShortProperty.setValue-impl(this.sThumbLX$delegate, this, $$delegatedProperties[4], s);
        }

        public final short getSThumbLY() {
            return FFIDelegateShortProperty.getValue-impl(this.sThumbLY$delegate, this, $$delegatedProperties[5]);
        }

        public final void setSThumbLY(short s) {
            FFIDelegateShortProperty.setValue-impl(this.sThumbLY$delegate, this, $$delegatedProperties[5], s);
        }

        public final short getSThumbRX() {
            return FFIDelegateShortProperty.getValue-impl(this.sThumbRX$delegate, this, $$delegatedProperties[6]);
        }

        public final void setSThumbRX(short s) {
            FFIDelegateShortProperty.setValue-impl(this.sThumbRX$delegate, this, $$delegatedProperties[6], s);
        }

        public final short getSThumbRY() {
            return FFIDelegateShortProperty.getValue-impl(this.sThumbRY$delegate, this, $$delegatedProperties[7]);
        }

        public final void setSThumbRY(short s) {
            FFIDelegateShortProperty.setValue-impl(this.sThumbRY$delegate, this, $$delegatedProperties[7], s);
        }

        @NotNull
        public String toString() {
            return "XInputState(dwPacketNumber=" + this.getDwPacketNumber() + ", wButtons=" + this.getWButtons() + ", bLeftTrigger=" + this.getBLeftTrigger() + ", bRightTrigger=" + this.getBRightTrigger() + ", sThumbLX=" + this.getSThumbLX() + ", sThumbLY=" + this.getSThumbLY() + ", sThumbRX=" + this.getSThumbRX() + ", sThumbRY=" + this.getSThumbRY() + ")";
        }

        public XInputState() {
            this(null, 1, null);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "dwPacketNumber", "getDwPacketNumber()I", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "wButtons", "getWButtons()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "bLeftTrigger", "getBLeftTrigger()B", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "bRightTrigger", "getBRightTrigger()B", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "sThumbLX", "getSThumbLX()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "sThumbLY", "getSThumbLY()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "sThumbRX", "getSThumbRX()S", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(XInputState.class, "sThumbRY", "getSThumbRY()S", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

