/*
 * Decompiled with CFR 0.152.
 */
package korlibs.ffi.osx;

import java.util.ArrayList;
import java.util.Collection;
import korlibs.ffi.osx.ConstObjcType;
import korlibs.ffi.osx.FixedArrayObjcType;
import korlibs.ffi.osx.ObjcMethodDesc;
import korlibs.ffi.osx.ObjcParam;
import korlibs.ffi.osx.ObjcType;
import korlibs.ffi.osx.ObjcTypeParser;
import korlibs.ffi.osx.PointerObjcType;
import korlibs.ffi.osx.PrimitiveObjcType;
import korlibs.ffi.osx.StructObjcType;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lkorlibs/ffi/osx/ObjcTypeParser;", "", "()V", "parse", "Lkorlibs/ffi/osx/ObjcMethodDesc;", "str", "Lkorlibs/ffi/osx/ObjcTypeParser$StrReader;", "", "parseInt", "", "parseParam", "Lkorlibs/ffi/osx/ObjcParam;", "parseType", "Lkorlibs/ffi/osx/ObjcType;", "StrReader", "korge-core"})
public final class ObjcTypeParser {
    @NotNull
    public static final ObjcTypeParser INSTANCE = new ObjcTypeParser();

    private ObjcTypeParser() {
    }

    public final int parseInt(@NotNull StrReader str) {
        Object out = "";
        while (Character.isDigit(str.peekChar())) {
            out = (String)out + str.readChar();
        }
        Integer n = StringsKt.toIntOrNull((String)out);
        return n != null ? n : -1;
    }

    @NotNull
    public final ObjcType parseType(@NotNull StrReader str) {
        ObjcType objcType;
        char c = str.readChar();
        char c2 = c;
        if (c2 == 'V') {
            objcType = PrimitiveObjcType.VOID;
        } else if (c2 == 'v') {
            objcType = PrimitiveObjcType.VOID;
        } else if (c2 == 'B') {
            objcType = PrimitiveObjcType.BOOL;
        } else if (c2 == '@') {
            PrimitiveObjcType primitiveObjcType;
            if (str.peekChar() == '?') {
                StrReader.skip$default(str, 0, 1, null);
                primitiveObjcType = PrimitiveObjcType.BLOCK;
            } else {
                primitiveObjcType = PrimitiveObjcType.ID;
            }
            objcType = primitiveObjcType;
        } else if (c2 == '{') {
            String name2 = str.readUntil(parseType.name.1.INSTANCE);
            if (str.readChar() != '=') {
                throw new IllegalStateException(("Invalid " + str).toString());
            }
            ArrayList out = new ArrayList();
            while (str.peekChar() != '}') {
                ((Collection)out).add(this.parseType(str));
            }
            StrReader.skip$default(str, 0, 1, null);
            objcType = new StructObjcType(name2, out);
        } else if (c2 == '[') {
            int count2 = this.parseInt(str);
            ObjcType type2 = this.parseType(str);
            if (str.readChar() != ']') {
                throw new IllegalStateException(("Invalid " + str).toString());
            }
            objcType = new FixedArrayObjcType(count2, type2);
        } else if (c2 == '#') {
            objcType = PrimitiveObjcType.ID;
        } else if (c2 == ':') {
            objcType = PrimitiveObjcType.SEL;
        } else if (c2 == 'C') {
            objcType = PrimitiveObjcType.BYTE;
        } else if (c2 == 'i') {
            objcType = PrimitiveObjcType.INT;
        } else if (c2 == 'I') {
            objcType = PrimitiveObjcType.UINT;
        } else if (c2 == 'q') {
            objcType = PrimitiveObjcType.NINT;
        } else if (c2 == 'Q') {
            objcType = PrimitiveObjcType.NUINT;
        } else if (c2 == '^') {
            objcType = new PointerObjcType(this.parseType(str));
        } else if (c2 == '?') {
            objcType = PrimitiveObjcType.BLOCK;
        } else if (c2 == '*') {
            objcType = new PointerObjcType(PrimitiveObjcType.BYTE);
        } else if (c2 == 'r') {
            objcType = new ConstObjcType(this.parseType(str));
        } else if (c2 == 'f') {
            objcType = PrimitiveObjcType.FLOAT;
        } else if (c2 == 'd') {
            objcType = PrimitiveObjcType.DOUBLE;
        } else {
            String string = "Not implemented '" + c + "' in " + str;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return objcType;
    }

    @NotNull
    public final ObjcParam parseParam(@NotNull StrReader str) {
        ObjcType type2 = this.parseType(str);
        int offset2 = this.parseInt(str);
        return new ObjcParam(offset2, type2);
    }

    @NotNull
    public final ObjcMethodDesc parse(@NotNull StrReader str) {
        ArrayList out = new ArrayList();
        while (str.getHasMore()) {
            ((Collection)out).add(this.parseParam(str));
        }
        return new ObjcMethodDesc(str.getStr(), out);
    }

    @NotNull
    public final ObjcMethodDesc parse(@NotNull String str) {
        return this.parse(new StrReader(str, 0, 0, 6, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u001a\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\r0 J\u0010\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0005J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lkorlibs/ffi/osx/ObjcTypeParser$StrReader;", "", "str", "", "pos", "", "end", "(Ljava/lang/String;II)V", "getEnd", "()I", "setEnd", "(I)V", "hasMore", "", "getHasMore", "()Z", "getPos", "setPos", "getStr", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "peekChar", "", "readChar", "readUntil", "cond", "Lkotlin/Function1;", "skip", "", "count", "toString", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nFFIObjc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FFIObjc.kt\nkorlibs/ffi/osx/ObjcTypeParser$StrReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n1#2:510\n*E\n"})
    public static final class StrReader {
        @NotNull
        private final String str;
        private int pos;
        private int end;

        public StrReader(@NotNull String str, int pos, int end2) {
            this.str = str;
            this.pos = pos;
            this.end = end2;
        }

        public /* synthetic */ StrReader(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = string.length();
            }
            this(string, n, n2);
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public final boolean getHasMore() {
            return this.pos < this.end;
        }

        public final char peekChar() {
            char c;
            CharSequence charSequence = this.str;
            int n = this.pos;
            if (n >= 0 && n <= StringsKt.getLastIndex(charSequence)) {
                c = charSequence.charAt(n);
            } else {
                int it = n;
                boolean bl = false;
                c = '\u0000';
            }
            return c;
        }

        public final char readChar() {
            char c;
            char it = c = this.peekChar();
            boolean bl = false;
            StrReader.skip$default(this, 0, 1, null);
            return c;
        }

        public final void skip(int count2) {
            this.pos += count2;
        }

        public static /* synthetic */ void skip$default(StrReader strReader, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            strReader.skip(n);
        }

        @NotNull
        public final String readUntil(@NotNull Function1<? super Character, Boolean> cond) {
            char c;
            Object out = "";
            while (cond.invoke(Character.valueOf(c = this.peekChar())).booleanValue()) {
                StrReader.skip$default(this, 0, 1, null);
                out = (String)out + c;
            }
            return out;
        }

        @NotNull
        public final String component1() {
            return this.str;
        }

        public final int component2() {
            return this.pos;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final StrReader copy(@NotNull String str, int pos, int end2) {
            return new StrReader(str, pos, end2);
        }

        public static /* synthetic */ StrReader copy$default(StrReader strReader, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = strReader.str;
            }
            if ((n3 & 2) != 0) {
                n = strReader.pos;
            }
            if ((n3 & 4) != 0) {
                n2 = strReader.end;
            }
            return strReader.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "StrReader(str=" + this.str + ", pos=" + this.pos + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result2 = this.str.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.pos);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StrReader)) {
                return false;
            }
            StrReader strReader = (StrReader)other;
            if (!Intrinsics.areEqual(this.str, strReader.str)) {
                return false;
            }
            if (this.pos != strReader.pos) {
                return false;
            }
            return this.end == strReader.end;
        }
    }
}

