/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics;

import korlibs.math.ClampKt;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.geom.RectangleD;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 82\u00020\u0001:\u00018B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\u0006\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0013\b\u0016\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fB'\b\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\t\u0010,\u001a\u00020\u0011H\u00c6\u0003J\t\u0010-\u001a\u00020\u0011H\u00c6\u0003J\t\u0010.\u001a\u00020\u0011H\u00c6\u0003J\t\u0010/\u001a\u00020\u0011H\u00c6\u0003J.\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003J1\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0011H\u00c6\u0001J\u0013\u00101\u001a\u00020 2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u00020\u0003H\u00d6\u0001J\n\u00104\u001a\u00060\rj\u0002`\u000eJ\u000e\u00105\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ\b\u00106\u001a\u000207H\u0016R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0011\u0010\"\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!R\u0011\u0010#\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001dR\u0011\u0010'\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001d\u00a8\u00069"}, d2={"Lkorlibs/graphics/AGScissor;", "", "x", "", "y", "width", "height", "(IIII)V", "", "(FFFF)V", "", "(DDDD)V", "rect", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "(Lkorlibs/math/geom/RectangleD;)V", "_left", "", "_top", "_right", "_bottom", "(SSSS)V", "get_bottom", "()S", "get_left", "get_right", "get_top", "bottom", "getBottom", "()I", "getHeight", "isNIL", "", "()Z", "isNotNIL", "left", "getLeft", "right", "getRight", "top", "getTop", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toRect", "toRectOrNull", "toString", "", "Companion", "korge"})
@SourceDebugExtension(value={"SMAP\nAGState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AGState.kt\nkorlibs/graphics/AGScissor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,877:1\n1#2:878\n*E\n"})
public final class AGScissor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final short _left;
    private final short _top;
    private final short _right;
    private final short _bottom;
    @NotNull
    private static final AGScissor EMPTY = new AGScissor(0, 0, 0, 0);
    @NotNull
    private static final AGScissor FULL = Companion.fromBounds(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    @NotNull
    private static final AGScissor INVALID = Companion.fromBounds(-32766, -32766, Integer.MAX_VALUE, Integer.MAX_VALUE);
    @NotNull
    private static final AGScissor NIL = Companion.fromBounds(-32767, -32767, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private AGScissor(short _left, short _top, short _right, short _bottom) {
        this._left = _left;
        this._top = _top;
        this._right = _right;
        this._bottom = _bottom;
    }

    public final short get_left() {
        return this._left;
    }

    public final short get_top() {
        return this._top;
    }

    public final short get_right() {
        return this._right;
    }

    public final short get_bottom() {
        return this._bottom;
    }

    public final boolean isNIL() {
        return Intrinsics.areEqual(this, NIL);
    }

    public final boolean isNotNIL() {
        return !this.isNIL();
    }

    public AGScissor(int x, int y, int width2, int height2) {
        this(ClampKt.toShortClamped(x), ClampKt.toShortClamped(y), ClampKt.toShortClamped(x + width2), ClampKt.toShortClamped(y + height2));
    }

    public AGScissor(float x, float y, float width2, float height2) {
        this(ToIntegerConvertersKt.toIntRound(x), ToIntegerConvertersKt.toIntRound(y), ToIntegerConvertersKt.toIntRound(width2), ToIntegerConvertersKt.toIntRound(height2));
    }

    public AGScissor(double x, double y, double width2, double height2) {
        this(ToIntegerConvertersKt.toIntRound(x), ToIntegerConvertersKt.toIntRound(y), ToIntegerConvertersKt.toIntRound(width2), ToIntegerConvertersKt.toIntRound(height2));
    }

    public AGScissor(@NotNull RectangleD rect) {
        this(ToIntegerConvertersKt.toIntRound(rect.getX()), ToIntegerConvertersKt.toIntRound(rect.getY()), ToIntegerConvertersKt.toIntRound(rect.getWidth()), ToIntegerConvertersKt.toIntRound(rect.getHeight()));
    }

    public final int getLeft() {
        return this._left;
    }

    public final int getTop() {
        return this._top;
    }

    public final int getRight() {
        return this._right;
    }

    public final int getBottom() {
        return this._bottom;
    }

    public final int getX() {
        return this.getLeft();
    }

    public final int getY() {
        return this.getTop();
    }

    public final int getWidth() {
        return this.getRight() - this.getLeft();
    }

    public final int getHeight() {
        return this.getBottom() - this.getTop();
    }

    @NotNull
    public final AGScissor copy(int x, int y, int width2, int height2) {
        return new AGScissor(x, y, width2, height2);
    }

    public static /* synthetic */ AGScissor copy$default(AGScissor aGScissor, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = aGScissor.getX();
        }
        if ((n5 & 2) != 0) {
            n2 = aGScissor.getY();
        }
        if ((n5 & 4) != 0) {
            n3 = aGScissor.getWidth();
        }
        if ((n5 & 8) != 0) {
            n4 = aGScissor.getHeight();
        }
        return aGScissor.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        if (Intrinsics.areEqual(this, NIL)) {
            return "null";
        }
        return "Scissor(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @NotNull
    public final RectangleD toRect() {
        return this.isNIL() ? RectangleD.Companion.getNIL() : RectangleD.Companion.invoke(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Nullable
    public final RectangleD toRectOrNull() {
        RectangleD rectangleD;
        RectangleD it = rectangleD = this.toRect();
        boolean bl = false;
        return it.isNotNIL() ? rectangleD : null;
    }

    public final short component1() {
        return this._left;
    }

    public final short component2() {
        return this._top;
    }

    public final short component3() {
        return this._right;
    }

    public final short component4() {
        return this._bottom;
    }

    @NotNull
    public final AGScissor copy(short _left, short _top, short _right, short _bottom) {
        return new AGScissor(_left, _top, _right, _bottom);
    }

    public static /* synthetic */ AGScissor copy$default(AGScissor aGScissor, short s, short s2, short s3, short s4, int n, Object object) {
        if ((n & 1) != 0) {
            s = aGScissor._left;
        }
        if ((n & 2) != 0) {
            s2 = aGScissor._top;
        }
        if ((n & 4) != 0) {
            s3 = aGScissor._right;
        }
        if ((n & 8) != 0) {
            s4 = aGScissor._bottom;
        }
        return aGScissor.copy(s, s2, s3, s4);
    }

    public int hashCode() {
        int result2 = Short.hashCode(this._left);
        result2 = result2 * 31 + Short.hashCode(this._top);
        result2 = result2 * 31 + Short.hashCode(this._right);
        result2 = result2 * 31 + Short.hashCode(this._bottom);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AGScissor)) {
            return false;
        }
        AGScissor aGScissor = (AGScissor)other;
        if (this._left != aGScissor._left) {
            return false;
        }
        if (this._top != aGScissor._top) {
            return false;
        }
        if (this._right != aGScissor._right) {
            return false;
        }
        return this._bottom == aGScissor._bottom;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\u0019\u0010\u0017\u001a\u00020\u00042\u000e\u0010\u0018\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001aH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkorlibs/graphics/AGScissor$Companion;", "", "()V", "EMPTY", "Lkorlibs/graphics/AGScissor;", "getEMPTY", "()Lkorlibs/graphics/AGScissor;", "FULL", "getFULL", "INVALID", "getINVALID", "NIL", "getNIL", "combine", "prev", "next", "fromBounds", "left", "", "top", "right", "bottom", "", "invoke", "rect", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "korge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AGScissor fromBounds(int left, int top, int right, int bottom) {
            return new AGScissor(left, top, right - left, bottom - top);
        }

        @NotNull
        public final AGScissor fromBounds(float left, float top, float right, float bottom) {
            return new AGScissor(left, top, right - left, bottom - top);
        }

        @NotNull
        public final AGScissor getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final AGScissor getFULL() {
            return FULL;
        }

        @NotNull
        public final AGScissor getINVALID() {
            return INVALID;
        }

        @NotNull
        public final AGScissor getNIL() {
            return NIL;
        }

        @NotNull
        public final AGScissor invoke(@Nullable RectangleD rect) {
            if (rect == null) {
                return this.getNIL();
            }
            if (rect.isNIL()) {
                return this.getNIL();
            }
            return new AGScissor(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }

        @NotNull
        public final AGScissor combine(@NotNull AGScissor prev, @NotNull AGScissor next) {
            boolean intersectsY;
            if (Intrinsics.areEqual(prev, this.getNIL())) {
                return next;
            }
            if (Intrinsics.areEqual(next, this.getNIL())) {
                return prev;
            }
            boolean intersectsX = prev.getLeft() <= next.getRight() && prev.getRight() >= next.getLeft();
            boolean bl = intersectsY = prev.getTop() <= next.getBottom() && prev.getBottom() >= next.getTop();
            if (!intersectsX || !intersectsY) {
                return this.getEMPTY();
            }
            int left = Math.max(prev.getLeft(), next.getLeft());
            int top = Math.max(prev.getTop(), next.getTop());
            int right = Math.min(prev.getRight(), next.getRight());
            int bottom = Math.min(prev.getBottom(), next.getBottom());
            return this.fromBounds(left, top, right, bottom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

