/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics;

import korlibs.datastructure.closeable.Closeable;
import korlibs.graphics.AGObject;
import korlibs.graphics.AGTextureTargetKind;
import korlibs.graphics.gl.AGOpenglConvertKt;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.image.bitmap.ForcedTexId;
import korlibs.image.bitmap.MultiBitmap;
import korlibs.logger.Logger;
import korlibs.math.PowerOfTwoKt;
import korlibs.math.geom.slice.RectSlice;
import korlibs.memory.unit.ByteUnits;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000fH\u0002J\u0018\u0010B\u001a\u00020+2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u00108\u001a\u00020+J\b\u0010C\u001a\u00020DH\u0016J7\u0010E\u001a\u00020\u00002\b\u0010A\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u00105\u001a\u00020+2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010FJE\u0010E\u001a\u00020\u00002\u0016\u0010A\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010Gj\u0004\u0018\u0001`H2\b\b\u0002\u00105\u001a\u00020+2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010IR\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0016R\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0017\u0010(\u001a\u00020\u00058F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00101\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b2\u0010\n\"\u0004\b3\u0010\fR$\u00105\u001a\u00020+2\u0006\u00104\u001a\u00020+@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010,\"\u0004\b7\u0010.R\u001a\u00108\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010,\"\u0004\b:\u0010.R\u0019\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010<\u001a\u0004\b;\u0010\u0016R\u0011\u0010=\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006J"}, d2={"Lkorlibs/graphics/AGTexture;", "Lkorlibs/graphics/AGObject;", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "targetKind", "Lkorlibs/graphics/AGTextureTargetKind;", "(ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "baseMipmapLevel", "", "getBaseMipmapLevel", "()Ljava/lang/Integer;", "setBaseMipmapLevel", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "bitmap", "Lkorlibs/image/bitmap/Bitmap;", "getBitmap", "()Lkorlibs/image/bitmap/Bitmap;", "setBitmap", "(Lkorlibs/image/bitmap/Bitmap;)V", "depth", "getDepth", "()I", "estimatedMemoryUsage", "Lkorlibs/memory/unit/ByteUnits;", "getEstimatedMemoryUsage-1QQjfvU", "()D", "setEstimatedMemoryUsage-r9KgFjA", "(D)V", "D", "forcedTexId", "Lkorlibs/image/bitmap/ForcedTexId;", "getForcedTexId", "()Lkorlibs/image/bitmap/ForcedTexId;", "setForcedTexId", "(Lkorlibs/image/bitmap/ForcedTexId;)V", "height", "getHeight", "implForcedTexId", "getImplForcedTexId", "implForcedTexTarget", "getImplForcedTexTarget-8MFrWls", "isFbo", "", "()Z", "setFbo", "(Z)V", "logger", "Lkorlibs/logger/Logger;", "maxMipmapLevel", "getMaxMipmapLevel", "setMaxMipmapLevel", "<set-?>", "mipmaps", "getMipmaps", "setMipmaps$korge", "requestMipmaps", "getRequestMipmaps", "setRequestMipmaps", "getTargetKind-8MFrWls", "I", "width", "getWidth", "checkBitmaps", "", "bmp", "doMipmaps", "toString", "", "upload", "(Lkorlibs/image/bitmap/Bitmap;ZLjava/lang/Integer;Ljava/lang/Integer;)Lkorlibs/graphics/AGTexture;", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/BmpSlice;", "(Lkorlibs/math/geom/slice/RectSlice;ZLjava/lang/Integer;Ljava/lang/Integer;)Lkorlibs/graphics/AGTexture;", "korge"})
@SourceDebugExtension(value={"SMAP\nAGObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AGObjects.kt\nkorlibs/graphics/AGTexture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nkorlibs/logger/Logger\n*L\n1#1,286:1\n1#2:287\n131#3:288\n125#3:289\n*S KotlinDebug\n*F\n+ 1 AGObjects.kt\nkorlibs/graphics/AGTexture\n*L\n167#1:288\n167#1:289\n*E\n"})
public final class AGTexture
extends AGObject
implements Closeable {
    private final int targetKind;
    @NotNull
    private final Logger logger;
    private boolean isFbo;
    private boolean requestMipmaps;
    @Nullable
    private Integer baseMipmapLevel;
    @Nullable
    private Integer maxMipmapLevel;
    @Nullable
    private Bitmap bitmap;
    private boolean mipmaps;
    @Nullable
    private ForcedTexId forcedTexId;
    private double estimatedMemoryUsage;

    private AGTexture(int targetKind) {
        this.targetKind = targetKind;
        this.logger = Logger.Companion.invoke("AGTexture");
        this.estimatedMemoryUsage = ByteUnits.Companion.fromBytes-rDZYvBM(0L);
    }

    public /* synthetic */ AGTexture(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = AGTextureTargetKind.Companion.getTEXTURE_2D-8MFrWls();
        }
        this(n, null);
    }

    public final int getTargetKind-8MFrWls() {
        return this.targetKind;
    }

    public final boolean isFbo() {
        return this.isFbo;
    }

    public final void setFbo(boolean bl) {
        this.isFbo = bl;
    }

    public final boolean getRequestMipmaps() {
        return this.requestMipmaps;
    }

    public final void setRequestMipmaps(boolean bl) {
        this.requestMipmaps = bl;
    }

    @Nullable
    public final Integer getBaseMipmapLevel() {
        return this.baseMipmapLevel;
    }

    public final void setBaseMipmapLevel(@Nullable Integer n) {
        this.baseMipmapLevel = n;
    }

    @Nullable
    public final Integer getMaxMipmapLevel() {
        return this.maxMipmapLevel;
    }

    public final void setMaxMipmapLevel(@Nullable Integer n) {
        this.maxMipmapLevel = n;
    }

    @Nullable
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    public final void setBitmap(@Nullable Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public final boolean getMipmaps() {
        return this.mipmaps;
    }

    public final void setMipmaps$korge(boolean bl) {
        this.mipmaps = bl;
    }

    @Nullable
    public final ForcedTexId getForcedTexId() {
        return this.forcedTexId;
    }

    public final void setForcedTexId(@Nullable ForcedTexId forcedTexId) {
        this.forcedTexId = forcedTexId;
    }

    public final int getImplForcedTexId() {
        ForcedTexId forcedTexId = this.forcedTexId;
        return forcedTexId != null ? forcedTexId.getForcedTexId() : -1;
    }

    public final int getImplForcedTexTarget-8MFrWls() {
        int n;
        ForcedTexId forcedTexId = this.forcedTexId;
        if (forcedTexId != null) {
            int it = forcedTexId.getForcedTexTarget();
            boolean bl = false;
            n = AGOpenglConvertKt.fromGl(AGTextureTargetKind.Companion, it);
        } else {
            n = this.targetKind;
        }
        return n;
    }

    public final double getEstimatedMemoryUsage-1QQjfvU() {
        return this.estimatedMemoryUsage;
    }

    public final void setEstimatedMemoryUsage-r9KgFjA(double d) {
        this.estimatedMemoryUsage = d;
    }

    public final int getWidth() {
        Bitmap bitmap = this.bitmap;
        return bitmap != null ? bitmap.getWidth() : 0;
    }

    public final int getHeight() {
        Bitmap bitmap = this.bitmap;
        return bitmap != null ? bitmap.getHeight() : 0;
    }

    public final int getDepth() {
        Bitmap bitmap = this.bitmap;
        Object object = bitmap instanceof MultiBitmap ? (MultiBitmap)bitmap : null;
        return object != null && (object = ((MultiBitmap)object).getBitmaps()) != null ? object.size() : 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBitmaps(Bitmap bmp2) {
        if (!bmp2.getPremultiplied()) {
            void this_$iv$iv;
            Logger this_$iv = this.logger;
            boolean $i$f$error = false;
            Logger logger2 = this_$iv;
            Logger.Level level$iv$iv = Logger.Level.ERROR;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                Logger.Level level = level$iv$iv;
                void var8_8 = this_$iv$iv;
                boolean bl = false;
                String string = "Trying to upload a non-premultiplied bitmap: " + bmp2 + ". This will cause rendering artifacts";
                var8_8.actualLog(level, string);
            }
        }
    }

    @NotNull
    public final AGTexture upload(@Nullable Bitmap bmp2, boolean mipmaps, @Nullable Integer baseMipmapLevel2, @Nullable Integer maxMipmapLevel2) {
        Bitmap bitmap = bmp2;
        if (bitmap != null) {
            Bitmap it = bitmap;
            boolean bl = false;
            this.checkBitmaps(it);
        }
        this.forcedTexId = bmp2 instanceof ForcedTexId ? (ForcedTexId)((Object)bmp2) : null;
        this.bitmap = bmp2;
        this.estimatedMemoryUsage = ByteUnits.Companion.fromBytes-rDZYvBM(this.getWidth() * this.getHeight() * this.getDepth() * 4);
        this.markAsDirty();
        this.requestMipmaps = mipmaps;
        this.baseMipmapLevel = baseMipmapLevel2;
        this.maxMipmapLevel = maxMipmapLevel2;
        return this;
    }

    public static /* synthetic */ AGTexture upload$default(AGTexture aGTexture, Bitmap bitmap, boolean bl, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return aGTexture.upload(bitmap, bl, n, n2);
    }

    @NotNull
    public final AGTexture upload(@Nullable RectSlice<? extends Bitmap> bmp2, boolean mipmaps, @Nullable Integer baseMipmapLevel2, @Nullable Integer maxMipmapLevel2) {
        RectSlice<? extends Bitmap> rectSlice = bmp2;
        return this.upload(rectSlice != null ? BitmapSliceKt.extract(rectSlice) : null, mipmaps, baseMipmapLevel2, maxMipmapLevel2);
    }

    public static /* synthetic */ AGTexture upload$default(AGTexture aGTexture, RectSlice rectSlice, boolean bl, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return aGTexture.upload(rectSlice, bl, n, n2);
    }

    public final boolean doMipmaps(@Nullable Bitmap bitmap, boolean requestMipmaps) {
        Bitmap bitmap2 = bitmap;
        int width2 = bitmap2 != null ? bitmap2.getWidth() : 0;
        Bitmap bitmap3 = bitmap;
        int height2 = bitmap3 != null ? bitmap3.getHeight() : 0;
        return requestMipmaps && PowerOfTwoKt.isPowerOfTwo(width2) && PowerOfTwoKt.isPowerOfTwo(height2);
    }

    @NotNull
    public String toString() {
        return "AGTexture(size=" + this.getWidth() + "," + this.getHeight() + ")";
    }

    public /* synthetic */ AGTexture(int targetKind, DefaultConstructorMarker $constructor_marker) {
        this(targetKind);
    }
}

