/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import korlibs.datastructure.FastArrayList;
import korlibs.graphics.AGBuffer;
import korlibs.graphics.AGVertexArrayObject;
import korlibs.graphics.AGVertexArrayObjectFlattenerKt;
import korlibs.graphics.AGVertexData;
import korlibs.graphics.shader.Attribute;
import korlibs.graphics.shader.ProgramLayout;
import korlibs.logger.Logger;
import korlibs.memory.Buffer;
import korlibs.memory.BufferKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\t0\u000bj\u0002`\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000e\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"logger", "Lkorlibs/logger/Logger;", "getLogger", "()Lkorlibs/logger/Logger;", "logger$delegate", "Lkotlin/Lazy;", "extractDataOf", "Lkorlibs/graphics/AGBuffer;", "attribute", "Lkorlibs/graphics/shader/Attribute;", "layout", "Lkorlibs/graphics/shader/ProgramLayout;", "Lkorlibs/graphics/shader/VertexLayout;", "flatten", "Lkorlibs/graphics/AGVertexArrayObject;", "offsetOf", "", "korge"})
@SourceDebugExtension(value={"SMAP\nAGVertexArrayObjectFlattener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AGVertexArrayObjectFlattener.kt\nkorlibs/graphics/AGVertexArrayObjectFlattenerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\nkorlibs/logger/Logger\n+ 5 Assert.kt\nkorlibs/io/lang/AssertKt\n*L\n1#1,50:1\n1360#2:51\n1446#2,2:52\n1549#2:54\n1620#2,3:55\n1448#2,3:58\n1#3:61\n143#4:62\n125#4:63\n4#5,2:64\n*S KotlinDebug\n*F\n+ 1 AGVertexArrayObjectFlattener.kt\nkorlibs/graphics/AGVertexArrayObjectFlattenerKt\n*L\n14#1:51\n14#1:52,2\n17#1:54\n17#1:55,3\n14#1:58,3\n35#1:62\n35#1:63\n36#1:64,2\n*E\n"})
public final class AGVertexArrayObjectFlattenerKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(logger.2.INSTANCE);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AGVertexArrayObject flatten(@NotNull AGVertexArrayObject $this$flatten) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$flatten.getList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            AGVertexData vertexData = (AGVertexData)element$iv$iv;
            boolean bl = false;
            if (vertexData.getLayout().getItems().size() == 1) {
                list2 = CollectionsKt.listOf(vertexData);
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = vertexData.getLayout().getItems();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void item2;
                    Attribute attribute = (Attribute)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    AGBuffer aGBuffer = AGVertexArrayObjectFlattenerKt.extractDataOf(vertexData.getBuffer(), (Attribute)item2, vertexData.getLayout());
                    ProgramLayout<void> programLayout = new ProgramLayout<void>(CollectionsKt.listOf(item2));
                    collection.add(new AGVertexData(programLayout, aGBuffer, 0, 4, null));
                }
                list2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        boolean bl3 = false;
        FastArrayList fastArrayList = new FastArrayList(it);
        return new AGVertexArrayObject(fastArrayList, bl3, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final AGBuffer extractDataOf(@NotNull AGBuffer $this$extractDataOf, @NotNull Attribute attribute, @NotNull ProgramLayout<Attribute> layout) {
        Buffer buffer;
        int indexes = $this$extractDataOf.getSizeInBytes() / layout.getTotalSize();
        int offsetOnLayout = AGVertexArrayObjectFlattenerKt.offsetOf(layout, attribute);
        Buffer $this$extractDataOf_u24lambda_u244 = buffer = new Buffer(attribute.getTotalBytes() * indexes, false, 2, null);
        boolean bl = false;
        for (int index2 = 0; index2 < indexes; ++index2) {
            void this_$iv$iv;
            int offset2 = index2 * layout.getTotalSize() + offsetOnLayout;
            int localOffset = index2 * attribute.getTotalBytes();
            Buffer buffer2 = $this$extractDataOf.getMem();
            Intrinsics.checkNotNull(buffer2);
            byte[] data2 = BufferKt.getUnalignedArrayInt8$default(buffer2, offset2, new byte[attribute.getTotalBytes()], 0, 0, 12, null);
            Logger this_$iv = AGVertexArrayObjectFlattenerKt.getLogger();
            boolean $i$f$trace = false;
            Logger logger2 = this_$iv;
            Logger.Level level$iv$iv = Logger.Level.TRACE;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                Logger.Level level = level$iv$iv;
                void var18_19 = this_$iv$iv;
                boolean bl2 = false;
                String string = "extracting data of " + attribute + " from " + data2;
                var18_19.actualLog(level, string);
            }
            boolean cond$iv = data2.length == attribute.getTotalBytes();
            boolean $i$f$assert = false;
            if (!cond$iv) {
                throw new AssertionError();
            }
            BufferKt.setUnalignedArrayInt8$default($this$extractDataOf_u24lambda_u244, localOffset, data2, 0, 0, 12, null);
        }
        Buffer it = buffer;
        boolean bl3 = false;
        return new AGBuffer().upload(it);
    }

    private static final int offsetOf(ProgramLayout<Attribute> $this$offsetOf, Attribute attribute) {
        int offset2 = 0;
        for (Attribute item2 : $this$offsetOf.getItems()) {
            if (Intrinsics.areEqual(item2, attribute)) {
                return offset2;
            }
            offset2 += item2.getTotalBytes();
        }
        throw new IllegalStateException(("attribute " + attribute + " not found in " + $this$offsetOf).toString());
    }
}

