/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics.gl;

import korlibs.graphics.gl.GLBaseObject;
import korlibs.graphics.gl.GLGlobalState;
import korlibs.io.concurrent.atomic.KorAtomicKt;
import korlibs.kgl.KmlGlExtKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lkorlibs/graphics/gl/GLBuffer;", "Lkorlibs/graphics/gl/GLBaseObject;", "state", "Lkorlibs/graphics/gl/GLGlobalState;", "(Lkorlibs/graphics/gl/GLGlobalState;)V", "value", "", "estimatedBytes", "getEstimatedBytes", "()J", "setEstimatedBytes", "(J)V", "id", "", "getId", "()I", "setId", "(I)V", "lastUploadedSize", "getLastUploadedSize$korge", "setLastUploadedSize$korge", "delete", "", "toString", "", "korge"})
public final class GLBuffer
extends GLBaseObject {
    private int id = KmlGlExtKt.genBuffer(this.getGl());
    private int lastUploadedSize = -1;
    private long estimatedBytes;

    public GLBuffer(@NotNull GLGlobalState state2) {
        super(state2);
        KorAtomicKt.incrementAndGet(this.getGlobalState().getBuffersCreated());
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final int getLastUploadedSize$korge() {
        return this.lastUploadedSize;
    }

    public final void setLastUploadedSize$korge(int n) {
        this.lastUploadedSize = n;
    }

    public final long getEstimatedBytes() {
        return this.estimatedBytes;
    }

    public final void setEstimatedBytes(long value) {
        this.getGlobalState().getBuffersSize().addAndGet(value - this.estimatedBytes);
        this.estimatedBytes = value;
    }

    @Override
    public void delete() {
        KorAtomicKt.incrementAndGet(this.getGlobalState().getBuffersDeleted());
        KmlGlExtKt.deleteBuffer(this.getGl(), this.id);
        this.id = -1;
        this.lastUploadedSize = -1;
    }

    @NotNull
    public String toString() {
        return "GLBuffer(" + this.id + ")";
    }
}

