/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics.gl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import korlibs.graphics.gl.AGOpengl;
import korlibs.graphics.gl.GLProgramInfo;
import korlibs.graphics.gl.GLShaderCompilerKt;
import korlibs.graphics.shader.Attribute;
import korlibs.graphics.shader.Program;
import korlibs.graphics.shader.gl.GlslConfig;
import korlibs.graphics.shader.gl.GlslExtKt;
import korlibs.graphics.shader.gl.GlslGenerator;
import korlibs.kgl.KmlGl;
import korlibs.kgl.KmlGlExtKt;
import korlibs.logger.Logger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J@\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010\u0017\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkorlibs/graphics/gl/GLShaderCompiler;", "", "()V", "logger", "Lkorlibs/logger/Logger;", "createShader", "", "gl", "Lkorlibs/kgl/KmlGl;", "type", "str", "", "debugName", "createShaderWithConfigs", "Lkotlin/Triple;", "Lkorlibs/graphics/shader/gl/GlslConfig;", "program", "Lkorlibs/graphics/shader/Program;", "configs", "", "programCreate", "Lkorlibs/graphics/gl/GLProgramInfo;", "config", "replaceVersion", "version", "korge"})
@SourceDebugExtension(value={"SMAP\nGLShaderCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GLShaderCompiler.kt\nkorlibs/graphics/gl/GLShaderCompiler\n+ 2 Logger.kt\nkorlibs/logger/Logger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KmlGl.kt\nkorlibs/kgl/KmlGl\n*L\n1#1,130:1\n143#2:131\n125#2:132\n140#2:138\n125#2:139\n140#2:140\n125#2:141\n1549#3:133\n1620#3,3:134\n1549#3:142\n1620#3,3:143\n354#4:137\n463#4:146\n209#4:147\n*S KotlinDebug\n*F\n+ 1 GLShaderCompiler.kt\nkorlibs/graphics/gl/GLShaderCompiler\n*L\n55#1:131\n55#1:132\n86#1:138\n86#1:139\n92#1:140\n92#1:141\n64#1:133\n64#1:134,3\n99#1:142\n99#1:143,3\n74#1:137\n108#1:146\n110#1:147\n*E\n"})
public final class GLShaderCompiler {
    @NotNull
    public static final GLShaderCompiler INSTANCE = new GLShaderCompiler();
    @NotNull
    private static final Logger logger = Logger.Companion.invoke("GLShaderCompiler");

    private GLShaderCompiler() {
    }

    private final String replaceVersion(String $this$replaceVersion, int version) {
        return StringsKt.replace$default($this$replaceVersion, "#version 100", "#version " + version, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GLProgramInfo programCreate(@NotNull KmlGl gl2, @NotNull GlslConfig config2, @NotNull Program program, @Nullable String debugName) {
        Collection<GlslConfig> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        GLShaderCompiler gLShaderCompiler;
        Object object2;
        Logger.Level level$iv$iv;
        int usedGlSlVersion;
        int id2 = gl2.createProgram();
        int guessedGlSlVersion = GLShaderCompilerKt.getVersionInt(gl2);
        Integer n = GlslGenerator.Companion.getFORCE_GLSL_VERSION();
        int n2 = usedGlSlVersion = n != null ? n : guessedGlSlVersion;
        if (GlslGenerator.Companion.getDEBUG_GLSL()) {
            void this_$iv$iv;
            Logger this_$iv = logger;
            boolean $i$f$trace = false;
            Logger logger2 = this_$iv;
            level$iv$iv = Logger.Level.TRACE;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                object2 = level$iv$iv;
                gLShaderCompiler = this_$iv$iv;
                boolean bl = false;
                object = "GLSL version: usedGlSlVersion=" + usedGlSlVersion + ", guessed=" + guessedGlSlVersion + ", forced=" + GlslGenerator.Companion.getFORCE_GLSL_VERSION() + ". used=" + usedGlSlVersion;
                ((Logger)((Object)gLShaderCompiler)).actualLog((Logger.Level)((Object)object2), object);
            }
        }
        Object $i$f$trace = new Boolean[]{false, true};
        $i$f$trace = CollectionsKt.listOf($i$f$trace);
        String string = debugName;
        object = program;
        object2 = gl2;
        gLShaderCompiler = this;
        boolean $i$f$map = false;
        level$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void compat;
            boolean bl = (Boolean)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(GlslConfig.copy-QpwQa9Y$default(config2, 0, null, usedGlSlVersion, (boolean)compat, 3, null));
        }
        collection = (List)destination$iv$iv;
        Triple<Integer, Integer, GlslConfig> triple = gLShaderCompiler.createShaderWithConfigs((KmlGl)object2, (Program)object, string, (List<GlslConfig>)collection);
        int fragmentShaderId = ((Number)triple.component1()).intValue();
        int vertexShaderId = ((Number)triple.component2()).intValue();
        GlslConfig finalConfig = triple.component3();
        for (Attribute attr : program.getAttributes()) {
            int location = attr.getFixedLocation();
            gl2.bindAttribLocation(id2, location, attr.getName());
        }
        gl2.attachShader(id2, fragmentShaderId);
        gl2.attachShader(id2, vertexShaderId);
        gl2.linkProgram(id2);
        KmlGl this_$iv = gl2;
        boolean $i$f$getLINK_STATUS = false;
        int linkStatus = KmlGlExtKt.getProgramiv(gl2, id2, 35714);
        return new GLProgramInfo(id2, vertexShaderId, fragmentShaderId, program.getUniformBlocks(), finalConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<Integer, Integer, GlslConfig> createShaderWithConfigs(@NotNull KmlGl gl2, @NotNull Program program, @Nullable String debugName, @NotNull List<GlslConfig> configs) {
        void $this$mapTo$iv$iv;
        Object object;
        ArrayList errors = new ArrayList();
        for (GlslConfig config2 : configs) {
            void var18_22;
            Logger.Level level;
            try {
                void this_$iv$iv;
                String fragmentString = GlslExtKt.toNewGlslString(program.getFragment(), config2);
                String vertexString = GlslExtKt.toNewGlslString(program.getVertex(), config2);
                int fragmentShaderId = this.createShader(gl2, 35632, fragmentString, debugName);
                int vertexShaderId = this.createShader(gl2, 35633, vertexString, debugName);
                Logger this_$iv = logger;
                boolean $i$f$debug = false;
                Logger logger2 = this_$iv;
                Logger.Level level$iv$iv = Logger.Level.DEBUG;
                boolean $i$f$log = false;
                if (this_$iv$iv.isEnabled(level$iv$iv)) {
                    level = level$iv$iv;
                    var18_22 = this_$iv$iv;
                    boolean bl = false;
                    object = "!!! PROGRAM SUCCESSFULLY COMPILED: config=" + config2 + "\n" + vertexString + "\n" + fragmentString;
                    var18_22.actualLog(level, object);
                }
                return new Triple<Integer, Integer, GlslConfig>(fragmentShaderId, vertexShaderId, config2);
            }
            catch (AGOpengl.ShaderException e) {
                void this_$iv$iv;
                Logger this_$iv = logger;
                boolean $i$f$debug = false;
                Logger vertexShaderId = this_$iv;
                Logger.Level level$iv$iv = Logger.Level.DEBUG;
                boolean $i$f$log = false;
                if (this_$iv$iv.isEnabled(level$iv$iv)) {
                    level = level$iv$iv;
                    var18_22 = this_$iv$iv;
                    boolean bl = false;
                    object = ExceptionsKt.stackTraceToString(e);
                    var18_22.actualLog(level, object);
                }
                ((Collection)errors).add(e);
            }
        }
        Iterable $this$map$iv = errors;
        boolean $i$f$map = false;
        Iterable e = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Throwable $i$f$log = (Throwable)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getMessage());
        }
        Throwable throwable = (Throwable)CollectionsKt.last(errors);
        String string = "Tried several shaders: " + (List)destination$iv$iv;
        throw new Exception(string, throwable);
    }

    private final int createShader(KmlGl gl2, int type2, String str, String debugName) {
        int shaderId = gl2.createShader(type2);
        gl2.shaderSource(shaderId, str);
        gl2.compileShader(shaderId);
        KmlGl this_$iv = gl2;
        boolean $i$f$getCOMPILE_STATUS = false;
        int out = KmlGlExtKt.getShaderiv(gl2, shaderId, 35713);
        int errorInt = gl2.getError();
        KmlGl this_$iv2 = gl2;
        boolean $i$f$getGTRUE = false;
        if (out != 1) {
            String error = KmlGlExtKt.getShaderInfoLog(gl2, shaderId);
            throw new AGOpengl.ShaderException(str, error, errorInt, gl2, debugName, type2, out);
        }
        return shaderId;
    }
}

