/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics.gl;

import korlibs.graphics.gl.GLBaseObject;
import korlibs.graphics.gl.GLGlobalState;
import korlibs.io.concurrent.atomic.KorAtomicKt;
import korlibs.kgl.KmlGlExtKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\n\u00a8\u0006\u001a"}, d2={"Lkorlibs/graphics/gl/GLTexture;", "Lkorlibs/graphics/gl/GLBaseObject;", "state", "Lkorlibs/graphics/gl/GLGlobalState;", "(Lkorlibs/graphics/gl/GLGlobalState;)V", "cachedAGContextVersion", "", "getCachedAGContextVersion", "()I", "setCachedAGContextVersion", "(I)V", "cachedContentVersion", "getCachedContentVersion", "setCachedContentVersion", "value", "", "estimatedBytes", "getEstimatedBytes", "()J", "setEstimatedBytes", "(J)V", "id", "getId", "setId", "delete", "", "korge"})
public final class GLTexture
extends GLBaseObject {
    private int id = KmlGlExtKt.genTexture(this.getGl());
    private int cachedContentVersion = -2;
    private int cachedAGContextVersion = -2;
    private long estimatedBytes;

    public GLTexture(@NotNull GLGlobalState state2) {
        super(state2);
        KorAtomicKt.incrementAndGet(this.getGlobalState().getTexturesCreated());
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final int getCachedContentVersion() {
        return this.cachedContentVersion;
    }

    public final void setCachedContentVersion(int n) {
        this.cachedContentVersion = n;
    }

    public final int getCachedAGContextVersion() {
        return this.cachedAGContextVersion;
    }

    public final void setCachedAGContextVersion(int n) {
        this.cachedAGContextVersion = n;
    }

    public final long getEstimatedBytes() {
        return this.estimatedBytes;
    }

    public final void setEstimatedBytes(long value) {
        this.getGlobalState().getTexturesSize().addAndGet(value - this.estimatedBytes);
        this.estimatedBytes = value;
    }

    @Override
    public void delete() {
        KorAtomicKt.incrementAndGet(this.getGlobalState().getTexturesDeleted());
        KmlGlExtKt.deleteTexture(this.getGl(), this.id);
        this.id = -1;
    }
}

