/*
 * Decompiled with CFR 0.152.
 */
package korlibs.graphics.shader.gl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import korlibs.graphics.shader.Attribute;
import korlibs.graphics.shader.FuncDecl;
import korlibs.graphics.shader.Output;
import korlibs.graphics.shader.Precision;
import korlibs.graphics.shader.Program;
import korlibs.graphics.shader.Sampler;
import korlibs.graphics.shader.Shader;
import korlibs.graphics.shader.ShaderType;
import korlibs.graphics.shader.Temp;
import korlibs.graphics.shader.TypedUniform;
import korlibs.graphics.shader.Uniform;
import korlibs.graphics.shader.UniformBlock;
import korlibs.graphics.shader.VarType;
import korlibs.graphics.shader.Variable;
import korlibs.graphics.shader.Varying;
import korlibs.graphics.shader.gl.BaseGlslGenerator;
import korlibs.graphics.shader.gl.GLVariant;
import korlibs.graphics.shader.gl.GlobalsProgramVisitor;
import korlibs.graphics.shader.gl.GlslBodyGenerator;
import korlibs.graphics.shader.gl.GlslConfig;
import korlibs.io.util.Indenter;
import korlibs.logger.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lkorlibs/graphics/shader/gl/GlslGenerator;", "Lkorlibs/graphics/shader/gl/BaseGlslGenerator;", "kind", "Lkorlibs/graphics/shader/ShaderType;", "config", "Lkorlibs/graphics/shader/gl/GlslConfig;", "(Lkorlibs/graphics/shader/ShaderType;Lkorlibs/graphics/shader/gl/GlslConfig;)V", "compatibility", "", "getCompatibility", "()Z", "getConfig", "()Lkorlibs/graphics/shader/gl/GlslConfig;", "getKind", "()Lkorlibs/graphics/shader/ShaderType;", "generate", "", "root", "Lkorlibs/graphics/shader/Program$Stm;", "funcs", "", "Lkorlibs/graphics/shader/FuncDecl;", "Lkorlibs/graphics/shader/Shader;", "generateResult", "Lkorlibs/graphics/shader/gl/GlslGenerator$Result;", "shader", "Companion", "Result", "korge"})
@SourceDebugExtension(value={"SMAP\nGlslGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlslGenerator.kt\nkorlibs/graphics/shader/gl/GlslGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\nkorlibs/logger/Logger\n*L\n1#1,413:1\n766#2:414\n857#2,2:415\n1655#2,8:417\n137#3:425\n125#3:426\n140#3:427\n125#3:428\n*S KotlinDebug\n*F\n+ 1 GlslGenerator.kt\nkorlibs/graphics/shader/gl/GlslGenerator\n*L\n129#1:414\n129#1:415,2\n129#1:417,8\n216#1:425\n216#1:426\n217#1:427\n217#1:428\n*E\n"})
public final class GlslGenerator
implements BaseGlslGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShaderType kind;
    @NotNull
    private final GlslConfig config;
    @NotNull
    private static final Logger logger = Logger.Companion.invoke("GlslGenerator");

    public GlslGenerator(@NotNull ShaderType kind2, @NotNull GlslConfig config2) {
        this.kind = kind2;
        this.config = config2;
    }

    @NotNull
    public final ShaderType getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public GlslConfig getConfig() {
        return this.config;
    }

    public final boolean getCompatibility() {
        return this.getConfig().getCompatibility();
    }

    @NotNull
    public final Result generateResult(@NotNull Shader shader) {
        return this.generateResult(shader.getStm(), shader.getFunctions());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result generateResult(@NotNull Program.Stm root, @NotNull List<FuncDecl> funcs2) {
        void $this$filterTo$iv$iv;
        GlobalsProgramVisitor types2 = new GlobalsProgramVisitor();
        if (this.kind == ShaderType.FRAGMENT && this.getConfig().getNewGlSlVersion()) {
            types2.getVaryings().add(new Varying(this.getConfig().getGl_FragColor(), VarType.Float4, null, 4, null));
        }
        FuncDecl mainFunc = new FuncDecl("main", VarType.TVOID, CollectionsKt.emptyList(), root);
        types2.visit(mainFunc);
        Iterable $this$filter$iv = funcs2;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FuncDecl it = (FuncDecl)element$iv$iv;
            boolean bl = false;
            if (!types2.getFuncRefs().contains(it.getRef().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$distinctBy$iv = CollectionsKt.reversed((List)destination$iv$iv);
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        Iterator $i$f$filterTo22 = $this$distinctBy$iv.iterator();
        while ($i$f$filterTo22.hasNext()) {
            Object e$iv = $i$f$filterTo22.next();
            FuncDecl it = (FuncDecl)e$iv;
            boolean bl2 = false;
            String key$iv = it.getRef().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List customFuncs = list$iv;
        for (FuncDecl func2 : funcs2) {
            types2.visit(mainFunc);
        }
        List<FuncDecl> allFuncs = CollectionsKt.plus((Collection)customFuncs, (Iterable)CollectionsKt.listOf(mainFunc));
        Object it = object = Indenter.Companion.invoke((Function1<? super Indenter, Unit>)new Function1<Indenter, Unit>(this, types2, allFuncs){
            final /* synthetic */ GlslGenerator this$0;
            final /* synthetic */ GlobalsProgramVisitor $types;
            final /* synthetic */ List<FuncDecl> $allFuncs;
            {
                this.this$0 = $receiver;
                this.$types = $types;
                this.$allFuncs = $allFuncs;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Indenter $this$invoke) {
                Object INOUT;
                Object layout;
                if (!this.this$0.getConfig().getCompatibility()) {
                    String suffix = GLVariant.isES-impl(this.this$0.getConfig().getVariant-4m8tqFw()) ? " es" : "";
                    $this$invoke.line("#version " + this.this$0.getConfig().getGlslVersion() + suffix);
                }
                if (this.this$0.getKind() == ShaderType.FRAGMENT) {
                    $this$invoke.line("#extension GL_OES_standard_derivatives : enable");
                }
                $this$invoke.line("#ifdef GL_ES");
                $this$invoke.line("precision mediump float;");
                $this$invoke.line("#endif");
                for (Attribute attribute : this.$types.getAttributes()) {
                    layout = this.this$0.getConfig().getNewGlSlVersion() && this.this$0.getConfig().getGlslVersion() >= 410 ? "layout(location = " + attribute.getFixedLocation() + ") " : "";
                    String string = this.this$0.getIN();
                    String string2 = this.this$0.precToString(attribute.getPrecision());
                    String string3 = this.this$0.typeToString(attribute.getType());
                    String string4 = attribute.getName();
                    Intrinsics.checkNotNull(attribute);
                    $this$invoke.line((String)layout + string + " " + string2 + string3 + " " + string4 + this.this$0.getArrayDecl(attribute) + ";");
                }
                for (Sampler sampler : this.$types.getSamplers()) {
                    layout = this.this$0.getConfig().getNewGlSlVersion() ? "" : "";
                    String string = this.this$0.getUNIFORM();
                    String string5 = this.this$0.precToString(sampler.getPrecision());
                    String string6 = this.this$0.typeToString(sampler.getType());
                    String string7 = sampler.getName();
                    Intrinsics.checkNotNull(sampler);
                    $this$invoke.line((String)layout + string + " " + string5 + string6 + " " + string7 + this.this$0.getArrayDecl(sampler) + ";");
                }
                if (this.this$0.getConfig().getUseUniformBlocks()) {
                    for (UniformBlock uniformBlock : this.$types.getUniformBlocks()) {
                        $this$invoke.line("layout(std140) uniform " + uniformBlock.getName() + " {");
                        for (TypedUniform typedUniform : uniformBlock.getUniforms()) {
                            $this$invoke.line("  " + this.this$0.precToString(typedUniform.getPrecision()) + this.this$0.typeToString(typedUniform.getType()) + " " + typedUniform.getName() + this.this$0.getArrayDecl(typedUniform) + ";");
                        }
                        $this$invoke.line("};");
                    }
                } else {
                    for (Uniform uniform2 : this.$types.getUniforms()) {
                        String string = this.this$0.getUNIFORM();
                        String string8 = this.this$0.precToString(uniform2.getPrecision());
                        String string9 = this.this$0.typeToString(uniform2.getType());
                        String string10 = uniform2.getName();
                        Intrinsics.checkNotNull(uniform2);
                        $this$invoke.line(string + " " + string8 + string9 + " " + string10 + this.this$0.getArrayDecl(uniform2) + ";");
                    }
                }
                Iterable iterable = this.$types.getVaryings();
                boolean $i$f$sortedBy = false;
                Iterator<Object> iterator2 = CollectionsKt.sortedWith(iterable, new Comparator(){

                    public final int compare(T a, T b) {
                        Varying it = (Varying)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (Varying)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                    }
                }).iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    void var3_13;
                    void index2 = var3_13++;
                    Varying varying = (Varying)iterator2.next();
                    if (varying instanceof Output) continue;
                    INOUT = !this.this$0.getConfig().getNewGlSlVersion() ? this.this$0.getOUT() : (Intrinsics.areEqual(varying.getName(), this.this$0.getConfig().getGl_FragColor()) && this.this$0.getKind() == ShaderType.FRAGMENT ? this.this$0.getOUT() : (this.this$0.getKind() == ShaderType.VERTEX ? this.this$0.getOUT() : this.this$0.getIN()));
                    $this$invoke.line((String)INOUT + " " + this.this$0.precToString(varying.getPrecision()) + this.this$0.typeToString(varying.getType()) + " " + varying.getName() + ";");
                }
                for (FuncDecl funcDecl : this.$allFuncs) {
                    void str$iv;
                    void this_$iv;
                    void $this$mapTo$iv$iv;
                    Indenter $this$map$iv;
                    GlslBodyGenerator gen = new GlslBodyGenerator(this.this$0.getKind(), this.this$0.getConfig());
                    gen.visit(funcDecl);
                    INOUT = funcDecl.getArgs();
                    Object object = this.this$0;
                    boolean $i$f$map = false;
                    void var9_28 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(((GlslGenerator)object).typeToString((VarType)((Object)it.getSecond())) + " " + it.getFirst());
                    }
                    List list2 = (List)destination$iv$iv;
                    $this$map$iv = $this$invoke;
                    object = this.this$0.typeToString(funcDecl.getRettype()) + " " + funcDecl.getName() + "(" + CollectionsKt.joinToString$default(list2, ", ", null, null, 0, null, null, 62, null) + ")";
                    GlslGenerator glslGenerator = this.this$0;
                    boolean $i$f$line = false;
                    this_$iv.line((String)(((CharSequence)str$iv).length() == 0 ? "{" : (String)str$iv + " {"));
                    void this_$iv$iv = this_$iv;
                    boolean $i$f$indent = false;
                    this_$iv$iv._indent();
                    try {
                        boolean bl3 = false;
                        for (Temp temp : gen.getTemps()) {
                            $this$invoke.line(glslGenerator.precToString(temp.getPrecision()) + glslGenerator.typeToString(temp.getType()) + " " + temp.getName() + ";");
                        }
                        $this$invoke.line(gen.getProgramIndenter());
                    }
                    finally {
                        this_$iv$iv._unindent();
                    }
                    this_$iv.line("}");
                }
            }
        }).toString();
        boolean bl = false;
        if (GlslConfig.Companion.getDEBUG_GLSL()) {
            String string;
            Logger logger2;
            Logger.Level level;
            Logger this_$iv$iv;
            Logger this_$iv = logger;
            boolean $i$f$info = false;
            Logger bl2 = this_$iv;
            Logger.Level level$iv$iv = Logger.Level.INFO;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                level = level$iv$iv;
                logger2 = this_$iv$iv;
                boolean bl3 = false;
                string = "GlSlGenerator.version: " + this.getConfig().getGlslVersion();
                logger2.actualLog(level, string);
            }
            this_$iv = logger;
            boolean $i$f$debug = false;
            this_$iv$iv = this_$iv;
            level$iv$iv = Logger.Level.DEBUG;
            $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                level = level$iv$iv;
                logger2 = this_$iv$iv;
                boolean bl4 = false;
                string = "GlSlGenerator:\n" + (String)it;
                logger2.actualLog(level, string);
            }
        }
        Object result2 = object;
        return new Result(this, (String)(root instanceof Program.Stm.Raw ? Program.Stm.Raw.string$default((Program.Stm.Raw)root, GlslConfig.Companion.getNAME(), null, 2, null) : result2), CollectionsKt.toList((Iterable)types2.getAttributes()), CollectionsKt.toList((Iterable)types2.getUniforms()), CollectionsKt.toList((Iterable)types2.getVaryings()));
    }

    @NotNull
    public final String generate(@NotNull Program.Stm root, @NotNull List<FuncDecl> funcs2) {
        return this.generateResult(root, funcs2).getResult();
    }

    @NotNull
    public final String generate(@NotNull Shader root) {
        return this.generate(root.getStm(), root.getFunctions());
    }

    @Override
    @NotNull
    public String precToString(@NotNull Precision prec) {
        return BaseGlslGenerator.DefaultImpls.precToString(this, prec);
    }

    @Override
    @NotNull
    public String typeToString(@NotNull VarType type2) {
        return BaseGlslGenerator.DefaultImpls.typeToString(this, type2);
    }

    @Override
    @NotNull
    public String getArrayDecl(@NotNull Variable $this$arrayDecl) {
        return BaseGlslGenerator.DefaultImpls.getArrayDecl(this, $this$arrayDecl);
    }

    @Override
    @NotNull
    public String getIN() {
        return BaseGlslGenerator.DefaultImpls.getIN(this);
    }

    @Override
    @NotNull
    public String getOUT() {
        return BaseGlslGenerator.DefaultImpls.getOUT(this);
    }

    @Override
    @NotNull
    public String getUNIFORM() {
        return BaseGlslGenerator.DefaultImpls.getUNIFORM(this);
    }

    @Override
    @NotNull
    public String getGl_FragColor() {
        return BaseGlslGenerator.DefaultImpls.getGl_FragColor(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkorlibs/graphics/shader/gl/GlslGenerator$Companion;", "", "()V", "DEBUG_GLSL", "", "getDEBUG_GLSL", "()Z", "DEFAULT_VERSION", "", "getDEFAULT_VERSION", "()I", "FORCE_GLSL_VERSION", "getFORCE_GLSL_VERSION", "()Ljava/lang/Integer;", "NAME", "", "getNAME", "()Ljava/lang/String;", "logger", "Lkorlibs/logger/Logger;", "korge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return GlslConfig.Companion.getNAME();
        }

        public final int getDEFAULT_VERSION() {
            return GlslConfig.Companion.getDEFAULT_VERSION();
        }

        @Nullable
        public final Integer getFORCE_GLSL_VERSION() {
            return GlslConfig.Companion.getFORCE_GLSL_VERSION();
        }

        public final boolean getDEBUG_GLSL() {
            return GlslConfig.Companion.getDEBUG_GLSL();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0003JM\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\""}, d2={"Lkorlibs/graphics/shader/gl/GlslGenerator$Result;", "", "generator", "Lkorlibs/graphics/shader/gl/GlslGenerator;", "result", "", "attributes", "", "Lkorlibs/graphics/shader/Attribute;", "uniforms", "Lkorlibs/graphics/shader/Uniform;", "varyings", "Lkorlibs/graphics/shader/Varying;", "(Lkorlibs/graphics/shader/gl/GlslGenerator;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAttributes", "()Ljava/util/List;", "getGenerator", "()Lkorlibs/graphics/shader/gl/GlslGenerator;", "getResult", "()Ljava/lang/String;", "getUniforms", "getVaryings", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "korge"})
    public static final class Result {
        @NotNull
        private final GlslGenerator generator;
        @NotNull
        private final String result;
        @NotNull
        private final List<Attribute> attributes;
        @NotNull
        private final List<Uniform> uniforms;
        @NotNull
        private final List<Varying> varyings;

        public Result(@NotNull GlslGenerator generator2, @NotNull String result2, @NotNull List<? extends Attribute> attributes, @NotNull List<? extends Uniform> uniforms, @NotNull List<? extends Varying> varyings) {
            this.generator = generator2;
            this.result = result2;
            this.attributes = attributes;
            this.uniforms = uniforms;
            this.varyings = varyings;
        }

        @NotNull
        public final GlslGenerator getGenerator() {
            return this.generator;
        }

        @NotNull
        public final String getResult() {
            return this.result;
        }

        @NotNull
        public final List<Attribute> getAttributes() {
            return this.attributes;
        }

        @NotNull
        public final List<Uniform> getUniforms() {
            return this.uniforms;
        }

        @NotNull
        public final List<Varying> getVaryings() {
            return this.varyings;
        }

        @NotNull
        public final GlslGenerator component1() {
            return this.generator;
        }

        @NotNull
        public final String component2() {
            return this.result;
        }

        @NotNull
        public final List<Attribute> component3() {
            return this.attributes;
        }

        @NotNull
        public final List<Uniform> component4() {
            return this.uniforms;
        }

        @NotNull
        public final List<Varying> component5() {
            return this.varyings;
        }

        @NotNull
        public final Result copy(@NotNull GlslGenerator generator2, @NotNull String result2, @NotNull List<? extends Attribute> attributes, @NotNull List<? extends Uniform> uniforms, @NotNull List<? extends Varying> varyings) {
            return new Result(generator2, result2, attributes, uniforms, varyings);
        }

        public static /* synthetic */ Result copy$default(Result result2, GlslGenerator glslGenerator, String string, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                glslGenerator = result2.generator;
            }
            if ((n & 2) != 0) {
                string = result2.result;
            }
            if ((n & 4) != 0) {
                list2 = result2.attributes;
            }
            if ((n & 8) != 0) {
                list3 = result2.uniforms;
            }
            if ((n & 0x10) != 0) {
                list4 = result2.varyings;
            }
            return result2.copy(glslGenerator, string, list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "Result(generator=" + this.generator + ", result=" + this.result + ", attributes=" + this.attributes + ", uniforms=" + this.uniforms + ", varyings=" + this.varyings + ")";
        }

        public int hashCode() {
            int result2 = this.generator.hashCode();
            result2 = result2 * 31 + this.result.hashCode();
            result2 = result2 * 31 + ((Object)this.attributes).hashCode();
            result2 = result2 * 31 + ((Object)this.uniforms).hashCode();
            result2 = result2 * 31 + ((Object)this.varyings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.generator, result2.generator)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.result, result2.result)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.attributes, result2.attributes)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.uniforms, result2.uniforms)) {
                return false;
            }
            return Intrinsics.areEqual(this.varyings, result2.varyings);
        }
    }
}

