/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.image.atlas.AtlasInfo;
import korlibs.image.atlas.AtlasLookup;
import korlibs.image.bitmap.Bitmap;
import korlibs.math.geom.slice.RectSlice;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u001eB%\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u00050\n\u00a2\u0006\u0002\u0010\u000bB/\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u00050\r\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001c\u001a\b\u0018\u00010\u0011R\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000eH\u0016R\u001b\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0011R\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u0011R\u00020\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0002\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR)\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\u0002`\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lkorlibs/image/atlas/Atlas;", "Lkorlibs/image/atlas/AtlasLookup;", "texture", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/Bitmap;", "Lkorlibs/image/bitmap/BmpSlice;", "info", "Lkorlibs/image/atlas/AtlasInfo;", "(Lkorlibs/math/geom/slice/RectSlice;Lkorlibs/image/atlas/AtlasInfo;)V", "slices", "", "(Ljava/util/List;)V", "textures", "", "", "(Ljava/util/Map;Lkorlibs/image/atlas/AtlasInfo;)V", "entries", "Lkorlibs/image/atlas/Atlas$Entry;", "getEntries", "()Ljava/util/List;", "entriesMap", "getEntriesMap", "()Ljava/util/Map;", "getInfo", "()Lkorlibs/image/atlas/AtlasInfo;", "getTexture", "()Lkorlibs/math/geom/slice/RectSlice;", "getTextures", "tryGetEntryByName", "name", "Entry", "korge-core"})
@SourceDebugExtension(value={"SMAP\nAtlas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Atlas.kt\nkorlibs/image/atlas/Atlas\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1360#2:58\n1446#2,2:59\n1549#2:61\n1620#2,3:62\n1448#2,3:65\n1194#2,2:68\n1222#2,4:70\n1559#2:74\n1590#2,3:75\n1593#2:79\n1#3:78\n*S KotlinDebug\n*F\n+ 1 Atlas.kt\nkorlibs/image/atlas/Atlas\n*L\n23#1:58\n23#1:59,2\n24#1:61\n24#1:62,3\n23#1:65,3\n28#1:68,2\n28#1:70,4\n10#1:74\n10#1:75,3\n10#1:79\n*E\n"})
public final class Atlas
implements AtlasLookup {
    @NotNull
    private final Map<String, RectSlice<? extends Bitmap>> textures;
    @NotNull
    private final AtlasInfo info;
    @NotNull
    private final List<Entry> entries;
    @NotNull
    private final Map<String, Entry> entriesMap;

    /*
     * WARNING - void declaration
     */
    public Atlas(@NotNull Map<String, ? extends RectSlice<? extends Bitmap>> textures2, @NotNull AtlasInfo info2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        this.textures = textures2;
        this.info = info2;
        Iterable iterable = this.info.getPages();
        Atlas atlas = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            AtlasInfo.Page page = (AtlasInfo.Page)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = page.getRegions();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void frame2;
                AtlasInfo.Region region = (AtlasInfo.Region)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new Entry((AtlasInfo.Region)frame2, page));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        atlas.entries = (List)destination$iv$iv;
        $this$flatMap$iv = this.entries;
        atlas = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entry bl = (Entry)element$iv$iv;
            Map map2 = destination$iv$iv3;
            boolean bl3 = false;
            map2.put(it.getFilename(), element$iv$iv);
        }
        atlas.entriesMap = destination$iv$iv3;
    }

    public /* synthetic */ Atlas(Map map2, AtlasInfo atlasInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            atlasInfo = new AtlasInfo(null, null, 3, null);
        }
        this(map2, atlasInfo);
    }

    @NotNull
    public final Map<String, RectSlice<? extends Bitmap>> getTextures() {
        return this.textures;
    }

    @NotNull
    public final AtlasInfo getInfo() {
        return this.info;
    }

    public Atlas(@NotNull RectSlice<? extends Bitmap> texture, @NotNull AtlasInfo info2) {
        this(MapsKt.mapOf(TuplesKt.to(CollectionsKt.first(info2.getPages()).getFileName(), texture)), info2);
    }

    public /* synthetic */ Atlas(RectSlice rectSlice, AtlasInfo atlasInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            atlasInfo = new AtlasInfo(null, null, 3, null);
        }
        this(rectSlice, atlasInfo);
    }

    /*
     * WARNING - void declaration
     */
    public Atlas(@NotNull List<? extends RectSlice<? extends Bitmap>> slices) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Iterable iterable = slices;
        Atlas atlas = this;
        boolean $i$f$mapIndexed = false;
        void var4_5 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void bmp2;
            String string;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RectSlice rectSlice = (RectSlice)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String it = string = bmp2.getName();
            boolean bl2 = false;
            String string2 = !Intrinsics.areEqual(it, "unknown") ? string : null;
            if (string2 == null) {
                void index2;
                string2 = String.valueOf((int)index2);
            }
            collection.add(TuplesKt.to(string2, bmp2));
        }
        atlas(MapsKt.toMap((List)destination$iv$iv), null, 2, null);
    }

    @NotNull
    public final RectSlice<? extends Bitmap> getTexture() {
        return (RectSlice)CollectionsKt.first((Iterable)this.textures.values());
    }

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    @NotNull
    public final Map<String, Entry> getEntriesMap() {
        return this.entriesMap;
    }

    @Override
    @Nullable
    public Entry tryGetEntryByName(@NotNull String name2) {
        return this.entriesMap.get(name2);
    }

    @Override
    @Nullable
    public RectSlice<? extends Bitmap> tryGet(@NotNull String name2) {
        return AtlasLookup.DefaultImpls.tryGet(this, name2);
    }

    @Override
    @NotNull
    public RectSlice<? extends Bitmap> get(@NotNull String name2) {
        return AtlasLookup.DefaultImpls.get(this, name2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lkorlibs/image/atlas/Atlas$Entry;", "", "info", "Lkorlibs/image/atlas/AtlasInfo$Region;", "page", "Lkorlibs/image/atlas/AtlasInfo$Page;", "(Lkorlibs/image/atlas/Atlas;Lkorlibs/image/atlas/AtlasInfo$Region;Lkorlibs/image/atlas/AtlasInfo$Page;)V", "filename", "", "getFilename", "()Ljava/lang/String;", "getInfo", "()Lkorlibs/image/atlas/AtlasInfo$Region;", "name", "getName", "getPage", "()Lkorlibs/image/atlas/AtlasInfo$Page;", "slice", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/Bitmap;", "getSlice", "()Lkorlibs/math/geom/slice/RectSlice;", "texture", "getTexture", "korge-core"})
    public final class Entry {
        @NotNull
        private final AtlasInfo.Region info;
        @NotNull
        private final AtlasInfo.Page page;
        @NotNull
        private final RectSlice<? extends Bitmap> texture;
        @NotNull
        private final RectSlice<? extends Bitmap> slice;

        public Entry(@NotNull AtlasInfo.Region info2, AtlasInfo.Page page) {
            this.info = info2;
            this.page = page;
            RectSlice<? extends Bitmap> rectSlice = Atlas.this.getTextures().get(this.page.getFileName());
            if (rectSlice == null) {
                throw new IllegalStateException(("Can't find '" + this.page.getFileName() + "' in " + Atlas.this.getTextures().keySet()).toString());
            }
            this.texture = rectSlice;
            this.slice = RectSlice.slice-EjYV8UY$default(this.texture, this.info.getFrame(), this.info.getName(), false, this.info.getImageOrientation-ycZQbMY(), 4, null).virtFrame(this.info.getVirtFrame());
        }

        @NotNull
        public final AtlasInfo.Region getInfo() {
            return this.info;
        }

        @NotNull
        public final AtlasInfo.Page getPage() {
            return this.page;
        }

        @NotNull
        public final RectSlice<? extends Bitmap> getTexture() {
            return this.texture;
        }

        @NotNull
        public final RectSlice<? extends Bitmap> getSlice() {
            return this.slice;
        }

        @NotNull
        public final String getName() {
            return this.info.getName();
        }

        @NotNull
        public final String getFilename() {
            return this.info.getName();
        }
    }
}

