/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JFrame;
import korlibs.image.awt.AwtNativeImage;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.color.BGRA;
import korlibs.image.format.ImageDecoderNotFoundException;
import korlibs.image.format.ImageDecodingProps;
import korlibs.io.async.DispatchersExtJvmKt;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.geom.Anchor2D;
import korlibs.math.geom.MPoint;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.RectangleKt;
import korlibs.math.geom.ScaleMode;
import korlibs.math.geom.Size2D;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0016\u001a\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0002\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0002H\u0086@\u00a2\u0006\u0002\u0010\u001e\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001f\u001a\u0014\u0010 \u001a\u00020\u0002*\u00020\u001b2\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u001a\u0014\u0010 \u001a\u00020\u0002*\u00020!2\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u001a\n\u0010 \u001a\u00020\"*\u00020#\u001a\n\u0010$\u001a\u00020!*\u00020\u0002\u001a\u0012\u0010%\u001a\u00020\u0002*\u00020!2\u0006\u0010\u000e\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006&"}, d2={"premultiplied", "", "Ljava/awt/image/BufferedImage;", "getPremultiplied", "(Ljava/awt/image/BufferedImage;)Z", "ImageIOReadFormat", "s", "Ljava/io/InputStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "type", "", "awtConvertImage", "image", "out", "awtConvertImageIfRequired", "awtReadImage", "data", "", "awtReadImageInWorker", "file", "Ljava/io/File;", "(Ljava/io/File;Lkorlibs/image/format/ImageDecodingProps;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([BLkorlibs/image/format/ImageDecodingProps;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awtShowImage", "Ljavax/swing/JFrame;", "bitmap", "Lkorlibs/image/bitmap/Bitmap;", "awtShowImageAndWait", "", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lkorlibs/image/bitmap/Bitmap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toAwt", "Lkorlibs/image/bitmap/Bitmap32;", "Ljava/awt/Point;", "Lkorlibs/math/geom/MPoint;", "toBMP32", "transferTo", "korge-core"})
@SourceDebugExtension(value={"SMAP\nAwtExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtExt.kt\nkorlibs/image/awt/AwtExtKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n310#2,11:171\n1#3:182\n*S KotlinDebug\n*F\n+ 1 AwtExt.kt\nkorlibs/image/awt/AwtExtKt\n*L\n45#1:171,11\n*E\n"})
public final class AwtExtKt {
    @NotNull
    public static final BufferedImage toAwt(@NotNull Bitmap32 $this$toAwt, @NotNull BufferedImage out) {
        AwtExtKt.transferTo($this$toAwt, out);
        return out;
    }

    public static /* synthetic */ BufferedImage toAwt$default(Bitmap32 bitmap32, BufferedImage bufferedImage, int n, Object object) {
        if ((n & 1) != 0) {
            bufferedImage = new BufferedImage(RangesKt.coerceAtLeast(bitmap32.getWidth(), 1), RangesKt.coerceAtLeast(bitmap32.getHeight(), 1), bitmap32.getPremultiplied() ? 3 : 2);
        }
        return AwtExtKt.toAwt(bitmap32, bufferedImage);
    }

    @NotNull
    public static final Point toAwt(@NotNull MPoint $this$toAwt) {
        return new Point(ToIntegerConvertersKt.toIntRound($this$toAwt.getX()), ToIntegerConvertersKt.toIntRound($this$toAwt.getY()));
    }

    @NotNull
    public static final BufferedImage toAwt(@NotNull Bitmap $this$toAwt, @NotNull BufferedImage out) {
        return AwtExtKt.toAwt($this$toAwt.toBMP32(), out);
    }

    public static /* synthetic */ BufferedImage toAwt$default(Bitmap bitmap, BufferedImage bufferedImage, int n, Object object) {
        if ((n & 1) != 0) {
            bufferedImage = new BufferedImage(RangesKt.coerceAtLeast(bitmap.getWidth(), 1), RangesKt.coerceAtLeast(bitmap.getHeight(), 1), bitmap.getPremultiplied() ? 3 : 2);
        }
        return AwtExtKt.toAwt(bitmap, bufferedImage);
    }

    @Nullable
    public static final Object awtShowImageAndWait(@NotNull Bitmap image2, @NotNull Continuation<? super Unit> $completion) {
        Object object = AwtExtKt.awtShowImageAndWait(AwtExtKt.toAwt$default(image2.toBMP32(), null, 1, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object awtShowImageAndWait(@NotNull BufferedImage image2, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = new CancellableContinuationImpl<Unit>(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation c = cancellable$iv;
        boolean bl2 = false;
        AwtExtKt.awtShowImage(image2).addWindowListener(new WindowAdapter(c){
            final /* synthetic */ CancellableContinuation<Unit> $c;
            {
                this.$c = $c;
            }

            public void windowClosing(@NotNull WindowEvent e) {
                ((Continuation)this.$c).resumeWith(Result.constructor-impl(Unit.INSTANCE));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final JFrame awtShowImage(@NotNull BufferedImage image2) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("If on tests, try NON_HEADLESS_TESTS=true");
        }
        String string = "Image (" + image2.getWidth() + "x" + image2.getHeight() + ")";
        JFrame frame2 = new JFrame(string){

            public void paint(@NotNull Graphics g) {
                this.paintComponents(g);
            }
        };
        frame2.setContentPane(new Container(image2){
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
            }

            public void paint(@NotNull Graphics g) {
                Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
                if (graphics2D != null) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                Graphics2D graphics2D2 = g instanceof Graphics2D ? (Graphics2D)g : null;
                if (graphics2D2 != null) {
                    graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                }
                Graphics2D graphics2D3 = g instanceof Graphics2D ? (Graphics2D)g : null;
                if (graphics2D3 != null) {
                    graphics2D3.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                }
                ScaleMode scaleMode = ScaleMode.Companion.getSHOW_ALL();
                Size2D imageSize = new Size2D(this.$image.getWidth(), this.$image.getHeight());
                Rectangle rectangle = g.getClipBounds();
                Intrinsics.checkNotNullExpressionValue(rectangle, "getClipBounds(...)");
                RectangleI containerSize = korlibs.math.awt.AwtExtKt.toKorma(rectangle);
                RectangleI out = RectangleKt.place(containerSize.toFloat(), imageSize, Anchor2D.Companion.getMIDDLE_CENTER(), scaleMode).toInt();
                g.drawImage(this.$image, out.getX(), out.getY(), out.getWidth(), out.getHeight(), null);
            }
        });
        frame2.setDefaultCloseOperation(2);
        frame2.getContentPane().setMinimumSize(new Dimension(128, 128));
        frame2.getContentPane().setPreferredSize(new Dimension(image2.getWidth(), image2.getHeight()));
        frame2.pack();
        frame2.setLocationRelativeTo(null);
        frame2.setVisible(true);
        return frame2;
    }

    @NotNull
    public static final JFrame awtShowImage(@NotNull Bitmap bitmap) {
        return AwtExtKt.awtShowImage(AwtExtKt.toAwt$default(bitmap.toBMP32(), null, 1, null));
    }

    @NotNull
    public static final BufferedImage awtConvertImage(@NotNull BufferedImage image2, @Nullable BufferedImage out) {
        BufferedImage bufferedImage;
        if (out == null) {
            bufferedImage = new BufferedImage(image2.getWidth(), image2.getHeight(), 3);
        } else {
            if (!(out.getWidth() == image2.getWidth())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(out.getHeight() == image2.getHeight())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(out.getType() == 3)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            bufferedImage = out;
        }
        BufferedImage result2 = bufferedImage;
        result2.getGraphics().drawImage(image2, 0, 0, null);
        return result2;
    }

    public static /* synthetic */ BufferedImage awtConvertImage$default(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, Object object) {
        if ((n & 2) != 0) {
            bufferedImage2 = null;
        }
        return AwtExtKt.awtConvertImage(bufferedImage, bufferedImage2);
    }

    @NotNull
    public static final BufferedImage awtConvertImageIfRequired(@NotNull BufferedImage image2, @Nullable BufferedImage out) {
        return image2.getType() == 3 || image2.getType() == 2 ? image2 : AwtExtKt.awtConvertImage(image2, out);
    }

    public static /* synthetic */ BufferedImage awtConvertImageIfRequired$default(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, Object object) {
        if ((n & 2) != 0) {
            bufferedImage2 = null;
        }
        return AwtExtKt.awtConvertImageIfRequired(bufferedImage, bufferedImage2);
    }

    @NotNull
    public static final BufferedImage transferTo(@NotNull Bitmap32 $this$transferTo, @NotNull BufferedImage out) {
        DataBuffer dataBuffer = out.getRaster().getDataBuffer();
        Intrinsics.checkNotNull(dataBuffer, "null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] ints2 = ((DataBufferInt)dataBuffer).getData();
        int[] nArray = $this$transferTo.getInts();
        Intrinsics.checkNotNull(ints2);
        ArraysKt.arraycopy(nArray, 0, ints2, 0, $this$transferTo.getWidth() * $this$transferTo.getHeight());
        BGRA.INSTANCE.rgbaToBgra(ints2, 0, $this$transferTo.getArea());
        out.flush();
        return out;
    }

    public static final boolean getPremultiplied(@NotNull BufferedImage $this$premultiplied) {
        return $this$premultiplied.isAlphaPremultiplied();
    }

    @NotNull
    public static final Bitmap32 toBMP32(@NotNull BufferedImage $this$toBMP32) {
        return new AwtNativeImage($this$toBMP32, null, 2, null).toBMP32();
    }

    @NotNull
    public static final BufferedImage ImageIOReadFormat(@NotNull InputStream s, @NotNull ImageDecodingProps props) {
        return AwtExtKt.ImageIOReadFormat(s, props.getAsumePremultiplied() ? 2 : (props.getPremultipliedSure() ? 3 : 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final BufferedImage ImageIOReadFormat(@NotNull InputStream s, int type2) {
        Object object;
        Closeable closeable2 = ImageIO.createImageInputStream(s);
        Throwable throwable = null;
        try {
            Object object2;
            ImageInputStream input = (ImageInputStream)closeable2;
            boolean bl = false;
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (!readers.hasNext()) {
                throw new ImageDecoderNotFoundException();
            }
            ImageReader reader = readers.next();
            try {
                void it;
                reader.setInput(input);
                Iterator<ImageTypeSpecifier> iterator2 = reader.getImageTypes(0);
                Intrinsics.checkNotNullExpressionValue(iterator2, "getImageTypes(...)");
                List<ImageTypeSpecifier> availableTypes = SequencesKt.toList(SequencesKt.asSequence(iterator2));
                Object object3 = ImageTypeSpecifier.createFromBufferedImageType(type2);
                ImageTypeSpecifier it2 = object3;
                boolean bl2 = false;
                Object object4 = availableTypes.contains(it2) ? object3 : null;
                if (object4 == null) {
                    ImageTypeSpecifier it3 = it2 = ImageTypeSpecifier.createFromBufferedImageType(6);
                    boolean bl3 = false;
                    object4 = availableTypes.contains(it3) ? it2 : null;
                    if (object4 == null) {
                        object4 = CollectionsKt.first(availableTypes);
                    }
                }
                ImageTypeSpecifier dtype = object4;
                object3 = object2 = reader.getDefaultReadParam();
                int n = 0;
                ImageReader imageReader = reader;
                boolean bl4 = false;
                it.setDestinationType(dtype);
                Unit unit = Unit.INSTANCE;
                object2 = imageReader.read(n, (ImageReadParam)object2);
            }
            finally {
                reader.dispose();
            }
            Object object5 = object2;
            object = object5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable2, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(object, "use(...)");
        return object;
    }

    public static /* synthetic */ BufferedImage ImageIOReadFormat$default(InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return AwtExtKt.ImageIOReadFormat(inputStream, n);
    }

    @NotNull
    public static final BufferedImage awtReadImage(@NotNull byte[] data2) {
        return AwtExtKt.ImageIOReadFormat$default(new ByteArrayInputStream(data2), 0, 2, null);
    }

    @Nullable
    public static final Object awtReadImageInWorker(@NotNull byte[] data2, @NotNull ImageDecodingProps props, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext(DispatchersExtJvmKt.getResourceDecoder(Dispatchers.INSTANCE), (Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(data2, props, null){
            int label;
            final /* synthetic */ byte[] $data;
            final /* synthetic */ ImageDecodingProps $props;
            {
                this.$data = $data;
                this.$props = $props;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return AwtExtKt.ImageIOReadFormat((InputStream)new ByteArrayInputStream(this.$data), this.$props);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public static final Object awtReadImageInWorker(@NotNull File file, @NotNull ImageDecodingProps props, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext(DispatchersExtJvmKt.getResourceDecoder(Dispatchers.INSTANCE), (Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(file, props, null){
            int label;
            final /* synthetic */ File $file;
            final /* synthetic */ ImageDecodingProps $props;
            {
                this.$file = $file;
                this.$props = $props;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BufferedImage bufferedImage;
                        ResultKt.throwOnFailure(object);
                        Closeable closeable2 = new FileInputStream(this.$file);
                        ImageDecodingProps imageDecodingProps = this.$props;
                        Throwable throwable = null;
                        try {
                            FileInputStream it = (FileInputStream)closeable2;
                            boolean bl = false;
                            bufferedImage = AwtExtKt.ImageIOReadFormat((InputStream)it, imageDecodingProps);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable);
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }
}

