/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.awt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import korlibs.image.awt.AwtContext2dRender;
import korlibs.image.awt.AwtExtKt;
import korlibs.image.awt.BaseAwtNativeImage;
import korlibs.image.vector.Context2d;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0016R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lkorlibs/image/awt/AwtNativeImage;", "Lkorlibs/image/awt/BaseAwtNativeImage;", "awtImage", "Ljava/awt/image/BufferedImage;", "out", "(Ljava/awt/image/BufferedImage;Ljava/awt/image/BufferedImage;)V", "dummy", "", "(Ljava/awt/image/BufferedImage;Lkotlin/Unit;)V", "awtData", "", "kotlin.jvm.PlatformType", "getAwtData", "()[I", "getAwtImage", "()Ljava/awt/image/BufferedImage;", "dataBuffer", "Ljava/awt/image/DataBufferInt;", "getDataBuffer", "()Ljava/awt/image/DataBufferInt;", "name", "", "getName", "()Ljava/lang/String;", "requireConv", "", "getRequireConv", "()Z", "getContext2d", "Lkorlibs/image/vector/Context2d;", "antialiasing", "korge-core"})
public final class AwtNativeImage
extends BaseAwtNativeImage {
    @NotNull
    private final BufferedImage awtImage;
    @NotNull
    private final DataBufferInt dataBuffer;
    private final int[] awtData;
    private final boolean requireConv;

    private AwtNativeImage(BufferedImage awtImage, Unit dummy) {
        super(awtImage.getWidth(), awtImage.getHeight(), awtImage, awtImage.getType() == 3);
        this.awtImage = awtImage;
        if (!(this.awtImage.getType() == 3 || this.awtImage.getType() == 2)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        DataBuffer dataBuffer = this.awtImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull(dataBuffer, "null cannot be cast to non-null type java.awt.image.DataBufferInt");
        this.dataBuffer = (DataBufferInt)dataBuffer;
        this.awtData = this.dataBuffer.getData();
        this.requireConv = true;
    }

    @NotNull
    public final BufferedImage getAwtImage() {
        return this.awtImage;
    }

    @NotNull
    public final DataBufferInt getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public int[] getAwtData() {
        return this.awtData;
    }

    public AwtNativeImage(@NotNull BufferedImage awtImage, @Nullable BufferedImage out) {
        this(AwtExtKt.awtConvertImageIfRequired(awtImage, out), Unit.INSTANCE);
    }

    public /* synthetic */ AwtNativeImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bufferedImage2 = null;
        }
        this(bufferedImage, bufferedImage2);
    }

    @Override
    @NotNull
    public String getName() {
        return "AwtNativeImage";
    }

    @Override
    public boolean getRequireConv() {
        return this.requireConv;
    }

    @Override
    @NotNull
    public Context2d getContext2d(boolean antialiasing) {
        return new Context2d(new AwtContext2dRender(this.awtImage, antialiasing, null, 4, null), null, null, 6, null);
    }
}

