/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import korlibs.datastructure.Extra;
import korlibs.datastructure.ExtraObject;
import korlibs.datastructure.IntArray2;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.BitmapKt;
import korlibs.image.color.Colors;
import korlibs.image.color.RGBA;
import korlibs.image.color.RGBAKt;
import korlibs.image.color.RGBAPremultiplied;
import korlibs.image.color.RgbaArray;
import korlibs.image.vector.Context2d;
import korlibs.io.lang.ExceptionsKt;
import korlibs.math.ClampKt;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.SizeInt;
import korlibs.math.geom.SizeableInt;
import korlibs.math.geom.slice.SliceOrientation;
import korlibs.math.geom.slice.SliceRotation;
import korlibs.math.interpolation._Math_interpolationKt;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J\u000e\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004J\u000e\u0010K\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004J\u000e\u0010L\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020\u0000H\u0016J\u0010\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\u0000H\u0016J\b\u0010R\u001a\u00020\u0004H\u0016J>\u0010S\u001a\u00020N2\u0006\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J@\u0010Y\u001a\u00020N2\u0006\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010Z\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010[\u001a\u00020\u0000H\u0016J\b\u0010\\\u001a\u00020\u0000H\u0016J\u0006\u0010]\u001a\u00020\u0000J\u0006\u0010^\u001a\u00020\u0000J~\u0010_\u001a\u00020N2\b\b\u0002\u0010`\u001a\u00020\u00042\b\b\u0002\u0010a\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042K\u0010b\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bd\u0012\b\be\u0012\u0004\b\b(f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bd\u0012\b\be\u0012\u0004\b\b(J\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bd\u0012\b\be\u0012\u0004\b\b(H\u0012\u0004\u0012\u00020N0cH\u0086\bJ\u0012\u0010g\u001a\u00020h2\b\b\u0002\u0010i\u001a\u00020\bH\u0016J\u0018\u0010j\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0016J%\u0010k\u001a\u00020l2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bm\u0010nJ#\u0010o\u001a\u00020l2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bp\u0010nJ#\u0010q\u001a\u00020l2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\br\u0010nJ%\u0010s\u001a\u00020t2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bu\u0010nJ%\u0010v\u001a\u00020l2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bw\u0010nJ#\u0010x\u001a\u00020l2\u0006\u0010J\u001a\u00020y2\u0006\u0010H\u001a\u00020y\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bz\u0010{J0\u0010x\u001a\u00020N2\u0006\u0010J\u001a\u00020y2\u0006\u0010H\u001a\u00020y2\u0006\u0010|\u001a\u00020\u00042\u0006\u0010}\u001a\u00020D\u00f8\u0001\u0000\u00a2\u0006\u0004\b~\u0010\u007fJ\u0017\u0010\u0080\u0001\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J\u000f\u0010\u0081\u0001\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u0004J\u000f\u0010\u0082\u0001\u001a\u00020\b2\u0006\u0010H\u001a\u00020\u0004J\u0017\u0010\u0083\u0001\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J\u0017\u0010\u0084\u0001\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J\t\u0010\u0085\u0001\u001a\u00020NH\u0016J3\u0010\u0085\u0001\u001a\u00020\u00042\f\b\u0002\u00105\u001a\u00060\"j\u0002`#2\t\b\u0002\u0010\u0086\u0001\u001a\u00020\b2\u000e\u0010\u0087\u0001\u001a\t\u0012\u0004\u0012\u00020N0\u0088\u0001H\u0086\bJ\"\u0010\u0089\u0001\u001a\u00020\u00002\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008e\u0001J=\u0010\u008f\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0007\u0010\u0090\u0001\u001a\u00020>2\t\b\u0002\u0010\u0091\u0001\u001a\u00020\u0004H\u0016J\u0016\u0010\u0092\u0001\u001a\u00020\u00002\r\u0010\u0093\u0001\u001a\b0\u0094\u0001j\u0003`\u0095\u0001J\u0007\u0010\u0096\u0001\u001a\u00020\u0000J\u0007\u0010\u0097\u0001\u001a\u00020\u0000J\"\u0010\u0098\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0007\u0010\u0099\u0001\u001a\u00020\u0004H\u0016J.\u0010\u009a\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0007\u0010\u009b\u0001\u001a\u00020lH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009c\u0001\u0010\u009d\u0001J.\u0010\u009a\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0007\u0010\u009b\u0001\u001a\u00020tH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009e\u0001\u0010\u009d\u0001J.\u0010\u009f\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0007\u0010\u009b\u0001\u001a\u00020lH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u009d\u0001J\u001b\u0010\u00a1\u0001\u001a\u00020N2\u0007\u0010\u00a2\u0001\u001a\u00020\u00042\u0007\u0010\u00a3\u0001\u001a\u00020\u0004H\u0016J\u001b\u0010\u00a4\u0001\u001a\u00020N2\u0007\u0010\u00a5\u0001\u001a\u00020\u00042\u0007\u0010\u00a6\u0001\u001a\u00020\u0004H\u0016J\n\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0016J\b\u0010\u00a9\u0001\u001a\u00030\u00a8\u0001J\t\u0010\u00aa\u0001\u001a\u00020\u0000H\u0016J\u0017\u0010\u00ab\u0001\u001a\u00020\u00042\f\b\u0002\u00105\u001a\u00060\"j\u0002`#H\u0016J=\u0010\u00ac\u0001\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0007\u0010\u0090\u0001\u001a\u00020>2\t\b\u0002\u0010\u0091\u0001\u001a\u00020\u0004H\u0016R\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010 R.\u0010$\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#2\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\b\u0018\u00010(j\u0002`)X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u000eR\u001a\u0010/\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0011\"\u0004\b1\u0010\u0013R$\u0010\u0007\u001a\u00020\b2\u0006\u00102\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0011\"\u0004\b4\u0010\u0013R\u0015\u00105\u001a\u00060\"j\u0002`#\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010&R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u000eR\u001b\u0010=\u001a\u00020>8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\b?\u0010@R\u001a\u0010C\u001a\u00020D8DX\u0084\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\bE\u0010@R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00ad\u0001"}, d2={"Lkorlibs/image/bitmap/Bitmap;", "Lkorlibs/math/geom/SizeableInt;", "Lkorlibs/datastructure/Extra;", "width", "", "height", "bpp", "premultiplied", "", "backingArray", "", "(IIIZLjava/lang/Object;)V", "area", "getArea", "()I", "asumePremultiplied", "getAsumePremultiplied", "()Z", "setAsumePremultiplied", "(Z)V", "getBackingArray", "()Ljava/lang/Object;", "bitmapName", "", "getBitmapName", "()Ljava/lang/String;", "setBitmapName", "(Ljava/lang/String;)V", "getBpp", "contentVersion", "getContentVersion", "setContentVersion", "(I)V", "<set-?>", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "dirtyRegion", "getDirtyRegion", "()Lkorlibs/math/geom/RectangleI;", "extra", "Lkorlibs/datastructure/ExtraObject;", "Lkorlibs/datastructure/ExtraType;", "getExtra", "()Lkorlibs/datastructure/ExtraObject;", "setExtra", "(Lkorlibs/datastructure/ExtraObject;)V", "getHeight", "mipmaps", "getMipmaps", "setMipmaps", "value", "getPremultiplied", "setPremultiplied", "rect", "getRect", "size", "Lkorlibs/math/geom/SizeInt;", "getSize", "()Lkorlibs/math/geom/SizeInt;", "stride", "getStride", "tempInts", "", "getTempInts", "()[I", "tempInts$delegate", "Lkotlin/Lazy;", "tempRgba", "Lkorlibs/image/color/RgbaArray;", "getTempRgba-FROm4YY", "getWidth", "clampHeight", "y", "clampWidth", "x", "clampX", "clampY", "clearDirtyRegion", "", "clone", "contentEquals", "other", "contentHashCode", "copy", "srcX", "srcY", "dst", "dstX", "dstY", "copyUnchecked", "createWithThisFormat", "flipX", "flipY", "flippedX", "flippedY", "forEach", "sx", "sy", "callback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "n", "getContext2d", "Lkorlibs/image/vector/Context2d;", "antialiasing", "getInt", "getRgba", "Lkorlibs/image/color/RGBA;", "getRgba-GWFm98M", "(II)I", "getRgbaClamped", "getRgbaClamped-GWFm98M", "getRgbaClampedBorder", "getRgbaClampedBorder-GWFm98M", "getRgbaPremultiplied", "Lkorlibs/image/color/RGBAPremultiplied;", "getRgbaPremultiplied-YdjHmOQ", "getRgbaRaw", "getRgbaRaw-GWFm98M", "getRgbaSampled", "", "getRgbaSampled-GWFm98M", "(FF)I", "count", "row", "getRgbaSampled-ImQKOBg", "(FFI[I)V", "inBounds", "inBoundsX", "inBoundsY", "index", "inside", "lock", "doLock", "block", "Lkotlin/Function0;", "oriented", "orientation", "Lkorlibs/math/geom/slice/SliceOrientation;", "Lkorlibs/image/bitmap/ImageOrientation;", "oriented-IC3zliY", "(I)Lkorlibs/image/bitmap/Bitmap;", "readPixelsUnsafe", "out", "offset", "rotated", "rotation", "Lkorlibs/math/geom/slice/SliceRotation;", "Lkorlibs/image/bitmap/ImageRotation;", "rotatedLeft", "rotatedRight", "setInt", "color", "setRgba", "v", "setRgba-QlK1N60", "(III)V", "setRgba-Ze3X27o", "setRgbaRaw", "setRgbaRaw-QlK1N60", "swapColumns", "x0", "x1", "swapRows", "y0", "y1", "toBMP32", "Lkorlibs/image/bitmap/Bitmap32;", "toBMP32IfRequired", "transposed", "unlock", "writePixelsUnsafe", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBitmap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bitmap.kt\nkorlibs/image/bitmap/Bitmap\n+ 2 RGBA.kt\nkorlibs/image/color/RGBAPremultiplied\n+ 3 Fract.kt\nkorlibs/math/FractKt\n+ 4 Array2.kt\nkorlibs/datastructure/IntArray2$Companion\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,367:1\n245#2:368\n245#2:369\n3#3:370\n3#3:371\n177#4:372\n1#5:373\n7#6:374\n*S KotlinDebug\n*F\n+ 1 Bitmap.kt\nkorlibs/image/bitmap/Bitmap\n*L\n116#1:368\n121#1:369\n145#1:370\n146#1:371\n236#1:372\n302#1:374\n*E\n"})
public abstract class Bitmap
implements SizeableInt,
Extra {
    private final int width;
    private final int height;
    private final int bpp;
    @Nullable
    private final Object backingArray;
    private final /* synthetic */ Extra.Mixin $$delegate_0;
    @NotNull
    private final RectangleI rect;
    @Nullable
    private String bitmapName;
    private boolean premultiplied;
    private boolean asumePremultiplied;
    @NotNull
    private final Lazy tempInts$delegate;
    private int contentVersion;
    @Nullable
    private RectangleI dirtyRegion;
    private boolean mipmaps;

    public Bitmap(int width2, int height2, int bpp, boolean premultiplied, @Nullable Object backingArray) {
        this.width = width2;
        this.height = height2;
        this.bpp = bpp;
        this.backingArray = backingArray;
        this.$$delegate_0 = new Extra.Mixin(null, 1, null);
        this.rect = new RectangleI(0, 0, this.width, this.height);
        this.premultiplied = premultiplied;
        this.tempInts$delegate = LazyKt.lazy((Function0)new Function0<int[]>(this){
            final /* synthetic */ Bitmap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final int[] invoke() {
                return new int[this.this$0.getWidth() * 2];
            }
        });
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getBpp() {
        return this.bpp;
    }

    @Nullable
    public final Object getBackingArray() {
        return this.backingArray;
    }

    @Override
    @Nullable
    public ExtraObject getExtra() {
        return this.$$delegate_0.getExtra();
    }

    @Override
    public void setExtra(@Nullable ExtraObject extraObject) {
        this.$$delegate_0.setExtra(extraObject);
    }

    @NotNull
    public final RectangleI getRect() {
        return this.rect;
    }

    @Override
    @NotNull
    public SizeInt getSize() {
        return new SizeInt(this.width, this.height);
    }

    @Nullable
    public final String getBitmapName() {
        return this.bitmapName;
    }

    public final void setBitmapName(@Nullable String string) {
        this.bitmapName = string;
    }

    public final boolean getPremultiplied() {
        return this.premultiplied;
    }

    public final void setPremultiplied(boolean value) {
        this.premultiplied = value;
    }

    public final boolean getAsumePremultiplied() {
        return this.asumePremultiplied;
    }

    public final void setAsumePremultiplied(boolean bl) {
        this.asumePremultiplied = bl;
    }

    @NotNull
    protected final int[] getTempInts() {
        Lazy lazy = this.tempInts$delegate;
        return (int[])lazy.getValue();
    }

    @NotNull
    protected final int[] getTempRgba-FROm4YY() {
        return RgbaArray.constructor-impl(this.getTempInts());
    }

    public final int getContentVersion() {
        return this.contentVersion;
    }

    public final void setContentVersion(int n) {
        this.contentVersion = n;
    }

    @Nullable
    public final RectangleI getDirtyRegion() {
        return this.dirtyRegion;
    }

    public final boolean getMipmaps() {
        return this.mipmaps;
    }

    public final void setMipmaps(boolean bl) {
        this.mipmaps = bl;
    }

    public final int getStride() {
        return this.width * this.bpp / 8;
    }

    public final int getArea() {
        return this.width * this.height;
    }

    public final int index(int x, int y) {
        return y * this.width + x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean inside(int x, int y) {
        if (0 > x) return false;
        if (x >= this.width) return false;
        boolean bl = true;
        if (!bl) return false;
        if (0 > y) return false;
        if (y >= this.height) return false;
        return true;
    }

    public final void clearDirtyRegion() {
        if (this.dirtyRegion != null) {
            this.dirtyRegion = null;
        }
    }

    public void lock() {
    }

    public int unlock(@NotNull RectangleI rect) {
        if (this.dirtyRegion == null) {
            this.dirtyRegion = rect;
        } else {
            RectangleI rectangleI = this.dirtyRegion;
            Intrinsics.checkNotNull(rectangleI);
            this.dirtyRegion = RectangleI.Companion.union(rectangleI, rect);
        }
        ++this.contentVersion;
        return this.contentVersion;
    }

    public static /* synthetic */ int unlock$default(Bitmap bitmap, RectangleI rectangleI, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unlock");
        }
        if ((n & 1) != 0) {
            rectangleI = bitmap.rect;
        }
        return bitmap.unlock(rectangleI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int lock(@NotNull RectangleI rect, boolean doLock, @NotNull Function0<Unit> block2) {
        boolean $i$f$lock = false;
        if (doLock) {
            this.lock();
        }
        int result2 = 0;
        try {
            block2.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart(1);
            result2 = doLock ? this.unlock(rect) : 0;
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        result2 = doLock ? this.unlock(rect) : 0;
        InlineMarker.finallyEnd(1);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ int lock$default(Bitmap $this, RectangleI rect, boolean doLock, Function0 block2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lock");
        }
        if ((n & 1) != 0) {
            rect = $this.getRect();
        }
        if ((n & 2) != 0) {
            doLock = true;
        }
        boolean $i$f$lock = false;
        if (doLock) {
            $this.lock();
        }
        int result2 = 0;
        try {
            block2.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart(1);
            result2 = doLock ? $this.unlock(rect) : 0;
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        result2 = doLock ? $this.unlock(rect) : 0;
        InlineMarker.finallyEnd(1);
        return result2;
    }

    public void readPixelsUnsafe(int x, int y, int width2, int height2, @NotNull int[] out, int offset2) {
        int n = offset2;
        for (int y0 = 0; y0 < height2; ++y0) {
            for (int x0 = 0; x0 < width2; ++x0) {
                out[n++] = this.getRgbaRaw-GWFm98M(x0 + x, y0 + y);
            }
        }
    }

    public static /* synthetic */ void readPixelsUnsafe$default(Bitmap bitmap, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readPixelsUnsafe");
        }
        if ((n6 & 0x20) != 0) {
            n5 = 0;
        }
        bitmap.readPixelsUnsafe(n, n2, n3, n4, nArray, n5);
    }

    public void writePixelsUnsafe(int x, int y, int width2, int height2, @NotNull int[] out, int offset2) {
        int n = offset2;
        for (int y0 = 0; y0 < height2; ++y0) {
            for (int x0 = 0; x0 < width2; ++x0) {
                this.setRgbaRaw-QlK1N60(x0 + x, y0 + y, RGBA.constructor-impl(out[n++]));
            }
        }
    }

    public static /* synthetic */ void writePixelsUnsafe$default(Bitmap bitmap, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writePixelsUnsafe");
        }
        if ((n6 & 0x20) != 0) {
            n5 = 0;
        }
        bitmap.writePixelsUnsafe(n, n2, n3, n4, nArray, n5);
    }

    public void setRgbaRaw-QlK1N60(int x, int y, int v) {
        throw new NotImplementedError(null, 1, null);
    }

    public int getRgbaRaw-GWFm98M(int x, int y) {
        return Colors.INSTANCE.getTRANSPARENT-JH0Opww();
    }

    public void setRgba-QlK1N60(int x, int y, int v) {
        if (this.premultiplied) {
            this.setRgbaRaw-QlK1N60(x, y, RGBAKt.asNonPremultiplied-YWajVTI(RGBA.getPremultiplied-WnMhupY(v)));
        } else {
            this.setRgbaRaw-QlK1N60(x, y, v);
        }
    }

    public void setRgba-Ze3X27o(int x, int y, int v) {
        if (this.premultiplied) {
            this.setRgbaRaw-QlK1N60(x, y, RGBAKt.asNonPremultiplied-YWajVTI(v));
        } else {
            boolean bl = false;
            this.setRgbaRaw-QlK1N60(x, y, RGBAPremultiplied.getDepremultipliedAccurate-JH0Opww(v));
        }
    }

    public int getRgba-GWFm98M(int x, int y) {
        int n;
        if (this.premultiplied) {
            int arg0$iv = RGBAKt.asPremultiplied-PXL95c4(this.getRgbaRaw-GWFm98M(x, y));
            boolean bl = false;
            n = RGBAPremultiplied.getDepremultipliedAccurate-JH0Opww(arg0$iv);
        } else {
            n = this.getRgbaRaw-GWFm98M(x, y);
        }
        return n;
    }

    public int getRgbaPremultiplied-YdjHmOQ(int x, int y) {
        return this.premultiplied ? RGBAKt.asPremultiplied-PXL95c4(this.getRgbaRaw-GWFm98M(x, y)) : RGBA.getPremultiplied-WnMhupY(this.getRgbaRaw-GWFm98M(x, y));
    }

    public void setInt(int x, int y, int color2) {
    }

    public int getInt(int x, int y) {
        return 0;
    }

    public final int getRgbaClamped-GWFm98M(int x, int y) {
        return this.inBounds(x, y) ? this.getRgbaRaw-GWFm98M(x, y) : Colors.INSTANCE.getTRANSPARENT-JH0Opww();
    }

    public final int getRgbaClampedBorder-GWFm98M(int x, int y) {
        return this.getRgbaRaw-GWFm98M(ClampKt.clamp(x, 0, this.width - 1), ClampKt.clamp(y, 0, this.height - 1));
    }

    public final int getRgbaSampled-GWFm98M(float x, float y) {
        int x0 = ToIntegerConvertersKt.toIntFloor(x);
        int y0 = ToIntegerConvertersKt.toIntFloor(y);
        if (x0 < 0 || y0 < 0 || x0 >= this.width || y0 >= this.height) {
            return Colors.INSTANCE.getTRANSPARENT-JH0Opww();
        }
        int x1 = ToIntegerConvertersKt.toIntCeil(x);
        int y1 = ToIntegerConvertersKt.toIntCeil(y);
        boolean x1Inside = x1 < this.width - 1;
        boolean y1Inside = y1 < this.height - 1;
        boolean $i$f$fract = false;
        float xratio = x - (float)ToIntegerConvertersKt.toIntFloor(x);
        boolean $i$f$fract2 = false;
        float yratio = y - (float)ToIntegerConvertersKt.toIntFloor(y);
        int c00 = this.getRgbaRaw-GWFm98M(x0, y0);
        int c10 = x1Inside ? this.getRgbaRaw-GWFm98M(x1, y0) : c00;
        int c01 = y1Inside ? this.getRgbaRaw-GWFm98M(x0, y1) : c00;
        int c11 = x1Inside && y1Inside ? this.getRgbaRaw-GWFm98M(x1, y1) : c01;
        return RGBA.Companion.mixRgba4-RdOqKdk(c00, c10, c01, c11, _Math_interpolationKt.toRatio(xratio), _Math_interpolationKt.toRatio(yratio));
    }

    public final void getRgbaSampled-ImQKOBg(float x, float y, int count2, @NotNull int[] row) {
        for (int n = 0; n < count2; ++n) {
            RgbaArray.set-XDoMphA(row, n, this.getRgbaSampled-GWFm98M(x + (float)n, y));
        }
    }

    public final void copy(int srcX, int srcY, @NotNull Bitmap dst, int dstX, int dstY, int width2, int height2) {
        Bitmap src = this;
        int srcX0 = src.clampWidth(srcX);
        int srcX1 = src.clampWidth(srcX + width2);
        int srcY0 = src.clampHeight(srcY);
        int srcY1 = src.clampHeight(srcY + height2);
        int dstX0 = dst.clampWidth(dstX);
        int dstX1 = dst.clampWidth(dstX + width2);
        int dstY0 = dst.clampHeight(dstY);
        int dstY1 = dst.clampHeight(dstY + height2);
        int srcX2 = srcX0;
        int srcY2 = srcY0;
        int dstX2 = dstX0;
        int dstY2 = dstY0;
        int width3 = Math.min(srcX1 - srcX0, dstX1 - dstX0);
        int height3 = Math.min(srcY1 - srcY0, dstY1 - dstY0);
        this.copyUnchecked(srcX2, srcY2, dst, dstX2, dstY2, width3, height3);
    }

    public void copyUnchecked(int srcX, int srcY, @NotNull Bitmap dst, int dstX, int dstY, int width2, int height2) {
        for (int y = 0; y < height2; ++y) {
            this.readPixelsUnsafe(srcX, srcY + y, width2, 1, this.getTempInts(), 0);
            dst.writePixelsUnsafe(dstX, dstY + y, width2, 1, this.getTempInts(), 0);
        }
    }

    public final boolean inBoundsX(int x) {
        return x >= 0 && x < this.width;
    }

    public final boolean inBoundsY(int y) {
        return y >= 0 && y < this.height;
    }

    public final boolean inBounds(int x, int y) {
        return this.inBoundsX(x) && this.inBoundsY(y);
    }

    public final int clampX(int x) {
        return ClampKt.clamp(x, 0, this.width - 1);
    }

    public final int clampY(int y) {
        return ClampKt.clamp(y, 0, this.height - 1);
    }

    public final int clampWidth(int x) {
        return ClampKt.clamp(x, 0, this.width);
    }

    public final int clampHeight(int y) {
        return ClampKt.clamp(y, 0, this.height);
    }

    @NotNull
    public Bitmap flipY() {
        int n = this.height / 2;
        for (int y = 0; y < n; ++y) {
            this.swapRows(y, this.height - y - 1);
        }
        return this;
    }

    @NotNull
    public Bitmap flipX() {
        int n = this.width / 2;
        for (int x = 0; x < n; ++x) {
            this.swapColumns(x, this.width - x - 1);
        }
        return this;
    }

    @NotNull
    public final Bitmap flippedY() {
        return this.clone().flipY();
    }

    @NotNull
    public final Bitmap flippedX() {
        return this.clone().flipX();
    }

    @NotNull
    public final Bitmap rotated(@NotNull SliceRotation rotation) {
        Bitmap bitmap;
        switch (WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
            case 1: {
                bitmap = this.clone();
                break;
            }
            case 2: {
                bitmap = this.transposed().flipX();
                break;
            }
            case 3: {
                bitmap = this.transposed().flipX().transposed().flipX();
                break;
            }
            case 4: {
                bitmap = this.transposed().flipY();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bitmap;
    }

    @NotNull
    public final Bitmap rotatedRight() {
        return this.rotated(SliceRotation.R90);
    }

    @NotNull
    public final Bitmap rotatedLeft() {
        return this.rotated(SliceRotation.R270);
    }

    @NotNull
    public final Bitmap oriented-IC3zliY(int orientation2) {
        Bitmap out = this.clone();
        if (SliceOrientation.getFlipX-impl(orientation2)) {
            out.flipX();
        }
        return out.rotated(SliceOrientation.getRotation-impl(orientation2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bitmap transposed() {
        Bitmap bitmap;
        void height$iv;
        int width$iv;
        IntArray2 temp = new IntArray2(this.width, this.height, BitmapKt.readPixelsUnsafe(this, 0, 0, this.width, this.height));
        IntArray2.Companion companion = IntArray2.Companion;
        int n = this.height;
        int n2 = this.width;
        int fill$iv = 0;
        boolean $i$f$invoke = false;
        int n3 = 0;
        void var9_11 = width$iv * height$iv;
        int[] nArray = new int[var9_11];
        void var11_13 = height$iv;
        void var12_14 = width$iv;
        while (n3 < var9_11) {
            int n4 = n3++;
            nArray[n4] = fill$iv;
        }
        int[] nArray2 = nArray;
        void var15_17 = var11_13;
        void var16_18 = var12_14;
        IntArray2 out = new IntArray2((int)var16_18, (int)var15_17, nArray2);
        width$iv = this.height;
        for (int y = 0; y < width$iv; ++y) {
            int n5 = this.width;
            for (int x = 0; x < n5; ++x) {
                out.set(y, x, temp.get(x, y));
            }
        }
        Bitmap it = bitmap = this.createWithThisFormat(this.height, this.width);
        boolean bl = false;
        Bitmap.writePixelsUnsafe$default(it, 0, 0, this.height, this.width, out.getData(), 0, 32, null);
        return bitmap;
    }

    public void swapRows(int y0, int y1) {
        int n = this.width;
        for (int x = 0; x < n; ++x) {
            int c0 = this.getInt(x, y0);
            int c1 = this.getInt(x, y1);
            this.setInt(x, y0, c1);
            this.setInt(x, y1, c0);
        }
    }

    public void swapColumns(int x0, int x1) {
        int n = this.height;
        for (int y = 0; y < n; ++y) {
            int c0 = this.getInt(x0, y);
            int c1 = this.getInt(x1, y);
            this.setInt(x0, y, c1);
            this.setInt(x1, y, c0);
        }
    }

    public final void forEach(int sx, int sy, int width2, int height2, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> callback) {
        boolean $i$f$forEach = false;
        int n = sy + height2;
        for (int y = sy; y < n; ++y) {
            int n2 = this.index(sx, sy + y);
            int n3 = sx + width2;
            for (int x = sx; x < n3; ++x) {
                callback.invoke((Integer)n2++, (Integer)x, (Integer)y);
            }
        }
    }

    public static /* synthetic */ void forEach$default(Bitmap $this, int sx, int sy, int width2, int height2, Function3 callback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: forEach");
        }
        if ((n & 1) != 0) {
            sx = 0;
        }
        if ((n & 2) != 0) {
            sy = 0;
        }
        if ((n & 4) != 0) {
            width2 = $this.getWidth() - sx;
        }
        if ((n & 8) != 0) {
            height2 = $this.getHeight() - sy;
        }
        boolean $i$f$forEach = false;
        int n2 = sy + height2;
        for (int y = sy; y < n2; ++y) {
            int n3 = $this.index(sx, sy + y);
            int n4 = sx + width2;
            for (int x = sx; x < n4; ++x) {
                callback.invoke(n3++, x, y);
            }
        }
    }

    @NotNull
    public Context2d getContext2d(boolean antialiasing) {
        throw new UnsupportedOperationException("Not implemented context2d on Bitmap, please use NativeImage or Bitmap32 instead");
    }

    public static /* synthetic */ Context2d getContext2d$default(Bitmap bitmap, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getContext2d");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return bitmap.getContext2d(bl);
    }

    @NotNull
    public Bitmap createWithThisFormat(int width2, int height2) {
        ExceptionsKt.invalidOp("Unsupported createWithThisFormat (" + this + ")");
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Bitmap32 toBMP32() {
        Bitmap32 bitmap32;
        Bitmap32 out = bitmap32 = new Bitmap32(this.width, this.height, null, this.premultiplied, 4, null);
        boolean bl = false;
        this.readPixelsUnsafe(0, 0, this.width, this.height, out.getInts(), 0);
        return bitmap32;
    }

    @NotNull
    public final Bitmap32 toBMP32IfRequired() {
        return this instanceof Bitmap32 ? (Bitmap32)this : this.toBMP32();
    }

    public boolean contentEquals(@NotNull Bitmap other) {
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        int n = this.height;
        for (int y = 0; y < n; ++y) {
            int n2 = this.width;
            for (int x = 0; x < n2; ++x) {
                if (RGBA.equals-impl0(this.getRgbaRaw-GWFm98M(x, y), other.getRgbaRaw-GWFm98M(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public int contentHashCode() {
        int v = 0;
        int n = this.height;
        for (int y = 0; y < n; ++y) {
            int n2 = this.width;
            for (int x = 0; x < n2; ++x) {
                v += Integer.hashCode(this.getRgbaRaw-GWFm98M(x, y)) * (7 + x + y * 3);
            }
        }
        boolean $this$toInt$iv = this.premultiplied;
        boolean $i$f$toInt = false;
        return this.width * 31 + this.height + v + ($this$toInt$iv ? 1 : 0);
    }

    @NotNull
    public Bitmap clone() {
        Bitmap out = this.createWithThisFormat(this.width, this.height);
        this.copyUnchecked(0, 0, out, 0, 0, this.width, this.height);
        return out;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SliceRotation.values().length];
            try {
                nArray[SliceRotation.R0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SliceRotation.R90.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SliceRotation.R180.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SliceRotation.R270.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

