/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import java.util.Arrays;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.color.ColorFormat;
import korlibs.image.color.ColorFormatKt;
import korlibs.image.color.RGBA_4444;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0019\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J%\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J!\u0010$\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J \u0010&\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J*\u0010'\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010(\u001a\u00020!H\u0016\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006-"}, d2={"Lkorlibs/image/bitmap/Bitmap16;", "Lkorlibs/image/bitmap/Bitmap;", "width", "", "height", "data", "", "format", "Lkorlibs/image/color/ColorFormat;", "premultiplied", "", "(II[SLkorlibs/image/color/ColorFormat;Z)V", "getData", "()[S", "getFormat", "()Lkorlibs/image/color/ColorFormat;", "clone", "contentEquals", "other", "contentHashCode", "copyUnchecked", "", "srcX", "srcY", "dst", "dstX", "dstY", "createWithThisFormat", "get", "x", "y", "getInt", "getRgbaRaw", "Lkorlibs/image/color/RGBA;", "getRgbaRaw-GWFm98M", "(II)I", "set", "color", "setInt", "setRgbaRaw", "v", "setRgbaRaw-QlK1N60", "(III)V", "toString", "", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBitmap16.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bitmap16.kt\nkorlibs/image/bitmap/Bitmap16\n+ 2 Assert.kt\nkorlibs/io/lang/AssertKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,51:1\n4#2,2:52\n1#3:54\n7#4:55\n*S KotlinDebug\n*F\n+ 1 Bitmap16.kt\nkorlibs/image/bitmap/Bitmap16\n*L\n20#1:52,2\n47#1:55\n*E\n"})
public final class Bitmap16
extends Bitmap {
    @NotNull
    private final short[] data;
    @NotNull
    private final ColorFormat format;

    public Bitmap16(int width2, int height2, @NotNull short[] data2, @NotNull ColorFormat format2, boolean premultiplied) {
        super(width2, height2, 16, premultiplied, data2);
        this.data = data2;
        this.format = format2;
        boolean cond$iv = this.data.length >= width2 * height2;
        boolean $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
    }

    public /* synthetic */ Bitmap16(int n, int n2, short[] sArray, ColorFormat colorFormat, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            sArray = new short[n * n2];
        }
        if ((n3 & 8) != 0) {
            colorFormat = RGBA_4444.INSTANCE;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, sArray, colorFormat, bl);
    }

    @NotNull
    public final short[] getData() {
        return this.data;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public Bitmap createWithThisFormat(int width2, int height2) {
        return new Bitmap16(width2, height2, null, this.format, this.getPremultiplied(), 4, null);
    }

    @Override
    @NotNull
    public Bitmap16 clone() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        short[] sArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(sArray, "copyOf(...)");
        return new Bitmap16(n, n2, sArray, this.format, this.getPremultiplied());
    }

    public final void set(int x, int y, int color2) {
        this.setInt(x, y, color2);
    }

    public final int get(int x, int y) {
        return this.getInt(x, y);
    }

    @Override
    public void setInt(int x, int y, int color2) {
        Unit unit;
        Unit $this$setInt_u24lambda_u240 = unit = Unit.INSTANCE;
        boolean bl = false;
        this.data[this.index((int)x, (int)y)] = (short)color2;
    }

    @Override
    public int getInt(int x, int y) {
        return this.data[this.index(x, y)] & 0xFFFF;
    }

    @Override
    public void setRgbaRaw-QlK1N60(int x, int y, int v) {
        this.setInt(x, y, ColorFormatKt.packRGBA-XDoMphA(this.format, v));
    }

    @Override
    public int getRgbaRaw-GWFm98M(int x, int y) {
        return ColorFormatKt.unpackToRGBA(this.format, this.data[this.index(x, y)]);
    }

    @Override
    public void copyUnchecked(int srcX, int srcY, @NotNull Bitmap dst, int dstX, int dstY, int width2, int height2) {
        if (!(dst instanceof Bitmap16)) {
            super.copyUnchecked(srcX, srcY, dst, dstX, dstY, width2, height2);
            return;
        }
        Bitmap16 src = this;
        short[] srcArray = src.data;
        short[] dstArray = ((Bitmap16)dst).data;
        for (int y = 0; y < height2; ++y) {
            ArraysKt.arraycopy(srcArray, src.index(srcX, srcY + y), dstArray, dst.index(dstX, dstY + y), width2);
        }
    }

    @Override
    public boolean contentEquals(@NotNull Bitmap other) {
        return other instanceof Bitmap16 && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight() && Arrays.equals(this.data, ((Bitmap16)other).data);
    }

    @Override
    public int contentHashCode() {
        boolean $this$toInt$iv = this.getPremultiplied();
        boolean $i$f$toInt = false;
        return this.getWidth() * 31 + this.getHeight() + Arrays.hashCode(this.data) + ($this$toInt$iv ? 1 : 0);
    }

    @NotNull
    public String toString() {
        return "Bitmap16(" + this.getWidth() + ", " + this.getHeight() + ", format=" + this.format + ")";
    }
}

