/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.image.color.RGBA;
import korlibs.image.color.RGBAPremultiplied;
import korlibs.image.color.RgbaArray;
import korlibs.image.color.RgbaPremultipliedArray;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.slice.RectSlice;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\f\u001a\u00020\r*\u000e\u0012\u0006\b\u0001\u0012\u00020\u00020\u000ej\u0002`\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"expandBorder", "", "Lkorlibs/image/bitmap/Bitmap32;", "area", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "border", "", "areaTop", "areaLeft", "areaBottom", "areaRight", "isFullyTransparent", "", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/BmpSlice32;", "posterize", "nbits", "posterizeInplace", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBitmap32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bitmap32.kt\nkorlibs/image/bitmap/Bitmap32Kt\n+ 2 RGBA.kt\nkorlibs/image/color/RGBAPremultiplied\n*L\n1#1,645:1\n245#2:646\n*S KotlinDebug\n*F\n+ 1 Bitmap32.kt\nkorlibs/image/bitmap/Bitmap32Kt\n*L\n592#1:646\n*E\n"})
public final class Bitmap32Kt {
    public static final boolean isFullyTransparent(@NotNull RectSlice<? extends Bitmap32> $this$isFullyTransparent) {
        Bitmap32 bmp2 = BitmapSliceKt.getBmp($this$isFullyTransparent);
        int[] data2 = RgbaArray.constructor-impl(BitmapSliceKt.getBmp($this$isFullyTransparent).getInts());
        int width2 = $this$isFullyTransparent.getRight() - $this$isFullyTransparent.getLeft();
        int n = $this$isFullyTransparent.getBottom();
        for (int y = $this$isFullyTransparent.getTop(); y < n; ++y) {
            int index2 = bmp2.index($this$isFullyTransparent.getLeft(), y);
            if (!(index2 >= 0 && index2 <= RgbaArray.getSize-impl(data2) - width2)) {
                boolean bl = false;
                String string = "left=" + $this$isFullyTransparent.getLeft() + ", top=" + $this$isFullyTransparent.getTop() + ", right=" + $this$isFullyTransparent.getRight() + ", bottom=" + $this$isFullyTransparent.getBottom();
                throw new IllegalStateException(string.toString());
            }
            for (int n2 = 0; n2 < width2; ++n2) {
                if (RGBA.getA-impl(RgbaArray.get-O1c-hRk(data2, index2 + n2)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static final Bitmap32 posterize(@NotNull Bitmap32 $this$posterize, int nbits) {
        return Bitmap32Kt.posterizeInplace($this$posterize.clone(), nbits);
    }

    public static /* synthetic */ Bitmap32 posterize$default(Bitmap32 bitmap32, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return Bitmap32Kt.posterize(bitmap32, n);
    }

    @NotNull
    public static final Bitmap32 posterizeInplace(@NotNull Bitmap32 $this$posterizeInplace, int nbits) {
        if (nbits == 0) {
            return $this$posterizeInplace;
        }
        int add1 = 1 << nbits;
        int lmask = (1 << nbits) - 1;
        int hlmask = lmask / 2;
        int mask = 0xFF & ~lmask;
        int[] array = RgbaArray.constructor-impl($this$posterizeInplace.getInts());
        int[] parray = RgbaPremultipliedArray.constructor-impl($this$posterizeInplace.getInts());
        int n = $this$posterizeInplace.getArea();
        for (int n2 = 0; n2 < n; ++n2) {
            int n3;
            if ($this$posterizeInplace.getPremultiplied()) {
                int arg0$iv = RgbaPremultipliedArray.get-UNGtISs(parray, n2);
                boolean bl = false;
                n3 = RGBAPremultiplied.getDepremultipliedAccurate-JH0Opww(arg0$iv);
            } else {
                n3 = RgbaArray.get-O1c-hRk(array, n2);
            }
            int rgba = n3;
            int hR = RGBA.getR-impl(rgba) & mask;
            int hG = RGBA.getG-impl(rgba) & mask;
            int hB = RGBA.getB-impl(rgba) & mask;
            int hA = RGBA.getA-impl(rgba) & mask;
            int lR = RGBA.getR-impl(rgba) & lmask;
            int lG = RGBA.getG-impl(rgba) & lmask;
            int lB = RGBA.getB-impl(rgba) & lmask;
            int lA = RGBA.getA-impl(rgba) & lmask;
            int orgba = RGBA.Companion.invoke-6bQucaA(lR > hlmask ? hR + add1 : hR, lG > hlmask ? hG + add1 : hG, lB > hlmask ? hB + add1 : hB, lA > hlmask ? hA + add1 : hA);
            if ($this$posterizeInplace.getPremultiplied()) {
                RgbaPremultipliedArray.set-ma3DQ24(parray, n2, RGBA.getPremultiplied-WnMhupY(orgba));
                continue;
            }
            RgbaArray.set-XDoMphA(array, n2, orgba);
        }
        return $this$posterizeInplace;
    }

    public static /* synthetic */ Bitmap32 posterizeInplace$default(Bitmap32 bitmap32, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return Bitmap32Kt.posterizeInplace(bitmap32, n);
    }

    public static final void expandBorder(@NotNull Bitmap32 $this$expandBorder, @NotNull RectangleI area, int border) {
        Bitmap32Kt.expandBorder($this$expandBorder, area.getTop(), area.getLeft(), area.getBottom(), area.getRight(), border);
    }

    public static final void expandBorder(@NotNull Bitmap32 $this$expandBorder, int areaTop, int areaLeft, int areaBottom, int areaRight, int border) {
        int[] data2 = $this$expandBorder.getInts();
        int x0Index = $this$expandBorder.index(areaLeft, areaTop);
        int x1Index = $this$expandBorder.index(areaRight - 1, areaTop);
        int areaWidth = areaRight - areaLeft;
        int areaHeight = areaBottom - areaTop;
        for (int n = 0; n < areaHeight; ++n) {
            int x0Color = data2[x0Index];
            int x1Color = data2[x1Index];
            for (int m = 0; m < border; ++m) {
                data2[x0Index - m - 1] = x0Color;
                data2[x1Index + m + 1] = x1Color;
            }
            x0Index += $this$expandBorder.getWidth();
            x1Index += $this$expandBorder.getWidth();
        }
        for (int m = 0; m < border; ++m) {
            int x = areaLeft - border;
            int npixels = areaWidth + border * 2;
            ArraysKt.arraycopy(data2, $this$expandBorder.index(x, areaTop), data2, $this$expandBorder.index(x, areaTop - m - 1), npixels);
            ArraysKt.arraycopy(data2, $this$expandBorder.index(x, areaBottom - 1), data2, $this$expandBorder.index(x, areaBottom + m), npixels);
        }
    }
}

