/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.image.bitmap.NativeImageKt;
import korlibs.image.color.RGBA;
import korlibs.image.color.RGBAPremultiplied;
import korlibs.image.vector.Context2d;
import korlibs.math.geom.Anchor2D;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.RectangleKt;
import korlibs.math.geom.ScaleMode;
import korlibs.math.geom.SizeKt;
import korlibs.math.geom.slice.RectSlice;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a8\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u0005\u001a;\u0010\u000e\u001a\u00020\u0007\"\b\b\u0000\u0010\u000f*\u00020\u0002*\u0002H\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u0002H\u000f2\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010\u001a&\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017\u001a8\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0001\u001a$\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0007*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005\u00a8\u0006\u001f"}, d2={"matchContents", "", "Lkorlibs/image/bitmap/Bitmap;", "that", "matchContentsDistinctCount", "", "putSliceWithBorder", "", "x", "y", "bmp", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/BmpSlice;", "border", "putWithBorder", "T", "(Lkorlibs/image/bitmap/Bitmap;IILkorlibs/image/bitmap/Bitmap;I)V", "resized", "out", "scale", "Lkorlibs/math/geom/ScaleMode;", "anchor", "Lkorlibs/math/geom/Anchor2D;", "Lkorlibs/math/geom/Anchor;", "width", "height", "native", "resizedUpTo", "setAlpha", "Lkorlibs/image/bitmap/Bitmap32;", "value", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBitmapExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapExt.kt\nkorlibs/image/bitmap/BitmapExtKt\n+ 2 Bitmap.kt\nkorlibs/image/bitmap/BitmapKt\n+ 3 Bitmap.kt\nkorlibs/image/bitmap/Bitmap\n*L\n1#1,81:1\n333#2,2:82\n335#2,7:89\n342#2:99\n72#3,5:84\n78#3,3:96\n*S KotlinDebug\n*F\n+ 1 BitmapExt.kt\nkorlibs/image/bitmap/BitmapExtKt\n*L\n65#1:82,2\n65#1:89,7\n65#1:99\n65#1:84,5\n65#1:96,3\n*E\n"})
public final class BitmapExtKt {
    public static final int matchContentsDistinctCount(@NotNull Bitmap $this$matchContentsDistinctCount, @NotNull Bitmap that) {
        if ($this$matchContentsDistinctCount.getWidth() != that.getWidth() || $this$matchContentsDistinctCount.getHeight() != that.getHeight()) {
            return -1;
        }
        Bitmap32 l = $this$matchContentsDistinctCount.toBMP32();
        Bitmap32 r = that.toBMP32();
        int width2 = l.getWidth();
        int height2 = l.getHeight();
        int rdiff = 0;
        int gdiff = 0;
        int bdiff = 0;
        int adiff = 0;
        for (int y = 0; y < height2; ++y) {
            for (int x = 0; x < width2; ++x) {
                int rgba1 = l.getRgbaPremultiplied-YdjHmOQ(x, y);
                int rgba2 = r.getRgbaPremultiplied-YdjHmOQ(x, y);
                rdiff += Math.abs(RGBAPremultiplied.getR-impl(rgba1) - RGBAPremultiplied.getR-impl(rgba2));
                gdiff += Math.abs(RGBAPremultiplied.getG-impl(rgba1) - RGBAPremultiplied.getG-impl(rgba2));
                bdiff += Math.abs(RGBAPremultiplied.getB-impl(rgba1) - RGBAPremultiplied.getB-impl(rgba2));
                adiff += Math.abs(RGBAPremultiplied.getA-impl(rgba1) - RGBAPremultiplied.getA-impl(rgba2));
            }
        }
        return rdiff + gdiff + bdiff + adiff;
    }

    public static final boolean matchContents(@NotNull Bitmap $this$matchContents, @NotNull Bitmap that) {
        return BitmapExtKt.matchContentsDistinctCount($this$matchContents, that) == 0;
    }

    public static final void setAlpha(@NotNull Bitmap32 $this$setAlpha, int value) {
        int n = $this$setAlpha.getInts().length;
        for (int n2 = 0; n2 < n; ++n2) {
            $this$setAlpha.getInts()[n2] = RGBA.Companion.invoke-GWFm98M(RGBA.getRgb-impl(RGBA.constructor-impl($this$setAlpha.getInts()[n2])), value);
        }
    }

    public static final <T extends Bitmap> void putWithBorder(@NotNull T $this$putWithBorder, int x, int y, @NotNull T bmp2, int border) {
        BitmapExtKt.putSliceWithBorder($this$putWithBorder, x, y, BitmapSliceKt.slice-pvcgspk$default(bmp2, null, null, 0, null, 15, null), border);
    }

    public static /* synthetic */ void putWithBorder$default(Bitmap bitmap, int n, int n2, Bitmap bitmap2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        BitmapExtKt.putWithBorder(bitmap, n, n2, bitmap2, n3);
    }

    public static final void putSliceWithBorder(@NotNull Bitmap $this$putSliceWithBorder, int x, int y, @NotNull RectSlice<? extends Bitmap> bmp2, int border) {
        int width2 = bmp2.getWidth();
        int height2 = bmp2.getHeight();
        BitmapSliceKt.getBmp(bmp2).copy(bmp2.getLeft(), bmp2.getTop(), $this$putSliceWithBorder, x, y, width2, height2);
        int n = 1;
        if (n <= border) {
            while (true) {
                $this$putSliceWithBorder.copy(x, y, $this$putSliceWithBorder, x - n, y, 1, height2);
                $this$putSliceWithBorder.copy(x + width2 - 1, y, $this$putSliceWithBorder, x + width2 - 1 + n, y, 1, height2);
                if (n == border) break;
                ++n;
            }
        }
        if ((n = 1) <= border) {
            while (true) {
                int rwidth = width2 + border * 2;
                $this$putSliceWithBorder.copy(x - border, y, $this$putSliceWithBorder, x - border, y - n, rwidth, 1);
                $this$putSliceWithBorder.copy(x - border, y + height2 - 1, $this$putSliceWithBorder, x - border, y + height2 - 1 + n, rwidth, 1);
                if (n == border) break;
                ++n;
            }
        }
    }

    public static /* synthetic */ void putSliceWithBorder$default(Bitmap bitmap, int n, int n2, RectSlice rectSlice, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        BitmapExtKt.putSliceWithBorder(bitmap, n, n2, rectSlice, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Bitmap resized(@NotNull Bitmap $this$resized, @NotNull Bitmap out, @NotNull ScaleMode scale, @NotNull Anchor2D anchor) {
        void $this$context2d_u24default$iv;
        Bitmap bmp2 = $this$resized;
        int width2 = out.getWidth();
        int height2 = out.getHeight();
        Bitmap bitmap = out;
        boolean antialiased$iv = true;
        boolean doLock$iv = true;
        boolean $i$f$context2d = false;
        RectangleI rect$iv$iv = $this$context2d_u24default$iv.getRect();
        boolean $i$f$lock = false;
        $this$context2d_u24default$iv.lock();
        int result$iv$iv = 0;
        try {
            boolean bl = false;
            Context2d ctx$iv = $this$context2d_u24default$iv.getContext2d(antialiased$iv);
            try {
                Context2d $this$resized_u24lambda_u240 = ctx$iv;
                boolean bl2 = false;
                RectangleD rect = RectangleKt.place(RectangleD.Companion.invoke(0, 0, width2, height2), SizeKt.toFloat(bmp2.getSize()), anchor, scale);
                $this$resized_u24lambda_u240.drawImage(bmp2, rect.getPosition(), rect.getSize());
            }
            finally {
                ctx$iv.dispose();
            }
        }
        finally {
            result$iv$iv = $this$context2d_u24default$iv.unlock(rect$iv$iv);
        }
        return out;
    }

    @NotNull
    public static final Bitmap resized(@NotNull Bitmap $this$resized, int width2, int height2, @NotNull ScaleMode scale, @NotNull Anchor2D anchor, boolean bl) {
        return BitmapExtKt.resized($this$resized, bl ? (Bitmap)NativeImageKt.NativeImage$default(width2, height2, null, 4, null) : $this$resized.createWithThisFormat(width2, height2), scale, anchor);
    }

    public static /* synthetic */ Bitmap resized$default(Bitmap bitmap, int n, int n2, ScaleMode scaleMode, Anchor2D anchor2D, boolean bl, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        return BitmapExtKt.resized(bitmap, n, n2, scaleMode, anchor2D, bl);
    }

    @NotNull
    public static final Bitmap resizedUpTo(@NotNull Bitmap $this$resizedUpTo, int width2, int height2, boolean bl) {
        RectangleD rect = RectangleKt.place(RectangleD.Companion.invoke(0, 0, width2, height2), SizeKt.toFloat($this$resizedUpTo.getSize()), Anchor2D.Companion.getTOP_LEFT(), ScaleMode.Companion.getFIT());
        return BitmapExtKt.resized($this$resizedUpTo, (int)rect.getWidth(), (int)rect.getHeight(), ScaleMode.Companion.getFILL(), Anchor2D.Companion.getTOP_LEFT(), bl);
    }

    public static /* synthetic */ Bitmap resizedUpTo$default(Bitmap bitmap, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return BitmapExtKt.resizedUpTo(bitmap, n, n2, bl);
    }
}

