/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.math.ILogKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.BitsKt;
import korlibs.memory.UByteArrayInt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001f\u001a\u00020\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0001H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\u0019\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0086\nJ\u0018\u0010'\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0016J%\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010-J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u0016\u0010.\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u0016\u0010/\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J!\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0086\nJ \u00103\u001a\u0002012\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u0002012\u0006\u0010)\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0016J\u0016\u00105\u001a\u0002012\u0006\u0010&\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0007J \u00105\u001a\u0002012\u0006\u0010&\u001a\u00020\u00032\u0006\u00106\u001a\u000207\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109J.\u0010:\u001a\u0002012\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J\u0006\u0010<\u001a\u00020\u0000J\u0018\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u0003H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010\b\u001a\u00020DJ\b\u0010E\u001a\u00020DH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0019\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0013\u0010\fR\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u00020\tX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006F"}, d2={"Lkorlibs/image/bitmap/BitmapIndexed;", "Lkorlibs/image/bitmap/Bitmap;", "bpp", "", "width", "height", "bytes", "", "palette", "Lkorlibs/image/color/RgbaArray;", "(III[B[ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBytes", "()[B", "setBytes", "([B)V", "data", "getData", "datau", "Lkorlibs/memory/UByteArrayInt;", "getDatau-uV-T8J8", "[B", "n8_dbpp", "n8_dbppLog2", "n8_dbppMask", "getPalette-FROm4YY", "()[I", "setPalette-2N1wtbg", "([I)V", "[I", "temp", "getTemp", "computeMaxReferencedColors", "contentEquals", "", "other", "contentHashCode", "get", "x", "y", "getInt", "getIntIndex", "n", "getRgbaRaw", "Lkorlibs/image/color/RGBA;", "getRgbaRaw-GWFm98M", "(II)I", "index_d", "index_m", "set", "", "color", "setInt", "setIntIndex", "setRow", "row", "Lkotlin/UByteArray;", "setRow-VU-fvBY", "(I[B)V", "setRowChunk", "increment", "setWhitescalePalette", "swapRows", "y0", "y1", "toBMP32", "Lkorlibs/image/bitmap/Bitmap32;", "toLines", "", "", "toString", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBitmapIndexed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapIndexed.kt\nkorlibs/image/bitmap/BitmapIndexed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,112:1\n31#1:113\n31#1:117\n1549#2:114\n1620#2,2:115\n1622#2:118\n7#3:119\n*S KotlinDebug\n*F\n+ 1 BitmapIndexed.kt\nkorlibs/image/bitmap/BitmapIndexed\n*L\n50#1:113\n82#1:117\n82#1:114\n82#1:115,2\n82#1:118\n104#1:119\n*E\n"})
public abstract class BitmapIndexed
extends Bitmap {
    @NotNull
    private byte[] bytes;
    @NotNull
    private int[] palette;
    @NotNull
    private final byte[] temp;
    @NotNull
    private final byte[] datau;
    private final int n8_dbpp;
    private final int n8_dbppLog2;
    private final int n8_dbppMask;

    private BitmapIndexed(int bpp, int width2, int height2, byte[] bytes, int[] palette) {
        super(width2, height2, bpp, false, bytes);
        this.bytes = bytes;
        this.palette = palette;
        if (this.bytes.length < width2 * height2 / (8 / bpp)) {
            throw new RuntimeException("Bitmap data is too short: width=" + width2 + ", height=" + height2 + ", data=ByteArray(" + this.getData().length + "), area=" + width2 * height2);
        }
        this.temp = new byte[Math.max(width2, height2)];
        this.datau = UByteArrayInt.constructor-impl(this.getData());
        this.n8_dbpp = 8 / bpp;
        this.n8_dbppLog2 = ILogKt.ilog2(this.n8_dbpp);
        this.n8_dbppMask = this.n8_dbpp - 1;
    }

    public /* synthetic */ BitmapIndexed(int n, int n2, int n3, byte[] byArray, int[] nArray, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            byArray = new byte[n2 * n3 / (8 / n)];
        }
        if ((n4 & 0x10) != 0) {
            nArray = RgbaArray.Companion.invoke-lrAz6eQ(1 << n);
        }
        this(n, n2, n3, byArray, nArray, null);
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(@NotNull byte[] byArray) {
        this.bytes = byArray;
    }

    @NotNull
    public final int[] getPalette-FROm4YY() {
        return this.palette;
    }

    public final void setPalette-2N1wtbg(@NotNull int[] nArray) {
        this.palette = nArray;
    }

    @NotNull
    public final byte[] getData() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        return "BitmapIndexed(bpp=" + this.getBpp() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", clut=" + RgbaArray.getSize-impl(this.palette) + ")";
    }

    @NotNull
    protected final byte[] getTemp() {
        return this.temp;
    }

    @NotNull
    public final byte[] getDatau-uV-T8J8() {
        return this.datau;
    }

    public final int get(int x, int y) {
        boolean $i$f$get = false;
        return this.getInt(x, y);
    }

    public final void set(int x, int y, int color2) {
        boolean $i$f$set = false;
        this.setInt(x, y, color2);
    }

    @Override
    public int getInt(int x, int y) {
        return this.getIntIndex(this.index(x, y));
    }

    @Override
    public void setInt(int x, int y, int color2) {
        this.setIntIndex(this.index(x, y), color2);
    }

    public int getIntIndex(int n) {
        int iD = this.index_d(n);
        int iM = this.index_m(n);
        return BitsKt.extract(UByteArrayInt.get-impl(this.datau, iD), this.getBpp() * iM, this.getBpp());
    }

    public void setIntIndex(int n, int color2) {
        int iD = this.index_d(n);
        int iM = this.index_m(n);
        UByteArrayInt.set-impl(this.datau, iD, BitsKt.insert(UByteArrayInt.get-impl(this.datau, iD), color2, this.getBpp() * iM, this.getBpp()));
    }

    @Override
    public int getRgbaRaw-GWFm98M(int x, int y) {
        BitmapIndexed this_$iv = this;
        boolean $i$f$get = false;
        return RgbaArray.get-O1c-hRk(this.palette, this_$iv.getInt(x, y));
    }

    public final int index_d(int x, int y) {
        return this.index_d(this.index(x, y));
    }

    public final int index_m(int x, int y) {
        return this.index_m(this.index(x, y));
    }

    public final int index_d(int n) {
        return n >>> this.n8_dbppLog2;
    }

    public final int index_m(int n) {
        return n & this.n8_dbppMask;
    }

    public final void setRow-VU-fvBY(int y, @NotNull byte[] row) {
        ArraysKt.arraycopy(row, 0, this.getData(), this.index(0, y), this.getStride());
    }

    public final void setRow(int y, @NotNull byte[] row) {
        ArraysKt.arraycopy(row, 0, this.getData(), this.index(0, y), this.getStride());
    }

    @NotNull
    public final BitmapIndexed setWhitescalePalette() {
        BitmapIndexed $this$setWhitescalePalette_u24lambda_u240 = this;
        boolean bl = false;
        int n = RgbaArray.getSize-impl($this$setWhitescalePalette_u24lambda_u240.palette);
        for (int n2 = 0; n2 < n; ++n2) {
            int col = (int)((float)n2 / (float)RgbaArray.getSize-impl($this$setWhitescalePalette_u24lambda_u240.palette) * (float)255);
            RgbaArray.set-XDoMphA($this$setWhitescalePalette_u24lambda_u240.palette, n2, RGBA.Companion.invoke-6bQucaA(col, col, col, 255));
        }
        return $this$setWhitescalePalette_u24lambda_u240;
    }

    @Override
    public void swapRows(int y0, int y1) {
        int s0 = this.index_d(0, y0);
        int s1 = this.index_d(0, y1);
        ArraysKt.arraycopy(this.getData(), s0, this.temp, 0, this.getStride());
        ArraysKt.arraycopy(this.getData(), s1, this.getData(), s0, this.getStride());
        ArraysKt.arraycopy(this.temp, 0, this.getData(), s1, this.getStride());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toLines(@NotNull String palette) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RangesKt.until(0, this.getHeight());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = RangesKt.until(0, this.getHeight());
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                void y;
                void x;
                int item$iv$iv2;
                int n2 = item$iv$iv2 = ((IntIterator)iterator3).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                BitmapIndexed this_$iv = this;
                boolean $i$f$get = false;
                collection2.add(Character.valueOf(palette.charAt(this_$iv.getInt((int)x, (int)y))));
            }
            collection.add(CollectionsKt.joinToString$default((List)destination$iv$iv2, "", null, null, 0, null, null, 62, null));
        }
        return (List)destination$iv$iv;
    }

    public final void setRowChunk(int x, int y, @NotNull byte[] data2, int width2, int increment) {
        if (increment == 1) {
            ArraysKt.arraycopy(data2, 0, this.getData(), this.index(x, y), width2 / this.n8_dbpp);
        } else {
            int m = this.index(x, y);
            int n = width2 / this.n8_dbpp;
            for (int n2 = 0; n2 < n; ++n2) {
                this.getData()[m] = data2[n2];
                m += increment;
            }
        }
    }

    public final int computeMaxReferencedColors() {
        int maxRefColor = -1;
        int n = this.getArea();
        for (int n2 = 0; n2 < n; ++n2) {
            maxRefColor = Math.max(maxRefColor, this.getIntIndex(n2));
        }
        return maxRefColor + 1;
    }

    @Override
    public boolean contentEquals(@NotNull Bitmap other) {
        return other instanceof BitmapIndexed && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight() && Arrays.equals(this.getData(), ((BitmapIndexed)other).getData());
    }

    @Override
    public int contentHashCode() {
        boolean $this$toInt$iv = this.getPremultiplied();
        boolean $i$f$toInt = false;
        return this.getWidth() * 31 + this.getHeight() + Arrays.hashCode(this.getData()) + ($this$toInt$iv ? 1 : 0);
    }

    @Override
    @NotNull
    public Bitmap32 toBMP32() {
        Bitmap32 bitmap32;
        Bitmap32 outBmp = bitmap32 = new Bitmap32(this.getWidth(), this.getHeight(), null, this.getPremultiplied(), 4, null);
        boolean bl = false;
        int[] out = outBmp.getInts();
        int[] pal = this.palette;
        int n = this.getArea();
        for (int n2 = 0; n2 < n; ++n2) {
            out[n2] = pal[this.getIntIndex(n2)];
        }
        return bitmap32;
    }

    public /* synthetic */ BitmapIndexed(int bpp, int width2, int height2, byte[] bytes, int[] palette, DefaultConstructorMarker $constructor_marker) {
        this(bpp, width2, height2, bytes, palette);
    }
}

