/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import korlibs.datastructure.FloatArray2;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.math.ClampKt;
import korlibs.math.ConvertRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010!\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0016J\u0018\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(J&\u0010)\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003J&\u0010,\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J&\u0010-\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u00063"}, d2={"Lkorlibs/image/bitmap/DistanceBitmap;", "", "width", "", "height", "d", "", "px", "", "py", "(II[F[I[I)V", "area", "getArea", "()I", "getD", "()[F", "getHeight", "getPx", "()[I", "getPy", "getWidth", "getDist", "", "x", "y", "getPosX", "getPosY", "getRPosX", "getRPosY", "inBounds", "", "inBoundsX", "inBoundsY", "index", "setDist", "", "setFromBitmap", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "thresold", "", "setPosRXY", "dx", "dy", "setPosXY", "setPosXYRel", "toFloatArray2", "Lkorlibs/datastructure/FloatArray2;", "toNormalizedDistanceBitmap8", "Lkorlibs/image/bitmap/Bitmap8;", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nDistanceBitmap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistanceBitmap.kt\nkorlibs/image/bitmap/DistanceBitmap\n+ 2 Assert.kt\nkorlibs/io/lang/AssertKt\n+ 3 RGBA.kt\nkorlibs/image/color/RgbaArray$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n4#2,2:165\n4#2,2:167\n4#2,2:169\n4#2,2:171\n4#2,2:173\n422#3:175\n1#4:176\n*S KotlinDebug\n*F\n+ 1 DistanceBitmap.kt\nkorlibs/image/bitmap/DistanceBitmap\n*L\n26#1:165,2\n27#1:167,2\n28#1:169,2\n71#1:171,2\n72#1:173,2\n141#1:175\n141#1:176\n*E\n"})
public final class DistanceBitmap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final float[] d;
    @NotNull
    private final int[] px;
    @NotNull
    private final int[] py;
    private final int area;
    private static final float d1 = 1.0f;
    private static final float d2 = 1.4142135f;

    public DistanceBitmap(int width2, int height2, @NotNull float[] d, @NotNull int[] px, @NotNull int[] py) {
        this.width = width2;
        this.height = height2;
        this.d = d;
        this.px = px;
        this.py = py;
        this.area = this.width * this.height;
        boolean cond$iv = this.d.length >= this.area;
        boolean $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        cond$iv = this.px.length >= this.area;
        $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        cond$iv = this.py.length >= this.area;
        $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
    }

    public /* synthetic */ DistanceBitmap(int n, int n2, float[] fArray, int[] nArray, int[] nArray2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            fArray = new float[n * n2];
        }
        if ((n3 & 8) != 0) {
            nArray = new int[n * n2];
        }
        if ((n3 & 0x10) != 0) {
            nArray2 = new int[n * n2];
        }
        this(n, n2, fArray, nArray, nArray2);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final float[] getD() {
        return this.d;
    }

    @NotNull
    public final int[] getPx() {
        return this.px;
    }

    @NotNull
    public final int[] getPy() {
        return this.py;
    }

    public final int getArea() {
        return this.area;
    }

    public final boolean inBoundsX(int x) {
        return x >= 0 && x < this.width;
    }

    public final boolean inBoundsY(int y) {
        return y >= 0 && y < this.height;
    }

    public final boolean inBounds(int x, int y) {
        return this.inBoundsX(x) && this.inBoundsY(y);
    }

    public final int index(int x, int y) {
        return y * this.width + x;
    }

    @NotNull
    public final FloatArray2 toFloatArray2() {
        return new FloatArray2(this.width, this.height, this.d);
    }

    public final float getDist(int x, int y) {
        return this.inBounds(x, y) ? this.d[this.index(x, y)] : Float.POSITIVE_INFINITY;
    }

    public final int getPosX(int x, int y) {
        return this.inBounds(x, y) ? this.px[this.index(x, y)] : -1;
    }

    public final int getPosY(int x, int y) {
        return this.inBounds(x, y) ? this.py[this.index(x, y)] : -1;
    }

    public final int getRPosX(int x, int y) {
        return this.inBounds(x, y) ? x - this.px[this.index(x, y)] : 0;
    }

    public final int getRPosY(int x, int y) {
        return this.inBounds(x, y) ? y - this.py[this.index(x, y)] : 0;
    }

    public final void setDist(int x, int y, float d) {
        if (!this.inBounds(x, y)) {
            return;
        }
        this.d[this.index((int)x, (int)y)] = d;
    }

    public final void setPosXY(int x, int y, int px, int py) {
        if (!this.inBounds(x, y)) {
            return;
        }
        int index2 = this.index(x, y);
        this.px[index2] = px;
        this.py[index2] = py;
    }

    public final void setPosRXY(int x, int y, int dx, int dy) {
        this.setPosXY(x, y, x + dx, y + dy);
    }

    public final void setPosXYRel(int x, int y, int px, int py) {
        this.setPosXY(x, y, this.getPosX(px, py), this.getPosY(px, py));
    }

    public final void setFromBitmap(@NotNull Bitmap bmp2, double thresold) {
        int x;
        int x2;
        int n;
        int y;
        boolean cond$iv = this.width == bmp2.getWidth();
        boolean $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        cond$iv = this.height == bmp2.getHeight();
        $i$f$assert = false;
        if (!cond$iv) {
            throw new AssertionError();
        }
        int thresoldInt = (int)(ClampKt.clamp01(thresold) * (double)255);
        int n2 = this.height;
        for (y = 0; y < n2; ++y) {
            n = this.width;
            for (x2 = 0; x2 < n; ++x2) {
                this.setDist(x2, y, Float.POSITIVE_INFINITY);
                this.setPosXY(x2, y, -1, -1);
            }
        }
        n2 = this.height;
        for (y = 0; y < n2; ++y) {
            n = this.width;
            for (x2 = 0; x2 < n; ++x2) {
                boolean cur = DistanceBitmap.setFromBitmap$getAlpha(bmp2, x2, y, thresoldInt);
                boolean left = DistanceBitmap.setFromBitmap$getAlpha(bmp2, x2 - 1, y, thresoldInt);
                boolean right = DistanceBitmap.setFromBitmap$getAlpha(bmp2, x2 + 1, y, thresoldInt);
                boolean up2 = DistanceBitmap.setFromBitmap$getAlpha(bmp2, x2, y - 1, thresoldInt);
                boolean down2 = DistanceBitmap.setFromBitmap$getAlpha(bmp2, x2, y + 1, thresoldInt);
                if (left == cur && right == cur && up2 == cur && down2 == cur) continue;
                this.setDist(x2, y, 0.0f);
                this.setPosXY(x2, y, x2, y);
            }
        }
        n2 = this.height;
        for (y = 0; y < n2; ++y) {
            n = this.width;
            for (x2 = 0; x2 < n; ++x2) {
                DistanceBitmap.setFromBitmap$pass(this, x2, y, -1, -1, 1.4142135f);
                DistanceBitmap.setFromBitmap$pass(this, x2, y, 0, -1, 1.0f);
                DistanceBitmap.setFromBitmap$pass(this, x2, y, 1, -1, 1.4142135f);
                DistanceBitmap.setFromBitmap$pass(this, x2, y, -1, 0, 1.0f);
            }
        }
        for (y = this.height - 1; -1 < y; --y) {
            for (x = this.width - 1; -1 < x; --x) {
                DistanceBitmap.setFromBitmap$pass(this, x, y, 1, 0, 1.0f);
                DistanceBitmap.setFromBitmap$pass(this, x, y, -1, 1, 1.4142135f);
                DistanceBitmap.setFromBitmap$pass(this, x, y, 0, 1, 1.0f);
                DistanceBitmap.setFromBitmap$pass(this, x, y, 1, 1, 1.4142135f);
            }
        }
        for (y = this.height - 1; -1 < y; --y) {
            for (x = this.width - 1; -1 < x; --x) {
                if (!DistanceBitmap.setFromBitmap$getAlpha(bmp2, x, y, thresoldInt)) continue;
                this.setDist(x, y, -this.getDist(x, y));
            }
        }
    }

    public static /* synthetic */ void setFromBitmap$default(DistanceBitmap distanceBitmap, Bitmap bitmap, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        distanceBitmap.setFromBitmap(bitmap, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap8 toNormalizedDistanceBitmap8() {
        int n;
        int[] nArray;
        void size$iv;
        int[] nArray2;
        RgbaArray.Companion companion = RgbaArray.Companion;
        int n2 = 256;
        byte[] byArray = null;
        int n3 = this.height;
        int n4 = this.width;
        boolean bl = false;
        int[] $this$invoke_Ufc9j94_u24lambda_u242$iv = nArray2 = RgbaArray.constructor-impl(new int[size$iv]);
        boolean bl2 = false;
        int n$iv = 0;
        while (n$iv < size$iv) {
            void it;
            int n5 = n$iv;
            int n6 = n$iv++;
            nArray = $this$invoke_Ufc9j94_u24lambda_u242$iv;
            boolean bl3 = false;
            int n7 = RGBA.Companion.invoke-6bQucaA((int)it, (int)it, (int)it, 255);
            RgbaArray.set-XDoMphA(nArray, n6, n7);
        }
        nArray = nArray2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n8 = 4;
        int[] nArray3 = nArray;
        byte[] byArray2 = byArray;
        int n9 = n3;
        int n10 = n4;
        Bitmap8 out = new Bitmap8(n10, n9, byArray2, nArray3, n8, defaultConstructorMarker);
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        int n11 = this.area;
        for (n = 0; n < n11; ++n) {
            min = Math.min(min, this.d[n]);
            max = Math.max(max, this.d[n]);
        }
        n11 = this.area;
        for (n = 0; n < n11; ++n) {
            out.getData()[n] = (byte)ConvertRangeKt.convertRange(this.d[n], min, max, 0.0f, 255.0f);
        }
        return out;
    }

    private static final boolean setFromBitmap$getAlpha(Bitmap $this$setFromBitmap_u24getAlpha, int x, int y, int min) {
        return $this$setFromBitmap_u24getAlpha.inBounds(x, y) ? RGBA.getA-impl($this$setFromBitmap_u24getAlpha.getRgbaRaw-GWFm98M(x, y)) >= min : false;
    }

    private static final void setFromBitmap$pass(DistanceBitmap this$0, int x, int y, int dx, int dy, float d) {
        if (this$0.getDist(x + dx, y + dy) + d < this$0.getDist(x, y)) {
            this$0.setPosXYRel(x, y, x + dx, y + dy);
            this$0.setDist(x, y, (float)Math.hypot(x - this$0.getPosX(x, y), y - this$0.getPosY(x, y)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkorlibs/image/bitmap/DistanceBitmap$Companion;", "", "()V", "d1", "", "d2", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

