/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.datastructure.Extra;
import korlibs.datastructure.ExtraObject;
import korlibs.datastructure.FastArrayListKt;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.io.util.RangesExtKt;
import korlibs.math.ClampKt;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.slice.RectSlice;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0003RSTBQ\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f\u00a2\u0006\u0002\u0010\rBc\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u0012\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f\u00a2\u0006\u0002\u0010\u0014J\u001b\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fH\u00c6\u0003J\u001b\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fH\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010<\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\fH\u00c6\u0003J\u0093\u0001\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060@j\u0002`A2\b\b\u0002\u0010B\u001a\u00020\u00112u\u0010C\u001aq\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(H\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(I\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020>0DJ\u0089\u0001\u0010J\u001a\u00020>2\n\u0010?\u001a\u00060@j\u0002`A2u\u0010C\u001aq\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(H\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(I\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020>0DJ\u0089\u0001\u0010K\u001a\u00020>2\n\u0010?\u001a\u00060@j\u0002`A2u\u0010C\u001aq\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(H\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(I\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bE\u0012\b\bF\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020>0DJo\u0010L\u001a\u00020\u00002\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f2\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\fH\u00c6\u0001J\u0013\u0010M\u001a\u00020\u00112\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010O\u001a\u00020\u0003H\u00d6\u0001J\t\u0010P\u001a\u00020QH\u00d6\u0001R!\u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u001d\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010$R\u000e\u00102\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010-R#\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010$R\u0017\u00106\u001a\b\u0012\u0004\u0012\u0002000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010$\u00a8\u0006U"}, d2={"Lkorlibs/image/bitmap/NinePatchInfo;", "", "width", "", "height", "left", "top", "right", "bottom", "content", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/Bitmap;", "Lkorlibs/image/bitmap/BmpSlice;", "(IIIIIILkorlibs/math/geom/slice/RectSlice;)V", "xranges", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "yranges", "(Ljava/util/List;Ljava/util/List;IILkorlibs/math/geom/slice/RectSlice;)V", "getContent", "()Lkorlibs/math/geom/slice/RectSlice;", "fixedHeight", "getFixedHeight", "()I", "fixedWidth", "getFixedWidth", "getHeight", "scaledHeight", "getScaledHeight", "scaledWidth", "getScaledWidth", "segments", "Lkorlibs/image/bitmap/NinePatchInfo$Segment;", "getSegments", "()Ljava/util/List;", "totalSegments", "getTotalSegments", "getWidth", "xComputed", "", "xaxis", "Lkorlibs/image/bitmap/NinePatchInfo$AxisInfo;", "getXaxis", "()Lkorlibs/image/bitmap/NinePatchInfo$AxisInfo;", "getXranges", "xsegments", "Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;", "getXsegments", "yComputed", "yaxis", "getYaxis", "getYranges", "ysegments", "getYsegments", "component1", "component2", "component3", "component4", "component5", "computeScale", "", "bounds", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "new", "callback", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "segment", "x", "y", "computeScaleNew", "computeScaleOld", "copy", "equals", "other", "hashCode", "toString", "", "AxisInfo", "AxisSegment", "Segment", "korge-core"})
@SourceDebugExtension(value={"SMAP\nNinePatchBitmap32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NinePatchBitmap32.kt\nkorlibs/image/bitmap/NinePatchInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n*L\n1#1,308:1\n1549#2:309\n1620#2,2:310\n1549#2:312\n1620#2,3:313\n1622#2:316\n1559#2:341\n1590#2,4:342\n1559#2:346\n1590#2,4:347\n350#2,7:357\n350#2,7:364\n107#3,6:317\n107#3,6:323\n107#3,3:329\n107#3,6:332\n110#3,3:338\n107#3,6:351\n*S KotlinDebug\n*F\n+ 1 NinePatchBitmap32.kt\nkorlibs/image/bitmap/NinePatchInfo\n*L\n73#1:309\n73#1:310,2\n74#1:312\n74#1:313,3\n73#1:316\n148#1:341\n148#1:342,4\n149#1:346\n149#1:347,4\n170#1:357,7\n171#1:364,7\n126#1:317,6\n127#1:323,6\n129#1:329,3\n131#1:332,6\n129#1:338,3\n161#1:351,6\n*E\n"})
public final class NinePatchInfo {
    @NotNull
    private final List<Pair<Boolean, IntRange>> xranges;
    @NotNull
    private final List<Pair<Boolean, IntRange>> yranges;
    private final int width;
    private final int height;
    @Nullable
    private final RectSlice<? extends Bitmap> content;
    @NotNull
    private final AxisInfo xaxis;
    @NotNull
    private final AxisInfo yaxis;
    @NotNull
    private final List<AxisSegment> xsegments;
    @NotNull
    private final List<AxisSegment> ysegments;
    private final int fixedWidth;
    private final int fixedHeight;
    private final int scaledWidth;
    private final int scaledHeight;
    @NotNull
    private final List<List<Segment>> segments;
    @NotNull
    private final int[] xComputed;
    @NotNull
    private final int[] yComputed;

    /*
     * WARNING - void declaration
     */
    public NinePatchInfo(@NotNull List<Pair<Boolean, IntRange>> xranges, @NotNull List<Pair<Boolean, IntRange>> yranges, int width2, int height2, @Nullable RectSlice<? extends Bitmap> content2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.xranges = xranges;
        this.yranges = yranges;
        this.width = width2;
        this.height = height2;
        this.content = content2;
        this.xaxis = new AxisInfo(this.xranges, this.width);
        this.yaxis = new AxisInfo(this.yranges, this.height);
        this.xsegments = this.xaxis.getSegments();
        this.ysegments = this.yaxis.getSegments();
        this.fixedWidth = this.xaxis.getFixedLen();
        this.fixedHeight = this.yaxis.getFixedLen();
        this.scaledWidth = this.xaxis.getScaledLen();
        this.scaledHeight = this.yaxis.getScaledLen();
        Iterable iterable = this.ysegments;
        NinePatchInfo ninePatchInfo = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            AxisSegment axisSegment = (AxisSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = this.xsegments;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void y;
                void x;
                AxisSegment axisSegment2 = (AxisSegment)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new Segment(this, RectangleI.Companion.fromBounds(x.getRange().getFirst(), y.getRange().getFirst(), x.getRange().getLast() + 1, y.getRange().getLast() + 1), (AxisSegment)x, (AxisSegment)y));
            }
            collection.add(FastArrayListKt.toFastList((List)destination$iv$iv2));
        }
        ninePatchInfo.segments = FastArrayListKt.toFastList((List)destination$iv$iv);
        this.xComputed = new int[64];
        this.yComputed = new int[64];
    }

    public /* synthetic */ NinePatchInfo(List list2, List list3, int n, int n2, RectSlice rectSlice, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            rectSlice = null;
        }
        this(list2, list3, n, n2, rectSlice);
    }

    @NotNull
    public final List<Pair<Boolean, IntRange>> getXranges() {
        return this.xranges;
    }

    @NotNull
    public final List<Pair<Boolean, IntRange>> getYranges() {
        return this.yranges;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @Nullable
    public final RectSlice<? extends Bitmap> getContent() {
        return this.content;
    }

    public NinePatchInfo(int width2, int height2, int left, int top, int right, int bottom, @Nullable RectSlice<? extends Bitmap> content2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to(false, RangesKt.until(0, left)), TuplesKt.to(true, RangesKt.until(left, right)), TuplesKt.to(false, RangesKt.until(right, width2))};
        List<Pair<Boolean, IntRange>> list2 = CollectionsKt.listOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(false, RangesKt.until(0, top)), TuplesKt.to(true, RangesKt.until(top, bottom)), TuplesKt.to(false, RangesKt.until(bottom, height2))};
        this(list2, CollectionsKt.listOf(pairArray), width2, height2, content2);
    }

    public /* synthetic */ NinePatchInfo(int n, int n2, int n3, int n4, int n5, int n6, RectSlice rectSlice, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x40) != 0) {
            rectSlice = null;
        }
        this(n, n2, n3, n4, n5, n6, rectSlice);
    }

    @NotNull
    public final AxisInfo getXaxis() {
        return this.xaxis;
    }

    @NotNull
    public final AxisInfo getYaxis() {
        return this.yaxis;
    }

    @NotNull
    public final List<AxisSegment> getXsegments() {
        return this.xsegments;
    }

    @NotNull
    public final List<AxisSegment> getYsegments() {
        return this.ysegments;
    }

    public final int getFixedWidth() {
        return this.fixedWidth;
    }

    public final int getFixedHeight() {
        return this.fixedHeight;
    }

    public final int getTotalSegments() {
        return this.xsegments.size() * this.ysegments.size();
    }

    public final int getScaledWidth() {
        return this.scaledWidth;
    }

    public final int getScaledHeight() {
        return this.scaledHeight;
    }

    @NotNull
    public final List<List<Segment>> getSegments() {
        return this.segments;
    }

    public final void computeScale(@NotNull RectangleI bounds2, boolean bl, @NotNull Function5<? super Segment, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> callback) {
        if (bl) {
            this.computeScaleNew(bounds2, callback);
        } else {
            this.computeScaleOld(bounds2, callback);
        }
    }

    public static /* synthetic */ void computeScale$default(NinePatchInfo ninePatchInfo, RectangleI rectangleI, boolean bl, Function5 function5, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ninePatchInfo.computeScale(rectangleI, bl, function5);
    }

    public final void computeScaleOld(@NotNull RectangleI bounds2, @NotNull Function5<? super Segment, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> callback) {
        int ry = 0;
        Iterator<AxisSegment> iterator2 = this.ysegments.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int yindex = n++;
            AxisSegment y = iterator2.next();
            int segHeight = (int)y.computedLength(this.yaxis, bounds2.getHeight());
            int rx = 0;
            Iterator<AxisSegment> iterator3 = this.xsegments.iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int xindex = n2++;
                AxisSegment x = iterator3.next();
                int segWidth = (int)x.computedLength(this.xaxis, bounds2.getWidth());
                Segment seg = this.segments.get(yindex).get(xindex);
                int segLeft = rx + bounds2.getLeft();
                int segTop = ry + bounds2.getTop();
                callback.invoke(seg, (Integer)segLeft, (Integer)segTop, (Integer)segWidth, (Integer)segHeight);
                rx += segWidth;
            }
            ry += segHeight;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void computeScaleNew(@NotNull RectangleI bounds2, @NotNull Function5<? super Segment, ? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> callback) {
        int yScaledFirst;
        Object $this$indexOfFirst$iv;
        int xScaledFirst;
        int yRemaining;
        int xRemaining;
        block20: {
            int n;
            int n2;
            block19: {
                void $this$mapIndexedTo$iv$iv;
                Collection collection;
                void $this$mapIndexedTo$iv$iv2;
                int n3;
                int index2;
                List<AxisSegment> $this$fastForEachWithIndex$iv = this.ysegments;
                boolean $i$f$fastForEachWithIndex = false;
                int n$iv = 0;
                while (n$iv < $this$fastForEachWithIndex$iv.size()) {
                    $this$fastForEachWithIndex$iv.get(n$iv);
                    index2 = n$iv++;
                    boolean bl = false;
                    this.yComputed[index2] = Integer.MAX_VALUE;
                }
                $this$fastForEachWithIndex$iv = this.xsegments;
                $i$f$fastForEachWithIndex = false;
                n$iv = 0;
                while (n$iv < $this$fastForEachWithIndex$iv.size()) {
                    $this$fastForEachWithIndex$iv.get(n$iv);
                    index2 = n$iv++;
                    boolean bl = false;
                    this.xComputed[index2] = Integer.MAX_VALUE;
                }
                $this$fastForEachWithIndex$iv = this.ysegments;
                $i$f$fastForEachWithIndex = false;
                for (n$iv = 0; n$iv < $this$fastForEachWithIndex$iv.size(); ++n$iv) {
                    void y;
                    AxisSegment axisSegment = $this$fastForEachWithIndex$iv.get(n$iv);
                    int yindex = n$iv;
                    boolean bl = false;
                    double segHeight = y.computedLength(this.yaxis, bounds2.getHeight());
                    List<AxisSegment> $this$fastForEachWithIndex$iv2 = this.xsegments;
                    boolean $i$f$fastForEachWithIndex2 = false;
                    for (int n$iv2 = 0; n$iv2 < $this$fastForEachWithIndex$iv2.size(); ++n$iv2) {
                        void x;
                        AxisSegment axisSegment2 = $this$fastForEachWithIndex$iv2.get(n$iv2);
                        int xindex = n$iv2;
                        n3 = 0;
                        double segWidth = x.computedLength(this.xaxis, bounds2.getWidth());
                        if (x.getFixed() && y.getFixed()) {
                            double xScale = segWidth / (double)x.getLength();
                            double yScale = segHeight / (double)y.getLength();
                            double minScale = Math.min(xScale, yScale);
                            this.xComputed[xindex] = Math.min(this.xComputed[xindex], (int)((double)x.getLength() * minScale));
                            this.yComputed[yindex] = Math.min(this.yComputed[yindex], (int)((double)y.getLength() * minScale));
                            continue;
                        }
                        this.xComputed[xindex] = Math.min(this.xComputed[xindex], (int)segWidth);
                        this.yComputed[yindex] = Math.min(this.yComputed[yindex], (int)segHeight);
                    }
                }
                int denormalizedWidth = ArraysKt.sum(this.xComputed);
                int denormalizedHeight = ArraysKt.sum(this.yComputed);
                Iterable $this$mapIndexed$iv = this.xsegments;
                boolean $i$f$mapIndexed = false;
                Iterable bl = $this$mapIndexed$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void index3;
                    void it2;
                    int x;
                    if ((x = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    AxisSegment xindex = (AxisSegment)item$iv$iv;
                    n3 = x;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it2.getScaled() ? this.xComputed[index3] : 0);
                }
                int denormalizedScaledWidth = CollectionsKt.sumOfInt((List)destination$iv$iv);
                Iterable $this$mapIndexed$iv2 = this.ysegments;
                boolean $i$f$mapIndexed2 = false;
                destination$iv$iv = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index4;
                    void it;
                    int it2;
                    if ((it2 = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    AxisSegment index3 = (AxisSegment)item$iv$iv;
                    int bl2 = it2;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(it.getScaled() ? this.yComputed[index4] : 0);
                }
                int denormalizedScaledHeight = CollectionsKt.sumOfInt((List)destination$iv$iv2);
                double xScaledRatio = denormalizedWidth > 0 ? (double)denormalizedScaledWidth / (double)denormalizedWidth : 1.0;
                double yScaledRatio = denormalizedWidth > 0 ? (double)denormalizedScaledHeight / (double)denormalizedHeight : 1.0;
                for (int n4 = 0; n4 < 2; ++n4) {
                    List<AxisSegment> segments = n4 == 0 ? this.ysegments : this.xsegments;
                    int[] computed2 = n4 == 0 ? this.yComputed : this.xComputed;
                    int denormalizedScaledLen = n4 == 0 ? denormalizedScaledHeight : denormalizedScaledWidth;
                    int side = n4 == 0 ? bounds2.getHeight() : bounds2.getWidth();
                    double scaledRatio = n4 == 0 ? yScaledRatio : xScaledRatio;
                    double scaledSide = (double)side * scaledRatio;
                    List<AxisSegment> $this$fastForEachWithIndex$iv3 = segments;
                    boolean $i$f$fastForEachWithIndex3 = false;
                    for (int n$iv3 = 0; n$iv3 < $this$fastForEachWithIndex$iv3.size(); ++n$iv3) {
                        void v;
                        AxisSegment minScale = $this$fastForEachWithIndex$iv3.get(n$iv3);
                        int index5 = n$iv3;
                        boolean bl4 = false;
                        if (!v.getScaled()) continue;
                        computed2[index5] = (int)(scaledSide * ((double)computed2[index5] / (double)denormalizedScaledLen));
                    }
                }
                xRemaining = bounds2.getWidth() - ArraysKt.sum(this.xComputed);
                yRemaining = bounds2.getHeight() - ArraysKt.sum(this.yComputed);
                List<AxisSegment> $this$indexOfFirst$iv2 = this.xsegments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<AxisSegment> index4 = $this$indexOfFirst$iv2.iterator();
                while (index4.hasNext()) {
                    AxisSegment item$iv;
                    AxisSegment it = item$iv = index4.next();
                    boolean bl5 = false;
                    if (it.getScaled()) {
                        n2 = index$iv;
                        break block19;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            xScaledFirst = n2;
            $this$indexOfFirst$iv = this.ysegments;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<AxisSegment> item$iv = $this$indexOfFirst$iv.iterator();
            while (item$iv.hasNext()) {
                AxisSegment item$iv2;
                AxisSegment it = item$iv2 = item$iv.next();
                boolean bl = false;
                if (it.getScaled()) {
                    n = index$iv;
                    break block20;
                }
                ++index$iv;
            }
            n = yScaledFirst = -1;
        }
        if (xRemaining > 0 && xScaledFirst >= 0) {
            $this$indexOfFirst$iv = this.xComputed;
            $this$indexOfFirst$iv[xScaledFirst] = $this$indexOfFirst$iv[xScaledFirst] + xRemaining;
        }
        if (yRemaining > 0 && yScaledFirst >= 0) {
            $this$indexOfFirst$iv = this.yComputed;
            $this$indexOfFirst$iv[yScaledFirst] = $this$indexOfFirst$iv[yScaledFirst] + yRemaining;
        }
        int ry = 0;
        int n = this.ysegments.size();
        for (int yindex = 0; yindex < n; ++yindex) {
            int segHeight = this.yComputed[yindex];
            int rx = 0;
            int n5 = this.xsegments.size();
            for (int xindex = 0; xindex < n5; ++xindex) {
                int segWidth = this.xComputed[xindex];
                Segment seg = this.segments.get(yindex).get(xindex);
                int segLeft = rx + bounds2.getLeft();
                int segTop = ry + bounds2.getTop();
                callback.invoke(seg, (Integer)segLeft, (Integer)segTop, (Integer)segWidth, (Integer)segHeight);
                rx += segWidth;
            }
            ry += segHeight;
        }
    }

    @NotNull
    public final List<Pair<Boolean, IntRange>> component1() {
        return this.xranges;
    }

    @NotNull
    public final List<Pair<Boolean, IntRange>> component2() {
        return this.yranges;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @Nullable
    public final RectSlice<? extends Bitmap> component5() {
        return this.content;
    }

    @NotNull
    public final NinePatchInfo copy(@NotNull List<Pair<Boolean, IntRange>> xranges, @NotNull List<Pair<Boolean, IntRange>> yranges, int width2, int height2, @Nullable RectSlice<? extends Bitmap> content2) {
        return new NinePatchInfo(xranges, yranges, width2, height2, content2);
    }

    public static /* synthetic */ NinePatchInfo copy$default(NinePatchInfo ninePatchInfo, List list2, List list3, int n, int n2, RectSlice rectSlice, int n3, Object object) {
        if ((n3 & 1) != 0) {
            list2 = ninePatchInfo.xranges;
        }
        if ((n3 & 2) != 0) {
            list3 = ninePatchInfo.yranges;
        }
        if ((n3 & 4) != 0) {
            n = ninePatchInfo.width;
        }
        if ((n3 & 8) != 0) {
            n2 = ninePatchInfo.height;
        }
        if ((n3 & 0x10) != 0) {
            rectSlice = ninePatchInfo.content;
        }
        return ninePatchInfo.copy(list2, list3, n, n2, rectSlice);
    }

    @NotNull
    public String toString() {
        return "NinePatchInfo(xranges=" + this.xranges + ", yranges=" + this.yranges + ", width=" + this.width + ", height=" + this.height + ", content=" + this.content + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.xranges).hashCode();
        result2 = result2 * 31 + ((Object)this.yranges).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.width);
        result2 = result2 * 31 + Integer.hashCode(this.height);
        result2 = result2 * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NinePatchInfo)) {
            return false;
        }
        NinePatchInfo ninePatchInfo = (NinePatchInfo)other;
        if (!Intrinsics.areEqual(this.xranges, ninePatchInfo.xranges)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.yranges, ninePatchInfo.yranges)) {
            return false;
        }
        if (this.width != ninePatchInfo.width) {
            return false;
        }
        if (this.height != ninePatchInfo.height) {
            return false;
        }
        return Intrinsics.areEqual(this.content, ninePatchInfo.content);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J/\u0010\u0017\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u001d"}, d2={"Lkorlibs/image/bitmap/NinePatchInfo$AxisInfo;", "", "ranges", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "totalLen", "", "(Ljava/util/List;I)V", "fixedLen", "getFixedLen", "()I", "getRanges", "()Ljava/util/List;", "scaledLen", "getScaledLen", "segments", "Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;", "getSegments", "getTotalLen", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nNinePatchBitmap32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NinePatchBitmap32.kt\nkorlibs/image/bitmap/NinePatchInfo$AxisInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1549#2:309\n1620#2,3:310\n766#2:313\n857#2,2:314\n766#2:317\n857#2,2:318\n1#3:316\n*S KotlinDebug\n*F\n+ 1 NinePatchBitmap32.kt\nkorlibs/image/bitmap/NinePatchInfo$AxisInfo\n*L\n46#1:309\n46#1:310,3\n47#1:313\n47#1:314,2\n48#1:317\n48#1:318,2\n*E\n"})
    public static final class AxisInfo {
        @NotNull
        private final List<Pair<Boolean, IntRange>> ranges;
        private final int totalLen;
        @NotNull
        private final List<AxisSegment> segments;
        private final int fixedLen;
        private final int scaledLen;

        /*
         * WARNING - void declaration
         */
        public AxisInfo(@NotNull List<Pair<Boolean, IntRange>> ranges, int totalLen) {
            int n;
            int n2;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv322;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.ranges = ranges;
            this.totalLen = totalLen;
            Iterable iterable = this.ranges;
            AxisInfo axisInfo = this;
            boolean $i$f$map22 = false;
            void var5_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AxisSegment((Boolean)it.getFirst(), (IntRange)it.getSecond()));
            }
            axisInfo.segments = FastArrayListKt.toFastList((List)destination$iv$iv);
            int n3 = 1;
            Iterable $i$f$map22 = this.segments;
            axisInfo = this;
            int $i$f$filter = 0;
            destination$iv$iv = $this$filter$iv322;
            Collection<Object> destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            item$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                element$iv$iv = item$iv$iv2.next();
                AxisSegment it = (AxisSegment)element$iv$iv;
                boolean bl = false;
                if (!it.getFixed()) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            $this$filter$iv322 = (List)destination$iv$iv22;
            $i$f$filter = 0;
            for (Collection<Object> destination$iv$iv22 : $this$filter$iv322) {
                void it;
                AxisSegment $i$f$filterTo2 = (AxisSegment)((Object)destination$iv$iv22);
                int n4 = $i$f$filter;
                boolean bl = false;
                n2 = it.getLength();
                $i$f$filter = n4 + n2;
            }
            int $this$filter$iv322 = n = $i$f$filter;
            axisInfo.fixedLen = Math.max(n3, $this$filter$iv322);
            n3 = 1;
            Iterable $this$filter$iv322 = this.segments;
            axisInfo = this;
            $i$f$filter = 0;
            $this$filterTo$iv$iv = $this$filter$iv322;
            destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo32 = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                AxisSegment it = (AxisSegment)element$iv$iv;
                boolean bl2 = false;
                if (!it.getScaled()) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv22;
            int n5 = 0;
            for (Object t : iterable2) {
                void it;
                AxisSegment $i$f$filterTo32 = (AxisSegment)t;
                n = n5;
                boolean bl3 = false;
                n2 = it.getLength();
                n5 = n + n2;
            }
            int n6 = n = n5;
            axisInfo.scaledLen = Math.max(n3, n6);
        }

        @NotNull
        public final List<Pair<Boolean, IntRange>> getRanges() {
            return this.ranges;
        }

        public final int getTotalLen() {
            return this.totalLen;
        }

        @NotNull
        public final List<AxisSegment> getSegments() {
            return this.segments;
        }

        public final int getFixedLen() {
            return this.fixedLen;
        }

        public final int getScaledLen() {
            return this.scaledLen;
        }

        @NotNull
        public final List<Pair<Boolean, IntRange>> component1() {
            return this.ranges;
        }

        public final int component2() {
            return this.totalLen;
        }

        @NotNull
        public final AxisInfo copy(@NotNull List<Pair<Boolean, IntRange>> ranges, int totalLen) {
            return new AxisInfo(ranges, totalLen);
        }

        public static /* synthetic */ AxisInfo copy$default(AxisInfo axisInfo, List list2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = axisInfo.ranges;
            }
            if ((n2 & 2) != 0) {
                n = axisInfo.totalLen;
            }
            return axisInfo.copy(list2, n);
        }

        @NotNull
        public String toString() {
            return "AxisInfo(ranges=" + this.ranges + ", totalLen=" + this.totalLen + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.ranges).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.totalLen);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AxisInfo)) {
                return false;
            }
            AxisInfo axisInfo = (AxisInfo)other;
            if (!Intrinsics.areEqual(this.ranges, axisInfo.ranges)) {
                return false;
            }
            return this.totalLen == axisInfo.totalLen;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0016"}, d2={"Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;", "", "scaled", "", "range", "Lkotlin/ranges/IntRange;", "(ZLkotlin/ranges/IntRange;)V", "fixed", "getFixed", "()Z", "length", "", "getLength", "()I", "getRange", "()Lkotlin/ranges/IntRange;", "getScaled", "computedLength", "", "axis", "Lkorlibs/image/bitmap/NinePatchInfo$AxisInfo;", "boundsLength", "korge-core"})
    public static final class AxisSegment {
        private final boolean scaled;
        @NotNull
        private final IntRange range;

        public AxisSegment(boolean scaled2, @NotNull IntRange range) {
            this.scaled = scaled2;
            this.range = range;
        }

        public final boolean getScaled() {
            return this.scaled;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public final boolean getFixed() {
            return !this.scaled;
        }

        public final int getLength() {
            return RangesExtKt.getLength(this.range);
        }

        public final double computedLength(@NotNull AxisInfo axis, int boundsLength) {
            double d;
            double scale = ClampKt.clamp((double)boundsLength / (double)axis.getTotalLen(), 0.0, 1.0);
            if (this.getFixed()) {
                d = (double)this.getLength() * scale;
            } else {
                double variableSize = (double)boundsLength - (double)axis.getFixedLen() * scale;
                d = variableSize * ((double)this.getLength() / (double)axis.getScaledLen());
            }
            return d;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\b\u0018\u00010\u0016j\u0002`\u0017X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'\u00a8\u0006)"}, d2={"Lkorlibs/image/bitmap/NinePatchInfo$Segment;", "Lkorlibs/datastructure/Extra;", "info", "Lkorlibs/image/bitmap/NinePatchInfo;", "rect", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "x", "Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;", "y", "(Lkorlibs/image/bitmap/NinePatchInfo;Lkorlibs/math/geom/RectangleI;Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;)V", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "getBmp", "()Lkorlibs/image/bitmap/Bitmap;", "bmp$delegate", "Lkotlin/Lazy;", "bmpSlice", "Lkorlibs/math/geom/slice/RectSlice;", "getBmpSlice", "()Lkorlibs/math/geom/slice/RectSlice;", "extra", "Lkorlibs/datastructure/ExtraObject;", "Lkorlibs/datastructure/ExtraType;", "getExtra", "()Lkorlibs/datastructure/ExtraObject;", "setExtra", "(Lkorlibs/datastructure/ExtraObject;)V", "getInfo", "()Lkorlibs/image/bitmap/NinePatchInfo;", "getRect", "()Lkorlibs/math/geom/RectangleI;", "scaleX", "", "getScaleX", "()Z", "scaleY", "getScaleY", "getX", "()Lkorlibs/image/bitmap/NinePatchInfo$AxisSegment;", "getY", "korge-core"})
    public static final class Segment
    implements Extra {
        @NotNull
        private final NinePatchInfo info;
        @NotNull
        private final RectangleI rect;
        @NotNull
        private final AxisSegment x;
        @NotNull
        private final AxisSegment y;
        private final /* synthetic */ Extra.Mixin $$delegate_0;
        private final boolean scaleX;
        private final boolean scaleY;
        @Nullable
        private final RectSlice<? extends Bitmap> bmpSlice;
        @NotNull
        private final Lazy bmp$delegate;

        public Segment(@NotNull NinePatchInfo info2, @NotNull RectangleI rect, @NotNull AxisSegment x, @NotNull AxisSegment y) {
            this.info = info2;
            this.rect = rect;
            this.x = x;
            this.y = y;
            this.$$delegate_0 = new Extra.Mixin(null, 1, null);
            this.scaleX = this.x.getScaled();
            this.scaleY = this.y.getScaled();
            RectSlice<? extends Bitmap> rectSlice = this.info.getContent();
            this.bmpSlice = rectSlice != null ? RectSlice.slice-EjYV8UY$default(rectSlice, this.rect, null, false, 0, 14, null) : null;
            this.bmp$delegate = LazyKt.lazy((Function0)new Function0<Bitmap>(this){
                final /* synthetic */ Segment this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Bitmap invoke() {
                    RectSlice<? extends Bitmap> rectSlice = this.this$0.getBmpSlice();
                    return rectSlice != null ? BitmapSliceKt.extract(rectSlice) : null;
                }
            });
        }

        @NotNull
        public final NinePatchInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final RectangleI getRect() {
            return this.rect;
        }

        @NotNull
        public final AxisSegment getX() {
            return this.x;
        }

        @NotNull
        public final AxisSegment getY() {
            return this.y;
        }

        @Override
        @Nullable
        public ExtraObject getExtra() {
            return this.$$delegate_0.getExtra();
        }

        @Override
        public void setExtra(@Nullable ExtraObject extraObject) {
            this.$$delegate_0.setExtra(extraObject);
        }

        public final boolean getScaleX() {
            return this.scaleX;
        }

        public final boolean getScaleY() {
            return this.scaleY;
        }

        @Nullable
        public final RectSlice<? extends Bitmap> getBmpSlice() {
            return this.bmpSlice;
        }

        @Nullable
        public final Bitmap getBmp() {
            Lazy lazy = this.bmp$delegate;
            return (Bitmap)lazy.getValue();
        }
    }
}

