/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.bitmap.effect;

import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.bitmap.BitmapChannel;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a0\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a0\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a^\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00062K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00010\u000eH\u0082\b\u001a0\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\b\u001a\u00020\u0006\u001a\u0012\u0010\u0015\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\b\u001a\u00020\u0006\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\b\u001a\u00020\u0006\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"boxBlur", "", "scl", "", "tcl", "w", "", "h", "r", "boxBlurH", "boxBlurT", "boxesForGaussN3", "sigma", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "a", "b", "c", "gaussBlur", "blur", "Lkorlibs/image/bitmap/Bitmap32;", "Lkorlibs/image/bitmap/Bitmap8;", "blurInplace", "korge-core"})
@SourceDebugExtension(value={"SMAP\nBlur.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Blur.kt\nkorlibs/image/bitmap/effect/BlurKt\n*L\n1#1,144:1\n128#1,16:145\n*S KotlinDebug\n*F\n+ 1 Blur.kt\nkorlibs/image/bitmap/effect/BlurKt\n*L\n54#1:145,16\n*E\n"})
public final class BlurKt {
    @NotNull
    public static final Bitmap32 blur(@NotNull Bitmap32 $this$blur, int r) {
        Bitmap32 out = new Bitmap32($this$blur.getWidth() + r * 2, $this$blur.getHeight() + r * 2, null, $this$blur.getPremultiplied(), 4, null);
        Bitmap32.Companion.copyRect($this$blur, 0, 0, out, r, r, $this$blur.getWidth(), $this$blur.getHeight());
        out.premultiplyInplaceIfRequired();
        BlurKt.blurInplace(out, r);
        if (!$this$blur.getPremultiplied()) {
            out.depremultiplyInplaceIfRequired();
        }
        return out;
    }

    @NotNull
    public static final Bitmap8 blur(@NotNull Bitmap8 $this$blur, int r) {
        Bitmap8 out = new Bitmap8($this$blur.getWidth() + r * 2, $this$blur.getHeight() + r * 2, null, null, 12, null);
        Bitmap8.Companion.copyRect($this$blur, 0, 0, out, r, r, $this$blur.getWidth(), $this$blur.getHeight());
        BlurKt.blurInplace(out, r);
        return out;
    }

    public static final void blurInplace(@NotNull Bitmap32 $this$blurInplace, int r) {
        int r2 = RangesKt.coerceAtMost(RangesKt.coerceAtMost(r, $this$blurInplace.getWidth() / 2 - 1), $this$blurInplace.getHeight() / 2 - 1);
        Bitmap8 t1 = new Bitmap8($this$blurInplace.getWidth(), $this$blurInplace.getHeight(), null, null, 12, null);
        Bitmap8 t2 = new Bitmap8($this$blurInplace.getWidth(), $this$blurInplace.getHeight(), null, null, 12, null);
        for (int n = 0; n < 4; ++n) {
            BitmapChannel channel = BitmapChannel.Companion.get(n);
            $this$blurInplace.extractChannel(channel, t1);
            ArraysKt.arraycopy(t1.getData(), 0, t2.getData(), 0, t2.getArea());
            BlurKt.gaussBlur(t1.getData(), t2.getData(), $this$blurInplace.getWidth(), $this$blurInplace.getHeight(), r2);
            $this$blurInplace.writeChannel(channel, t2);
        }
    }

    public static final void blurInplace(@NotNull Bitmap8 $this$blurInplace, int r) {
        int r2 = RangesKt.coerceAtMost(RangesKt.coerceAtMost(r, $this$blurInplace.getWidth() / 2 - 1), $this$blurInplace.getHeight() / 2 - 1);
        Bitmap8 t2 = new Bitmap8($this$blurInplace.getWidth(), $this$blurInplace.getHeight(), null, null, 12, null);
        ArraysKt.arraycopy($this$blurInplace.getData(), 0, t2.getData(), 0, $this$blurInplace.getArea());
        BlurKt.gaussBlur(t2.getData(), $this$blurInplace.getData(), $this$blurInplace.getWidth(), $this$blurInplace.getHeight(), r2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void gaussBlur(byte[] scl, byte[] tcl, int w, int h, int r) {
        void v2;
        void v1;
        int a = 0;
        int b = 0;
        int c = 0;
        boolean $i$f$boxesForGaussN3 = false;
        int n$iv = 3;
        double wIdeal$iv = Math.sqrt(12.0 * (double)r * (double)r / (double)n$iv + 1.0);
        int wl$iv = ToIntegerConvertersKt.toIntFloor(wIdeal$iv);
        if (wl$iv % 2 == 0) {
            --wl$iv;
        }
        int wu$iv = wl$iv + 2;
        double mIdeal$iv = (12.0 * (double)r * (double)r - (double)(n$iv * wl$iv * wl$iv) - (double)(4 * n$iv * wl$iv) - (double)(3 * n$iv)) / (double)(-4 * wl$iv - 4);
        double m$iv = Math.rint(mIdeal$iv);
        int n = 0.0 < m$iv ? wl$iv : wu$iv;
        int n2 = 2.0 < m$iv ? wl$iv : wu$iv;
        int n3 = 1.0 < m$iv ? wl$iv : wu$iv;
        int v0 = n;
        boolean bl = false;
        a = v0;
        b = v1;
        c = v2;
        BlurKt.boxBlur(scl, tcl, w, h, (a - 1) / 2);
        BlurKt.boxBlur(tcl, scl, w, h, (b - 1) / 2);
        BlurKt.boxBlur(scl, tcl, w, h, (c - 1) / 2);
    }

    private static final void boxBlur(byte[] scl, byte[] tcl, int w, int h, int r) {
        ArraysKt.arraycopy(scl, 0, tcl, 0, scl.length);
        BlurKt.boxBlurH(tcl, scl, w, h, r);
        BlurKt.boxBlurT(scl, tcl, w, h, r);
    }

    private static final void boxBlurH(byte[] scl, byte[] tcl, int w, int h, int r) {
        int arr = r + r + 1;
        for (int i2 = 0; i2 < h; ++i2) {
            int j;
            int ti;
            int li = ti = i2 * w;
            int ri = ti + r;
            int fv = ByteArrayGetSetKt.getU8(scl, ti);
            int lv = ByteArrayGetSetKt.getU8(scl, ti + w - 1);
            int v = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                v += ByteArrayGetSetKt.getU8(scl, ti + j);
            }
            j = 0;
            if (j <= r) {
                while (true) {
                    tcl[ti++] = (byte)((v += ByteArrayGetSetKt.getU8(scl, ri++) - fv) / arr);
                    if (j == r) break;
                    ++j;
                }
            }
            int n = w - r;
            for (j = r + 1; j < n; ++j) {
                tcl[ti++] = (byte)((v += ByteArrayGetSetKt.getU8(scl, ri++) - ByteArrayGetSetKt.getU8(scl, li++)) / arr);
            }
            for (j = w - r; j < w; ++j) {
                tcl[ti++] = (byte)((v += lv - ByteArrayGetSetKt.getU8(scl, li++)) / arr);
            }
        }
    }

    private static final void boxBlurT(byte[] scl, byte[] tcl, int w, int h, int r) {
        int arr = r + r + 1;
        for (int i2 = 0; i2 < w; ++i2) {
            int j;
            int ti;
            int li = ti = i2;
            int ri = ti + r * w;
            int fv = ByteArrayGetSetKt.getU8(scl, ti);
            int lv = ByteArrayGetSetKt.getU8(scl, ti + w * (h - 1));
            int v = (r + 1) * fv;
            for (j = 0; j < r; ++j) {
                v += ByteArrayGetSetKt.getU8(scl, ti + j * w);
            }
            j = 0;
            if (j <= r) {
                while (true) {
                    tcl[ti] = (byte)((v += ByteArrayGetSetKt.getU8(scl, ri) - fv) / arr);
                    ri += w;
                    ti += w;
                    if (j == r) break;
                    ++j;
                }
            }
            int n = h - r;
            for (j = r + 1; j < n; ++j) {
                tcl[ti] = (byte)((v += ByteArrayGetSetKt.getU8(scl, ri) - ByteArrayGetSetKt.getU8(scl, li)) / arr);
                li += w;
                ri += w;
                ti += w;
            }
            for (j = h - r; j < h; ++j) {
                tcl[ti] = (byte)((v += lv - ByteArrayGetSetKt.getU8(scl, li)) / arr);
                li += w;
                ti += w;
            }
        }
    }

    private static final void boxesForGaussN3(int sigma, Function3<? super Integer, ? super Integer, ? super Integer, Unit> emit2) {
        boolean $i$f$boxesForGaussN3 = false;
        int n = 3;
        double wIdeal = Math.sqrt(12.0 * (double)sigma * (double)sigma / (double)n + 1.0);
        int wl = ToIntegerConvertersKt.toIntFloor(wIdeal);
        if (wl % 2 == 0) {
            --wl;
        }
        int wu = wl + 2;
        double mIdeal = (12.0 * (double)sigma * (double)sigma - (double)(n * wl * wl) - (double)(4 * n * wl) - (double)(3 * n)) / (double)(-4 * wl - 4);
        double m = Math.rint(mIdeal);
        emit2.invoke((Integer)(0.0 < m ? wl : wu), (Integer)(1.0 < m ? wl : wu), (Integer)(2.0 < m ? wl : wu));
    }
}

