/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.font;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.datastructure.ArrayListExtKt;
import korlibs.datastructure.DoubleArrayList;
import korlibs.datastructure.IntArrayList;
import korlibs.datastructure.IntMap;
import korlibs.datastructure.IntMapKt;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.stream.FastByteArrayInputStream;
import korlibs.io.stream.FastByteArrayInputStreamKt;
import korlibs.logger.Logger;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.vector.VectorBuilder;
import korlibs.math.geom.vector.VectorPath;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.random.Random;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lkorlibs/image/font/TtfCIDFont;", "", "()V", "logger", "Lkorlibs/logger/Logger;", "getLogger", "()Lkorlibs/logger/Logger;", "CFF", "CharStringType2", "korge-core"})
public final class TtfCIDFont {
    @NotNull
    public static final TtfCIDFont INSTANCE = new TtfCIDFont();
    @NotNull
    private static final Logger logger = Logger.Companion.invoke("TtfCIDFont");

    private TtfCIDFont() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\f\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0005J\u001c\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b*\u00020\u0005J\u0014\u0010\f\u001a\u00020\r*\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u000e\u001a\u00020\u0012*\u00020\u0005J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0005J\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0005J\u0014\u0010\u0017\u001a\u00020\u0016*\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0016\u00a8\u0006\u001d"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF;", "", "()V", "readCFF", "Lkorlibs/image/font/TtfCIDFont$CFF$CFFResult;", "Lkorlibs/io/stream/FastByteArrayInputStream;", "readDICTElement", "readDICTMap", "", "Lkorlibs/image/font/TtfCIDFont$CFF$Op;", "", "", "readEncodedReal", "", "readHeader", "", "readEncodedRealString", "", "", "readIndex", "Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "readOffSize", "", "readOffset", "offSize", "CFFResult", "DataIndex", "GlyphPath", "Op", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nTtfCIDFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\nkorlibs/logger/Logger\n+ 4 ArrayListExt.kt\nkorlibs/datastructure/ArrayListExtKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Assert.kt\nkorlibs/io/lang/AssertKt\n*L\n1#1,708:1\n1549#2:709\n1620#2,3:710\n140#3:713\n125#3:714\n15#4:715\n1#5:716\n4#6,2:717\n*S KotlinDebug\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF\n*L\n78#1:709\n78#1:710,3\n164#1:713\n164#1:714\n197#1:715\n197#1:716\n247#1:717,2\n*E\n"})
    public static final class CFF {
        @NotNull
        public static final CFF INSTANCE = new CFF();

        private CFF() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CFFResult readCFF(@NotNull FastByteArrayInputStream $this$readCFF) {
            List<Number> charstringsOffsets;
            this.readHeader($this$readCFF);
            DataIndex nameIndex = this.readIndex($this$readCFF);
            DataIndex topDictIndex = this.readIndex($this$readCFF);
            byte topDictByte = topDictIndex.get(0)[1];
            Map<Op, List<Number>> topDict = this.readDICTMap(FastByteArrayInputStreamKt.openFastStream$default(topDictIndex.get(0), 0, 1, null));
            DataIndex stringIndex = this.readIndex($this$readCFF);
            DataIndex globalSubrIndex = this.readIndex($this$readCFF);
            List<Number> privateSizeOffset = topDict.get(Op.Private);
            DataIndex localSubrsIndex = new DataIndex();
            Map<Object, Object> privateDict = MapsKt.emptyMap();
            if (privateSizeOffset != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = privateSizeOffset;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Number number = (Number)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.intValue());
                }
                List list2 = (List)destination$iv$iv;
                int privateSize = ((Number)list2.get(0)).intValue();
                int privateOffset = ((Number)list2.get(1)).intValue();
                privateDict = this.readDICTMap($this$readCFF.sliceWithSize(privateOffset, privateSize));
                List localSubrs = (List)privateDict.get(Op.Subrs);
                if (localSubrs != null) {
                    int subrsOffset = privateOffset + ((Number)CollectionsKt.last(localSubrs)).intValue();
                    localSubrsIndex = this.readIndex($this$readCFF.sliceStart(subrsOffset));
                }
            }
            List<Number> list3 = charstringsOffsets = topDict.get(Op.CharStrings);
            Intrinsics.checkNotNull(list3);
            int charstringsOffset = CollectionsKt.first(list3).intValue();
            DataIndex charstringsIndex = this.readIndex($this$readCFF.sliceStart(charstringsOffset));
            return new CFFResult(charstringsIndex, globalSubrIndex, localSubrsIndex, privateDict);
        }

        /*
         * WARNING - void declaration
         */
        public final void readHeader(@NotNull FastByteArrayInputStream $this$readHeader) {
            void this_$iv$iv;
            int versionMajor = $this$readHeader.readU8();
            int versionMinor = $this$readHeader.readU8();
            int headerSize = $this$readHeader.readU8();
            int offsetSize = $this$readHeader.readU8();
            if (versionMajor > 1) {
                throw new IllegalStateException("Only supported CFF version 1".toString());
            }
            Logger this_$iv = INSTANCE.getLogger();
            boolean $i$f$debug = false;
            Logger logger2 = this_$iv;
            Logger.Level level$iv$iv = Logger.Level.DEBUG;
            boolean $i$f$log = false;
            if (this_$iv$iv.isEnabled(level$iv$iv)) {
                Logger.Level level = level$iv$iv;
                void var12_12 = this_$iv$iv;
                boolean bl = false;
                String string = "CFF.versionMajor/Minor: " + versionMajor + "." + versionMinor + " : headerSize=" + headerSize + ", offsetSize=" + offsetSize;
                var12_12.actualLog(level, string);
            }
        }

        public final int readOffSize(@NotNull FastByteArrayInputStream $this$readOffSize) {
            return $this$readOffSize.readU8();
        }

        public final int readOffset(@NotNull FastByteArrayInputStream $this$readOffset, int offSize) {
            int n;
            int roffSize = offSize < 0 ? this.readOffSize($this$readOffset) : offSize;
            switch (roffSize) {
                case 1: {
                    n = $this$readOffset.readU8();
                    break;
                }
                case 2: {
                    n = $this$readOffset.readU16BE();
                    break;
                }
                case 3: {
                    n = $this$readOffset.readU24BE();
                    break;
                }
                case 4: {
                    n = $this$readOffset.readS32BE();
                    break;
                }
                default: {
                    ExceptionsKt.reserved(String.valueOf(roffSize));
                    throw new KotlinNothingValueException();
                }
            }
            return n;
        }

        public static /* synthetic */ int readOffset$default(CFF cFF, FastByteArrayInputStream fastByteArrayInputStream, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = -1;
            }
            return cFF.readOffset(fastByteArrayInputStream, n);
        }

        @NotNull
        public final DataIndex readIndex(@NotNull FastByteArrayInputStream $this$readIndex) {
            IntArrayList intArrayList;
            int count2 = $this$readIndex.readU16BE();
            if (count2 == 0) {
                return new DataIndex();
            }
            int offSize = this.readOffSize($this$readIndex);
            IntRange $this$mapInt$iv = RangesKt.until(0, count2 + 1);
            boolean $i$f$mapInt = false;
            IntArrayList it$iv = intArrayList = new IntArrayList(RangesKt.coerceAtLeast($this$mapInt$iv.getEndInclusive() - $this$mapInt$iv.getStart(), 0) / $this$mapInt$iv.getStep() + 1);
            boolean bl = false;
            int n = $this$mapInt$iv.getStart();
            int n2 = $this$mapInt$iv.getEndInclusive();
            int n3 = $this$mapInt$iv.getStep();
            if (n3 <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + n3 + ".");
            }
            int v$iv = n;
            int n4 = ProgressionUtilKt.getProgressionLastElement(n, n2, n3);
            int n5 = n3;
            if (v$iv <= n4) {
                while (true) {
                    int n6 = v$iv;
                    IntArrayList intArrayList2 = it$iv;
                    boolean bl2 = false;
                    int n7 = INSTANCE.readOffset($this$readIndex, offSize) - 1;
                    intArrayList2.add(n7);
                    if (v$iv == n4) break;
                    v$iv += n5;
                }
            }
            IntArrayList offsets = intArrayList;
            byte[] bytes = $this$readIndex.readBytesExact(offsets.last());
            return new DataIndex(offsets.toIntArray(), bytes);
        }

        @NotNull
        public final Map<Op, List<Number>> readDICTMap(@NotNull FastByteArrayInputStream $this$readDICTMap) {
            LinkedHashMap map2 = new LinkedHashMap();
            ArrayList<Object> values2 = new ArrayList<Object>();
            while ($this$readDICTMap.getHasMore()) {
                Object item2 = this.readDICTElement($this$readDICTMap);
                Object object = item2;
                if (object instanceof Op) {
                    ((Map)map2).put(item2, CollectionsKt.toList((Iterable)values2));
                    values2.clear();
                    continue;
                }
                if (!(object instanceof Number)) continue;
                values2.add(item2);
            }
            return map2;
        }

        @Nullable
        public final Object readDICTElement(@NotNull FastByteArrayInputStream $this$readDICTElement) {
            Object object;
            int b0 = $this$readDICTElement.readU8();
            int n = b0;
            boolean bl = 0 <= n ? n < 22 : false;
            if (bl) {
                object = Op.Companion.get(b0 == 12 ? b0 << 8 | $this$readDICTElement.readU8() : b0);
            } else {
                boolean bl2 = 22 <= n ? n < 28 : false;
                if (bl2) {
                    ExceptionsKt.getReserved();
                    throw new KotlinNothingValueException();
                }
                if (n == 28) {
                    object = (int)((short)($this$readDICTElement.readU8() << 8 | $this$readDICTElement.readU8()));
                } else if (n == 29) {
                    object = $this$readDICTElement.readU8() << 24 | $this$readDICTElement.readU8() << 16 | $this$readDICTElement.readU8() << 8 | $this$readDICTElement.readU8();
                } else if (n == 30) {
                    object = this.readEncodedReal($this$readDICTElement, false);
                } else {
                    if (n == 31) {
                        ExceptionsKt.getReserved();
                        throw new KotlinNothingValueException();
                    }
                    boolean bl3 = 32 <= n ? n < 247 : false;
                    if (bl3) {
                        object = b0 - 139;
                    } else {
                        boolean bl4 = 247 <= n ? n < 251 : false;
                        if (bl4) {
                            object = (b0 - 247) * 256 + $this$readDICTElement.readU8() + 108;
                        } else {
                            boolean bl5 = 251 <= n ? n < 255 : false;
                            if (bl5) {
                                object = -((b0 - 251) * 256) - $this$readDICTElement.readU8() - 108;
                            } else {
                                if (n == 255) {
                                    ExceptionsKt.getReserved();
                                    throw new KotlinNothingValueException();
                                }
                                ExceptionsKt.getUnreachable();
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                }
            }
            return object;
        }

        @NotNull
        public final String readEncodedRealString(@NotNull FastByteArrayInputStream $this$readEncodedRealString, boolean readHeader) {
            if (readHeader) {
                boolean cond$iv = $this$readEncodedRealString.readU8() == 30;
                boolean $i$f$assert = false;
                if (!cond$iv) {
                    throw new AssertionError();
                }
            }
            StringBuilder str = new StringBuilder();
            block4: while (true) {
                int n = $this$readEncodedRealString.readU8();
                int n2 = 0;
                while (true) {
                    if (n2 >= 2) continue block4;
                    int nibble = n >>> (1 - n2) * 4 & 0xF;
                    if (nibble == 15) break block4;
                    switch (nibble) {
                        case 15: {
                            break block4;
                        }
                        case 12: {
                            str.append("E-");
                            break;
                        }
                        default: {
                            int n3 = nibble;
                            str.append((0 <= n3 ? n3 < 10 : false) ? (char)(48 + nibble) : (n3 == 10 ? (char)46 : (n3 == 11 ? (char)69 : (n3 == 14 ? (char)45 : (char)48))));
                        }
                    }
                    ++n2;
                }
                break;
            }
            String string = str.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public static /* synthetic */ String readEncodedRealString$default(CFF cFF, FastByteArrayInputStream fastByteArrayInputStream, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return cFF.readEncodedRealString(fastByteArrayInputStream, bl);
        }

        public final double readEncodedReal(@NotNull FastByteArrayInputStream $this$readEncodedReal, boolean readHeader) {
            return Double.parseDouble(this.readEncodedRealString($this$readEncodedReal, readHeader));
        }

        public static /* synthetic */ double readEncodedReal$default(CFF cFF, FastByteArrayInputStream fastByteArrayInputStream, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return cFF.readEncodedReal(fastByteArrayInputStream, bl);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF$CFFResult;", "", "charstringsIndex", "Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "globalSubrIndex", "localSubrsIndex", "privateDict", "", "Lkorlibs/image/font/TtfCIDFont$CFF$Op;", "", "", "(Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;Ljava/util/Map;)V", "getCharstringsIndex", "()Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "defaultWidthX", "", "getDefaultWidthX", "()D", "setDefaultWidthX", "(D)V", "getGlobalSubrIndex", "getLocalSubrsIndex", "nominalWidthX", "getNominalWidthX", "setNominalWidthX", "getPrivateDict", "()Ljava/util/Map;", "getGlyphVector", "Lkorlibs/image/font/TtfCIDFont$CFF$GlyphPath;", "index", "", "flipY", "", "korge-core"})
        public static final class CFFResult {
            @NotNull
            private final DataIndex charstringsIndex;
            @NotNull
            private final DataIndex globalSubrIndex;
            @NotNull
            private final DataIndex localSubrsIndex;
            @NotNull
            private final Map<Op, List<Number>> privateDict;
            private double defaultWidthX;
            private double nominalWidthX;

            public CFFResult(@NotNull DataIndex charstringsIndex, @NotNull DataIndex globalSubrIndex, @NotNull DataIndex localSubrsIndex, @NotNull Map<Op, ? extends List<? extends Number>> privateDict) {
                this.charstringsIndex = charstringsIndex;
                this.globalSubrIndex = globalSubrIndex;
                this.localSubrsIndex = localSubrsIndex;
                this.privateDict = privateDict;
                List<Number> list2 = this.privateDict.get(Op.defaultWidthX);
                this.defaultWidthX = list2 != null && (list2 = CollectionsKt.firstOrNull(list2)) != null ? ((Number)((Object)list2)).doubleValue() : 0.0;
                List<Number> list3 = this.privateDict.get(Op.nominalWidthX);
                this.nominalWidthX = list3 != null && (list3 = CollectionsKt.firstOrNull(list3)) != null ? ((Number)((Object)list3)).doubleValue() : 0.0;
            }

            @NotNull
            public final DataIndex getCharstringsIndex() {
                return this.charstringsIndex;
            }

            @NotNull
            public final DataIndex getGlobalSubrIndex() {
                return this.globalSubrIndex;
            }

            @NotNull
            public final DataIndex getLocalSubrsIndex() {
                return this.localSubrsIndex;
            }

            @NotNull
            public final Map<Op, List<Number>> getPrivateDict() {
                return this.privateDict;
            }

            public final double getDefaultWidthX() {
                return this.defaultWidthX;
            }

            public final void setDefaultWidthX(double d) {
                this.defaultWidthX = d;
            }

            public final double getNominalWidthX() {
                return this.nominalWidthX;
            }

            public final void setNominalWidthX(double d) {
                this.nominalWidthX = d;
            }

            @NotNull
            public final GlyphPath getGlyphVector(int index2, boolean flipY) {
                CharStringType2.EvalContext evalCtx = new CharStringType2.EvalContext(this.globalSubrIndex, this.localSubrsIndex, this.defaultWidthX, this.nominalWidthX, index2, null, 32, null);
                VectorPath vp = new VectorPath(null, null, null, false, 15, null);
                byte[] bytes = this.charstringsIndex.get(index2);
                CharStringType2.eval$default(CharStringType2.INSTANCE, vp, FastByteArrayInputStreamKt.openFastStream$default(bytes, 0, 1, null), evalCtx, null, 0, 24, null);
                if (flipY) {
                    vp.scale(1.0, -1.0);
                }
                return new GlyphPath(vp, evalCtx.getWidth());
            }

            public static /* synthetic */ GlyphPath getGlyphVector$default(CFFResult cFFResult, int n, boolean bl, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    bl = true;
                }
                return cFFResult.getGlyphVector(n, bl);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\rH\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0096\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "", "", "()V", "offsets", "", "bytes", "([I[B)V", "getBytes", "()[B", "getOffsets", "()[I", "size", "", "getSize", "()I", "get", "index", "itemSize", "iterator", "", "toList", "", "toString", "", "korge-core"})
        @SourceDebugExtension(value={"SMAP\nTtfCIDFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF$DataIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,708:1\n1549#2:709\n1620#2,3:710\n1549#2:713\n1620#2,3:714\n*S KotlinDebug\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF$DataIndex\n*L\n186#1:709\n186#1:710,3\n189#1:713\n189#1:714,3\n*E\n"})
        public static final class DataIndex
        implements Iterable<byte[]>,
        KMappedMarker {
            @NotNull
            private final int[] offsets;
            @NotNull
            private final byte[] bytes;

            public DataIndex(@NotNull int[] offsets, @NotNull byte[] bytes) {
                this.offsets = offsets;
                this.bytes = bytes;
            }

            @NotNull
            public final int[] getOffsets() {
                return this.offsets;
            }

            @NotNull
            public final byte[] getBytes() {
                return this.bytes;
            }

            public DataIndex() {
                int[] nArray = new int[]{0};
                this(nArray, new byte[0]);
            }

            public final int getSize() {
                return this.offsets.length - 1;
            }

            public final int itemSize(int index2) {
                return this.offsets[index2 + 1] - this.offsets[index2];
            }

            @NotNull
            public final byte[] get(int index2) {
                byte[] byArray = this.bytes;
                int n = this.offsets[index2];
                int n2 = this.offsets[index2 + 1];
                return ArraysKt.copyOfRange(byArray, n, n2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<byte[]> toList() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, this.getSize());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.get((int)it));
                }
                return (List)destination$iv$iv;
            }

            @Override
            @NotNull
            public Iterator<byte[]> iterator() {
                return this.toList().iterator();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public String toString() {
                Collection<Integer> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = RangesKt.until(0, this.getSize());
                List<Integer> list2 = ArraysKt.toList(this.offsets);
                int n = this.getSize();
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.itemSize((int)it));
                }
                collection = (List)destination$iv$iv;
                return "DataIndex[" + n + "](" + list2 + ")(" + (List)collection + ")";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF$GlyphPath;", "", "path", "Lkorlibs/math/geom/vector/VectorPath;", "advanceWidth", "", "(Lkorlibs/math/geom/vector/VectorPath;D)V", "getAdvanceWidth", "()D", "getPath", "()Lkorlibs/math/geom/vector/VectorPath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "korge-core"})
        public static final class GlyphPath {
            @NotNull
            private final VectorPath path;
            private final double advanceWidth;

            public GlyphPath(@NotNull VectorPath path2, double advanceWidth) {
                this.path = path2;
                this.advanceWidth = advanceWidth;
            }

            @NotNull
            public final VectorPath getPath() {
                return this.path;
            }

            public final double getAdvanceWidth() {
                return this.advanceWidth;
            }

            @NotNull
            public final VectorPath component1() {
                return this.path;
            }

            public final double component2() {
                return this.advanceWidth;
            }

            @NotNull
            public final GlyphPath copy(@NotNull VectorPath path2, double advanceWidth) {
                return new GlyphPath(path2, advanceWidth);
            }

            public static /* synthetic */ GlyphPath copy$default(GlyphPath glyphPath, VectorPath vectorPath, double d, int n, Object object) {
                if ((n & 1) != 0) {
                    vectorPath = glyphPath.path;
                }
                if ((n & 2) != 0) {
                    d = glyphPath.advanceWidth;
                }
                return glyphPath.copy(vectorPath, d);
            }

            @NotNull
            public String toString() {
                return "GlyphPath(path=" + this.path + ", advanceWidth=" + this.advanceWidth + ")";
            }

            public int hashCode() {
                int result2 = this.path.hashCode();
                result2 = result2 * 31 + Double.hashCode(this.advanceWidth);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GlyphPath)) {
                    return false;
                }
                GlyphPath glyphPath = (GlyphPath)other;
                if (!Intrinsics.areEqual(this.path, glyphPath.path)) {
                    return false;
                }
                return Double.compare(this.advanceWidth, glyphPath.advanceWidth) == 0;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b=\b\u0086\u0081\u0002\u0018\u0000 @2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001@B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?\u00a8\u0006A"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF$Op;", "", "Lkorlibs/image/font/TtfCIDFont$CharStringType2$Token;", "id", "", "(Ljava/lang/String;II)V", "getId", "()I", "version", "Copyright", "Notice", "isFixedPitch", "FullName", "ItalicAngle", "FamilyName", "UnderlinePosition", "Weight", "UnderlineThickness", "FontBBox", "PaintType", "BlueValues", "CharstringType", "OtherBlues", "FontMatrix", "FamilyBlues", "StrokeWidth", "FamilyOtherBlues", "BlueScale", "StdHW", "BlueShift", "StdVW", "BlueFuzz", "StemSnapH", "UniqueID", "StemSnapV", "XUID", "ForceBold", "charset", "Encoding", "CharStrings", "LanguageGroup", "Private", "ExpansionFactor", "Subrs", "initialRandomSeed", "defaultWidthX", "SyntheicBase", "nominalWidthX", "PostScript", "vsindex", "BaseFontName", "blend", "BaseFontBlend", "vstore", "maxstack", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName", "Companion", "korge-core"})
        @SourceDebugExtension(value={"SMAP\nTtfCIDFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF$Op\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,708:1\n8541#2,2:709\n8801#2,4:711\n*S KotlinDebug\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CFF$Op\n*L\n313#1:709,2\n313#1:711,4\n*E\n"})
        public static final class Op
        extends Enum<Op>
        implements CharStringType2.Token {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private static final IntMap<Op> VALUES_BY_ID;
            public static final /* enum */ Op version;
            public static final /* enum */ Op Copyright;
            public static final /* enum */ Op Notice;
            public static final /* enum */ Op isFixedPitch;
            public static final /* enum */ Op FullName;
            public static final /* enum */ Op ItalicAngle;
            public static final /* enum */ Op FamilyName;
            public static final /* enum */ Op UnderlinePosition;
            public static final /* enum */ Op Weight;
            public static final /* enum */ Op UnderlineThickness;
            public static final /* enum */ Op FontBBox;
            public static final /* enum */ Op PaintType;
            public static final /* enum */ Op BlueValues;
            public static final /* enum */ Op CharstringType;
            public static final /* enum */ Op OtherBlues;
            public static final /* enum */ Op FontMatrix;
            public static final /* enum */ Op FamilyBlues;
            public static final /* enum */ Op StrokeWidth;
            public static final /* enum */ Op FamilyOtherBlues;
            public static final /* enum */ Op BlueScale;
            public static final /* enum */ Op StdHW;
            public static final /* enum */ Op BlueShift;
            public static final /* enum */ Op StdVW;
            public static final /* enum */ Op BlueFuzz;
            public static final /* enum */ Op StemSnapH;
            public static final /* enum */ Op UniqueID;
            public static final /* enum */ Op StemSnapV;
            public static final /* enum */ Op XUID;
            public static final /* enum */ Op ForceBold;
            public static final /* enum */ Op charset;
            public static final /* enum */ Op Encoding;
            public static final /* enum */ Op CharStrings;
            public static final /* enum */ Op LanguageGroup;
            public static final /* enum */ Op Private;
            public static final /* enum */ Op ExpansionFactor;
            public static final /* enum */ Op Subrs;
            public static final /* enum */ Op initialRandomSeed;
            public static final /* enum */ Op defaultWidthX;
            public static final /* enum */ Op SyntheicBase;
            public static final /* enum */ Op nominalWidthX;
            public static final /* enum */ Op PostScript;
            public static final /* enum */ Op vsindex;
            public static final /* enum */ Op BaseFontName;
            public static final /* enum */ Op blend;
            public static final /* enum */ Op BaseFontBlend;
            public static final /* enum */ Op vstore;
            public static final /* enum */ Op maxstack;
            public static final /* enum */ Op ROS;
            public static final /* enum */ Op CIDFontVersion;
            public static final /* enum */ Op CIDFontRevision;
            public static final /* enum */ Op CIDFontType;
            public static final /* enum */ Op CIDCount;
            public static final /* enum */ Op UIDBase;
            public static final /* enum */ Op FDArray;
            public static final /* enum */ Op FDSelect;
            public static final /* enum */ Op FontName;
            private static final /* synthetic */ Op[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Op(int id2) {
                this.id = id2;
            }

            public final int getId() {
                return this.id;
            }

            public static Op[] values() {
                return (Op[])$VALUES.clone();
            }

            public static Op valueOf(String value) {
                return Enum.valueOf(Op.class, value);
            }

            @NotNull
            public static EnumEntries<Op> getEntries() {
                return $ENTRIES;
            }

            /*
             * WARNING - void declaration
             */
            static {
                void $this$associateByTo$iv$iv;
                version = new Op(0);
                Copyright = new Op(3072);
                Notice = new Op(1);
                isFixedPitch = new Op(3073);
                FullName = new Op(2);
                ItalicAngle = new Op(3074);
                FamilyName = new Op(3);
                UnderlinePosition = new Op(3075);
                Weight = new Op(4);
                UnderlineThickness = new Op(3076);
                FontBBox = new Op(5);
                PaintType = new Op(3077);
                BlueValues = new Op(6);
                CharstringType = new Op(3078);
                OtherBlues = new Op(7);
                FontMatrix = new Op(3079);
                FamilyBlues = new Op(8);
                StrokeWidth = new Op(3080);
                FamilyOtherBlues = new Op(9);
                BlueScale = new Op(3081);
                StdHW = new Op(10);
                BlueShift = new Op(3082);
                StdVW = new Op(11);
                BlueFuzz = new Op(3083);
                StemSnapH = new Op(3084);
                UniqueID = new Op(13);
                StemSnapV = new Op(3085);
                XUID = new Op(14);
                ForceBold = new Op(3086);
                charset = new Op(15);
                Encoding = new Op(16);
                CharStrings = new Op(17);
                LanguageGroup = new Op(3089);
                Private = new Op(18);
                ExpansionFactor = new Op(3090);
                Subrs = new Op(19);
                initialRandomSeed = new Op(3091);
                defaultWidthX = new Op(20);
                SyntheicBase = new Op(3092);
                nominalWidthX = new Op(21);
                PostScript = new Op(3093);
                vsindex = new Op(22);
                BaseFontName = new Op(3094);
                blend = new Op(23);
                BaseFontBlend = new Op(3095);
                vstore = new Op(24);
                maxstack = new Op(25);
                ROS = new Op(3102);
                CIDFontVersion = new Op(3103);
                CIDFontRevision = new Op(3104);
                CIDFontType = new Op(3105);
                CIDCount = new Op(3106);
                UIDBase = new Op(3107);
                FDArray = new Op(3108);
                FDSelect = new Op(3109);
                FontName = new Op(3110);
                $VALUES = opArray = new Op[]{Op.version, Op.Copyright, Op.Notice, Op.isFixedPitch, Op.FullName, Op.ItalicAngle, Op.FamilyName, Op.UnderlinePosition, Op.Weight, Op.UnderlineThickness, Op.FontBBox, Op.PaintType, Op.BlueValues, Op.CharstringType, Op.OtherBlues, Op.FontMatrix, Op.FamilyBlues, Op.StrokeWidth, Op.FamilyOtherBlues, Op.BlueScale, Op.StdHW, Op.BlueShift, Op.StdVW, Op.BlueFuzz, Op.StemSnapH, Op.UniqueID, Op.StemSnapV, Op.XUID, Op.ForceBold, Op.charset, Op.Encoding, Op.CharStrings, Op.LanguageGroup, Op.Private, Op.ExpansionFactor, Op.Subrs, Op.initialRandomSeed, Op.defaultWidthX, Op.SyntheicBase, Op.nominalWidthX, Op.PostScript, Op.vsindex, Op.BaseFontName, Op.blend, Op.BaseFontBlend, Op.vstore, Op.maxstack, Op.ROS, Op.CIDFontVersion, Op.CIDFontRevision, Op.CIDFontType, Op.CIDCount, Op.UIDBase, Op.FDArray, Op.FDSelect, Op.FontName};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                Op[] $this$associateBy$iv = Op.values();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
                Op[] opArray = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                int n = ((void)$this$associateByTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void element$iv$iv;
                    void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[j];
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it.id, element$iv$iv);
                }
                VALUES_BY_ID = IntMapKt.toIntMap(destination$iv$iv);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lkorlibs/image/font/TtfCIDFont$CFF$Op$Companion;", "", "()V", "VALUES_BY_ID", "Lkorlibs/datastructure/IntMap;", "Lkorlibs/image/font/TtfCIDFont$CFF$Op;", "getVALUES_BY_ID", "()Lkorlibs/datastructure/IntMap;", "get", "id", "", "korge-core"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final IntMap<Op> getVALUES_BY_ID() {
                    return VALUES_BY_ID;
                }

                @Nullable
                public final Op get(int id2) {
                    return this.getVALUES_BY_ID().get(id2);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003<=>B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\fJE\u0010\u0018\u001a\u00020\u000f*\u00020\u000626\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00040\u001aH\u0086\bJ:\u0010\u001f\u001a\u00020\u000f*\u00020\u00112\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\n\u0010&\u001a\u00020\u000f*\u00020\u0011J:\u0010'\u001a\u00020\u000f*\u00020\u00112\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u001a\u0010.\u001a\u00020\u000f*\u00020\u00112\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\u001a\u00101\u001a\u00020\u000f*\u00020\u00112\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u000204J\u001a\u00105\u001a\u00020\u000f*\u00020\u00112\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\u001a\u00106\u001a\u00020\u000f*\u00020\u00112\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u000204J\n\u00107\u001a\u00020\u0004*\u00020\u0006J\u0012\u00108\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u00108\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\fJ\n\u00109\u001a\u00020\f*\u00020\u0013J0\u0010:\u001a\u00020\u000f*\u00020\u00062!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00040;H\u0086\bR(\u0010\u0005\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006?"}, d2={"Lkorlibs/image/font/TtfCIDFont$CharStringType2;", "", "()V", "value", "", "last", "Lkorlibs/datastructure/DoubleArrayList;", "getLast", "(Lkorlibs/datastructure/DoubleArrayList;)D", "setLast", "(Lkorlibs/datastructure/DoubleArrayList;D)V", "computeSubrBias", "", "count", "eval", "", "ctx", "Lkorlibs/math/geom/vector/VectorBuilder;", "s", "Lkorlibs/io/stream/FastByteArrayInputStream;", "evalCtx", "Lkorlibs/image/font/TtfCIDFont$CharStringType2$EvalContext;", "stack", "stackLevel", "binop", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "l", "r", "cfCubicTo", "fcx1", "fcy1", "fcx2", "fcy2", "fax", "fay", "cfrClose", "cfrCubicTo", "cx1", "cy1", "cx2", "cy2", "ax", "ay", "cfrLineTo", "x", "y", "cfrLineToHV", "v", "horizontal", "", "cfrMoveTo", "cfrMoveToHV", "pop", "push", "u8", "unop", "Lkotlin/Function1;", "EvalContext", "Op", "Token", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nTtfCIDFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CharStringType2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\nkorlibs/io/lang/AssertKt\n+ 4 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,708:1\n345#1,2:712\n339#1,3:714\n342#1:718\n339#1,3:719\n342#1:723\n345#1:724\n346#1:726\n339#1,3:727\n342#1:731\n345#1,2:732\n345#1,2:734\n345#1,2:736\n339#1,4:738\n339#1,4:742\n339#1,4:746\n339#1,4:750\n1#2:709\n4#3,2:710\n7#4:717\n7#4:722\n7#4:725\n7#4:730\n*S KotlinDebug\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CharStringType2\n*L\n466#1:712,2\n469#1:714,3\n469#1:718\n470#1:719,3\n470#1:723\n471#1:724\n471#1:726\n474#1:727,3\n474#1:731\n488#1:732,2\n489#1:734,2\n490#1:736,2\n492#1:738,4\n493#1:742,4\n494#1:746,4\n495#1:750,4\n457#1:710,2\n469#1:717\n470#1:722\n471#1:725\n474#1:730\n*E\n"})
    public static final class CharStringType2 {
        @NotNull
        public static final CharStringType2 INSTANCE = new CharStringType2();

        private CharStringType2() {
        }

        public final double getLast(@NotNull DoubleArrayList $this$last) {
            return $this$last.get($this$last.size() - 1);
        }

        public final void setLast(@NotNull DoubleArrayList $this$last, double value) {
            $this$last.set($this$last.size() - 1, value);
        }

        public final double pop(@NotNull DoubleArrayList $this$pop) {
            return $this$pop.removeAt($this$pop.size() - 1);
        }

        public final void push(@NotNull DoubleArrayList $this$push, double value) {
            $this$push.add(value);
        }

        public final void push(@NotNull DoubleArrayList $this$push, int value) {
            $this$push.add(value);
        }

        public final void binop(@NotNull DoubleArrayList $this$binop, @NotNull Function2<? super Double, ? super Double, Double> block2) {
            boolean $i$f$binop = false;
            double r = this.pop($this$binop);
            double l = this.pop($this$binop);
            this.push($this$binop, ((Number)block2.invoke((Double)l, (Double)r)).doubleValue());
        }

        public final void unop(@NotNull DoubleArrayList $this$unop, @NotNull Function1<? super Double, Double> block2) {
            boolean $i$f$unop = false;
            this.setLast($this$unop, ((Number)block2.invoke((Double)this.getLast($this$unop))).doubleValue());
        }

        public final void cfrClose(@NotNull VectorBuilder $this$cfrClose) {
            Vector2D lastPoint = $this$cfrClose.getLastPos();
            $this$cfrClose.close();
            $this$cfrClose.moveTo(lastPoint);
        }

        public final void cfrMoveTo(@NotNull VectorBuilder $this$cfrMoveTo, double x, double y) {
            $this$cfrMoveTo.rMoveTo(new Vector2D(x, y));
        }

        public final void cfrLineTo(@NotNull VectorBuilder $this$cfrLineTo, double x, double y) {
            $this$cfrLineTo.rLineTo(new Vector2D(x, y));
        }

        public final void cfCubicTo(@NotNull VectorBuilder $this$cfCubicTo, double fcx1, double fcy1, double fcx2, double fcy2, double fax, double fay) {
            $this$cfCubicTo.cubicTo(new Vector2D(fcx1, fcy1), new Vector2D(fcx2, fcy2), new Vector2D(fax, fay));
        }

        public final void cfrCubicTo(@NotNull VectorBuilder $this$cfrCubicTo, double cx1, double cy1, double cx2, double cy2, double ax, double ay) {
            double fcx1 = $this$cfrCubicTo.getLastPos().getX() + cx1;
            double fcy1 = $this$cfrCubicTo.getLastPos().getY() + cy1;
            double fcx2 = fcx1 + cx2;
            double fcy2 = fcy1 + cy2;
            double fax = fcx2 + ax;
            double fay = fcy2 + ay;
            this.cfCubicTo($this$cfrCubicTo, fcx1, fcy1, fcx2, fcy2, fax, fay);
        }

        public final void cfrMoveToHV(@NotNull VectorBuilder $this$cfrMoveToHV, double v, boolean horizontal) {
            this.cfrMoveTo($this$cfrMoveToHV, horizontal ? v : 0.0, !horizontal ? v : 0.0);
        }

        public final void cfrLineToHV(@NotNull VectorBuilder $this$cfrLineToHV, double v, boolean horizontal) {
            this.cfrLineTo($this$cfrLineToHV, horizontal ? v : 0.0, !horizontal ? v : 0.0);
        }

        public final int u8(@NotNull FastByteArrayInputStream $this$u8) {
            int n;
            int it = n = $this$u8.readU8();
            boolean bl = false;
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final void eval(@NotNull VectorBuilder ctx, @NotNull FastByteArrayInputStream s, @NotNull EvalContext evalCtx, @NotNull DoubleArrayList stack, int stackLevel) {
            block36: while (s.getHasMore()) {
                short s2;
                int v0 = this.u8(s);
                int n = v0;
                boolean bl = (0 <= n ? n < 28 : false) ? true : (29 <= n ? n < 32 : false);
                if (bl) {
                    Op op = Op.Companion.get(v0 == 12 ? v0 << 8 | this.u8(s) : v0);
                    switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
                        case 1: {
                            return;
                        }
                        case 2: {
                            if (!((Collection)stack).isEmpty() && !evalCtx.getHaveWidth()) {
                                evalCtx.setWidth(stack.get(0) + evalCtx.getNominalWidthX());
                                evalCtx.setHaveWidth(true);
                            }
                            if (ctx.getTotalPoints() != 0) {
                                this.cfrClose(ctx);
                            }
                            return;
                        }
                        case 3: 
                        case 4: {
                            boolean global = op == Op.callgsubr;
                            int funcOffset = (int)this.pop(stack);
                            byte[] bytes = global ? evalCtx.getGlobalSubrIndex().get(evalCtx.getGlobalBias() + funcOffset) : evalCtx.getLocalSubrsIndex().get(evalCtx.getLocalBias() + funcOffset);
                            this.eval(ctx, FastByteArrayInputStreamKt.openFastStream$default(bytes, 0, 1, null), evalCtx, stack, stackLevel + 1);
                            continue block36;
                        }
                        case 5: {
                            this.pop(stack);
                            continue block36;
                        }
                        case 6: {
                            double global;
                            double it = global = this.pop(stack);
                            boolean bl2 = false;
                            stack.add(it, it);
                            continue block36;
                        }
                        case 7: {
                            stack.swap(stack.size() - 2, stack.size() - 1);
                            continue block36;
                        }
                        case 8: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 9: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 10: {
                            double value;
                            double index2 = this.pop(stack);
                            evalCtx.getHeap()[(int)index2] = value = this.pop(stack);
                            continue block36;
                        }
                        case 11: {
                            void it;
                            void this_$iv;
                            CharStringType2 index2 = this;
                            DoubleArrayList $this$unop$iv = stack;
                            boolean $i$f$unop = false;
                            double bl2 = this_$iv.getLast($this$unop$iv);
                            DoubleArrayList doubleArrayList = $this$unop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl3 = false;
                            double d3 = evalCtx.getHeap()[(int)it];
                            charStringType2.setLast(doubleArrayList, d3);
                            continue block36;
                        }
                        case 12: {
                            void r;
                            double l;
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double d = r$iv;
                            double d2 = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl4 = false;
                            boolean $this$toInt$iv = !(l == 0.0) && !(r == 0.0);
                            boolean $i$f$toInt = false;
                            double d3 = $this$toInt$iv ? 1 : 0;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 13: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double r = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl5 = false;
                            boolean $this$toInt$iv = !(l == 0.0) || !(r == 0.0);
                            boolean $i$f$toInt = false;
                            double d3 = $this$toInt$iv ? 1 : 0;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 14: {
                            void it;
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$unop$iv = stack;
                            boolean $i$f$unop = false;
                            double r$iv = this_$iv.getLast($this$unop$iv);
                            DoubleArrayList doubleArrayList = $this$unop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl6 = false;
                            boolean $this$toInt$iv = it == 0.0;
                            boolean $i$f$toInt = false;
                            double d3 = $this$toInt$iv ? 1 : 0;
                            charStringType2.setLast(doubleArrayList, d3);
                            continue block36;
                        }
                        case 15: {
                            void r;
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double $i$f$toInt = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl7 = false;
                            boolean $this$toInt$iv = l == r;
                            boolean $i$f$toInt2 = false;
                            double d3 = $this$toInt$iv ? 1 : 0;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 16: {
                            double v2 = this.pop(stack);
                            double v1 = this.pop(stack);
                            double s22 = this.pop(stack);
                            double s1 = this.pop(stack);
                            this.push(stack, v1 <= v2 ? s1 : s22);
                            continue block36;
                        }
                        case 17: {
                            stack.add(Random.Default.nextDouble());
                            continue block36;
                        }
                        case 18: {
                            void it;
                            void this_$iv;
                            CharStringType2 v2 = this;
                            DoubleArrayList $this$unop$iv = stack;
                            boolean $i$f$unop = false;
                            double r$iv = this_$iv.getLast($this$unop$iv);
                            DoubleArrayList doubleArrayList = $this$unop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl8 = false;
                            double d3 = Math.sqrt((double)it);
                            charStringType2.setLast(doubleArrayList, d3);
                            continue block36;
                        }
                        case 19: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$unop$iv = stack;
                            boolean $i$f$unop = false;
                            double it = this_$iv.getLast($this$unop$iv);
                            DoubleArrayList doubleArrayList = $this$unop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl9 = false;
                            double d3 = Math.abs(it);
                            charStringType2.setLast(doubleArrayList, d3);
                            continue block36;
                        }
                        case 20: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$unop$iv = stack;
                            boolean $i$f$unop = false;
                            double it = this_$iv.getLast($this$unop$iv);
                            DoubleArrayList doubleArrayList = $this$unop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl10 = false;
                            double d3 = -it;
                            charStringType2.setLast(doubleArrayList, d3);
                            continue block36;
                        }
                        case 21: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double r = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl11 = false;
                            double d3 = l + r;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 22: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double r = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl12 = false;
                            double d3 = l - r;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 23: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double r = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl13 = false;
                            double d3 = l / r;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 24: {
                            CharStringType2 this_$iv = this;
                            DoubleArrayList $this$binop$iv = stack;
                            boolean $i$f$binop = false;
                            double r$iv = this_$iv.pop($this$binop$iv);
                            double l$iv = this_$iv.pop($this$binop$iv);
                            double r = r$iv;
                            double l = l$iv;
                            DoubleArrayList doubleArrayList = $this$binop$iv;
                            CharStringType2 charStringType2 = this_$iv;
                            boolean bl14 = false;
                            double d3 = l * r;
                            charStringType2.push(doubleArrayList, d3);
                            continue block36;
                        }
                        case 25: {
                            if (stack.size() > 2) {
                                evalCtx.setWidth(stack.get(0) + evalCtx.getNominalWidthX());
                                evalCtx.setHaveWidth(true);
                            }
                            if (ctx.getTotalPoints() != 0) {
                                this.cfrClose(ctx);
                            }
                            this.cfrMoveTo(ctx, stack.get(stack.size() - 2), stack.get(stack.size() - 1));
                            stack.clear();
                            continue block36;
                        }
                        case 26: 
                        case 27: {
                            if (stack.size() > 1) {
                                evalCtx.setWidth(stack.get(0) + evalCtx.getNominalWidthX());
                                evalCtx.setHaveWidth(true);
                            }
                            this.cfrMoveToHV(ctx, this.pop(stack), op == Op.hmoveto);
                            stack.clear();
                            continue block36;
                        }
                        case 28: {
                            IntProgression this_$iv = RangesKt.step(RangesKt.until(0, stack.size()), 2);
                            int n2 = this_$iv.getFirst();
                            int $i$f$binop = this_$iv.getLast();
                            int r$iv = this_$iv.getStep();
                            if (r$iv > 0 && n2 <= $i$f$binop || r$iv < 0 && $i$f$binop <= n2) {
                                while (true) {
                                    this.cfrLineTo(ctx, stack.get(n2), stack.get(n2 + 1));
                                    if (n2 == $i$f$binop) break;
                                    n2 += r$iv;
                                }
                            }
                            stack.clear();
                            continue block36;
                        }
                        case 29: 
                        case 30: {
                            boolean toggle = op == Op.hlineto;
                            int $i$f$binop = stack.size();
                            for (int n2 = 0; n2 < $i$f$binop; ++n2) {
                                this.cfrLineToHV(ctx, stack.get(n2), toggle);
                                toggle = !toggle;
                            }
                            stack.clear();
                            continue block36;
                        }
                        case 31: 
                        case 32: 
                        case 33: {
                            int n3 = 0;
                            if (op == Op.rlinecurve) {
                                while (stack.size() - n3 < 6) {
                                    this.cfrLineTo(ctx, stack.get(n3++), stack.get(n3++));
                                }
                            }
                            while (stack.size() - n3 >= 6) {
                                this.cfrCubicTo(ctx, stack.get(n3++), stack.get(n3++), stack.get(n3++), stack.get(n3++), stack.get(n3++), stack.get(n3++));
                            }
                            if (op == Op.rcurveline) {
                                while (n3 < stack.size()) {
                                    this.cfrLineTo(ctx, stack.get(n3++), stack.get(n3++));
                                }
                            }
                            stack.clear();
                            continue block36;
                        }
                        case 34: 
                        case 35: {
                            double initialX;
                            boolean horizontal = op == Op.hhcurveto;
                            int n2 = 0;
                            double v = stack.size() % 2 == 1 ? stack.get(n2++) : 0.0;
                            double initialY = horizontal ? v : 0.0;
                            double d = initialX = horizontal ? 0.0 : v;
                            if ((stack.size() - n2) % 4 != 0) {
                                throw new IllegalStateException("Invalid number of operands".toString());
                            }
                            while (n2 < stack.size()) {
                                double vv2 = stack.get(n2++);
                                double x1 = initialX + (horizontal ? vv2 : 0.0);
                                double y1 = initialY + (horizontal ? 0.0 : vv2);
                                double x2 = stack.get(n2++);
                                double y2 = stack.get(n2++);
                                double v1 = stack.get(n2++);
                                double lastX = horizontal ? v1 : 0.0;
                                double lastY = horizontal ? 0.0 : v1;
                                this.cfrCubicTo(ctx, x1, y1, x2, y2, lastX, lastY);
                                initialX = 0.0;
                                initialY = 0.0;
                            }
                            stack.clear();
                            continue block36;
                        }
                        case 36: 
                        case 37: {
                            ArrayListExtKt.reverse$default(stack, 0, 0, 3, null);
                            boolean toggle = op == Op.hvcurveto;
                            while (!((Collection)stack).isEmpty()) {
                                double vv3 = this.pop(stack);
                                double x1 = toggle ? vv3 : 0.0;
                                double y1 = toggle ? 0.0 : vv3;
                                double x2 = this.pop(stack);
                                double y2 = this.pop(stack);
                                double v1 = this.pop(stack);
                                double v2 = stack.size() == 1 ? this.pop(stack) : 0.0;
                                double ax = toggle ? v2 : v1;
                                double ay = toggle ? v1 : v2;
                                this.cfrCubicTo(ctx, x1, y1, x2, y2, ax, ay);
                                toggle = !toggle;
                            }
                            stack.clear();
                            continue block36;
                        }
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: {
                            if (stack.size() % 2 != 0 && !evalCtx.getHaveWidth()) {
                                double value = stack.get(0);
                                evalCtx.setWidth(value + evalCtx.getNominalWidthX());
                            }
                            evalCtx.setNStems(evalCtx.getNStems() + (stack.size() >>> 1));
                            evalCtx.setHaveWidth(true);
                            stack.clear();
                            if (op != Op.hintmask && op != Op.cntrmask) continue block36;
                            int skipCount = evalCtx.getNStems() + 7 >>> 3;
                            s.skip(skipCount);
                            continue block36;
                        }
                        case 48: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 49: {
                            throw new NotImplementedError(null, 1, null);
                        }
                    }
                    continue;
                }
                if (n == 255) {
                    int integerPart = this.u8(s) << 8 | this.u8(s);
                    int fractionPart = this.u8(s) << 8 | this.u8(s);
                    double value = (double)integerPart + (double)fractionPart / 65536.0;
                    this.push(stack, value);
                    continue;
                }
                int n4 = v0;
                if (n4 == 28) {
                    s2 = (short)(this.u8(s) << 8 | this.u8(s));
                } else {
                    boolean bl2 = 32 <= n4 ? n4 < 247 : false;
                    if (bl2) {
                        s2 = v0 - 139;
                    } else {
                        boolean bl3 = 247 <= n4 ? n4 < 251 : false;
                        if (bl3) {
                            s2 = (short)((v0 - 247) * 256 + this.u8(s) + 108);
                        } else {
                            boolean bl4 = 251 <= n4 ? n4 < 255 : false;
                            if (bl4) {
                                s2 = (short)(-((v0 - 251) * 256) - this.u8(s) - 108);
                            } else {
                                ExceptionsKt.getUnreachable();
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                }
                short value = s2;
                this.push(stack, value);
            }
        }

        public static /* synthetic */ void eval$default(CharStringType2 charStringType2, VectorBuilder vectorBuilder, FastByteArrayInputStream fastByteArrayInputStream, EvalContext evalContext2, DoubleArrayList doubleArrayList, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                doubleArrayList = new DoubleArrayList(32);
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            charStringType2.eval(vectorBuilder, fastByteArrayInputStream, evalContext2, doubleArrayList, n);
        }

        private final int computeSubrBias(int count2) {
            return count2 < 1240 ? 107 : (count2 < 33900 ? 1131 : 32768);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u001a\u0010\"\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0010R\u001a\u0010(\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u000e\"\u0004\b*\u0010\u0010\u00a8\u0006+"}, d2={"Lkorlibs/image/font/TtfCIDFont$CharStringType2$EvalContext;", "", "globalSubrIndex", "Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "localSubrsIndex", "defaultWidthX", "", "nominalWidthX", "index", "", "heap", "", "(Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;DDI[D)V", "getDefaultWidthX", "()D", "setDefaultWidthX", "(D)V", "globalBias", "getGlobalBias", "()I", "getGlobalSubrIndex", "()Lkorlibs/image/font/TtfCIDFont$CFF$DataIndex;", "haveWidth", "", "getHaveWidth", "()Z", "setHaveWidth", "(Z)V", "getHeap", "()[D", "getIndex", "localBias", "getLocalBias", "getLocalSubrsIndex", "nStems", "getNStems", "setNStems", "(I)V", "getNominalWidthX", "setNominalWidthX", "width", "getWidth", "setWidth", "korge-core"})
        public static final class EvalContext {
            @NotNull
            private final CFF.DataIndex globalSubrIndex;
            @NotNull
            private final CFF.DataIndex localSubrsIndex;
            private double defaultWidthX;
            private double nominalWidthX;
            private final int index;
            @NotNull
            private final double[] heap;
            private final int globalBias;
            private final int localBias;
            private int nStems;
            private double width;
            private boolean haveWidth;

            public EvalContext(@NotNull CFF.DataIndex globalSubrIndex, @NotNull CFF.DataIndex localSubrsIndex, double defaultWidthX, double nominalWidthX, int index2, @NotNull double[] heap) {
                this.globalSubrIndex = globalSubrIndex;
                this.localSubrsIndex = localSubrsIndex;
                this.defaultWidthX = defaultWidthX;
                this.nominalWidthX = nominalWidthX;
                this.index = index2;
                this.heap = heap;
                this.globalBias = INSTANCE.computeSubrBias(this.globalSubrIndex.getSize());
                this.localBias = INSTANCE.computeSubrBias(this.localSubrsIndex.getSize());
                this.width = this.defaultWidthX;
            }

            public /* synthetic */ EvalContext(CFF.DataIndex dataIndex, CFF.DataIndex dataIndex2, double d, double d2, int n, double[] dArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    dataIndex = new CFF.DataIndex();
                }
                if ((n2 & 2) != 0) {
                    dataIndex2 = new CFF.DataIndex();
                }
                if ((n2 & 4) != 0) {
                    d = 0.0;
                }
                if ((n2 & 8) != 0) {
                    d2 = 0.0;
                }
                if ((n2 & 0x10) != 0) {
                    n = -1;
                }
                if ((n2 & 0x20) != 0) {
                    dArray = new double[32];
                }
                this(dataIndex, dataIndex2, d, d2, n, dArray);
            }

            @NotNull
            public final CFF.DataIndex getGlobalSubrIndex() {
                return this.globalSubrIndex;
            }

            @NotNull
            public final CFF.DataIndex getLocalSubrsIndex() {
                return this.localSubrsIndex;
            }

            public final double getDefaultWidthX() {
                return this.defaultWidthX;
            }

            public final void setDefaultWidthX(double d) {
                this.defaultWidthX = d;
            }

            public final double getNominalWidthX() {
                return this.nominalWidthX;
            }

            public final void setNominalWidthX(double d) {
                this.nominalWidthX = d;
            }

            public final int getIndex() {
                return this.index;
            }

            @NotNull
            public final double[] getHeap() {
                return this.heap;
            }

            public final int getGlobalBias() {
                return this.globalBias;
            }

            public final int getLocalBias() {
                return this.localBias;
            }

            public final int getNStems() {
                return this.nStems;
            }

            public final void setNStems(int n) {
                this.nStems = n;
            }

            public final double getWidth() {
                return this.width;
            }

            public final void setWidth(double d) {
                this.width = d;
            }

            public final boolean getHaveWidth() {
                return this.haveWidth;
            }

            public final void setHaveWidth(boolean bl) {
                this.haveWidth = bl;
            }

            public EvalContext() {
                this(null, null, 0.0, 0.0, 0, null, 63, null);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b6\b\u0086\u0081\u0002\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u00019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8\u00a8\u0006:"}, d2={"Lkorlibs/image/font/TtfCIDFont$CharStringType2$Op;", "", "Lkorlibs/image/font/TtfCIDFont$CharStringType2$Token;", "id", "", "(Ljava/lang/String;II)V", "getId", "()I", "hstem", "vstem", "and", "vmoveto", "or", "rlineto", "not", "hlineto", "vlineto", "rrcurveto", "abs", "callsubr", "add", "return", "sub", "div", "endchar", "neg", "cff2vsidx", "eq", "cff2blend", "hstemhm", "drop", "hintmask", "cntrmask", "put", "rmoveto", "get", "hmoveto", "ifelse", "vstemhm", "random", "rcurveline", "mul", "rlinecurve", "vvcurveto", "sqrt", "hhcurveto", "dup", "exch", "callgsubr", "index", "vhcurveto", "roll", "hvcurveto", "hflex", "flex", "hflex1", "flex1", "Companion", "korge-core"})
        @SourceDebugExtension(value={"SMAP\nTtfCIDFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CharStringType2$Op\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,708:1\n8541#2,2:709\n8801#2,4:711\n*S KotlinDebug\n*F\n+ 1 TtfCIDFont.kt\nkorlibs/image/font/TtfCIDFont$CharStringType2$Op\n*L\n701#1:709,2\n701#1:711,4\n*E\n"})
        public static final class Op
        extends Enum<Op>
        implements Token {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private static final IntMap<Op> MAP;
            public static final /* enum */ Op hstem;
            public static final /* enum */ Op vstem;
            public static final /* enum */ Op and;
            public static final /* enum */ Op vmoveto;
            public static final /* enum */ Op or;
            public static final /* enum */ Op rlineto;
            public static final /* enum */ Op not;
            public static final /* enum */ Op hlineto;
            public static final /* enum */ Op vlineto;
            public static final /* enum */ Op rrcurveto;
            public static final /* enum */ Op abs;
            public static final /* enum */ Op callsubr;
            public static final /* enum */ Op add;
            public static final /* enum */ Op return;
            public static final /* enum */ Op sub;
            public static final /* enum */ Op div;
            public static final /* enum */ Op endchar;
            public static final /* enum */ Op neg;
            public static final /* enum */ Op cff2vsidx;
            public static final /* enum */ Op eq;
            public static final /* enum */ Op cff2blend;
            public static final /* enum */ Op hstemhm;
            public static final /* enum */ Op drop;
            public static final /* enum */ Op hintmask;
            public static final /* enum */ Op cntrmask;
            public static final /* enum */ Op put;
            public static final /* enum */ Op rmoveto;
            public static final /* enum */ Op get;
            public static final /* enum */ Op hmoveto;
            public static final /* enum */ Op ifelse;
            public static final /* enum */ Op vstemhm;
            public static final /* enum */ Op random;
            public static final /* enum */ Op rcurveline;
            public static final /* enum */ Op mul;
            public static final /* enum */ Op rlinecurve;
            public static final /* enum */ Op vvcurveto;
            public static final /* enum */ Op sqrt;
            public static final /* enum */ Op hhcurveto;
            public static final /* enum */ Op dup;
            public static final /* enum */ Op exch;
            public static final /* enum */ Op callgsubr;
            public static final /* enum */ Op index;
            public static final /* enum */ Op vhcurveto;
            public static final /* enum */ Op roll;
            public static final /* enum */ Op hvcurveto;
            public static final /* enum */ Op hflex;
            public static final /* enum */ Op flex;
            public static final /* enum */ Op hflex1;
            public static final /* enum */ Op flex1;
            private static final /* synthetic */ Op[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Op(int id2) {
                this.id = id2;
            }

            public final int getId() {
                return this.id;
            }

            public static Op[] values() {
                return (Op[])$VALUES.clone();
            }

            public static Op valueOf(String value) {
                return Enum.valueOf(Op.class, value);
            }

            @NotNull
            public static EnumEntries<Op> getEntries() {
                return $ENTRIES;
            }

            /*
             * WARNING - void declaration
             */
            static {
                void $this$associateByTo$iv$iv;
                hstem = new Op(1);
                vstem = new Op(3);
                and = new Op(3075);
                vmoveto = new Op(4);
                or = new Op(3076);
                rlineto = new Op(5);
                not = new Op(3077);
                hlineto = new Op(6);
                vlineto = new Op(7);
                rrcurveto = new Op(8);
                abs = new Op(3081);
                callsubr = new Op(10);
                add = new Op(3082);
                return = new Op(11);
                sub = new Op(3083);
                div = new Op(3084);
                endchar = new Op(14);
                neg = new Op(3086);
                cff2vsidx = new Op(15);
                eq = new Op(3087);
                cff2blend = new Op(16);
                hstemhm = new Op(18);
                drop = new Op(3090);
                hintmask = new Op(19);
                cntrmask = new Op(20);
                put = new Op(3092);
                rmoveto = new Op(21);
                get = new Op(3093);
                hmoveto = new Op(22);
                ifelse = new Op(3094);
                vstemhm = new Op(23);
                random = new Op(3095);
                rcurveline = new Op(24);
                mul = new Op(3096);
                rlinecurve = new Op(25);
                vvcurveto = new Op(26);
                sqrt = new Op(3098);
                hhcurveto = new Op(27);
                dup = new Op(3099);
                exch = new Op(3100);
                callgsubr = new Op(29);
                index = new Op(3101);
                vhcurveto = new Op(30);
                roll = new Op(3102);
                hvcurveto = new Op(31);
                hflex = new Op(3106);
                flex = new Op(3107);
                hflex1 = new Op(3108);
                flex1 = new Op(3109);
                $VALUES = opArray = new Op[]{Op.hstem, Op.vstem, Op.and, Op.vmoveto, Op.or, Op.rlineto, Op.not, Op.hlineto, Op.vlineto, Op.rrcurveto, Op.abs, Op.callsubr, Op.add, Op.return, Op.sub, Op.div, Op.endchar, Op.neg, Op.cff2vsidx, Op.eq, Op.cff2blend, Op.hstemhm, Op.drop, Op.hintmask, Op.cntrmask, Op.put, Op.rmoveto, Op.get, Op.hmoveto, Op.ifelse, Op.vstemhm, Op.random, Op.rcurveline, Op.mul, Op.rlinecurve, Op.vvcurveto, Op.sqrt, Op.hhcurveto, Op.dup, Op.exch, Op.callgsubr, Op.index, Op.vhcurveto, Op.roll, Op.hvcurveto, Op.hflex, Op.flex, Op.hflex1, Op.flex1};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                Op[] $this$associateBy$iv = Op.values();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
                Op[] opArray = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                int n = ((void)$this$associateByTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void element$iv$iv;
                    void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[j];
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it.id, element$iv$iv);
                }
                MAP = IntMapKt.toIntMap(destination$iv$iv);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lkorlibs/image/font/TtfCIDFont$CharStringType2$Op$Companion;", "", "()V", "MAP", "Lkorlibs/datastructure/IntMap;", "Lkorlibs/image/font/TtfCIDFont$CharStringType2$Op;", "getMAP", "()Lkorlibs/datastructure/IntMap;", "get", "id", "", "korge-core"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final IntMap<Op> getMAP() {
                    return MAP;
                }

                @NotNull
                public final Op get(int id2) {
                    Op op = this.getMAP().get(id2);
                    if (op == null) {
                        throw new IllegalStateException(("Unknown CFF CS2 operator " + id2).toString());
                    }
                    return op;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00a8\u0006\u0004"}, d2={"Lkorlibs/image/font/TtfCIDFont$CharStringType2$Token;", "", "Lkorlibs/image/font/TtfCIDFont$CFF$Op;", "Lkorlibs/image/font/TtfCIDFont$CharStringType2$Op;", "korge-core"})
        public static interface Token {
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Op.values().length];
                try {
                    nArray[Op.return.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.endchar.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.callsubr.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.callgsubr.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.drop.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.dup.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.exch.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.roll.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.index.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.put.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.get.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.and.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.or.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.not.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.eq.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.ifelse.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.random.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.sqrt.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.abs.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.neg.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.add.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.sub.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.div.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.mul.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.rmoveto.ordinal()] = 25;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vmoveto.ordinal()] = 26;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hmoveto.ordinal()] = 27;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.rlineto.ordinal()] = 28;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hlineto.ordinal()] = 29;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vlineto.ordinal()] = 30;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.rrcurveto.ordinal()] = 31;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.rcurveline.ordinal()] = 32;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.rlinecurve.ordinal()] = 33;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vvcurveto.ordinal()] = 34;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hhcurveto.ordinal()] = 35;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vhcurveto.ordinal()] = 36;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hvcurveto.ordinal()] = 37;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hflex.ordinal()] = 38;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.flex.ordinal()] = 39;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hflex1.ordinal()] = 40;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.flex1.ordinal()] = 41;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hstem.ordinal()] = 42;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vstem.ordinal()] = 43;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hstemhm.ordinal()] = 44;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.vstemhm.ordinal()] = 45;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.hintmask.ordinal()] = 46;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.cntrmask.ordinal()] = 47;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.cff2vsidx.ordinal()] = 48;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Op.cff2blend.ordinal()] = 49;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

