/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.datastructure.FastArrayList;
import korlibs.datastructure.FastMapKt;
import korlibs.datastructure.IntArray2;
import korlibs.datastructure.IntMap;
import korlibs.datastructure._DelegatesKt;
import korlibs.encoding.HexKt;
import korlibs.image.bitmap.Bitmap;
import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.bitmap.BitmapSliceKt;
import korlibs.image.bitmap.NinePatchBitmap32Kt;
import korlibs.image.bitmap.Palette;
import korlibs.image.color.Colors;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.ASEKt;
import korlibs.image.format.Fixed32;
import korlibs.image.format.ImageAnimation;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDataContainer;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageFormatWithContainer;
import korlibs.image.format.ImageFrame;
import korlibs.image.format.ImageFrameLayer;
import korlibs.image.format.ImageInfo;
import korlibs.image.format.ImageLayer;
import korlibs.image.tiles.TileMapData;
import korlibs.image.tiles.TileSet;
import korlibs.image.tiles.TileSetTileInfo;
import korlibs.image.vector.BlendMode;
import korlibs.io.compression.CompressionMethodKt;
import korlibs.io.compression.deflate.ZLib;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.math.ClampKt;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.slice.RectSlice;
import korlibs.math.geom.slice._MathGeom_sliceKt;
import korlibs.memory.BitsKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000e\u001b\u001c\u001d\u001e\u001f !\"#$%&'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\u000b\u001a\u00020\f*\u00020\u0006J\u0019\u0010\r\u001a\u00020\u000e*\u00020\u0006H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u0012*\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u0012*\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0010J\f\u0010\u0016\u001a\u00020\u0017*\u00020\bH\u0002J\u0014\u0010\u0018\u001a\u00020\u0017*\u00020\b2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u0017*\u00020\bH\u0002\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"Lkorlibs/image/format/ASE;", "Lkorlibs/image/format/ImageFormatWithContainer;", "()V", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readImageContainer", "Lkorlibs/image/format/ImageDataContainer;", "readAseString", "", "readFixedLE", "Lkorlibs/image/format/Fixed32;", "readFixedLE-70vMFI0$korge_core", "(Lkorlibs/io/stream/SyncStream;)I", "readRGB", "Lkorlibs/image/color/RGBA;", "readRGB-O1c-hRk", "readRGBA", "readRGBA-O1c-hRk", "slicingEnabled", "", "takeLayersByName", "name", "useSlicePosition", "AseBitmapCell", "AseCell", "AseEntity", "AseFrame", "AseImage", "AseLayer", "AseLayerCell", "AseLinkedCell", "AsePalette", "AseSlice", "AseSliceKey", "AseTag", "AseTilemapCell", "AseTileset", "korge-core"})
@SourceDebugExtension(value={"SMAP\nASE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE\n+ 2 Bits.kt\nkorlibs/memory/BitsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 TimeSpan.kt\nkorlibs/time/TimeSpanKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,768:1\n130#2,5:769\n130#2,5:774\n130#2,5:779\n766#3:784\n857#3,2:785\n1603#3,9:787\n1855#3:796\n1856#3:810\n1612#3:811\n1549#3:812\n1620#3,3:813\n1603#3,9:816\n1855#3:825\n1603#3,9:827\n1855#3:836\n1549#3:848\n1620#3,3:849\n1856#3:854\n1612#3:855\n1549#3:856\n1620#3,3:857\n1856#3:861\n1612#3:862\n1864#3,3:863\n526#4:797\n511#4,6:798\n526#4:837\n511#4,6:838\n125#5:804\n152#5,3:805\n125#5:844\n152#5,3:845\n53#6:808\n53#6:852\n1#7:809\n1#7:826\n1#7:853\n1#7:860\n1#7:866\n*S KotlinDebug\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE\n*L\n562#1:769,5\n563#1:774,5\n564#1:779,5\n605#1:784\n605#1:785,2\n636#1:787,9\n636#1:796\n636#1:810\n636#1:811\n652#1:812\n652#1:813,3\n671#1:816,9\n671#1:825\n676#1:827,9\n676#1:836\n685#1:848\n685#1:849,3\n676#1:854\n676#1:855\n712#1:856\n712#1:857,3\n671#1:861\n671#1:862\n736#1:863,3\n637#1:797\n637#1:798,6\n678#1:837\n678#1:838,6\n642#1:804\n642#1:805,3\n683#1:844\n683#1:845,3\n646#1:808\n708#1:852\n636#1:809\n676#1:853\n671#1:860\n*E\n"})
public final class ASE
extends ImageFormatWithContainer {
    @NotNull
    public static final ASE INSTANCE = new ASE();

    private ASE() {
        String[] stringArray = new String[]{"ase"};
        super(stringArray);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageInfo imageInfo;
        SyncStream ss2 = s.clone();
        SyncStreamKt.readBytesExact(ss2, 4);
        if (SyncStreamKt.readU16LE(ss2) != 42464) {
            return null;
        }
        int frames = SyncStreamKt.readU16LE(ss2);
        int width2 = SyncStreamKt.readU16LE(ss2);
        int height2 = SyncStreamKt.readU16LE(ss2);
        int bitsPerPixel = SyncStreamKt.readU16LE(ss2);
        ImageInfo it = imageInfo = new ImageInfo();
        boolean bl = false;
        it.setBitsPerPixel(bitsPerPixel);
        it.setWidth(width2);
        it.setHeight(height2);
        return imageInfo;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public ImageDataContainer readImageContainer(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        fileSize = SyncStreamKt.readS32LE(s);
        if (s.getLength() < (long)fileSize) {
            throw new IllegalStateException("File too short".toString());
        }
        if (SyncStreamKt.readU16LE(s) != 42464) {
            throw new IllegalStateException("Not an Aseprite file".toString());
        }
        numFrames = SyncStreamKt.readU16LE(s);
        imageWidth = SyncStreamKt.readU16LE(s);
        imageHeight = SyncStreamKt.readU16LE(s);
        bitsPerPixel = SyncStreamKt.readU16LE(s);
        bytesPerPixel = bitsPerPixel / 8;
        flags = SyncStreamKt.readU32LE(s);
        speed = SyncStreamKt.readU16LE(s);
        s.skip(4);
        s.skip(4);
        transparentIndex = SyncStreamKt.readU8(s);
        s.skip(3);
        numColors = SyncStreamKt.readU16LE(s);
        pixelWidth = SyncStreamKt.readU8(s);
        pixelHeight = SyncStreamKt.readU8(s);
        gridX = SyncStreamKt.readS16LE(s);
        gridY = SyncStreamKt.readS16LE(s);
        gridWidth = SyncStreamKt.readU16LE(s);
        gridHeight = SyncStreamKt.readU16LE(s);
        s.skip(84);
        image = new AseImage();
        for (frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            bytesInFrame = SyncStreamKt.readS32LE(s);
            fs = SyncStreamKt.readStream(s, bytesInFrame - 4);
            if (SyncStreamKt.readU16LE(fs) != 61946) {
                throw new IllegalStateException("Invalid ASE sprite file or error parsing".toString());
            }
            SyncStreamKt.readU16LE(fs);
            frameDuration = SyncStreamKt.readU16LE(fs);
            fs.skip(2);
            numChunks = SyncStreamKt.readS32LE(fs);
            currentFrame = new AseFrame(frameIndex);
            image.getFrames().add(currentFrame);
            currentFrame.setTime(frameDuration);
            lastEntity = null;
            lastCell = null;
            block26: for (nc = 0; nc < numChunks; ++nc) {
                chunkSize = SyncStreamKt.readS32LE(fs);
                chunkType = SyncStreamKt.readU16LE(fs);
                cs = SyncStreamKt.readStream(fs, chunkSize - 6);
                switch (chunkType) {
                    case 4: {
                        if (image.getPalette() == null) {
                            // empty if block
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 17: {
                        if (image.getPalette() == null) {
                            // empty if block
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8196: {
                        flags = SyncStreamKt.readU16LE(cs);
                        type = ImageLayer.Type.Companion.getBY_ORDINAL()[SyncStreamKt.readU16LE(cs)];
                        childLevel = SyncStreamKt.readU16LE(cs);
                        defaultLayerWidth = SyncStreamKt.readU16LE(cs);
                        defaultLayerHeight = SyncStreamKt.readU16LE(cs);
                        blendModeInt = SyncStreamKt.readU16LE(cs);
                        opacity = SyncStreamKt.readU8(cs);
                        cs.skip(3);
                        name = this.readAseString(cs);
                        tilesetIndex = type.isTilemap() != false ? SyncStreamKt.readS32LE(cs) : 0;
                        layer = new AseLayer(image.getLayers().size(), image.getLayers().size(), name, flags, type, childLevel, blendModeInt, opacity, tilesetIndex);
                        image.getLayers().add(layer);
                        lastEntity = layer;
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8197: {
                        layerIndex = SyncStreamKt.readU16LE(cs);
                        x = SyncStreamKt.readS16LE(cs);
                        y = SyncStreamKt.readS16LE(cs);
                        opacity = SyncStreamKt.readU8(cs);
                        celType = SyncStreamKt.readU16LE(cs);
                        cs.skip(7);
                        switch (celType) {
                            case 0: 
                            case 2: {
                                width = SyncStreamKt.readU16LE(cs);
                                height = SyncStreamKt.readU16LE(cs);
                                data = SyncStreamKt.readAvailable(cs);
                                udata = celType == 2 ? CompressionMethodKt.uncompress(data, ZLib.Companion, width * height * bytesPerPixel) : data;
                                var46_165 = bitsPerPixel;
                                switch (var46_165) {
                                    case 32: {
                                        it = var47_172 = new Bitmap32(width, height, RgbaArray.constructor-impl(ByteArrayGetSetKt.getS32Array(udata, 0, width * height, true)), null);
                                        $i$a$-also-ASE$readImageContainer$cel$bmp$1 = false;
                                        if (props.getPremultipliedSure()) {
                                            it.premultiplyInplaceIfRequired();
                                        }
                                        v1 = var47_172;
                                        break;
                                    }
                                    case 8: {
                                        v2 = image.getPalette();
                                        Intrinsics.checkNotNull(v2);
                                        v1 = new Bitmap8(width, height, udata, v2.getColors-FROm4YY(), null);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("Unsupported ASE mode".toString());
                                    }
                                }
                                bmp = v1;
                                v3 = new AseBitmapCell(bmp, x, y, opacity);
                                break;
                            }
                            case 1: {
                                linkFrame = SyncStreamKt.readU16LE(cs);
                                Intrinsics.checkNotNull(image.getFrames().get(linkFrame).getCelsByLayer().get(layerIndex));
                                v3 = new AseLinkedCell(aseCell, x, y, opacity);
                                break;
                            }
                            case 3: {
                                tilesWidth = SyncStreamKt.readU16LE(cs);
                                tilesHeight = SyncStreamKt.readU16LE(cs);
                                bitsPerTile = SyncStreamKt.readU16LE(cs);
                                tileBitmask = SyncStreamKt.readS32LE(cs);
                                bitmaskXFlip = SyncStreamKt.readS32LE(cs);
                                bitmaskYFlip = SyncStreamKt.readS32LE(cs);
                                bitmask90CWFlip = SyncStreamKt.readS32LE(cs);
                                bytesPerTile = bitsPerTile / 8;
                                cs.skip(10);
                                compressedData = CompressionMethodKt.uncompress(SyncStreamKt.readAvailable(cs), ZLib.Companion, tilesWidth * tilesHeight * bytesPerTile);
                                if (bitsPerTile != 32) {
                                    var52_194 = "Only supported 32-bits per tile";
                                    throw new NotImplementedError("An operation is not implemented: " + var52_194);
                                }
                                data = ByteArrayGetSetKt.getS32ArrayLE(compressedData, 0, tilesWidth * tilesHeight);
                                v3 = new AseTilemapCell(new IntArray2(tilesWidth, tilesHeight, data), tileBitmask, bitmaskXFlip, bitmaskYFlip, bitmask90CWFlip, x, y, opacity);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(("Aseprite: Unknown celType=" + celType).toString());
                            }
                        }
                        cel = v3;
                        lastEntity = cel;
                        lastCell = cel;
                        currentFrame.getCelsByLayer().set(layerIndex, cel);
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8198: {
                        flags = SyncStreamKt.readS32LE(cs);
                        x = Fixed32.getDouble-impl(this.readFixedLE-70vMFI0$korge_core(cs));
                        y = Fixed32.getDouble-impl(this.readFixedLE-70vMFI0$korge_core(cs));
                        width = Fixed32.getDouble-impl(this.readFixedLE-70vMFI0$korge_core(cs));
                        height = Fixed32.getDouble-impl(this.readFixedLE-70vMFI0$korge_core(cs));
                        cs.skip(16);
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8199: {
                        type = SyncStreamKt.readU16LE(cs);
                        flags = SyncStreamKt.readU16LE(cs);
                        gamma = this.readFixedLE-70vMFI0$korge_core(cs);
                        cs.skip(8);
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8200: {
                        nentries = SyncStreamKt.readS32LE(cs);
                        cs.skip(8);
                        for (n = 0; n < nentries; ++n) {
                            entryId = SyncStreamKt.readS32LE(cs);
                            cs.skip(8);
                            externalFileName = this.readAseString(cs);
                            image.getExternalFiles().set(entryId, externalFileName);
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8214: {
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8215: {
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8216: {
                        numTags = SyncStreamKt.readU16LE(cs);
                        cs.skip(8);
                        for (tag = 0; tag < numTags; ++tag) {
                            fromFrame = SyncStreamKt.readU16LE(cs);
                            toFrame = SyncStreamKt.readU16LE(cs);
                            direction = SyncStreamKt.readU8(cs);
                            cs.skip(8);
                            tagColor = RGBA.withA-O1c-hRk(this.readRGBA-O1c-hRk(cs), 255);
                            tagName = this.readAseString(cs);
                            tag = new AseTag(fromFrame, toFrame, direction, tagColor, tagName, null);
                            image.getTags().add(tag);
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8217: {
                        numEntries = SyncStreamKt.readS32LE(cs);
                        changeStart = SyncStreamKt.readS32LE(cs);
                        changeEnd = SyncStreamKt.readS32LE(cs);
                        colors = RgbaArray.Companion.invoke-lrAz6eQ(numEntries);
                        colorNames = new String[numEntries];
                        cs.skip(8);
                        for (ncol = 0; ncol < numEntries; ++ncol) {
                            flags = SyncStreamKt.readU16LE(cs);
                            rgba = this.readRGBA-O1c-hRk(cs);
                            name = BitsKt.hasBitSet(flags, 0) != false ? this.readAseString(cs) : null;
                            RgbaArray.set-XDoMphA(colors, ncol, rgba);
                            colorNames[ncol] = name;
                        }
                        image.setPalette(new AsePalette(colors, colorNames, changeStart, changeEnd, null));
                        lastEntity = image.getPalette();
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8224: {
                        flags = SyncStreamKt.readS32LE(cs);
                        if (BitsKt.hasBitSet(flags, 0)) {
                            v4 = lastEntity;
                            if (v4 != null) {
                                v4.setUserData(this.readAseString(cs));
                            }
                        }
                        if (BitsKt.hasBitSet(flags, 1)) {
                            v5 = lastEntity;
                            if (v5 != null) {
                                v5.setUserDataColor-PXL95c4(this.readRGBA-O1c-hRk(cs));
                            }
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8226: {
                        numSliceKeys = SyncStreamKt.readS32LE(cs);
                        sliceFlags = SyncStreamKt.readS32LE(cs);
                        cs.skip(4);
                        sliceName = this.readAseString(cs);
                        hasNinePatch = BitsKt.hasBitSet(sliceFlags, 0);
                        hasPivotInfo = BitsKt.hasBitSet(sliceFlags, 1);
                        slice = new AseSlice(sliceName, hasNinePatch, hasPivotInfo);
                        image.getSlices().add(slice);
                        lastEntity = slice;
                        for (nsk = 0; nsk < numSliceKeys; ++nsk) {
                            sliceFrameIndex = SyncStreamKt.readS32LE(cs);
                            sliceXOrigin = SyncStreamKt.readS32LE(cs);
                            sliceYOrigin = SyncStreamKt.readS32LE(cs);
                            sliceWidth = SyncStreamKt.readS32LE(cs);
                            sliceHeight = SyncStreamKt.readS32LE(cs);
                            centerXPos = hasNinePatch != false ? SyncStreamKt.readS32LE(cs) : 0;
                            centerYPos = hasNinePatch != false ? SyncStreamKt.readS32LE(cs) : 0;
                            centerWidth = hasNinePatch != false ? SyncStreamKt.readS32LE(cs) : sliceWidth;
                            centerHeight = hasNinePatch != false ? SyncStreamKt.readS32LE(cs) : sliceHeight;
                            pivotX = hasPivotInfo != false ? SyncStreamKt.readS32LE(cs) : 0;
                            pivotY = hasPivotInfo != false ? SyncStreamKt.readS32LE(cs) : 0;
                            slice.getKeys().add(new AseSliceKey(sliceFrameIndex, sliceXOrigin, sliceYOrigin, sliceWidth, sliceHeight, centerXPos, centerYPos, centerWidth, centerHeight, pivotX, pivotY));
                        }
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    case 8227: {
                        tilesetId = SyncStreamKt.readS32LE(cs);
                        hasNinePatch = tilesetFlags = SyncStreamKt.readS32LE(cs);
                        offset$iv = 0;
                        $i$f$extract = false;
                        $this$extract1$iv$iv = $this$extract$iv;
                        $i$f$extract1 = false;
                        includeLinkToExternalFile = ($this$extract1$iv$iv >>> offset$iv & 1) != 0;
                        offset$iv = tilesetFlags;
                        offset$iv = 1;
                        $i$f$extract = false;
                        $this$extract1$iv$iv = $this$extract$iv;
                        $i$f$extract1 = false;
                        includeTilesInsideThisFile = ($this$extract1$iv$iv >>> offset$iv & 1) != 0;
                        offset$iv = tilesetFlags;
                        offset$iv = 2;
                        $i$f$extract = false;
                        $this$extract1$iv$iv = $this$extract$iv;
                        $i$f$extract1 = false;
                        tile0IsEmpty = ($this$extract1$iv$iv >>> offset$iv & 1) != 0;
                        ntiles = SyncStreamKt.readS32LE(cs);
                        tileWidth = SyncStreamKt.readU16LE(cs);
                        tileHeight = SyncStreamKt.readU16LE(cs);
                        baseIndex = SyncStreamKt.readS16LE(cs);
                        cs.skip(14);
                        tilesetName = this.readAseString(cs);
                        tiles /* !! */  = CollectionsKt.emptyList();
                        if (includeLinkToExternalFile) {
                            externalFileId = SyncStreamKt.readS32LE(cs);
                            centerXPos = SyncStreamKt.readS32LE(cs);
                        }
                        if (includeTilesInsideThisFile) {
                            compressedDataLength = SyncStreamKt.readS32LE(cs);
                            compressedData = SyncStreamKt.readBytesExact(cs, compressedDataLength);
                            data = CompressionMethodKt.uncompress$default(compressedData, ZLib.Companion, 0, 2, null);
                            ints = ByteArrayGetSetKt.getS32ArrayLE(data, 0, tileWidth * tileHeight * ntiles);
                            it = pivotX = new Bitmap32(tileWidth, tileHeight * ntiles, RgbaArray.constructor-impl((int[])ints), null);
                            $i$a$-also-ASE$readImageContainer$bitmap$1 = false;
                            if (props.getPremultipliedSure()) {
                                it.premultiplyInplaceIfRequired();
                            }
                            bitmap = pivotX;
                            tiles /* !! */  = _MathGeom_sliceKt.splitInRows(BitmapSliceKt.slice-pvcgspk$default(bitmap, null, null, 0, null, 15, null), tileWidth, tileHeight);
                        }
                        image.getTilesets().set(tilesetId, new AseTileset(tilesetId, ntiles, tileWidth, tileHeight, baseIndex, tilesetName, tiles /* !! */ ));
                        v0 = Unit.INSTANCE;
                        continue block26;
                    }
                    default: {
                        System.out.println((Object)("WARNING: Aseprite: Not implemented chunkType=" + HexKt.getHex(chunkType)));
                        v0 = Unit.INSTANCE;
                    }
                }
            }
        }
        imageLayers = image.getLayers();
        $this$filter$iv = imageLayers;
        $i$f$filter = false;
        numChunks = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AseLayer)element$iv$iv;
            $i$a$-filter-ASE$readImageContainer$imageLayersToProcess$1 = false;
            v6 = shouldProcess = ASEKt.getOnlyReadVisibleLayers(props) != false ? it.isVisible() : true;
            if (!shouldProcess) ** GOTO lbl-1000
            v7 = it.getName();
            Intrinsics.checkNotNull(v7, "null cannot be cast to non-null type kotlin.String");
            if (ASE.INSTANCE.takeLayersByName(props, v7)) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            if (!v8) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        imageLayersToProcess = (List)destination$iv$iv;
        $this$mapNotNull$iv = image.getFrames();
        $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        $i$a$-filter-ASE$readImageContainer$imageLayersToProcess$1 = $this$forEach$iv$iv$iv.iterator();
        while ($i$a$-filter-ASE$readImageContainer$imageLayersToProcess$1.hasNext()) {
            element$iv$iv = element$iv$iv$iv = $i$a$-filter-ASE$readImageContainer$imageLayersToProcess$1.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            frame = (AseFrame)element$iv$iv;
            $i$a$-mapNotNull-ASE$readImageContainer$frames$1 = false;
            $this$filter$iv = FastMapKt.toLinkedMap(frame.getCelsByLayer());
            $i$f$filter = false;
            ntiles = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                it = element$iv$iv;
                $i$a$-filter-ASE$readImageContainer$frames$1$cells$1 = false;
                v9 = shouldProcess = ASEKt.getOnlyReadVisibleLayers(props) != false ? imageLayers.get(((Number)it.getKey()).intValue()).isVisible() : true;
                if (!shouldProcess) ** GOTO lbl-1000
                v10 = imageLayers.get(((Number)it.getKey()).intValue()).getName();
                Intrinsics.checkNotNull(v10, "null cannot be cast to non-null type kotlin.String");
                if (ASE.INSTANCE.takeLayersByName(props, v10)) {
                    v11 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v11 = false;
                }
                if (!v11) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$map$iv = cells = destination$iv$iv;
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.size());
            $i$f$mapTo = false;
            element$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                $i$a$-filter-ASE$readImageContainer$frames$1$cells$1 = item$iv$iv = (Map.Entry)element$iv$iv.next();
                ints = destination$iv$iv;
                $i$a$-map-ASE$readImageContainer$frames$1$layerData$1 = false;
                key = ((Number)$i$a$-filter-ASE$readImageContainer$frames$1$cells$1.getKey()).intValue();
                value = (AseCell)$i$a$-filter-ASE$readImageContainer$frames$1$cells$1.getValue();
                ints.add(ASE.readImageContainer$createImageFrameLayer(imageLayers, image, key, value));
            }
            layerData = (List)destination$iv$iv;
            if (((Collection)layerData).isEmpty() == false) {
                $this$milliseconds$iv = frame.getTime();
                $i$f$getMilliseconds = false;
                v12 = new ImageFrame(frame.getIndex(), DurationKt.toDuration((double)$this$milliseconds$iv, DurationUnit.MILLISECONDS), layerData, null);
            } else {
                v12 = new ImageFrame(frame.getIndex(), 0L, null, 6, null);
            }
            it$iv$iv = v12;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        frames = (List)destination$iv$iv;
        $this$map$iv = image.getTags();
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv$iv = (AseTag)item$iv$iv;
            var78_201 = destination$iv$iv;
            $i$a$-map-ASE$readImageContainer$animations$1 = false;
            framesRange = CollectionsKt.slice(frames, new IntRange(ClampKt.clamp(it.getFromFrame(), 0, frames.size()), ClampKt.clamp(it.getToFrame(), 0, frames.size() - 1)));
            var78_201.add(new ImageAnimation(framesRange, it.getDirection(), it.getTagName(), null, 8, null));
        }
        animations = (List)destination$iv$iv;
        defaultData = new ImageData(frames, 0, imageWidth, imageHeight, imageLayersToProcess, animations, null, 66, null);
        $this$mapNotNull$iv = image.getSlices();
        $i$f$mapNotNull = false;
        $i$f$mapTo = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        framesRange = $this$forEach$iv$iv$iv.iterator();
        while (framesRange.hasNext()) {
            element$iv$iv = element$iv$iv$iv = framesRange.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            slice = (AseSlice)element$iv$iv;
            $i$a$-mapNotNull-ASE$readImageContainer$datas$1 = false;
            slice.sortKeys();
            $this$mapTo$iv$iv = ((Iterable)slice.getKeys()).iterator();
            if (!$this$mapTo$iv$iv.hasNext()) {
                v13 = null;
            } else {
                it = (AseSliceKey)$this$mapTo$iv$iv.next();
                $i$a$-maxOfOrNull-ASE$readImageContainer$datas$1$maxWidth$1 = false;
                it = it.getSliceWidth();
                while ($this$mapTo$iv$iv.hasNext()) {
                    it = (AseSliceKey)$this$mapTo$iv$iv.next();
                    $i$a$-maxOfOrNull-ASE$readImageContainer$datas$1$maxWidth$1 = false;
                    if (it.compareTo(it = (Comparable)Integer.valueOf(it.getSliceWidth())) >= 0) continue;
                    it = it;
                }
                v13 = it;
            }
            v14 = (Integer)v13;
            maxWidth = v14 != null ? v14 : 0;
            it = ((Iterable)slice.getKeys()).iterator();
            if (!it.hasNext()) {
                v15 = null;
            } else {
                it = (AseSliceKey)it.next();
                $i$a$-maxOfOrNull-ASE$readImageContainer$datas$1$maxHeight$1 = false;
                it = it.getSliceHeight();
                while (it.hasNext()) {
                    it = (AseSliceKey)it.next();
                    $i$a$-maxOfOrNull-ASE$readImageContainer$datas$1$maxHeight$1 = false;
                    if (it.compareTo(it = (Comparable)Integer.valueOf(it.getSliceHeight())) >= 0) continue;
                    it = it;
                }
                v15 = it;
            }
            v16 = (Integer)v15;
            maxHeight = v16 != null ? v16 : 0;
            $this$mapNotNull$iv = image.getFrames();
            $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            key = $this$forEach$iv$iv$iv.iterator();
            while (key.hasNext()) {
                element$iv$iv = element$iv$iv$iv /* !! */  = key.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                frame = (AseFrame)element$iv$iv;
                $i$a$-mapNotNull-ASE$readImageContainer$datas$1$frames$1 = false;
                sliceKey = slice.getSliceForFrame(frame.getIndex());
                $this$filter$iv = FastMapKt.toLinkedMap(frame.getCelsByLayer());
                $i$f$filter = false;
                var58_210 = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                var61_215 = $this$filterTo$iv$iv.entrySet().iterator();
                while (var61_215.hasNext()) {
                    it = element$iv$iv = var61_215.next();
                    $i$a$-filter-ASE$readImageContainer$datas$1$frames$1$cells$1 = false;
                    v17 = shouldProcess = ASEKt.getOnlyReadVisibleLayers(props) != false ? imageLayers.get(((Number)it.getKey()).intValue()).isVisible() : true;
                    if (!shouldProcess) ** GOTO lbl-1000
                    v18 = imageLayers.get(((Number)it.getKey()).intValue()).getName();
                    Intrinsics.checkNotNull(v18, "null cannot be cast to non-null type kotlin.String");
                    if (ASE.INSTANCE.takeLayersByName(props, v18)) {
                        v19 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v19 = false;
                    }
                    if (!v19) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                cells = destination$iv$iv;
                $this$map$iv = cells;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                var62_216 = $this$mapTo$iv$iv.entrySet().iterator();
                while (var62_216.hasNext()) {
                    $i$a$-filter-ASE$readImageContainer$datas$1$frames$1$cells$1 = item$iv$iv = var62_216.next();
                    var67_223 = destination$iv$iv;
                    $i$a$-map-ASE$readImageContainer$datas$1$frames$1$layerData$1 = false;
                    key = ((Number)$i$a$-filter-ASE$readImageContainer$datas$1$frames$1$cells$1.getKey()).intValue();
                    value = (AseCell)$i$a$-filter-ASE$readImageContainer$datas$1$frames$1$cells$1.getValue();
                    var67_223.add(ASE.readImageContainer$createImageFrameLayer(imageLayers, image, key, value));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                var62_216 = $this$mapTo$iv$iv.iterator();
                while (var62_216.hasNext()) {
                    item$iv$iv = var62_216.next();
                    $i$a$-filter-ASE$readImageContainer$datas$1$frames$1$cells$1 = (ImageFrameLayer)item$iv$iv;
                    var67_223 = destination$iv$iv;
                    $i$a$-map-ASE$readImageContainer$datas$1$frames$1$layerData$2 = false;
                    sliceKeyFrame = sliceKey.getSliceFrame();
                    sliceFrame = new RectangleI(sliceKeyFrame.getX() - it.getTargetX(), sliceKeyFrame.getY() - it.getTargetY(), sliceKeyFrame.getWidth(), sliceKeyFrame.getHeight());
                    sslice = RectSlice.slice-EjYV8UY$default(it.getSlice(), sliceFrame, it.getSlice().getName(), false, 0, 12, null);
                    ninePatchSlice = slice.getHasNinePatch() != false ? NinePatchBitmap32Kt.asNinePatchSimple(sslice, sliceKey.getCenterXPos(), sliceKey.getCenterYPos(), sliceKey.getCenterXPos() + sliceKey.getCenterWidth(), sliceKey.getCenterYPos() + sliceKey.getCenterHeight()) : null;
                    var67_223.add(new ImageFrameLayer(it.getLayer(), sslice, (ASE.INSTANCE.useSlicePosition(props) != false ? sliceKeyFrame.getX() : it.getTargetX()) - sliceKey.getPivotX(), (ASE.INSTANCE.useSlicePosition(props) != false ? sliceKeyFrame.getY() : it.getTargetY()) - sliceKey.getPivotY(), it.getMain(), it.getIncludeInAtlas(), null, ninePatchSlice, 64, null));
                }
                layerData = (List)destination$iv$iv;
                if (((Collection)layerData).isEmpty() == false) {
                    $this$milliseconds$iv = frame.getTime();
                    $i$f$getMilliseconds = false;
                    v20 = new ImageFrame(frame.getIndex(), DurationKt.toDuration((double)$this$milliseconds$iv, DurationUnit.MILLISECONDS), layerData, null);
                } else {
                    v20 = null;
                }
                if (v20 == null) continue;
                it$iv$iv = v20;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            frames = (List)destination$iv$iv;
            if (((Collection)frames).isEmpty() == false && ASE.INSTANCE.slicingEnabled(props)) {
                $this$map$iv = image.getTags();
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    element$iv$iv$iv /* !! */  = (AseTag)item$iv$iv;
                    var75_232 = destination$iv$iv;
                    $i$a$-map-ASE$readImageContainer$datas$1$animations$1 = false;
                    framesRange = CollectionsKt.slice(frames, new IntRange(ClampKt.clamp(it.getFromFrame(), 0, frames.size()), ClampKt.clamp(it.getToFrame(), 0, frames.size() - 1)));
                    var75_232.add(new ImageAnimation(framesRange, it.getDirection(), it.getTagName(), null, 8, null));
                }
                animations = (List)destination$iv$iv;
                v21 = new ImageData(frames, 0, maxWidth, maxHeight, imageLayersToProcess, animations, slice.getName(), 2, null);
            } else {
                v21 = null;
            }
            if (v21 == null) continue;
            it$iv$iv = v21;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        datas = (List)destination$iv$iv;
        $this$forEachIndexed$iv = imageLayersToProcess;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            if ((var32_61 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $i$f$forEach = (AseLayer)item$iv;
            index = var32_61;
            $i$a$-forEachIndexed-ASE$readImageContainer$1 = false;
            element.setIndex(index);
        }
        var27_36 = datas;
        if (var27_36.isEmpty()) {
            $i$a$-ifEmpty-ASE$readImageContainer$2 = false;
            v22 = CollectionsKt.listOf(defaultData);
        } else {
            v22 = var27_36;
        }
        var79_235 = v22;
        return new ImageDataContainer(var79_235);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean takeLayersByName(ImageDecodingProps $this$takeLayersByName, String name2) {
        if (_DelegatesKt.getExtra($this$takeLayersByName, "layers") == null) return true;
        Object object = _DelegatesKt.getExtra($this$takeLayersByName, "layers");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        if (!StringsKt.contains$default((CharSequence)((String)object), name2, false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean slicingEnabled(ImageDecodingProps $this$slicingEnabled) {
        if (_DelegatesKt.getExtraTyped($this$slicingEnabled, "disableSlicing") == null) return true;
        Object t = _DelegatesKt.getExtraTyped($this$slicingEnabled, "disableSlicing");
        Intrinsics.checkNotNull(t);
        if ((Boolean)t != false) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean useSlicePosition(ImageDecodingProps $this$useSlicePosition) {
        if (_DelegatesKt.getExtraTyped($this$useSlicePosition, "useSlicePosition") == null) return false;
        Object t = _DelegatesKt.getExtraTyped($this$useSlicePosition, "useSlicePosition");
        Intrinsics.checkNotNull(t);
        if ((Boolean)t == false) return false;
        return true;
    }

    public final int readRGB-O1c-hRk(@NotNull SyncStream $this$readRGB_u2dO1c_u2dhRk) {
        return RGBA.Companion.invoke-u6-pZFY(SyncStreamKt.readU8($this$readRGB_u2dO1c_u2dhRk), SyncStreamKt.readU8($this$readRGB_u2dO1c_u2dhRk), SyncStreamKt.readU8($this$readRGB_u2dO1c_u2dhRk));
    }

    public final int readRGBA-O1c-hRk(@NotNull SyncStream $this$readRGBA_u2dO1c_u2dhRk) {
        return RGBA.constructor-impl(SyncStreamKt.readS32LE($this$readRGBA_u2dO1c_u2dhRk));
    }

    public final int readFixedLE-70vMFI0$korge_core(@NotNull SyncStream $this$readFixedLE_u2d70vMFI0) {
        return Fixed32.Companion.fromRaw-70vMFI0(SyncStreamKt.readS32LE($this$readFixedLE_u2d70vMFI0));
    }

    @NotNull
    public final String readAseString(@NotNull SyncStream $this$readAseString) {
        return SyncStreamKt.readString$default($this$readAseString, SyncStreamKt.readU16LE($this$readAseString), null, 2, null);
    }

    private static final ImageFrameLayer readImageContainer$createImageFrameLayer(FastArrayList<AseLayer> imageLayers, AseImage image2, int key, AseCell value) {
        AseCell resolved = value.resolve();
        AseLayer layer = imageLayers.get(key);
        TileMapData tilemap = null;
        if (resolved instanceof AseTilemapCell) {
            AseTileset tileset = image2.getTilesets().get(layer.getTilesetIndex());
            AseTileset aseTileset = tileset;
            tilemap = TileMapData.Companion.invoke$default(TileMapData.Companion, ((AseTilemapCell)resolved).getData(), aseTileset != null ? aseTileset.getTileSet() : null, ((AseTilemapCell)resolved).getTileBitmask(), ((AseTilemapCell)resolved).getBitmaskXFlip(), ((AseTilemapCell)resolved).getBitmaskYFlip(), ((AseTilemapCell)resolved).getBitmask90CWFlip(), 0, 0, false, null, null, 0.0f, 4032, null);
        }
        return new ImageFrameLayer(layer, BitmapSliceKt.slice-pvcgspk$default(resolved.getBmp(), null, null, 0, null, 15, null), resolved.getX(), resolved.getY(), false, true, tilemap, null, 128, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u0015X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lkorlibs/image/format/ASE$AseBitmapCell;", "Lkorlibs/image/format/ASE$AseEntity;", "Lkorlibs/image/format/ASE$AseCell;", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "x", "", "y", "opacity", "(Lkorlibs/image/bitmap/Bitmap;III)V", "getBmp", "()Lkorlibs/image/bitmap/Bitmap;", "getOpacity", "()I", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "getX", "getY", "korge-core"})
    public static class AseBitmapCell
    implements AseEntity,
    AseCell {
        @NotNull
        private final Bitmap bmp;
        private final int x;
        private final int y;
        private final int opacity;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;

        public AseBitmapCell(@NotNull Bitmap bmp2, int x, int y, int opacity) {
            this.bmp = bmp2;
            this.x = x;
            this.y = y;
            this.opacity = opacity;
            this.$$delegate_0 = AseEntity.Companion.invoke();
        }

        @Override
        @NotNull
        public Bitmap getBmp() {
            return this.bmp;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getOpacity() {
            return this.opacity;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @Override
        @NotNull
        public AseCell resolve() {
            return AseCell.DefaultImpls.resolve(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\b\u0010\u000e\u001a\u00020\u0000H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000f"}, d2={"Lkorlibs/image/format/ASE$AseCell;", "Lkorlibs/image/format/ASE$AseEntity;", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "getBmp", "()Lkorlibs/image/bitmap/Bitmap;", "opacity", "", "getOpacity", "()I", "x", "getX", "y", "getY", "resolve", "korge-core"})
    public static interface AseCell
    extends AseEntity {
        @NotNull
        public Bitmap getBmp();

        public int getX();

        public int getY();

        public int getOpacity();

        @NotNull
        public AseCell resolve();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static AseCell resolve(@NotNull AseCell $this) {
                return $this;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fR\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\tX\u00a6\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0010"}, d2={"Lkorlibs/image/format/ASE$AseEntity;", "", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "()I", "setUserDataColor-PXL95c4", "(I)V", "Companion", "Mixin", "korge-core"})
    public static interface AseEntity {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Nullable
        public String getUserData();

        public void setUserData(@Nullable String var1);

        public int getUserDataColor-JH0Opww();

        public void setUserDataColor-PXL95c4(int var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lkorlibs/image/format/ASE$AseEntity$Companion;", "", "()V", "invoke", "Lkorlibs/image/format/ASE$AseEntity$Mixin;", "korge-core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Mixin invoke() {
                return new Mixin();
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\nX\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0010"}, d2={"Lkorlibs/image/format/ASE$AseEntity$Mixin;", "Lkorlibs/image/format/ASE$AseEntity;", "()V", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "()I", "setUserDataColor-PXL95c4", "(I)V", "I", "korge-core"})
        public static class Mixin
        implements AseEntity {
            @Nullable
            private String userData;
            private int userDataColor = Colors.INSTANCE.getTRANSPARENT-JH0Opww();

            @Override
            @Nullable
            public String getUserData() {
                return this.userData;
            }

            @Override
            public void setUserData(@Nullable String string) {
                this.userData = string;
            }

            @Override
            public int getUserDataColor-JH0Opww() {
                return this.userDataColor;
            }

            @Override
            public void setUserDataColor-PXL95c4(int n) {
                this.userDataColor = n;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0004R\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u0017X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u0004\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lkorlibs/image/format/ASE$AseFrame;", "Lkorlibs/image/format/ASE$AseEntity;", "index", "", "(I)V", "celsByLayer", "Lkorlibs/datastructure/IntMap;", "Lkorlibs/image/format/ASE$AseCell;", "Lkorlibs/datastructure/FastIntMap;", "getCelsByLayer", "()Lkorlibs/datastructure/IntMap;", "getIndex", "()I", "time", "getTime", "setTime", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nASE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE$AseFrame\n+ 2 NonJs.kt\nkorlibs/datastructure/NonJsKt\n*L\n1#1,768:1\n226#2:769\n*S KotlinDebug\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE$AseFrame\n*L\n146#1:769\n*E\n"})
    public static class AseFrame
    implements AseEntity {
        private final int index;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        private int time;
        @NotNull
        private final IntMap<AseCell> celsByLayer;

        public AseFrame(int index2) {
            this.index = index2;
            this.$$delegate_0 = AseEntity.Companion.invoke();
            boolean $i$f$FastIntMap = false;
            this.celsByLayer = new IntMap(0, 0.0, 3, null);
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        public final int getTime() {
            return this.time;
        }

        public final void setTime(int n) {
            this.time = n;
        }

        @NotNull
        public final IntMap<AseCell> getCelsByLayer() {
            return this.celsByLayer;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u0005X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020%X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006*"}, d2={"Lkorlibs/image/format/ASE$AseImage;", "Lkorlibs/image/format/ASE$AseEntity;", "()V", "externalFiles", "Lkorlibs/datastructure/IntMap;", "", "getExternalFiles", "()Lkorlibs/datastructure/IntMap;", "frames", "Lkorlibs/datastructure/FastArrayList;", "Lkorlibs/image/format/ASE$AseFrame;", "getFrames", "()Lkorlibs/datastructure/FastArrayList;", "layers", "Lkorlibs/image/format/ASE$AseLayer;", "getLayers", "palette", "Lkorlibs/image/format/ASE$AsePalette;", "getPalette", "()Lkorlibs/image/format/ASE$AsePalette;", "setPalette", "(Lkorlibs/image/format/ASE$AsePalette;)V", "slices", "Lkorlibs/image/format/ASE$AseSlice;", "getSlices", "tags", "Lkorlibs/image/format/ASE$AseTag;", "getTags", "tilesets", "Lkorlibs/image/format/ASE$AseTileset;", "getTilesets", "userData", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "()I", "setUserDataColor-PXL95c4", "(I)V", "korge-core"})
    public static class AseImage
    implements AseEntity {
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        @Nullable
        private AsePalette palette;
        @NotNull
        private final FastArrayList<AseLayer> layers = new FastArrayList();
        @NotNull
        private final FastArrayList<AseFrame> frames = new FastArrayList();
        @NotNull
        private final FastArrayList<AseTag> tags = new FastArrayList();
        @NotNull
        private final FastArrayList<AseSlice> slices = new FastArrayList();
        @NotNull
        private final IntMap<String> externalFiles = new IntMap(0, 0.0, 3, null);
        @NotNull
        private final IntMap<AseTileset> tilesets = new IntMap(0, 0.0, 3, null);

        public AseImage() {
            this.$$delegate_0 = AseEntity.Companion.invoke();
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @Nullable
        public final AsePalette getPalette() {
            return this.palette;
        }

        public final void setPalette(@Nullable AsePalette asePalette) {
            this.palette = asePalette;
        }

        @NotNull
        public final FastArrayList<AseLayer> getLayers() {
            return this.layers;
        }

        @NotNull
        public final FastArrayList<AseFrame> getFrames() {
            return this.frames;
        }

        @NotNull
        public final FastArrayList<AseTag> getTags() {
            return this.tags;
        }

        @NotNull
        public final FastArrayList<AseSlice> getSlices() {
            return this.slices;
        }

        @NotNull
        public final IntMap<String> getExternalFiles() {
            return this.externalFiles;
        }

        @NotNull
        public final IntMap<AseTileset> getTilesets() {
            return this.tilesets;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010 \u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0011\u0010!\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u0011\u0010\"\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R\u0011\u0010#\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u001a\u0010*\u001a\u0004\u0018\u00010\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001e\u0010/\u001a\u000200X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b1\u0010\u0019\"\u0004\b2\u00103\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00064"}, d2={"Lkorlibs/image/format/ASE$AseLayer;", "Lkorlibs/image/format/ImageLayer;", "Lkorlibs/image/format/ASE$AseEntity;", "originalAseIndex", "", "index", "name", "", "flags", "type", "Lkorlibs/image/format/ImageLayer$Type;", "childLevel", "blendModeInt", "opacity", "tilesetIndex", "(IILjava/lang/String;ILkorlibs/image/format/ImageLayer$Type;IIII)V", "background", "", "getBackground", "()Z", "blendMode", "Lkorlibs/image/vector/BlendMode;", "getBlendMode", "()Lkorlibs/image/vector/BlendMode;", "getBlendModeInt", "()I", "getChildLevel", "collapsed", "getCollapsed", "getFlags", "isEditable", "isGroup", "isReferenceLayer", "isTilemap", "isVisible", "lockMovement", "getLockMovement", "getOpacity", "getOriginalAseIndex", "preferredLinkedCels", "getPreferredLinkedCels", "getTilesetIndex", "userData", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "korge-core"})
    public static class AseLayer
    extends ImageLayer
    implements AseEntity {
        private final int originalAseIndex;
        private final int flags;
        private final int childLevel;
        private final int blendModeInt;
        private final int opacity;
        private final int tilesetIndex;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        private final boolean isVisible;
        private final boolean isEditable;
        private final boolean lockMovement;
        private final boolean background;
        private final boolean preferredLinkedCels;
        private final boolean collapsed;
        private final boolean isReferenceLayer;
        @NotNull
        private final BlendMode blendMode;

        public AseLayer(int originalAseIndex, int index2, @NotNull String name2, int flags, @NotNull ImageLayer.Type type2, int childLevel, int blendModeInt, int opacity, int tilesetIndex) {
            super(index2, name2, type2);
            BlendMode blendMode;
            this.originalAseIndex = originalAseIndex;
            this.flags = flags;
            this.childLevel = childLevel;
            this.blendModeInt = blendModeInt;
            this.opacity = opacity;
            this.tilesetIndex = tilesetIndex;
            this.$$delegate_0 = AseEntity.Companion.invoke();
            this.isVisible = BitsKt.hasBitSet(this.flags, 0);
            this.isEditable = BitsKt.hasBitSet(this.flags, 1);
            this.lockMovement = BitsKt.hasBitSet(this.flags, 2);
            this.background = BitsKt.hasBitSet(this.flags, 3);
            this.preferredLinkedCels = BitsKt.hasBitSet(this.flags, 4);
            this.collapsed = BitsKt.hasBitSet(this.flags, 5);
            this.isReferenceLayer = BitsKt.hasBitSet(this.flags, 6);
            switch (this.blendModeInt) {
                case 0: {
                    blendMode = BlendMode.NORMAL;
                    break;
                }
                case 1: {
                    blendMode = BlendMode.MULTIPLY;
                    break;
                }
                case 2: {
                    blendMode = BlendMode.SCREEN;
                    break;
                }
                case 3: {
                    blendMode = BlendMode.OVERLAY;
                    break;
                }
                case 4: {
                    blendMode = BlendMode.DARKEN;
                    break;
                }
                case 5: {
                    blendMode = BlendMode.LIGHTEN;
                    break;
                }
                case 6: {
                    blendMode = BlendMode.COLOR_DODGE;
                    break;
                }
                case 7: {
                    blendMode = BlendMode.COLOR_BURN;
                    break;
                }
                case 8: {
                    blendMode = BlendMode.HARD_LIGHT;
                    break;
                }
                case 9: {
                    blendMode = BlendMode.SOFT_LIGHT;
                    break;
                }
                case 10: {
                    blendMode = BlendMode.DIFFERENCE;
                    break;
                }
                case 11: {
                    blendMode = BlendMode.EXCLUSION;
                    break;
                }
                case 12: {
                    blendMode = BlendMode.HUE;
                    break;
                }
                case 13: {
                    blendMode = BlendMode.SATURATION;
                    break;
                }
                case 14: {
                    blendMode = BlendMode.COLOR;
                    break;
                }
                case 15: {
                    blendMode = BlendMode.LUMINOSITY;
                    break;
                }
                case 16: {
                    blendMode = BlendMode.ADDITION;
                    break;
                }
                case 17: {
                    blendMode = BlendMode.SUBTRACT;
                    break;
                }
                case 18: {
                    blendMode = BlendMode.DIVIDE;
                    break;
                }
                default: {
                    blendMode = BlendMode.NORMAL;
                }
            }
            this.blendMode = blendMode;
        }

        public final int getOriginalAseIndex() {
            return this.originalAseIndex;
        }

        public final int getFlags() {
            return this.flags;
        }

        public final int getChildLevel() {
            return this.childLevel;
        }

        public final int getBlendModeInt() {
            return this.blendModeInt;
        }

        public final int getOpacity() {
            return this.opacity;
        }

        public final int getTilesetIndex() {
            return this.tilesetIndex;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        public final boolean isEditable() {
            return this.isEditable;
        }

        public final boolean getLockMovement() {
            return this.lockMovement;
        }

        public final boolean getBackground() {
            return this.background;
        }

        public final boolean getPreferredLinkedCels() {
            return this.preferredLinkedCels;
        }

        public final boolean getCollapsed() {
            return this.collapsed;
        }

        public final boolean isReferenceLayer() {
            return this.isReferenceLayer;
        }

        public final boolean isGroup() {
            return this.getType().isGroup();
        }

        public final boolean isTilemap() {
            return this.getType().isTilemap();
        }

        @NotNull
        public final BlendMode getBlendMode() {
            return this.blendMode;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u0016X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u0019\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lkorlibs/image/format/ASE$AseLayerCell;", "Lkorlibs/image/format/ASE$AseEntity;", "frameIndex", "", "layer", "Lkorlibs/image/format/ASE$AseLayer;", "cell", "Lkorlibs/image/format/ASE$AseCell;", "(ILkorlibs/image/format/ASE$AseLayer;Lkorlibs/image/format/ASE$AseCell;)V", "getCell", "()Lkorlibs/image/format/ASE$AseCell;", "getFrameIndex", "()I", "getLayer", "()Lkorlibs/image/format/ASE$AseLayer;", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "korge-core"})
    public static class AseLayerCell
    implements AseEntity {
        private final int frameIndex;
        @NotNull
        private final AseLayer layer;
        @NotNull
        private final AseCell cell;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;

        public AseLayerCell(int frameIndex, @NotNull AseLayer layer, @NotNull AseCell cell) {
            this.frameIndex = frameIndex;
            this.layer = layer;
            this.cell = cell;
            this.$$delegate_0 = AseEntity.Companion.invoke();
        }

        public final int getFrameIndex() {
            return this.frameIndex;
        }

        @NotNull
        public final AseLayer getLayer() {
            return this.layer;
        }

        @NotNull
        public final AseCell getCell() {
            return this.cell;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u0002H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u0018X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Lkorlibs/image/format/ASE$AseLinkedCell;", "Lkorlibs/image/format/ASE$AseEntity;", "Lkorlibs/image/format/ASE$AseCell;", "linkedCell", "x", "", "y", "opacity", "(Lkorlibs/image/format/ASE$AseCell;III)V", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "getBmp", "()Lkorlibs/image/bitmap/Bitmap;", "getLinkedCell", "()Lkorlibs/image/format/ASE$AseCell;", "getOpacity", "()I", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "getX", "getY", "resolve", "korge-core"})
    public static class AseLinkedCell
    implements AseEntity,
    AseCell {
        @NotNull
        private final AseCell linkedCell;
        private final int x;
        private final int y;
        private final int opacity;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;

        public AseLinkedCell(@NotNull AseCell linkedCell, int x, int y, int opacity) {
            this.linkedCell = linkedCell;
            this.x = x;
            this.y = y;
            this.opacity = opacity;
            this.$$delegate_0 = AseEntity.Companion.invoke();
        }

        @NotNull
        public final AseCell getLinkedCell() {
            return this.linkedCell;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getOpacity() {
            return this.opacity;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @Override
        @NotNull
        public Bitmap getBmp() {
            return this.linkedCell.getBmp();
        }

        @Override
        @NotNull
        public AseCell resolve() {
            return this.linkedCell.resolve();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\b\u0002\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u0012X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0017"}, d2={"Lkorlibs/image/format/ASE$AsePalette;", "Lkorlibs/image/bitmap/Palette;", "Lkorlibs/image/format/ASE$AseEntity;", "colors", "Lkorlibs/image/color/RgbaArray;", "names", "", "", "changeStart", "", "changeEnd", "([I[Ljava/lang/String;IILkotlin/jvm/internal/DefaultConstructorMarker;)V", "userData", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "()I", "setUserDataColor-PXL95c4", "(I)V", "korge-core"})
    public static class AsePalette
    extends Palette
    implements AseEntity {
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;

        private AsePalette(int[] colors, String[] names2, int changeStart, int changeEnd) {
            super(colors, names2, changeStart, changeEnd, null);
            this.$$delegate_0 = AseEntity.Companion.invoke();
        }

        public /* synthetic */ AsePalette(int[] nArray, String[] stringArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                stringArray = null;
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(nArray, stringArray, n, n2, null);
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        public /* synthetic */ AsePalette(int[] colors, String[] names2, int changeStart, int changeEnd, DefaultConstructorMarker $constructor_marker) {
            this(colors, names2, changeStart, changeEnd);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u0017X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lkorlibs/image/format/ASE$AseSlice;", "Lkorlibs/image/format/ASE$AseEntity;", "name", "", "hasNinePatch", "", "hasPivotInfo", "(Ljava/lang/String;ZZ)V", "getHasNinePatch", "()Z", "getHasPivotInfo", "keys", "Lkorlibs/datastructure/FastArrayList;", "Lkorlibs/image/format/ASE$AseSliceKey;", "getKeys", "()Lkorlibs/datastructure/FastArrayList;", "getName", "()Ljava/lang/String;", "userData", "getUserData", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "()I", "setUserDataColor-PXL95c4", "(I)V", "getSliceForFrame", "index", "", "sortKeys", "", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nASE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE$AseSlice\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NonJs.kt\nkorlibs/datastructure/FastArrayList\n*L\n1#1,768:1\n1002#2,2:769\n184#3,11:771\n*S KotlinDebug\n*F\n+ 1 ASE.kt\nkorlibs/image/format/ASE$AseSlice\n*L\n197#1:769,2\n203#1:771,11\n*E\n"})
    public static class AseSlice
    implements AseEntity {
        @NotNull
        private final String name;
        private final boolean hasNinePatch;
        private final boolean hasPivotInfo;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        @NotNull
        private final FastArrayList<AseSliceKey> keys;

        public AseSlice(@NotNull String name2, boolean hasNinePatch, boolean hasPivotInfo) {
            this.name = name2;
            this.hasNinePatch = hasNinePatch;
            this.hasPivotInfo = hasPivotInfo;
            this.$$delegate_0 = AseEntity.Companion.invoke();
            this.keys = new FastArrayList();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getHasNinePatch() {
            return this.hasNinePatch;
        }

        public final boolean getHasPivotInfo() {
            return this.hasPivotInfo;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @NotNull
        public final FastArrayList<AseSliceKey> getKeys() {
            return this.keys;
        }

        public final void sortKeys() {
            List $this$sortBy$iv = this.keys;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        AseSliceKey it = (AseSliceKey)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getFrameIndex());
                        it = (AseSliceKey)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getFrameIndex());
                    }
                });
            }
        }

        @NotNull
        public final AseSliceKey getSliceForFrame(int index2) {
            int size$iv;
            FastArrayList<AseSliceKey> this_$iv = this.keys;
            boolean $i$f$fastForEachReverse = false;
            Object[] array$iv = this_$iv.getArray();
            int initialSize$iv = this_$iv.get_size();
            for (int n$iv = 0; n$iv < (size$iv = Math.min(initialSize$iv, this_$iv.get_size())); ++n$iv) {
                int index$iv = size$iv - n$iv - 1;
                AseSliceKey it = (AseSliceKey)array$iv[index$iv];
                boolean bl = false;
                if (index2 < it.getFrameIndex()) continue;
                return it;
            }
            AseSliceKey aseSliceKey = (AseSliceKey)CollectionsKt.firstOrNull((List)this.keys);
            if (aseSliceKey == null) {
                throw new IllegalStateException("No frames key frames for slice!".toString());
            }
            return aseSliceKey;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001e\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010\u00a8\u0006\""}, d2={"Lkorlibs/image/format/ASE$AseSliceKey;", "", "frameIndex", "", "sliceXOrigin", "sliceYOrigin", "sliceWidth", "sliceHeight", "centerXPos", "centerYPos", "centerWidth", "centerHeight", "pivotX", "pivotY", "(IIIIIIIIIII)V", "getCenterHeight", "()I", "getCenterWidth", "getCenterXPos", "getCenterYPos", "getFrameIndex", "getPivotX", "getPivotY", "sliceFrame", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "getSliceFrame", "()Lkorlibs/math/geom/RectangleI;", "setSliceFrame", "(Lkorlibs/math/geom/RectangleI;)V", "getSliceHeight", "getSliceWidth", "getSliceXOrigin", "getSliceYOrigin", "korge-core"})
    public static class AseSliceKey {
        private final int frameIndex;
        private final int sliceXOrigin;
        private final int sliceYOrigin;
        private final int sliceWidth;
        private final int sliceHeight;
        private final int centerXPos;
        private final int centerYPos;
        private final int centerWidth;
        private final int centerHeight;
        private final int pivotX;
        private final int pivotY;
        @NotNull
        private RectangleI sliceFrame;

        public AseSliceKey(int frameIndex, int sliceXOrigin, int sliceYOrigin, int sliceWidth, int sliceHeight, int centerXPos, int centerYPos, int centerWidth, int centerHeight, int pivotX, int pivotY) {
            this.frameIndex = frameIndex;
            this.sliceXOrigin = sliceXOrigin;
            this.sliceYOrigin = sliceYOrigin;
            this.sliceWidth = sliceWidth;
            this.sliceHeight = sliceHeight;
            this.centerXPos = centerXPos;
            this.centerYPos = centerYPos;
            this.centerWidth = centerWidth;
            this.centerHeight = centerHeight;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.sliceFrame = new RectangleI(this.sliceXOrigin, this.sliceYOrigin, this.sliceWidth, this.sliceHeight);
        }

        public final int getFrameIndex() {
            return this.frameIndex;
        }

        public final int getSliceXOrigin() {
            return this.sliceXOrigin;
        }

        public final int getSliceYOrigin() {
            return this.sliceYOrigin;
        }

        public final int getSliceWidth() {
            return this.sliceWidth;
        }

        public final int getSliceHeight() {
            return this.sliceHeight;
        }

        public final int getCenterXPos() {
            return this.centerXPos;
        }

        public final int getCenterYPos() {
            return this.centerYPos;
        }

        public final int getCenterWidth() {
            return this.centerWidth;
        }

        public final int getCenterHeight() {
            return this.centerHeight;
        }

        public final int getPivotX() {
            return this.pivotX;
        }

        public final int getPivotY() {
            return this.pivotY;
        }

        @NotNull
        public final RectangleI getSliceFrame() {
            return this.sliceFrame;
        }

        public final void setSliceFrame(@NotNull RectangleI rectangleI) {
            this.sliceFrame = rectangleI;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0019\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u0004\u0018\u00010\tX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u0007X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u001e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Lkorlibs/image/format/ASE$AseTag;", "Lkorlibs/image/format/ASE$AseEntity;", "fromFrame", "", "toFrame", "directionByte", "tagColor", "Lkorlibs/image/color/RGBA;", "tagName", "", "(IIIILjava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "direction", "Lkorlibs/image/format/ImageAnimation$Direction;", "getDirection", "()Lkorlibs/image/format/ImageAnimation$Direction;", "getDirectionByte", "()I", "getFromFrame", "getTagColor-JH0Opww", "I", "getTagName", "()Ljava/lang/String;", "getToFrame", "userData", "getUserData", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "korge-core"})
    public static class AseTag
    implements AseEntity {
        private final int fromFrame;
        private final int toFrame;
        private final int directionByte;
        private final int tagColor;
        @NotNull
        private final String tagName;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        @NotNull
        private final ImageAnimation.Direction direction;

        private AseTag(int fromFrame, int toFrame, int directionByte, int tagColor, String tagName) {
            ImageAnimation.Direction direction2;
            this.fromFrame = fromFrame;
            this.toFrame = toFrame;
            this.directionByte = directionByte;
            this.tagColor = tagColor;
            this.tagName = tagName;
            this.$$delegate_0 = AseEntity.Companion.invoke();
            switch (this.directionByte) {
                case 0: {
                    direction2 = ImageAnimation.Direction.FORWARD;
                    break;
                }
                case 1: {
                    direction2 = ImageAnimation.Direction.REVERSE;
                    break;
                }
                case 2: {
                    direction2 = ImageAnimation.Direction.PING_PONG;
                    break;
                }
                default: {
                    direction2 = ImageAnimation.Direction.FORWARD;
                }
            }
            this.direction = direction2;
        }

        public final int getFromFrame() {
            return this.fromFrame;
        }

        public final int getToFrame() {
            return this.toFrame;
        }

        public final int getDirectionByte() {
            return this.directionByte;
        }

        public final int getTagColor-JH0Opww() {
            return this.tagColor;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @NotNull
        public final ImageAnimation.Direction getDirection() {
            return this.direction;
        }

        public /* synthetic */ AseTag(int fromFrame, int toFrame, int directionByte, int tagColor, String tagName, DefaultConstructorMarker $constructor_marker) {
            this(fromFrame, toFrame, directionByte, tagColor, tagName);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020!X\u0096\u000f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010$R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lkorlibs/image/format/ASE$AseTilemapCell;", "Lkorlibs/image/format/ASE$AseEntity;", "Lkorlibs/image/format/ASE$AseCell;", "data", "Lkorlibs/datastructure/IntArray2;", "tileBitmask", "", "bitmaskXFlip", "bitmaskYFlip", "bitmask90CWFlip", "x", "y", "opacity", "(Lkorlibs/datastructure/IntArray2;IIIIIII)V", "getBitmask90CWFlip", "()I", "getBitmaskXFlip", "getBitmaskYFlip", "bmp", "Lkorlibs/image/bitmap/Bitmap;", "getBmp", "()Lkorlibs/image/bitmap/Bitmap;", "getData", "()Lkorlibs/datastructure/IntArray2;", "getOpacity", "getTileBitmask", "userData", "", "getUserData", "()Ljava/lang/String;", "setUserData", "(Ljava/lang/String;)V", "userDataColor", "Lkorlibs/image/color/RGBA;", "getUserDataColor-JH0Opww", "setUserDataColor-PXL95c4", "(I)V", "getX", "getY", "korge-core"})
    public static class AseTilemapCell
    implements AseEntity,
    AseCell {
        @NotNull
        private final IntArray2 data;
        private final int tileBitmask;
        private final int bitmaskXFlip;
        private final int bitmaskYFlip;
        private final int bitmask90CWFlip;
        private final int x;
        private final int y;
        private final int opacity;
        private final /* synthetic */ AseEntity.Mixin $$delegate_0;
        @NotNull
        private final Bitmap bmp;

        public AseTilemapCell(@NotNull IntArray2 data2, int tileBitmask, int bitmaskXFlip, int bitmaskYFlip, int bitmask90CWFlip, int x, int y, int opacity) {
            this.data = data2;
            this.tileBitmask = tileBitmask;
            this.bitmaskXFlip = bitmaskXFlip;
            this.bitmaskYFlip = bitmaskYFlip;
            this.bitmask90CWFlip = bitmask90CWFlip;
            this.x = x;
            this.y = y;
            this.opacity = opacity;
            this.$$delegate_0 = AseEntity.Companion.invoke();
            this.bmp = new Bitmap32(1, 1, null, true, 4, null);
        }

        @NotNull
        public final IntArray2 getData() {
            return this.data;
        }

        public final int getTileBitmask() {
            return this.tileBitmask;
        }

        public final int getBitmaskXFlip() {
            return this.bitmaskXFlip;
        }

        public final int getBitmaskYFlip() {
            return this.bitmaskYFlip;
        }

        public final int getBitmask90CWFlip() {
            return this.bitmask90CWFlip;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getOpacity() {
            return this.opacity;
        }

        @Override
        @Nullable
        public String getUserData() {
            return this.$$delegate_0.getUserData();
        }

        @Override
        public void setUserData(@Nullable String string) {
            this.$$delegate_0.setUserData(string);
        }

        @Override
        public int getUserDataColor-JH0Opww() {
            return this.$$delegate_0.getUserDataColor-JH0Opww();
        }

        @Override
        public void setUserDataColor-PXL95c4(int n) {
            this.$$delegate_0.setUserDataColor-PXL95c4(n);
        }

        @Override
        @NotNull
        public Bitmap getBmp() {
            return this.bmp;
        }

        @Override
        @NotNull
        public AseCell resolve() {
            return AseCell.DefaultImpls.resolve(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\u001b\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u00c6\u0003Ja\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r0\fj\u0002`\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lkorlibs/image/format/ASE$AseTileset;", "", "tilesetId", "", "ntiles", "tileWidth", "tileHeight", "baseIndex", "tilesetName", "", "tiles", "", "Lkorlibs/math/geom/slice/RectSlice;", "Lkorlibs/image/bitmap/Bitmap;", "Lkorlibs/image/bitmap/BmpSlice;", "(IIIIILjava/lang/String;Ljava/util/List;)V", "getBaseIndex", "()I", "getNtiles", "getTileHeight", "tileSet", "Lkorlibs/image/tiles/TileSet;", "getTileSet", "()Lkorlibs/image/tiles/TileSet;", "getTileWidth", "getTiles", "()Ljava/util/List;", "getTilesetId", "getTilesetName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "korge-core"})
    public static final class AseTileset {
        private final int tilesetId;
        private final int ntiles;
        private final int tileWidth;
        private final int tileHeight;
        private final int baseIndex;
        @NotNull
        private final String tilesetName;
        @NotNull
        private final List<RectSlice<? extends Bitmap>> tiles;
        @NotNull
        private final TileSet tileSet;

        /*
         * WARNING - void declaration
         */
        public AseTileset(int tilesetId, int ntiles, int tileWidth, int tileHeight, int baseIndex, @NotNull String tilesetName, @NotNull List<? extends RectSlice<? extends Bitmap>> tiles) {
            IntMap intMap;
            this.tilesetId = tilesetId;
            this.ntiles = ntiles;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            this.baseIndex = baseIndex;
            this.tilesetName = tilesetName;
            this.tiles = tiles;
            IntMap intMap2 = intMap = new IntMap(0, 0.0, 3, null);
            AseTileset aseTileset = this;
            boolean bl = false;
            int n = this.tiles.size();
            for (int n2 = 0; n2 < n; ++n2) {
                void map2;
                int id2 = n2;
                map2.set(id2, new TileSetTileInfo(id2, this.tiles.get(n2), null, null, 12, null));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 6;
            int n4 = 0;
            int n5 = 0;
            IntMap intMap3 = intMap;
            aseTileset.tileSet = new TileSet(intMap3, n5, n4, n3, defaultConstructorMarker);
        }

        public final int getTilesetId() {
            return this.tilesetId;
        }

        public final int getNtiles() {
            return this.ntiles;
        }

        public final int getTileWidth() {
            return this.tileWidth;
        }

        public final int getTileHeight() {
            return this.tileHeight;
        }

        public final int getBaseIndex() {
            return this.baseIndex;
        }

        @NotNull
        public final String getTilesetName() {
            return this.tilesetName;
        }

        @NotNull
        public final List<RectSlice<? extends Bitmap>> getTiles() {
            return this.tiles;
        }

        @NotNull
        public final TileSet getTileSet() {
            return this.tileSet;
        }

        public final int component1() {
            return this.tilesetId;
        }

        public final int component2() {
            return this.ntiles;
        }

        public final int component3() {
            return this.tileWidth;
        }

        public final int component4() {
            return this.tileHeight;
        }

        public final int component5() {
            return this.baseIndex;
        }

        @NotNull
        public final String component6() {
            return this.tilesetName;
        }

        @NotNull
        public final List<RectSlice<? extends Bitmap>> component7() {
            return this.tiles;
        }

        @NotNull
        public final AseTileset copy(int tilesetId, int ntiles, int tileWidth, int tileHeight, int baseIndex, @NotNull String tilesetName, @NotNull List<? extends RectSlice<? extends Bitmap>> tiles) {
            return new AseTileset(tilesetId, ntiles, tileWidth, tileHeight, baseIndex, tilesetName, tiles);
        }

        public static /* synthetic */ AseTileset copy$default(AseTileset aseTileset, int n, int n2, int n3, int n4, int n5, String string, List list2, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = aseTileset.tilesetId;
            }
            if ((n6 & 2) != 0) {
                n2 = aseTileset.ntiles;
            }
            if ((n6 & 4) != 0) {
                n3 = aseTileset.tileWidth;
            }
            if ((n6 & 8) != 0) {
                n4 = aseTileset.tileHeight;
            }
            if ((n6 & 0x10) != 0) {
                n5 = aseTileset.baseIndex;
            }
            if ((n6 & 0x20) != 0) {
                string = aseTileset.tilesetName;
            }
            if ((n6 & 0x40) != 0) {
                list2 = aseTileset.tiles;
            }
            return aseTileset.copy(n, n2, n3, n4, n5, string, list2);
        }

        @NotNull
        public String toString() {
            return "AseTileset(tilesetId=" + this.tilesetId + ", ntiles=" + this.ntiles + ", tileWidth=" + this.tileWidth + ", tileHeight=" + this.tileHeight + ", baseIndex=" + this.baseIndex + ", tilesetName=" + this.tilesetName + ", tiles=" + this.tiles + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.tilesetId);
            result2 = result2 * 31 + Integer.hashCode(this.ntiles);
            result2 = result2 * 31 + Integer.hashCode(this.tileWidth);
            result2 = result2 * 31 + Integer.hashCode(this.tileHeight);
            result2 = result2 * 31 + Integer.hashCode(this.baseIndex);
            result2 = result2 * 31 + this.tilesetName.hashCode();
            result2 = result2 * 31 + ((Object)this.tiles).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AseTileset)) {
                return false;
            }
            AseTileset aseTileset = (AseTileset)other;
            if (this.tilesetId != aseTileset.tilesetId) {
                return false;
            }
            if (this.ntiles != aseTileset.ntiles) {
                return false;
            }
            if (this.tileWidth != aseTileset.tileWidth) {
                return false;
            }
            if (this.tileHeight != aseTileset.tileHeight) {
                return false;
            }
            if (this.baseIndex != aseTileset.baseIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tilesetName, aseTileset.tilesetName)) {
                return false;
            }
            return Intrinsics.areEqual(this.tiles, aseTileset.tiles);
        }
    }
}

