/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.bitmap.Bitmap32;
import korlibs.image.bitmap.Bitmap8;
import korlibs.image.color.BGR;
import korlibs.image.color.BGRA;
import korlibs.image.color.ColorFormat;
import korlibs.image.color.ColorFormatKt;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageEncodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.io.stream.FastByteArrayInputStream;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncOutputStream;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lkorlibs/image/format/BMP;", "Lkorlibs/image/format/ImageFormat;", "()V", "decodeHeader", "Lkorlibs/image/format/BMP$BmImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readImage", "Lkorlibs/image/format/ImageData;", "writeImage", "", "image", "Lkorlibs/image/format/ImageEncodingProps;", "BmImageInfo", "korge-core"})
public final class BMP
extends ImageFormat {
    @NotNull
    public static final BMP INSTANCE = new BMP();

    private BMP() {
        String[] stringArray = new String[]{"bmp"};
        super(stringArray);
    }

    @Override
    @Nullable
    public BmImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        BmImageInfo bmImageInfo;
        if (!Intrinsics.areEqual(SyncStreamKt.readStringz$default((SyncInputStream)s, 2, null, 2, null), "BM")) {
            return null;
        }
        int size2 = SyncStreamKt.readS32LE(s);
        int reserved1 = SyncStreamKt.readS16LE(s);
        int reserved2 = SyncStreamKt.readS16LE(s);
        int offBits = SyncStreamKt.readS32LE(s);
        int bsize = SyncStreamKt.readS32LE(s);
        FastByteArrayInputStream ss2 = SyncStreamKt.readFastByteArrayInputStream(s, bsize - 4);
        int width2 = ss2.readS32LE();
        int height2 = ss2.readS32LE();
        int planes = ss2.readS16LE();
        int bitcount = ss2.readS16LE();
        int compression = ss2.readS32LE();
        int sizeImage = ss2.readS32LE();
        int pixelsPerMeterX = ss2.readS32LE();
        int pixelsPerMeterY = ss2.readS32LE();
        int clrUsed = ss2.readS32LE();
        int clrImportant = ss2.readS32LE();
        BmImageInfo $this$decodeHeader_u24lambda_u240 = bmImageInfo = new BmImageInfo();
        boolean bl = false;
        $this$decodeHeader_u24lambda_u240.setCompression(compression);
        $this$decodeHeader_u24lambda_u240.setSizeImage(sizeImage);
        $this$decodeHeader_u24lambda_u240.setFlipX(width2 < 0);
        $this$decodeHeader_u24lambda_u240.setFlipY(height2 >= 0);
        $this$decodeHeader_u24lambda_u240.setWidth(Math.abs(width2));
        $this$decodeHeader_u24lambda_u240.setHeight(Math.abs(height2));
        $this$decodeHeader_u24lambda_u240.setBitsPerPixel(bitcount);
        return bmImageInfo;
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageData imageData;
        BmImageInfo bmImageInfo = this.decodeHeader(s, props);
        if (bmImageInfo == null) {
            throw new IllegalArgumentException("Not a BMP file");
        }
        BmImageInfo h = bmImageInfo;
        switch (h.getCompression()) {
            case 0: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported BMP compression " + h.getCompression()).toString());
            }
        }
        switch (h.getBitsPerPixel()) {
            case 8: {
                int n;
                Bitmap8 out = new Bitmap8(h.getWidth(), h.getHeight(), null, null, 12, null);
                for (n = 0; n < 256; ++n) {
                    RgbaArray.set-XDoMphA(out.getPalette-FROm4YY(), n, RGBA.Companion.invoke-GWFm98M(SyncStreamKt.readS32LE(s), 255));
                }
                int n2 = h.getHeight();
                for (n = 0; n < n2; ++n) {
                    out.setRow(h.getHeight() - n - 1, SyncStreamKt.readBytes(s, h.getWidth()));
                }
                imageData = ImageData.Companion.invoke(out);
                break;
            }
            case 24: 
            case 32: {
                int bytesPerRow = h.getWidth() * h.getBitsPerPixel() / 8;
                Bitmap32 out = new Bitmap32(h.getWidth(), h.getHeight(), null, false, 4, null);
                byte[] row = new byte[bytesPerRow];
                ColorFormat format2 = h.getBitsPerPixel() == 24 ? (ColorFormat)BGR.INSTANCE : (ColorFormat)BGRA.INSTANCE;
                int padding = 4 - bytesPerRow % 4;
                boolean flipY = h.getFlipY();
                int n = h.getHeight();
                for (int n3 = 0; n3 < n; ++n3) {
                    int y = h.getFlipY() ? h.getHeight() - n3 - 1 : n3;
                    SyncInputStream.DefaultImpls.read$default(s, row, 0, 0, 6, null);
                    ColorFormatKt.decode-GuNni5w$default(format2, row, 0, RgbaArray.constructor-impl(out.getInts()), out.index(0, y), h.getWidth(), false, 32, null);
                    if (padding == 4) continue;
                    s.skip(padding);
                }
                imageData = ImageData.Companion.invoke(out);
                break;
            }
            default: {
                String string = "Unsupported bitsPerPixel=" + h.getBitsPerPixel();
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return imageData;
    }

    @Override
    public void writeImage(@NotNull ImageData image2, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        Bitmap32 bmp2 = image2.getMainBitmap().toBMP32();
        SyncStreamKt.write8(s, 66);
        SyncStreamKt.write8(s, 77);
        SyncStreamKt.write32LE((SyncOutputStream)s, 4 * bmp2.getArea());
        SyncStreamKt.write32LE((SyncOutputStream)s, 0);
        SyncStreamKt.write32LE((SyncOutputStream)s, 54);
        SyncStreamKt.write32LE((SyncOutputStream)s, 40);
        SyncStreamKt.write32LE((SyncOutputStream)s, bmp2.getWidth());
        SyncStreamKt.write32LE((SyncOutputStream)s, bmp2.getHeight() * 2);
        SyncStreamKt.write16LE(s, 1);
        SyncStreamKt.write16LE(s, 32);
        SyncStreamKt.write32LE((SyncOutputStream)s, 0);
        SyncStreamKt.write32LE((SyncOutputStream)s, 4 * bmp2.getArea());
        SyncStreamKt.write32LE((SyncOutputStream)s, 2834);
        SyncStreamKt.write32LE((SyncOutputStream)s, 2834);
        SyncStreamKt.write32LE((SyncOutputStream)s, 0);
        SyncStreamKt.write32LE((SyncOutputStream)s, 0);
        int n = bmp2.getHeight();
        for (int n2 = 0; n2 < n; ++n2) {
            int y = bmp2.getHeight() - 1 - n2;
            SyncStreamKt.writeBytes(s, ColorFormatKt.encode-MtLQgE8(BGRA.INSTANCE, RgbaArray.constructor-impl(bmp2.getInts()), y * bmp2.getWidth(), bmp2.getWidth(), true));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lkorlibs/image/format/BMP$BmImageInfo;", "Lkorlibs/image/format/ImageInfo;", "()V", "compression", "", "getCompression", "()I", "setCompression", "(I)V", "flipX", "", "getFlipX", "()Z", "setFlipX", "(Z)V", "flipY", "getFlipY", "setFlipY", "sizeImage", "getSizeImage", "setSizeImage", "korge-core"})
    public static final class BmImageInfo
    extends ImageInfo {
        private boolean flipX;
        private boolean flipY;
        private int compression;
        private int sizeImage;

        public final boolean getFlipX() {
            return this.flipX;
        }

        public final void setFlipX(boolean bl) {
            this.flipX = bl;
        }

        public final boolean getFlipY() {
            return this.flipY;
        }

        public final void setFlipY(boolean bl) {
            this.flipY = bl;
        }

        public final int getCompression() {
            return this.compression;
        }

        public final void setCompression(int n) {
            this.compression = n;
        }

        public final int getSizeImage() {
            return this.sizeImage;
        }

        public final void setSizeImage(int n) {
            this.sizeImage = n;
        }
    }
}

