/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.format.DDSKt;
import korlibs.image.format.DXT;
import korlibs.image.format.DXT1;
import korlibs.image.format.DXT3;
import korlibs.image.format.DXT4;
import korlibs.image.format.DXT5;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lkorlibs/image/format/DDS;", "Lkorlibs/image/format/ImageFormat;", "()V", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "readImage", "Lkorlibs/image/format/ImageData;", "korge-core"})
public final class DDS
extends ImageFormat {
    @NotNull
    public static final DDS INSTANCE = new DDS();

    private DDS() {
        String[] stringArray = new String[]{"dds"};
        super(stringArray);
    }

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageInfo imageInfo;
        if (!Intrinsics.areEqual(SyncStreamKt.readString$default(s, 4, null, 2, null), "DDS ")) {
            return null;
        }
        int size2 = SyncStreamKt.readS32LE(s);
        SyncStream sh = SyncStreamKt.readStream(s, size2 - 4);
        int flags = SyncStreamKt.readS32LE(sh);
        int height2 = SyncStreamKt.readS32LE(sh);
        int width2 = SyncStreamKt.readS32LE(sh);
        int pitchOrLinearSize = SyncStreamKt.readS32LE(sh);
        int depth = SyncStreamKt.readS32LE(sh);
        int mipmapCount = SyncStreamKt.readS32LE(sh);
        int[] reserved = SyncStreamKt.readIntArrayLE(sh, 11);
        int pf_size = SyncStreamKt.readS32LE(sh);
        SyncStream pf_s = SyncStreamKt.readStream(sh, pf_size - 4);
        int pf_flags = SyncStreamKt.readS32LE(pf_s);
        String pf_fourcc = SyncStreamKt.readString$default(pf_s, 4, null, 2, null);
        int pf_bitcount = SyncStreamKt.readS32LE(pf_s);
        int pf_rbitmask = SyncStreamKt.readS32LE(pf_s);
        int pf_gbitmask = SyncStreamKt.readS32LE(pf_s);
        int pf_bbitmask = SyncStreamKt.readS32LE(pf_s);
        int pf_abitmask = SyncStreamKt.readS32LE(pf_s);
        int caps = SyncStreamKt.readS32LE(sh);
        int caps2 = SyncStreamKt.readS32LE(sh);
        int caps3 = SyncStreamKt.readS32LE(sh);
        int caps4 = SyncStreamKt.readS32LE(sh);
        int reserved2 = SyncStreamKt.readS32LE(sh);
        ImageInfo $this$decodeHeader_u24lambda_u240 = imageInfo = new ImageInfo();
        boolean bl = false;
        $this$decodeHeader_u24lambda_u240.setWidth(width2);
        $this$decodeHeader_u24lambda_u240.setHeight(height2);
        $this$decodeHeader_u24lambda_u240.setBitsPerPixel(32);
        DDSKt.access$setFourcc($this$decodeHeader_u24lambda_u240, pf_fourcc);
        return imageInfo;
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        DXT dXT;
        String fourcc2;
        ImageInfo imageInfo = this.decodeHeader(s, props);
        if (imageInfo == null) {
            ExceptionsKt.invalidOp("Not a DDS file");
            throw new KotlinNothingValueException();
        }
        ImageInfo h = imageInfo;
        String string = DDSKt.access$getFourcc(h).toUpperCase();
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        switch (fourcc2 = string) {
            case "DXT1": {
                dXT = DXT1.INSTANCE;
                break;
            }
            case "DXT3": {
                dXT = DXT3.INSTANCE;
                break;
            }
            case "DXT4": {
                dXT = DXT4.INSTANCE;
                break;
            }
            case "DXT5": {
                dXT = DXT5.INSTANCE;
                break;
            }
            default: {
                ExceptionsKt.invalidOp("Unsupported DDS FourCC '" + fourcc2 + "'");
                throw new KotlinNothingValueException();
            }
        }
        DXT subimageFormat = dXT;
        byte[] bytes = SyncStreamKt.readAll(s);
        return subimageFormat.readImage(SyncStreamKt.openSync$default(bytes, null, 1, null), new ImageDecodingProps("image." + fourcc2, h.getWidth(), h.getHeight(), null, false, null, false, false, false, null, null, null, 4088, null));
    }
}

