/*
 * Decompiled with CFR 0.152.
 */
package korlibs.image.format;

import korlibs.image.bitmap.Bitmap32;
import korlibs.image.color.BGR_565;
import korlibs.image.color.ColorFormatKt;
import korlibs.image.color.Colors;
import korlibs.image.color.RGBA;
import korlibs.image.color.RgbaArray;
import korlibs.image.format.ImageData;
import korlibs.image.format.ImageDecodingProps;
import korlibs.image.format.ImageFormat;
import korlibs.image.format.ImageInfo;
import korlibs.io.file.PathInfo;
import korlibs.io.file.PathInfoKt;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JJ\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H&\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\u0016\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006+"}, d2={"Lkorlibs/image/format/DXT;", "Lkorlibs/image/format/ImageFormat;", "format", "", "premultiplied", "", "blockSize", "", "(Ljava/lang/String;ZI)V", "getBlockSize", "()I", "getFormat", "()Ljava/lang/String;", "getPremultiplied", "()Z", "decodeBitmap", "Lkorlibs/image/bitmap/Bitmap32;", "bytes", "", "width", "height", "decodeHeader", "Lkorlibs/image/format/ImageInfo;", "s", "Lkorlibs/io/stream/SyncStream;", "props", "Lkorlibs/image/format/ImageDecodingProps;", "decodeRow", "", "data", "dataOffset", "bmp", "Lkorlibs/image/color/RgbaArray;", "bmpOffset", "bmpStride", "aa", "", "cc", "decodeRow-tnfyYuo", "([BI[III[I[I)V", "readImage", "Lkorlibs/image/format/ImageData;", "Companion", "korge-core"})
public abstract class DXT
extends ImageFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String format;
    private final boolean premultiplied;
    private final int blockSize;
    public static final int FACT_2_3 = 170;
    public static final int FACT_1_3 = 85;
    public static final int FACT_1_2 = 128;

    public DXT(@NotNull String format2, boolean premultiplied, int blockSize) {
        String[] stringArray = new String[]{format2};
        super(stringArray);
        this.format = format2;
        this.premultiplied = premultiplied;
        this.blockSize = blockSize;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final boolean getPremultiplied() {
        return this.premultiplied;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public abstract void decodeRow-tnfyYuo(@NotNull byte[] var1, int var2, @NotNull int[] var3, int var4, int var5, @NotNull int[] var6, @NotNull int[] var7);

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageInfo imageInfo;
        if (!StringsKt.startsWith$default(PathInfoKt.getExtensionLC-pnq4Q78(PathInfo.constructor-impl(props.getFilename())), this.format, false, 2, null)) {
            return null;
        }
        ImageInfo $this$decodeHeader_u24lambda_u240 = imageInfo = new ImageInfo();
        boolean bl = false;
        Integer n = props.getWidth();
        $this$decodeHeader_u24lambda_u240.setWidth(n != null ? n : 1);
        Integer n2 = props.getHeight();
        $this$decodeHeader_u24lambda_u240.setHeight(n2 != null ? n2 : 1);
        return imageInfo;
    }

    @NotNull
    public final Bitmap32 decodeBitmap(@NotNull byte[] bytes, int width2, int height2) {
        Bitmap32 out = new Bitmap32(width2, height2, null, this.premultiplied, 4, null);
        int blockWidth = out.getWidth() / 4;
        int blockHeight = out.getHeight() / 4;
        int offset2 = 0;
        int[] aa = new int[8];
        int[] cc = RgbaArray.Companion.invoke-lrAz6eQ(4);
        int[] rgba = RgbaArray.constructor-impl(out.getInts());
        for (int y = 0; y < blockHeight; ++y) {
            for (int x = 0; x < blockWidth; ++x) {
                this.decodeRow-tnfyYuo(bytes, offset2, rgba, out.index(x * 4, y * 4), out.getWidth(), aa, cc);
                offset2 += this.blockSize;
            }
        }
        return out;
    }

    @Override
    @NotNull
    public final ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        byte[] bytes = SyncStreamKt.readAll(s);
        int totalPixels = bytes.length / this.blockSize * 4 * 4;
        int potentialSide = (int)Math.sqrt(totalPixels);
        Integer n = props.getWidth();
        int width2 = n != null ? n : potentialSide;
        Integer n2 = props.getHeight();
        int height2 = n2 != null ? n2 : potentialSide;
        return ImageData.Companion.invoke(this.decodeBitmap(bytes, width2, height2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001b\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lkorlibs/image/format/DXT$Companion;", "", "()V", "FACT_1_2", "", "FACT_1_3", "FACT_2_3", "decodeDxt1Color", "", "data", "", "dataOffset", "cc", "Lkorlibs/image/color/RgbaArray;", "decodeDxt1Color--xEBeNA", "([BI[I)V", "decodeDxt1ColorCond", "decodeDxt1ColorCond--xEBeNA", "decodeDxt5Alpha", "aa", "", "decodeRGB656", "Lkorlibs/image/color/RGBA;", "v", "decodeRGB656-O1c-hRk", "(I)I", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int decodeRGB656-O1c-hRk(int v) {
            return ColorFormatKt.toRGBA(BGR_565.INSTANCE, v);
        }

        public final void decodeDxt1ColorCond--xEBeNA(@NotNull byte[] data2, int dataOffset, @NotNull int[] cc) {
            int c0 = ByteArrayGetSetKt.getU16LE(data2, dataOffset + 0);
            int c1 = ByteArrayGetSetKt.getU16LE(data2, dataOffset + 2);
            int[] ccArray = cc;
            RgbaArray.set-XDoMphA(ccArray, 0, this.decodeRGB656-O1c-hRk(c0));
            RgbaArray.set-XDoMphA(ccArray, 1, this.decodeRGB656-O1c-hRk(c1));
            if (c0 > c1) {
                RgbaArray.set-XDoMphA(ccArray, 2, RGBA.Companion.mixRgbFactor256-kmvcM9k(RgbaArray.get-O1c-hRk(cc, 0), RgbaArray.get-O1c-hRk(cc, 1), 170));
                RgbaArray.set-XDoMphA(ccArray, 3, RGBA.Companion.mixRgbFactor256-kmvcM9k(RgbaArray.get-O1c-hRk(cc, 0), RgbaArray.get-O1c-hRk(cc, 1), 85));
            } else {
                RgbaArray.set-XDoMphA(ccArray, 2, RGBA.Companion.mixRgbFactor256-kmvcM9k(RgbaArray.get-O1c-hRk(cc, 0), RgbaArray.get-O1c-hRk(cc, 1), 128));
                RgbaArray.set-XDoMphA(ccArray, 3, Colors.INSTANCE.getTRANSPARENT-JH0Opww());
            }
        }

        public final void decodeDxt1Color--xEBeNA(@NotNull byte[] data2, int dataOffset, @NotNull int[] cc) {
            RgbaArray.set-XDoMphA(cc, 0, this.decodeRGB656-O1c-hRk(ByteArrayGetSetKt.getU16LE(data2, dataOffset + 0)));
            RgbaArray.set-XDoMphA(cc, 1, this.decodeRGB656-O1c-hRk(ByteArrayGetSetKt.getU16LE(data2, dataOffset + 2)));
            RgbaArray.set-XDoMphA(cc, 2, RGBA.Companion.mixRgbFactor256-kmvcM9k(RgbaArray.get-O1c-hRk(cc, 0), RgbaArray.get-O1c-hRk(cc, 1), 170));
            RgbaArray.set-XDoMphA(cc, 3, RGBA.Companion.mixRgbFactor256-kmvcM9k(RgbaArray.get-O1c-hRk(cc, 0), RgbaArray.get-O1c-hRk(cc, 1), 85));
        }

        public final void decodeDxt5Alpha(@NotNull byte[] data2, int dataOffset, @NotNull int[] aa) {
            int a0 = ByteArrayGetSetKt.getU8(data2, dataOffset + 0);
            int a1 = ByteArrayGetSetKt.getU8(data2, dataOffset + 1);
            aa[0] = a0;
            aa[1] = a1;
            if (a0 > a1) {
                aa[2] = (6 * a0 + 1 * a1) / 7;
                aa[3] = (5 * a0 + 2 * a1) / 7;
                aa[4] = (4 * a0 + 3 * a1) / 7;
                aa[5] = (3 * a0 + 4 * a1) / 7;
                aa[6] = (2 * a0 + 5 * a1) / 7;
                aa[7] = (1 * a0 + 6 * a1) / 7;
            } else {
                aa[2] = (4 * a0 + 1 * a1) / 5;
                aa[3] = (3 * a0 + 2 * a1) / 5;
                aa[4] = (2 * a0 + 3 * a1) / 5;
                aa[5] = (1 * a0 + 4 * a1) / 5;
                aa[6] = 0;
                aa[7] = 255;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

